""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """

import ssl
import pika
from pika.credentials import ExternalCredentials
import argparse
import logging
logging.basicConfig(level=logging.INFO)

def establish_connection(host, sni,port, vhost,credentials, key_file, cert_file, cacert_file):

    if cacert_file:
        context = ssl.create_default_context(cafile=cacert_file)
        if cert_file:
            context.load_cert_chain(cert_file, key_file)
        ssl_options = pika.SSLOptions(context, server_hostname=sni if sni else host)
    else:
        ssl_options = None
    parameters = pika.ConnectionParameters(port=port,
                                        credentials=credentials,
                                        host=host,
                                        virtual_host=vhost,
                                        ssl_options=ssl_options
                                        )

    with pika.BlockingConnection(parameters) as conn:
        print("Success")



def main():
    parser = argparse.ArgumentParser(description="Script to check RabbitMQ connection")
    parser.add_argument("--host", required=True, help="Hostname or IP address of the RabbitMQ server")
    parser.add_argument("--sni", required=False, help="Server Name Indication (SNI) for SSL/TLS connection")
    parser.add_argument("--port", type=int, default=5671, help="Port number of the RabbitMQ server (default: 5671)")
    parser.add_argument("--key", required=False,
                        help="Path to the client key file in PEM format for SSL/TLS connection")
    parser.add_argument("--cert", required=False,
                        help="Path to the client certificate file in PEM format for SSL/TLS connection")
    parser.add_argument("--vhost", required=True, help="Virtual host to connect to on the RabbitMQ server")
    parser.add_argument("--cacert", required=False,
                        help="Path to the CA certificate file in PEM format for SSL/TLS connection")
    parser.add_argument("--username", help="Username for RabbitMQ authentication")
    parser.add_argument("--password", help="Password for RabbitMQ authentication")

    args = parser.parse_args()

    if args.username:
        credentials = pika.PlainCredentials(args.username,args.password)
    else:
        credentials = ExternalCredentials()

    establish_connection(args.host, args.sni,args.port, args.vhost,credentials, args.key, args.cert, args.cacert)

if __name__ == "__main__":
    main()