#!/usr/bin/python3
""" Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end """

import yaml, sys, argparse
import json


def extend_dict(extend_me, extend_by):
    if isinstance(extend_me, dict):
        for k, v in extend_by.items():
            if k in extend_me:
                extend_dict(extend_me[k], v)
            else:
                extend_me[k] = v
    else:
        if isinstance(extend_me, list):
            extend_list(extend_me, extend_by)
        else:
            extend_me += extend_by


def extend_list(extend_me, extend_by):
    missing = []
    for item in extend_by:
        if item not in extend_me:
            missing.append(item)
    extend_me += missing


def update(d, u, val):
    for k, v in d.items():
        if isinstance(v, dict) or isinstance(v, list):
            d[k] = update(d.get(k, {}), u, val)
        else:
            if k == u:
                if val.lower() == 'true':
                    val = True
                elif val.lower() == 'false':
                    val = False
                d[k] = val
    return d

def update_values(file_to_update, dict_of_updated_key_values):
    with open(file_to_update, 'r') as outfile:
        config = yaml.load(outfile,Loader=yaml.FullLoader)
        for key, value in dict_of_updated_key_values.items():
            config = update(config, key, value)
    with open(file_to_update, 'w') as outfile:
        yaml.dump(config, outfile, default_flow_style=False)


def get_value(d, u):
    for k, v in d.items():
        if isinstance(v, dict) or isinstance(v, list):
            ret_val = get_value(d.get(k, {}), u)
            if ret_val != 0:
                return ret_val
        else:
            if k == u:
                return d[k]

    return 0
  
def delete_key(config, key_to_delete):
    config.pop(key_to_delete, None)
    return config
  
def append_key(config, key, value):
    config[key] = json.loads(value)
    return config

def parse_conf_file(file_obj):
    """Parses a key=value configuration file from an open file object."""
    kv_dict = {}
    for line in file_obj:
        line = line.strip()
        if line and not line.startswith("#"):  # Ignore empty lines and comments
            key, value = line.split("=", maxsplit=1)  # Split only on first '='
            kv_dict[key.strip()] = value.strip()
    return kv_dict


def main(argv):
    inputfile = ''
    force_file = {}
    child_file = {}
    mergeConfig = {}
    config = {}
    EXTENDABLE_KEYS = ()
    try:
        # opts, args = getopt.getopt(argv[1:],'k:fhv',['--key=','--file=','--help=','--value='])
        parser = argparse.ArgumentParser()
        parser.add_argument("-f", "--file", help="file to read config from")
        parser.add_argument("-k", "--ke", help="the key to be updated")
        parser.add_argument("-v", "--val", help="new value for the given key")
        parser.add_argument("-g", "--getval", help="get value of the given key")
        parser.add_argument("-d", "--delete", help="Delete specific key from file")
        parser.add_argument("-a", "--append", help="Append Specific key to file")
        args = parser.parse_args()
    except Exception as identifier:
        print('valid options are --file <absolutePathInputfile> --key <string> --value <string>')
        sys.exit(2)

    if args.getval:
        inputfile = args.file
        with open(inputfile, 'r') as outfile:
            file_extension = inputfile.split('.')[-1]
            if file_extension == 'conf':
                config = parse_conf_file(outfile)
                key_val = config.get(args.getval)
                if not key_val:
                    key_val=""
                elif isinstance(key_val, str):
                    key_val = key_val.strip().strip("\"'")
            else:
                config = yaml.load(outfile, Loader=yaml.FullLoader)
                key_val = (get_value(config, args.getval))
            sys.stdout.write(str(key_val))
            sys.exit(0)
            
    elif args.delete:
        inputfile = args.file
        with open(inputfile, 'r') as outfile:
            config = yaml.load(outfile,Loader=yaml.FullLoader)
            formatted_config = delete_key(config, args.delete)
            with open(inputfile, 'w') as outfile:
                yaml.dump(formatted_config, outfile, default_flow_style=False)

    elif args.append:
        inputfile = args.file
        with open(inputfile, 'r') as outfile:
            config = yaml.load(outfile,Loader=yaml.FullLoader)
            formatted_config = append_key(config, args.ke, args.val)
            with open(inputfile, 'w') as outfile:
                yaml.dump(formatted_config, outfile, default_flow_style=False)

    elif args.ke:
        if args.val:
            inputfile = args.file
            with open(inputfile, 'r') as outfile:
                config = yaml.load(outfile,Loader=yaml.FullLoader)
                updated_var = update(config, args.ke, args.val)
                with open(inputfile, 'w') as outfile:
                    yaml.dump(updated_var, outfile, default_flow_style=False)

    elif args.file:
        inputfile = args.file
        with open(inputfile, 'r') as outfile:
            config = yaml.load(outfile,Loader=yaml.FullLoader)
            mergeConfig = config['mergeparams']
            EXTENDABLE_KEYS = mergeConfig.get('EXTENDABLE_KEYS', ())

        for file_name in mergeConfig.get('forcefiles', {}):
            with open(file_name, 'r') as outfile:
                forcefilesconfigs = yaml.load(outfile,Loader=yaml.FullLoader)
                extend_dict(force_file, forcefilesconfigs)

        for file_name in mergeConfig.get('childrenfiles', {}):
            with open(file_name, 'r') as outfile:
                childfilesconfigs = yaml.load(outfile,Loader=yaml.FullLoader)
                extend_dict(child_file, childfilesconfigs)

            with open(mergeConfig.get('parentfile', ''), 'r') as outfile:
                parent_file = yaml.load(outfile,Loader=yaml.FullLoader)

            extend_dict(force_file, parent_file)
            extend_dict(force_file, child_file)
            with open(mergeConfig.get('parentfile'), 'w') as outfile:
                yaml.dump(force_file, outfile, default_flow_style=False)


if __name__ == '__main__':
    main(sys.argv)
