# Copyright (c) 2012-2013, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.

from aws import Action as BaseAction
from aws import BaseARN

service_name = 'AWS IoT'
prefix = 'iot'


class Action(BaseAction):
    def __init__(self, action=None):
        sup = super(Action, self)
        sup.__init__(prefix, action)


class ARN(BaseARN):
    def __init__(self, resource='', region='', account=''):
        sup = super(ARN, self)
        sup.__init__(service=prefix, resource=resource, region=region,
                     account=account)


AcceptCertificateTransfer = Action('AcceptCertificateTransfer')
AddThingToBillingGroup = Action('AddThingToBillingGroup')
AddThingToThingGroup = Action('AddThingToThingGroup')
AssociateTargetsWithJob = Action('AssociateTargetsWithJob')
AttachPolicy = Action('AttachPolicy')
AttachPrincipalPolicy = Action('AttachPrincipalPolicy')
AttachSecurityProfile = Action('AttachSecurityProfile')
AttachThingPrincipal = Action('AttachThingPrincipal')
CancelAuditTask = Action('CancelAuditTask')
CancelCertificateTransfer = Action('CancelCertificateTransfer')
CancelJob = Action('CancelJob')
CancelJobExecution = Action('CancelJobExecution')
ClearDefaultAuthorizer = Action('ClearDefaultAuthorizer')
Connect = Action('Connect')
CreateAuthorizer = Action('CreateAuthorizer')
CreateBillingGroup = Action('CreateBillingGroup')
CreateCertificateFromCsr = Action('CreateCertificateFromCsr')
CreateDynamicThingGroup = Action('CreateDynamicThingGroup')
CreateJob = Action('CreateJob')
CreateKeysAndCertificate = Action('CreateKeysAndCertificate')
CreateOTAUpdate = Action('CreateOTAUpdate')
CreateOTAUpdateJob = Action('CreateOTAUpdateJob')
CreatePolicy = Action('CreatePolicy')
CreatePolicyVersion = Action('CreatePolicyVersion')
CreateRoleAlias = Action('CreateRoleAlias')
CreateScheduledAudit = Action('CreateScheduledAudit')
CreateSecurityProfile = Action('CreateSecurityProfile')
CreateStream = Action('CreateStream')
CreateThing = Action('CreateThing')
CreateThingGroup = Action('CreateThingGroup')
CreateThingType = Action('CreateThingType')
CreateTopicRule = Action('CreateTopicRule')
DeleteAccountAuditConfiguration = \
    Action('DeleteAccountAuditConfiguration')
DeleteAuthorizer = Action('DeleteAuthorizer')
DeleteBillingGroup = Action('DeleteBillingGroup')
DeleteCACertificate = Action('DeleteCACertificate')
DeleteCertificate = Action('DeleteCertificate')
DeleteDynamicThingGroup = Action('DeleteDynamicThingGroup')
DeleteJob = Action('DeleteJob')
DeleteJobExecution = Action('DeleteJobExecution')
DeleteOTAUpdate = Action('DeleteOTAUpdate')
DeleteOTAUpdateJob = Action('DeleteOTAUpdateJob')
DeletePolicy = Action('DeletePolicy')
DeletePolicyVersion = Action('DeletePolicyVersion')
DeleteRegistrationCode = Action('DeleteRegistrationCode')
DeleteRoleAlias = Action('DeleteRoleAlias')
DeleteScheduledAudit = Action('DeleteScheduledAudit')
DeleteSecurityProfile = Action('DeleteSecurityProfile')
DeleteStream = Action('DeleteStream')
DeleteThing = Action('DeleteThing')
DeleteThingGroup = Action('DeleteThingGroup')
DeleteThingShadow = Action('DeleteThingShadow')
DeleteThingType = Action('DeleteThingType')
DeleteTopicRule = Action('DeleteTopicRule')
DeleteV2LoggingLevel = Action('DeleteV2LoggingLevel')
DeprecateThingType = Action('DeprecateThingType')
DescribeAccountAuditConfiguration = \
    Action('DescribeAccountAuditConfiguration')
DescribeAuditTask = Action('DescribeAuditTask')
DescribeAuthorizer = Action('DescribeAuthorizer')
DescribeBillingGroup = Action('DescribeBillingGroup')
DescribeCACertificate = Action('DescribeCACertificate')
DescribeCertificate = Action('DescribeCertificate')
DescribeDefaultAuthorizer = Action('DescribeDefaultAuthorizer')
DescribeEndpoint = Action('DescribeEndpoint')
DescribeEventConfigurations = Action('DescribeEventConfigurations')
DescribeIndex = Action('DescribeIndex')
DescribeJob = Action('DescribeJob')
DescribeJobExecution = Action('DescribeJobExecution')
DescribeRoleAlias = Action('DescribeRoleAlias')
DescribeScheduledAudit = Action('DescribeScheduledAudit')
DescribeSecurityProfile = Action('DescribeSecurityProfile')
DescribeStream = Action('DescribeStream')
DescribeThing = Action('DescribeThing')
DescribeThingGroup = Action('DescribeThingGroup')
DescribeThingRegistrationTask = Action('DescribeThingRegistrationTask')
DescribeThingType = Action('DescribeThingType')
DetachPolicy = Action('DetachPolicy')
DetachPrincipalPolicy = Action('DetachPrincipalPolicy')
DetachSecurityProfile = Action('DetachSecurityProfile')
DetachThingPrincipal = Action('DetachThingPrincipal')
DisableTopicRule = Action('DisableTopicRule')
EnableTopicRule = Action('EnableTopicRule')
GetEffectivePolicies = Action('GetEffectivePolicies')
GetIndexingConfiguration = Action('GetIndexingConfiguration')
GetJobDocument = Action('GetJobDocument')
GetLoggingOptions = Action('GetLoggingOptions')
GetOTAUpdate = Action('GetOTAUpdate')
GetOTAUpdateJob = Action('GetOTAUpdateJob')
GetPendingJobExecutions = Action('GetPendingJobExecutions')
GetPolicy = Action('GetPolicy')
GetPolicyVersion = Action('GetPolicyVersion')
GetRegistrationCode = Action('GetRegistrationCode')
GetStatistics = Action('GetStatistics')
GetThingShadow = Action('GetThingShadow')
GetTopicRule = Action('GetTopicRule')
GetV2LoggingOptions = Action('GetV2LoggingOptions')
ListActiveViolations = Action('ListActiveViolations')
ListAttachedPolicies = Action('ListAttachedPolicies')
ListAuditFindings = Action('ListAuditFindings')
ListAuditTasks = Action('ListAuditTasks')
ListAuthorizers = Action('ListAuthorizers')
ListBillingGroups = Action('ListBillingGroups')
ListCACertificates = Action('ListCACertificates')
ListCertificates = Action('ListCertificates')
ListCertificatesByCA = Action('ListCertificatesByCA')
ListIndices = Action('ListIndices')
ListJobExecutionsForJob = Action('ListJobExecutionsForJob')
ListJobExecutionsForThing = Action('ListJobExecutionsForThing')
ListJobs = Action('ListJobs')
ListOTAUpdateJobs = Action('ListOTAUpdateJobs')
ListOTAUpdates = Action('ListOTAUpdates')
ListOutgoingCertificates = Action('ListOutgoingCertificates')
ListPolicies = Action('ListPolicies')
ListPolicyPrincipals = Action('ListPolicyPrincipals')
ListPolicyVersions = Action('ListPolicyVersions')
ListPrincipalPolicies = Action('ListPrincipalPolicies')
ListPrincipalThings = Action('ListPrincipalThings')
ListRoleAliases = Action('ListRoleAliases')
ListScheduledAudits = Action('ListScheduledAudits')
ListSecurityProfiles = Action('ListSecurityProfiles')
ListSecurityProfilesForTarget = Action('ListSecurityProfilesForTarget')
ListStreams = Action('ListStreams')
ListTagsForResource = Action('ListTagsForResource')
ListTargetsForPolicy = Action('ListTargetsForPolicy')
ListTargetsForSecurityProfile = Action('ListTargetsForSecurityProfile')
ListThingGroups = Action('ListThingGroups')
ListThingGroupsForThing = Action('ListThingGroupsForThing')
ListThingPrincipals = Action('ListThingPrincipals')
ListThingRegistrationTaskReports = \
    Action('ListThingRegistrationTaskReports')
ListThingRegistrationTasks = Action('ListThingRegistrationTasks')
ListThingTypes = Action('ListThingTypes')
ListThings = Action('ListThings')
ListThingsInBillingGroup = Action('ListThingsInBillingGroup')
ListThingsInThingGroup = Action('ListThingsInThingGroup')
ListTopicRules = Action('ListTopicRules')
ListV2LoggingLevels = Action('ListV2LoggingLevels')
ListViolationEvents = Action('ListViolationEvents')
Publish = Action('Publish')
Receive = Action('Receive')
RegisterCACertificate = Action('RegisterCACertificate')
RegisterCertificate = Action('RegisterCertificate')
RegisterThing = Action('RegisterThing')
RejectCertificateTransfer = Action('RejectCertificateTransfer')
RemoveThingFromBillingGroup = Action('RemoveThingFromBillingGroup')
RemoveThingFromThingGroup = Action('RemoveThingFromThingGroup')
ReplaceTopicRule = Action('ReplaceTopicRule')
SearchIndex = Action('SearchIndex')
SetDefaultAuthorizer = Action('SetDefaultAuthorizer')
SetDefaultPolicyVersion = Action('SetDefaultPolicyVersion')
SetLoggingOptions = Action('SetLoggingOptions')
SetV2LoggingLevel = Action('SetV2LoggingLevel')
SetV2LoggingOptions = Action('SetV2LoggingOptions')
StartNextPendingJobExecution = Action('StartNextPendingJobExecution')
StartOnDemandAuditTask = Action('StartOnDemandAuditTask')
StartThingRegistrationTask = Action('StartThingRegistrationTask')
StopThingRegistrationTask = Action('StopThingRegistrationTask')
Subscribe = Action('Subscribe')
TagResource = Action('TagResource')
TestAuthorization = Action('TestAuthorization')
TestInvokeAuthorizer = Action('TestInvokeAuthorizer')
TransferCertificate = Action('TransferCertificate')
UntagResource = Action('UntagResource')
UpdateAccountAuditConfiguration = \
    Action('UpdateAccountAuditConfiguration')
UpdateAuthorizer = Action('UpdateAuthorizer')
UpdateBillingGroup = Action('UpdateBillingGroup')
UpdateCACertificate = Action('UpdateCACertificate')
UpdateCertificate = Action('UpdateCertificate')
UpdateDynamicThingGroup = Action('UpdateDynamicThingGroup')
UpdateEventConfigurations = Action('UpdateEventConfigurations')
UpdateIndexingConfiguration = Action('UpdateIndexingConfiguration')
UpdateJob = Action('UpdateJob')
UpdateJobExecution = Action('UpdateJobExecution')
UpdateRoleAlias = Action('UpdateRoleAlias')
UpdateScheduledAudit = Action('UpdateScheduledAudit')
UpdateSecurityProfile = Action('UpdateSecurityProfile')
UpdateStream = Action('UpdateStream')
UpdateThing = Action('UpdateThing')
UpdateThingGroup = Action('UpdateThingGroup')
UpdateThingGroupsForThing = Action('UpdateThingGroupsForThing')
UpdateThingShadow = Action('UpdateThingShadow')
ValidateSecurityProfileBehaviors = \
    Action('ValidateSecurityProfileBehaviors')
