# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SegmentMembershipList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid, identity):
        """
        Initialize the SegmentMembershipList

        :param Version version: Version that contains the resource
        :param service_sid: The service_sid
        :param identity: The identity

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipList
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipList
        """
        super(SegmentMembershipList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'identity': identity, }
        self._uri = '/Services/{service_sid}/Users/{identity}/SegmentMemberships'.format(**self._solution)

    def create(self, segment):
        """
        Create a new SegmentMembershipInstance

        :param unicode segment: The segment

        :returns: Newly created SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        """
        data = values.of({'Segment': segment, })

        payload = self._version.create(
            'POST',
            self._uri,
            data=data,
        )

        return SegmentMembershipInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            identity=self._solution['identity'],
        )

    def get(self, segment):
        """
        Constructs a SegmentMembershipContext

        :param segment: The segment

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        """
        return SegmentMembershipContext(
            self._version,
            service_sid=self._solution['service_sid'],
            identity=self._solution['identity'],
            segment=segment,
        )

    def __call__(self, segment):
        """
        Constructs a SegmentMembershipContext

        :param segment: The segment

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        """
        return SegmentMembershipContext(
            self._version,
            service_sid=self._solution['service_sid'],
            identity=self._solution['identity'],
            segment=segment,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.SegmentMembershipList>'


class SegmentMembershipPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the SegmentMembershipPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The service_sid
        :param identity: The identity

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipPage
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipPage
        """
        super(SegmentMembershipPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SegmentMembershipInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        """
        return SegmentMembershipInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            identity=self._solution['identity'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Notify.V1.SegmentMembershipPage>'


class SegmentMembershipContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid, identity, segment):
        """
        Initialize the SegmentMembershipContext

        :param Version version: Version that contains the resource
        :param service_sid: The service_sid
        :param identity: The identity
        :param segment: The segment

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        """
        super(SegmentMembershipContext, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'identity': identity, 'segment': segment, }
        self._uri = '/Services/{service_sid}/Users/{identity}/SegmentMemberships/{segment}'.format(**self._solution)

    def delete(self):
        """
        Deletes the SegmentMembershipInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete('delete', self._uri)

    def fetch(self):
        """
        Fetch a SegmentMembershipInstance

        :returns: Fetched SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return SegmentMembershipInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            identity=self._solution['identity'],
            segment=self._solution['segment'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Notify.V1.SegmentMembershipContext {}>'.format(context)


class SegmentMembershipInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, service_sid, identity, segment=None):
        """
        Initialize the SegmentMembershipInstance

        :returns: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        """
        super(SegmentMembershipInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'service_sid': payload['service_sid'],
            'identity': payload['identity'],
            'segment': payload['segment'],
            'url': payload['url'],
        }

        # Context
        self._context = None
        self._solution = {
            'service_sid': service_sid,
            'identity': identity,
            'segment': segment or self._properties['segment'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SegmentMembershipContext for this SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipContext
        """
        if self._context is None:
            self._context = SegmentMembershipContext(
                self._version,
                service_sid=self._solution['service_sid'],
                identity=self._solution['identity'],
                segment=self._solution['segment'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def service_sid(self):
        """
        :returns: The service_sid
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def identity(self):
        """
        :returns: The identity
        :rtype: unicode
        """
        return self._properties['identity']

    @property
    def segment(self):
        """
        :returns: The segment
        :rtype: unicode
        """
        return self._properties['segment']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def delete(self):
        """
        Deletes the SegmentMembershipInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def fetch(self):
        """
        Fetch a SegmentMembershipInstance

        :returns: Fetched SegmentMembershipInstance
        :rtype: twilio.rest.notify.v1.service.user.segment_memberships.SegmentMembershipInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Notify.V1.SegmentMembershipInstance {}>'.format(context)
