/* Copyright (C) 2008 - 2024 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */
(function () {
    let self;

    class editPromptComponent {

        constructor() {
            self = this;
            self.mode = 'view';

        }

        $onInit() {
            self.fields = self.resolve.recordMetaData.fields;
            self.coRelatedFields = self.resolve.recordMetaData.coRelatedFields;
            self.widgetBasePath = self.resolve.widgetBasePath;
            self.showCoRelatedFields =  Object.keys(self.coRelatedFields).length >= 1 ? true : false; 
            self.stringToModify = self.objectToString(self.fields);
            self.similarRecordsPresent = self.resolve.recordMetaData.hasOwnProperty('similarRecords') && self.resolve.recordMetaData.similarRecords.length > 0;
            self.selectedQuestion = self.resolve.selectedQuestion;
        }

        // Formatting the json to make it readable
        objectToString(obj) {
            let result = '';
            for (var [key, value] of Object.entries(obj)) {
                //remove html elements
                // Check if the value starts with a newline character and remove \n 
                if (typeof value !== 'string') {
                    value = String(value);
                }
                var formattedValue = value.replace(/\n/g, '');
                // formattedValue = self.removeHtmlTags(formattedValue);
                result += `${key}: ${formattedValue}\n\n`;
            }
            return result;
        }

        removeHtmlTags(htmlString) {
            // Regular expression to match HTML tags
            const htmlTagRegex = /<[^>]*>/g;
            // Replace HTML tags with an empty string
            return htmlString.replace(htmlTagRegex, '');
        }

        toggleEditPrompt() {
            if (self.mode === 'view') {
                self.mode = 'edit';
            }
            else {
                self.stringToModify = self.objectToString(self.fields);
                self.mode = 'view';
            }
        }

        generateReport(){
            self.modalInstance.close({
                generateReport: true,
                recordMetaData: self.stringToModify,
                coRelatedFields: Object.keys(self.coRelatedFields).filter(key => self.coRelatedFields[key].include === true)
            });
        }

        cancel() {
            self.modalInstance.close({
                generateReport: false
            });
        }
    }

    angular.module('cybersponse').component('editPromptComponent', {
        bindings: {
            modalInstance: '<',
            resolve: '<'
        },
        controller: [editPromptComponent],
        templateUrl: "widgets/installed/aiAssistant-2.0.0/editPrompt.html"
    });

})();

