/* Copyright (C) 2008 - 2024 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('aiAssistant200Ctrl', aiAssistant200Ctrl);

  aiAssistant200Ctrl.$inject = ['$scope', 'toaster', '$rootScope', '$q', '$timeout', 'localStorageService', 'aiAssistantService', '$window', '$state', 'widgetBasePath', 'Entity', '$uibModal', 'COMMENT_TYPES', 'Modules', '$filter', 'currentPermissionsService', 'FormEntityService', 'playbookService'];

  function aiAssistant200Ctrl($scope, toaster, $rootScope, $q, $timeout, localStorageService, aiAssistantService, $window, $state, widgetBasePath, Entity, $uibModal, COMMENT_TYPES, Modules, $filter, currentPermissionsService, FormEntityService, playbookService) {

    var widgetBasePath = widgetBasePath;
    var constantMessages = aiAssistantService.constantMessages();
    const staticMessage = {
      playbookSuggestionMessages: [{
        text: constantMessages.initialMessage.playbookSuggestionMessages,
        type: 'botGeneral'
      }],
      conversationInDesigner: [{
        text: constantMessages.initialMessage.conversationInDesigner,
        type: 'botGeneral'
      }],
      conversationThroughOutApplication: [{
        text: constantMessages.initialMessage.conversationThroughOutApplication,
        type: 'botGeneral'
      }]
    };
    $scope.messages = loadDataFromLocalStorage() || angular.copy(staticMessage);
    $scope.pageState = $state;
    $scope.updateRichTextHtmlValue = updateRichTextHtmlValue;
    $scope.clearConversation = clearConversation;
    $scope.generatePlaybook = generatePlaybook;
    $scope.generatePlaybookDescription = generatePlaybookDescription;
    $scope.onChangeMode = onChangeMode;
    $scope.openDocumentation = openDocumentation;
    $scope.prepareMaskedData = prepareMaskedData;
    $scope.generateReport = generateReport;
    $scope.adjustTextareaHeight = adjustTextareaHeight;
    $scope.hideQuestionsPopUp = hideQuestionsPopUp;
    $scope.addComment = addComment;
    $scope.playbookDescription = '';
    $scope.botType = 'Playbook Suggestion';
    $scope.showDescription = false;//To append review results button to the bot text, button only visible on playbook description
    $scope.generatePlaybookFlag = false;
    $scope.processingPlaybook = false;
    $scope.processingConversation = false;
    $scope.inPlaybookDesignerPage = false;
    $scope.disableTextArea = true;
    $scope.isConnectorConfigured = true;
    $scope.showStaticQuestions = false;
    $scope.playbookPermission = currentPermissionsService.getPermission('workflows');
    var selectedQuestion = '';
    var stateChangeSuccess = '';
    var keyStoreValue = {};
    var modulesForStaticQuestions = [];
    var maskedObjects = { emails: {}, ips: {}, domains: {}, hashes: {}, urls: {}, sha256: {}, sha1: {}, md5: {} };
    var recordMetadata = {};
    $scope.listOfQuestions = {};
    $scope.recommendationSettings = {};
    $scope.suggestedPlaybooksList = [];
    $scope.isLightTheme = $rootScope.theme.id === 'light';//"widgets/installed/aiAssistant-2.0.0/"
    $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
    $scope.bulbIcon = $scope.isLightTheme ? widgetBasePath + 'images/bulb-light.svg' : widgetBasePath + 'images/bulb-dark.svg';
    $scope.botIcon = widgetBasePath + 'images/bot.svg';
    $scope.playbookTags = {
      pBDesignerDescription: [constantMessages.playbookTags.pBDesignerDescription],
      pBDesignerSteps: [constantMessages.playbookTags.pBDesignerSteps],
      conversation: [constantMessages.playbookTags.conversation]
    };
    $scope.options = {
      'name': 'Workflow Steps',
      mode: 'form',
      modes: ['code', 'form'],
      'enableTransform': true,
      'enableSort': false
    };
    $scope.configForMarkdown = {
      initialEditType: 'markdown',
      previewStyle: 'tab',
      height: '420px',
      usageStatistics: false,
      hideModeSwitch: true,
      toolbarItems: ['']
    };
    $scope.userInput = {
      textVal: ''
    };
    $scope.inputText = {
      inputText: '',
    };
    $scope.configurationFailedMessage = constantMessages.configurationFailedMessage;

    //variables for playbook percentage loader
    $scope.processCompleted = 6;

    init();
    function init() {
      $timeout(function () {
        scrollToBottom();
        adjustTextareaHeight();
      })
      if ($scope.pageState.current.name === "main.playbookDetail") {
        $scope.inPlaybookDesignerPage = true;
      }
      aiAssistantService.getKeyStoreRecord(constantMessages.queryForKeyStore, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          keyStoreValue = response['hydra:member'][0].jSONValue;
          modulesForStaticQuestions = Object.keys(keyStoreValue['modules']);
        }
        else {
          toaster.error({ body: "Key Store record not found, refer documentation" });
        }
        if ($scope.pageState.current.name === "viewPanel.modulesDetail" && modulesForStaticQuestions.includes($scope.pageState.current.params.module)) {
          updateListOfQuestions($scope.pageState.current.params.module);
          $scope.entity = FormEntityService.get();
          aiAssistantService.getRecommendationSettings($scope.pageState.current.params.module).then(function (response) {
            $scope.recommendationSettings = response;
          })
          $scope.inRecordDetailedView = true;
        }
        stateChangeSuccessFunction();
        checkConnectorHealth();
      })
    }

    function updateListOfQuestions(currentModule) {
      $scope.listOfQuestions = {};
      for (const module of keyStoreValue.modules[currentModule].questions) {
        if (module.enabled) {
          $scope.listOfQuestions[module.question] = module.description ? module.description : '';
        }
      }
    }

    function addComment(index, fetchFrom) {
      $scope.processingConversation = true;
      var comment = {
        content: $scope.messages[fetchFrom][index].text,
        recordTags: ['FortiAI'],
        type: COMMENT_TYPES.COMMENT,
        people: []
      };
      var parentIri = $filter('prependIri')($scope.pageState.current.params.module + '/' + $scope.pageState.current.params.id);
      comment[$scope.pageState.current.params.module] = [parentIri];
      comment.uuid = $window.UUID.generate();
      Modules.save({
        module: 'comments'
      }, angular.copy(comment)).$promise.then(function (response) {
        toaster.success({ body: 'Added as a comment to this record successfully!' });
      }).catch(function (error) {
        toaster.error({ body: "Unable to save comment" });
      }).finally(function(){
        $scope.processingConversation = false;
      })
    }

    function prepareMaskedData(selectedMessage) {
      hideQuestionsPopUp(true);
      selectedQuestion = selectedMessage;
      var index = Object.entries($scope.listOfQuestions).findIndex(([key, value]) => key === selectedMessage);
      var fields = keyStoreValue['modules'][$scope.pageState.current.params.module]['questions'][index]['fieldsOfInterest'];
      if (fields != undefined && (fields.primaryFields.length != 0 || fields.correlatedFields.length != 0)) {
        _prepareMaskedData(selectedMessage, keyStoreValue['modules'][$scope.pageState.current.params.module]['questions'][index]['fieldsOfInterest']);
      }
      else {
        generateReport(false);
      }
    }

    function _prepareMaskedData(selectedMessage, fields) {
      $scope.entity = FormEntityService.get();
      $scope.processingConversation = true;
      var entity = new Entity($scope.pageState.current.params.module);
      entity.get($scope.pageState.current.params.id, {
        $relationships: true
      }).then(function () {
        recordMetadata = {
          fields: {},
          coRelatedFields: {},
          similarRecords: {}
        };
        for (const field of fields.primaryFields) {
          if (entity.fields[field]) {
            if (entity.fields[field].type != "picklist" && entity.fields[field].type != "manyToMany" && entity.fields[field].type != "manyToOne" && entity.fields[field].type != "datetime" && entity.fields[field].type != "lookup" && entity.fields[field].value) {
              // var maskedValue = aiAssistantService.maskSensitiveContent(entity.fields[field].value, maskedObjects).maskedText;
              recordMetadata['fields'][entity.fields[field].title] = typeof entity.fields[field].value === 'string' 
              ? entity.fields[field].value : String(entity.fields[field].value);            
            }
            else if (entity.fields[field].type === "picklist") {
              if(entity.fields[field].value){
                recordMetadata['fields'][entity.fields[field].title] = entity.fields[field].value.itemValue;
              }
            }
            else if(entity.fields[field].type === "datetime"){
              recordMetadata['fields'][entity.fields[field].title] = aiAssistantService.epochToReadable(entity.fields[field].value);
            }
          }
          for (const coRelatedFields of fields.coRelatedFields) {
            recordMetadata['coRelatedFields'][entity.fields[coRelatedFields.moduleName].title] = {
              include: true,
              recordDetails: {}
            }
            var recordCount = '';
            for (const [index, recordDetails] of entity.fields[coRelatedFields.moduleName].value.entries()) {
              if(recordDetails.isDeleted){
                continue;
              }
              var _recordMetadataRecordDetails = recordMetadata['coRelatedFields'][entity.fields[coRelatedFields.moduleName].title].recordDetails;
              if (Object.entries(_recordMetadataRecordDetails).length === coRelatedFields.recordCount) {
                break; // Break out of the loop once count reaches 5
              }
              recordCount = 'record' + (Object.entries(_recordMetadataRecordDetails).length + 1);
              _recordMetadataRecordDetails[recordCount] = {}
              for (const coRelatedPrimaryField of coRelatedFields.primaryFields) {
                _recordMetadataRecordDetails[recordCount][coRelatedPrimaryField]
                  = recordDetails[coRelatedPrimaryField];
              }
            }
          }
        }
        if (keyStoreValue['modules'][$scope.pageState.current.params.module]['questions'][Object.entries($scope.listOfQuestions).findIndex(([key, value]) => key === selectedQuestion)]['getSimilarRecords']) {
          aiAssistantService.getSimilarRecords($scope.recommendationSettings.workspace, $scope.entity, angular.copy(fields.primaryFields)).then(function (similarRecords) {
            recordMetadata.similarRecords = similarRecords;
            openEditPrompt();
          }, function(error){
            toaster.error({body: "Could not load similar records"})
          })
        }
        else{
          openEditPrompt();
        }
      },
        function (err) {
          toaster.error({ body: "Error in fetching record data, please try again" });
        }
      ).finally(function () {
        scrollToBottom();
      });
    }

    function openEditPrompt(){
      var stringMetaData = JSON.stringify(angular.copy(recordMetadata));
      aiAssistantService.getArtifacts(stringMetaData)
      .then(function (artifacts) {
        maskedObjects = artifacts.data;
        aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.fields, maskedObjects);
        editPromptModal();
      })
      .catch(function (error) {
        console.error('Error:', error);
      });
    }

    function editPromptModal() {
      var recordMetaDataForModal = angular.copy(recordMetadata);
      $scope.processingConversation = false;
      $uibModal.open({
        component: 'editPromptComponent',
        animation: false,
        backdrop: 'static',
        size: 'lg',

        templateUrl: function () {
          return widgetBasePath + 'editPrompt.html';
        },
        windowClass: 'ai-assistant-edit-prompt',
        resolve: {
          recordMetaData: function () {
            return recordMetaDataForModal;
          },
          widgetBasePath: function () {
            return widgetBasePath;
          },
          selectedQuestion: function () {
            return selectedQuestion;
          }
        }
      }).result.then(function (response) {
        if (response.generateReport) {
          $scope.processingConversation = true;
          var userInput = '';
          userInput += selectedQuestion + '\n';
          $scope.messages.conversationThroughOutApplication.push({ text: userInput, type: 'user' });
          generateReport(true, response.recordMetaData, response.coRelatedFields);
        }
      })
    }

    function generateReport(sendRecordDetails, recordMaskedData, listOfCoRelatedModules) {
      var parametersForPlaybook = returnParameters();
      $scope.suggestedPlaybooksList = [];
      var showRecommendedPlaybooks = false;
      var _selectedQuestion = keyStoreValue['modules'][$scope.pageState.current.params.module]['questions'][Object.entries($scope.listOfQuestions).findIndex(([key, value]) => key === selectedQuestion)];
      var prompt = _selectedQuestion['prompt'];
      var playbookTag = _selectedQuestion['pbTag'];
      $scope.userInput.textVal = '';
      $scope.processingConversation = true;
      $timeout(function () {
        scrollToBottom();
        adjustTextareaHeight();
      })
      if (sendRecordDetails) {
        parametersForPlaybook.request.data['record_detail'] = recordMaskedData;
        // var coRelatedRecordString = '';
        for (const key in recordMetadata.coRelatedFields) {
          if (listOfCoRelatedModules.includes(key) && Object.keys(recordMetadata.coRelatedFields[key].recordDetails).length > 0) {
            for (const record in recordMetadata.coRelatedFields[key].recordDetails) {
              aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.coRelatedFields[key].recordDetails[record], maskedObjects);
            }
          }
          else if (!listOfCoRelatedModules.includes(key)) {
            delete recordMetadata.coRelatedFields[key];
          }
        }
        parametersForPlaybook.request.data['co_related_records'] = recordMetadata.coRelatedFields;
        parametersForPlaybook.request.data['masked_data_list'] = maskedObjects;
        if (_selectedQuestion['getSimilarRecords']) {
          if(recordMetadata.similarRecords && recordMetadata.similarRecords.length > 0){
            recordMetadata.similarRecords.forEach(obj => {
              // Iterate over each key in the object
              Object.keys(obj).forEach(key => {
                // Access the key and value of the object
                if(obj[key]!= null && typeof obj[key] === 'object' && obj[key].itemValue){
                  obj[key] = obj[key].itemValue;
                }
              });
              aiAssistantService.replaceArtifactsWithMaskedData(obj, maskedObjects);
            });
            parametersForPlaybook.request.data['similar_records'] = recordMetadata.similarRecords;
          }
        }
      }

      parametersForPlaybook.request.data['record_iri'] = $scope.pageState.current.params.id;
      parametersForPlaybook.request.data['record_type'] = $scope.pageState.current.params.module;
      parametersForPlaybook.request.data['prompt'] = prompt;

      var promise1 = aiAssistantService.getDataFromPlaybook(playbookTag, parametersForPlaybook, $scope);
      var promises = [promise1];

      if (_selectedQuestion['showRecommendedPlaybooks'] && $scope.playbookPermission.execute && $scope.playbookPermission.read) {
        showRecommendedPlaybooks = true;
        var promise2 = aiAssistantService.getRecommendedPlaybooks($scope.recommendationSettings.workspace.suggestedPlaybooks, $scope.entity);
        promises.push(promise2);
      }

      $q.all(promises).then(function (results) {
        var data = results[0];
        $scope.suggestedPlaybooksList = results[1];
        if (data.result && data.result.query_result && (data.status !== 'failed')) {
          var unmaskedText = aiAssistantService.unmaskResult(maskedObjects, data.result.query_result);
          if (showRecommendedPlaybooks) {
            $scope.messages.conversationThroughOutApplication.push({ text: unmaskedText, type: 'bot', addComment: true, showRecommendedPlaybooks: showRecommendedPlaybooks, recommendedPlaybooksList: results[1] });
          }
          else {
            $scope.messages.conversationThroughOutApplication.push({ text: unmaskedText, type: 'bot', addComment: true });
          }
          updateLocalStorageData();
        }
        else {
          if ((data.status === 'failed')) {
            $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.playbookFailed, type: 'bot' });
          }
        }
        // Process dataFromPlaybook
      })
        .finally(function () {
          $scope.processingConversation = false;
          scrollToBottom();
          $timeout(function () {
            scrollToBottom();
          })
        })
    }

    $scope.executePlaybook = function (playbook) {
      aiAssistantService.getPlaybook(playbook.actionUuid, $scope.entity.module).then(function (result) {
        playbookService.triggerPlaybookAction(result.data, $scope.getOriginalRecord, $scope, false, $scope.entity);
      }, function (error) {
        statusCodeService(error, true);
      });
    };

    $scope.getOriginalRecord = function () {
      var records = [];
      records.push({
        '@id': $scope.entity.originalData['@id']
      });
      return records;
    };

    function checkConnectorHealth() {
      if ($scope.disableTextArea) {
        aiAssistantService.connectorHealthCheck('openai').then(function (result) {
          if (result) {
            $scope.disableTextArea = false;
            $scope.isConnectorConfigured = true;
          }
          else {
            $scope.disableTextArea = true;
            $scope.isConnectorConfigured = false;
          }
        }, function (err) {
          $scope.disableTextArea = true;
          $scope.isConnectorConfigured = false;
        })
      }
      else {
        $scope.isConnectorConfigured = true;
        $scope.disableTextArea = false;
      }
    }

    function stateChangeSuccessFunction() {
      stateChangeSuccess = $scope.$on('$stateChangeSuccess', function (event, toState, toParams, from, fromParams) {
        // Condition for module listing page check
        $scope.inRecordDetailedView = false;
        if (toState.name.includes('main.playbookDetail')) {
          $scope.inPlaybookDesignerPage = true;
        }
        else {
          $scope.inPlaybookDesignerPage = false;
          if (toState.name.includes('viewPanel.modulesDetail') && modulesForStaticQuestions.includes(toParams.module)) {
            $scope.entity = FormEntityService.get();
            aiAssistantService.getRecommendationSettings($scope.pageState.current.params.module).then(function (response) {
              $scope.recommendationSettings = response;
            })
            updateListOfQuestions(toParams.module);
            $scope.inRecordDetailedView = true;
          }
        }
      });
    }

    function hideQuestionsPopUp(hide) {
      const customModal = document.getElementById('record-static-questions');
      if (hide) {
        customModal.setAttribute('style', 'display:none;');
      }
      else {
        customModal.setAttribute('style', 'display:inline-block;');
        adjustTextareaHeight(true)
      }
    }

    $scope.$on('popupOpened', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        $scope.inRecordDetailedView = false;
        $scope.isLightTheme = $rootScope.theme.id === 'light';
        $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
        checkConnectorHealth();
        if ($scope.pageState.current.name !== "main.playbookDetail") {
          $scope.inPlaybookDesignerPage = false;
        }
        else {
          $scope.inPlaybookDesignerPage = true;
        }
        if($scope.pageState.current.name === "viewPanel.modulesDetail" && modulesForStaticQuestions.includes($scope.pageState.current.params.module)) {
          $scope.inRecordDetailedView = true;
          updateListOfQuestions($scope.pageState.current.params.module);
          hideQuestionsPopUp(false);
        }
        stateChangeSuccessFunction();
      }
    })

    $scope.$on('popupClosed', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        //to destroy the listener for state change
        stateChangeSuccess();
      }
    })

    $scope.$on('$destroy', function () {
      stateChangeSuccess();
    });

    function loadDataFromLocalStorage() {
      return JSON.parse(localStorageService.get('aiAssistantBot.messages'));
    }

    function clearConversation() {
      if ($scope.inPlaybookDesignerPage) {
        if ($scope.botType === 'Conversation Playbook') {
          $scope.messages.conversationInDesigner = angular.copy(staticMessage.conversationInDesigner);
        }
        else {
          $scope.messages.playbookSuggestionMessages = angular.copy(staticMessage.playbookSuggestionMessages);
        }
      }
      else {
        $scope.messages.conversationThroughOutApplication = angular.copy(staticMessage.conversationThroughOutApplication);
      }
      updateLocalStorageData();
    }

    function updateLocalStorageData() {
      localStorageService.set('aiAssistantBot.messages', JSON.stringify(aiAssistantService.copyWithoutBotGeneral($scope.messages)));
    }

    //When radio button selection is changed
    function onChangeMode() {
      delete $scope.userInput.textVal;
      if ($scope.botType === 'Playbook Suggestion') {
        $scope.botType = 'Conversation Playbook';
      }
      else {
        $scope.botType = 'Playbook Suggestion';
      }
      $timeout(function () {
        scrollToBottom();
      })
    }

    //scroll to bottom when new conversation message is added
    function scrollToBottom() {
      var container = document.getElementById('bot-conversation-body');
      container.scrollTop = container.scrollHeight;
    }

    function adjustTextareaHeight(fromKeypress) {
      var textarea = document.getElementById('conversation-text-input');
      //fetching height of custom modal from drawerWidgetGroup.html 
      var aiAssistantBot = document.getElementById('custom-modal');
      var userInputContainer = document.getElementById('user-input-container');
      var recordQuestionsBox = document.getElementById('record-static-questions');
      var botConversationBody = document.getElementById('bot-conversation-body');
      if (fromKeypress) {
        textarea.style.height = "auto"; // Reset textarea height
        textarea.style.height = (textarea.scrollHeight) + "px"; // Set new height
        var bottomForStaticQuestions = (textarea.scrollHeight) + 12 > 362 ? 362 : (textarea.scrollHeight) + 12;
        recordQuestionsBox.style.bottom = bottomForStaticQuestions + "px"; // Set new height
        var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 120;
        botConversationBody.style.height = botConversationBodyHeight + 'px';
      }
      else {
        textarea.style.height = "46px";
        recordQuestionsBox.style.bottom = "58px";
        var userInputContainer = document.getElementById('user-input-container');
        var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 120;
        botConversationBody.style.height = botConversationBodyHeight + 'px';
      }
      scrollToBottom();
    };

    //generate response if enter is pressed in textbox
    $scope.sendMessage = function (event, flagEnterClick) {
      //if conversation option is selected
      if (((event.keyCode === 13 && !event.shiftKey) || flagEnterClick) && ($scope.userInput.textVal && $scope.userInput.textVal !== '')) {
        //Check if the bot is in designer page
        // $scope.showMaskedData = false;
        if ($scope.inPlaybookDesignerPage) {
          if ($scope.botType === 'Conversation Playbook') {
            // Check if Enter key is pressed
            $scope.messages.conversationInDesigner.push({ text: $scope.userInput.textVal, type: 'user' });
            updateLocalStorageData();
            $timeout(function () {
              scrollToBottom();
            })
            // Process user input and generate a bot response
            $scope.userInput.textVal = '';
            adjustTextareaHeight();
            generatePBDesignerConversation($scope.messages.conversationInDesigner);
          }
          //when playbook suggestion is selected
          else {
            // Check if Enter key is pressed
            $scope.messages.playbookSuggestionMessages.push({ text: $scope.userInput.textVal, type: 'user' });
            updateLocalStorageData();
            var userInput = angular.copy($scope.userInput.textVal);
            $scope.userInput.textVal = ''; // Clear the input field
            // Process user input and generate a bot response
            generatePlaybookDescription(userInput);
            adjustTextareaHeight();
          }
        }
        else {
          // Check if Enter key is pressed
          $scope.messages.conversationThroughOutApplication.push({ text: $scope.userInput.textVal, type: 'user' });
          updateLocalStorageData();
          $timeout(function () {
            scrollToBottom();
          })
          // Process user input and generate a bot response
          $scope.userInput.textVal = '';
          const jsonString = JSON.stringify( angular.copy($scope.messages.conversationThroughOutApplication).slice(-10));
          aiAssistantService.getArtifacts(JSON.stringify(angular.copy(jsonString)))
          .then(function (artifacts) {
            maskedObjects = artifacts.data;
            var unmaskedString = aiAssistantService.replaceArtifactsInString(jsonString, maskedObjects);
            generateApplicationConversation(JSON.parse(unmaskedString));
            adjustTextareaHeight();
          })
          .catch(function (error) {
            console.error('Error:', error);
          });
        }
      }
    };

    // Function to generate a bot response 
    function generateApplicationConversation(userMessages) {
      $scope.processingConversation = true;
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['conversation'] = userMessages;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;

      //trigger playbook and get response when execution is completed
      aiAssistantService.getDataFromPlaybook($scope.playbookTags.conversation, parametersForPlaybook, $scope).then(function (data) {
        if (data.result && data.result.query_result && (data.status !== 'failed')) {
          var unmaskedText = aiAssistantService.unmaskResult(maskedObjects, data.result.query_result);
          $scope.messages.conversationThroughOutApplication.push({ text: unmaskedText, type: 'bot', addComment: true, });
          updateLocalStorageData();
        }
        else {
          $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.playbookFailed, type: 'bot' });
        }
      },
        function (error) {
          $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.playbookFailed, type: 'bot' });
        }
      ).finally(function () {
        $scope.processingConversation = false;
        $timeout(function () {
          scrollToBottom();
        })
      })
    }

    // Function to generate a bot response 
    function generatePBDesignerConversation(userMessages) {
      $scope.processingConversation = true;
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['conversation'] = userMessages;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;

      //trigger playbook and get response when execution is completed
      aiAssistantService.getDataFromPlaybook($scope.playbookTags.conversation, parametersForPlaybook, $scope).then(function (data) {
        if (data.result && data.result.query_result && (data.status !== 'failed')) {
          $scope.messages.conversationInDesigner.push({ text: data.result.query_result, type: 'bot' });
          updateLocalStorageData();
        }
        else {
          if ((data.status === 'failed')) {
            $scope.messages.conversationInDesigner.push({ text: constantMessages.playbookFailed, type: 'bot' });
          }
        }
      },
        function (error) {
          $scope.messages.conversationInDesigner.push({ text: constantMessages.playbookFailed, type: 'bot' });
        }
      ).finally(function () {
        $scope.processingConversation = false;
        $timeout(function () {
          scrollToBottom();
        })
      })
    }

    //when review button is clicked paste the playbook block on pb-designer
    function generatePlaybook(descriptionMessage) {
      var playbookDescription = (typeof descriptionMessage === 'object' && descriptionMessage !== null) ? descriptionMessage : JSON.parse(descriptionMessage);
      $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookSuggestionMessages.proceedingToGenerate, type: 'botGeneral' });
      $timeout(function () {
        scrollToBottom();
      })

      var connectorsNotInstalled = [];
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['task_to_automate'] = playbookDescription;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;
      $scope.numberOfDivisions = countStepKeys(playbookDescription);
      $scope.processingPlaybook = true;
      $scope.generatePlaybookFlag = true;
      scrollToBottom();
      //trigger playbook and get response when execution is completed
      aiAssistantService.getDataFromPlaybook($scope.playbookTags.pBDesignerSteps, parametersForPlaybook, $scope).then(function (data) {
        $scope.generatePlaybookFlag = false;
        $scope.processCompleted = 6;
        if (data.result && data.result.data && (data.status !== 'failed')) {
          $rootScope.$broadcast('designer:addPlaybookElements', data.result.data);
          const customModal = document.getElementById('custom-modal');
          $timeout(function () {
            customModal.setAttribute('style', 'display:none;');
          }, 6000);
          toaster.info('Copied all selected steps');
          if ($scope.botType === 'Playbook Suggestion' && data.status != 'failed') {
            $scope.messages.playbookSuggestionMessages.push({
              text:
                constantMessages.playbookSuggestionMessages.generatedSuccessfully, type: 'botGeneral'
            });
            if (data.result.data.connectors_not_installed && data.result.data.connectors_not_installed.length > 0) {
              connectorsNotInstalled = data.result.data.connectors_not_installed.map(item => item.label);
              $scope.messages.playbookSuggestionMessages.push({ connectorsNotInstalled: connectorsNotInstalled, type: 'botGeneral' });
            }
            $timeout(function () {
              scrollToBottom();
            });
          }
        }
        else {
          $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookFailed, type: 'botGeneral' });
        }
      },
        function (error) {
          $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookFailed, type: 'botGeneral' });
        }
      ).finally(function () {
        $scope.generatePlaybookFlag = false;
        $scope.processingPlaybook = false;
        $timeout(function () {
          scrollToBottom();
        });
        setTimeout(function () {
          $rootScope.isBotWidgetOpen = false;
          $scope.close();
        }, connectorsNotInstalled.length < 1 ? 3000 : 5000);
      });
    }

    //get JSON playbook description 
    function generatePlaybookDescription(inputText) {
      $scope.processingPlaybook = true;
      var generateButton = document.getElementById('generate-result-button');
      if (generateButton) {
        generateButton.style.display = 'none';
      }
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;
      parametersForPlaybook.request.data['task_to_automate'] = inputText;
      if ($scope.botType === 'Playbook Suggestion') {
        $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookSuggestionMessages.buildingDescription, type: 'botGeneral' });
        $timeout(function () {
          scrollToBottom();
        })
      }
      aiAssistantService.getDataFromPlaybook($scope.playbookTags.pBDesignerDescription, parametersForPlaybook, $scope).then(function (data) {
        if (data.result && data.result.query_result && data.result.query_result.result && data.status !== 'failed') {
          $scope.processingPlaybook = false;
          $scope.messages.playbookSuggestionMessages.push({ text: data.result.query_result.result, type: 'bot', generatePlaybook: true });
          updateLocalStorageData();
          $scope.playbookDescription = data.result.query_result.result;
          $timeout(function () {
            scrollToBottom();
          })
        }
        else {
          $scope.processingPlaybook = false;
          $scope.playbookFailed = true;
          toaster.error({ body: constantMessages.playbookFailedToaster });
          $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookFailed, type: 'botGeneral' });
        }
      }
      ).catch(
        function (error) {
          $scope.processingPlaybook = false;
          $scope.playbookFailed = true;
          $scope.messages.playbookSuggestionMessages.push({ text: constantMessages.playbookFailed, type: 'botGeneral' });
        })
    }

    function returnParameters() {
      return {
        'input': {},
        'request': {
          'data': {
            'records': [],
          }
        },
        'useMockOutput': false,
        'globalMock': false,
        'force_debug': true
      };
    }

    function countStepKeys(data) {
      let count = 0;

      function countKeysRecursively(subObj) {
        for (const key in subObj) {
          if (key.includes('Step')) {
            count++;
          }
          if (typeof subObj[key] === 'object') {
            countKeysRecursively(subObj[key]);
          }
        }
      }
      countKeysRecursively(data);
      return count;
    }

    function openDocumentation() {
      $window.open('https://github.com/fortinet-fortisoar/solution-pack-fortinet-advisor/blob/release/2.0.0/docs/usage.md#prompting-tips', '_blank');
    }

    function updateRichTextHtmlValue(value) {
      //Placeholder
      updateLocalStorageData();
      return;
    }
  }
})();
