/* Copyright (C) 2008 - 2024 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('aiAssistant301Ctrl', aiAssistant301Ctrl);

  aiAssistant301Ctrl.$inject = ['$scope', 'toaster', '$rootScope', '$q', '$timeout', 'localStorageService', 'aiAssistantService', '$window', '$state', 'widgetBasePath', 'Entity', 'COMMENT_TYPES', 'Modules', '$filter', 'currentPermissionsService', 'FormEntityService', 'playbookService', 'usersService', '$location', 'Cryptography', 'CommonUtils', 'clipboard'];

  function aiAssistant301Ctrl($scope, toaster, $rootScope, $q, $timeout, localStorageService, aiAssistantService, $window, $state, widgetBasePath, Entity, COMMENT_TYPES, Modules, $filter, currentPermissionsService, FormEntityService, playbookService, usersService, $location, Cryptography, CommonUtils, clipboard) {

    var widgetBasePath = widgetBasePath;
    var constantMessages = aiAssistantService.constantMessages();
    const initialBotMessage = {
      conversationThroughOutApplication: [{
        text: constantMessages.botGeneralMessages.initialMessage,
        type: 'botGeneral'
      }]
    };
    $scope.messages = loadDataFromLocalStorage() || angular.copy(initialBotMessage);
    $scope.pageState = $state;
    $scope.updateRichTextHtmlValue = updateRichTextHtmlValue;
    $scope.clearConversation = clearConversation;
    $scope.generatePlaybook = generatePlaybook;
    $scope.openDocumentation = openDocumentation;
    $scope.prepareMaskedData = prepareMaskedData;
    $scope.adjustTextareaHeight = adjustTextareaHeight;
    $scope.hideQuestionsPopUp = hideQuestionsPopUp;
    $scope.addComment = addComment;
    $scope.processSelectedQuestion = processSelectedQuestion;
    $scope.playbookDescription = '';
    $scope.showDescription = false;//To append review results button to the bot text, button only visible on playbook description
    $scope.generatePlaybookFlag = false;
    $scope.processingConversation = false;
    $scope.inPlaybookDesignerPage = false;
    $scope.disableTextArea = true;
    $scope.isConnectorConfigured = true;
    $scope.showStaticQuestions = false;
    $scope.playbookPermission = currentPermissionsService.getPermission('workflows');
    $scope.listOfQuestions = {};
    $scope.recommendationSettings = {};
    $scope.suggestedPlaybooksList = [];
    $scope.isLightTheme = $rootScope.theme.id === 'light';
    $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
    $scope.bulbIcon = $scope.isLightTheme ? widgetBasePath + 'images/bulb-light.svg' : widgetBasePath + 'images/bulb-dark.svg';
    $scope.botIcon = widgetBasePath + 'images/bot.svg';
    $scope.playbookTags = {
      pBDesignerSteps: [constantMessages.playbookTags.pBDesignerSteps]
    };
    $scope.options = {
      'name': 'Workflow Steps',
      mode: 'form',
      modes: ['code', 'form'],
      'enableTransform': true,
      'enableSort': false
    };
    $scope.configForMarkdown = {
      initialEditType: 'markdown',
      previewStyle: 'tab',
      height: '420px',
      usageStatistics: false,
      hideModeSwitch: true,
      toolbarItems: ['']
    };
    $scope.userInput = {
      textVal: ''
    };
    $scope.inputText = {
      inputText: '',
    };
    $scope.processCompleted = 6; //variables for playbook percentage loader
    $scope.loadingThreadConversation = true; //on load if thread conversation are present to be loaded
    $scope.staticQuestionsPresent = false;
    $scope.textAreaFocused = textAreaFocused;
    $scope.errorExists = false;
    $scope.inRecordDetailedView = false;

    var selectedQuestion = '';
    var stateChangeSuccess = '';
    var keyStoreJSONValue = {};
    var staticQuestionsModule = [];
    var maskedObjects = { emails: {}, urls: {}, domains: {}, ips: {}, hashes: {}, sha256: {}, sha1: {}, md5: {} };
    var maskedObjectFactory = { ioc_type: [], masked_data: {} }; //to store the masked object in userPref
    var recordMetadata = {}; //to create records and field data
    var record_data = {}; // to create records and fieldOfInterest data to pass in payload
    var currentModule = undefined;
    var currentModuleId = undefined;
    var keyStoreProperties = constantMessages.keyStoreProperties;
    let user = usersService.getCurrentUser();
    const currentUserId = user.userId;
    var userLoginId = '', recordIRI = '', previousRecordIRI = '';
    var threadId = '';
    var soc_assistantId = '';
    var aiConfiguration = {};
    var responseProtocol = aiAssistantService.constantMessages().responseProtocol;
    var staticQuestionPopUpShown = false;
    var record_context_updated = false;
    var keystorePermission = currentPermissionsService.getPermission('keys');

    init();
    
    function init() {
      maskedObjectFactory = { ioc_type: [], masked_data: {} };
      if(keystorePermission.read){
        $scope.errorExists = false;
        $q.all([loadUserLoginDetails(), loadKeyStoreData()]).then((response) => {
            getAIConfiguration();
            stateChangeSuccessFunction(); //to activate the stateChange listener on init
            updateModuleDataOnEventChange($scope.pageState.current, $scope.pageState.current.params);
        },function(error){
          hideLoaders();
        });
      }
      else{
        $scope.errorExists = true;
        $scope.messages.conversationThroughOutApplication = [];
          $scope.messages.conversationThroughOutApplication.push({
            text: aiAssistantService.constantMessages().botGeneralMessages.keystorePermissionError,
            type: 'botGeneral'
          });
          hideLoaders();
      }
    }

    function loadUserLoginDetails(){
      var defer = $q.defer();
      aiAssistantService.getUserLoginId(currentUserId).then(function (userLoginDetails) {
        if (userLoginDetails && userLoginDetails.usersresp && userLoginDetails.usersresp[0].loginid) {
          userLoginId = userLoginDetails.usersresp[0].loginid;
          defer.resolve();
        }
      }, function (error) {
        console.log(error);
        hideLoaders();
      });
      return defer.promise;
    }

    function loadKeyStoreData(){
      var defer = $q.defer();
      aiAssistantService.getKeyStoreRecord(keyStoreProperties.fortiAIStaticQuestions.queryParameters, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          keyStoreJSONValue = response['hydra:member'][0].jSONValue;
          staticQuestionsModule = Object.keys(keyStoreJSONValue['modules']);
          defer.resolve();
        }  else {
          toaster.error({ body: keyStoreProperties.fortiAIStaticQuestions.errorMessage });
          hideLoaders();
        }
      });
      return defer.promise;     
    }

    function fetchStaticQuestions(currentModule) {
      $scope.listOfQuestions = {};
      if(keyStoreJSONValue.modules[currentModule].questions && keyStoreJSONValue.modules[currentModule].questions.length > 0){
        $scope.staticQuestionsPresent = true;
        for (const module of keyStoreJSONValue.modules[currentModule].questions) {
          if (module.enabled) {
            $scope.listOfQuestions[module.question] = module.description ? module.description : '';
          }
        }
      }
      else{
        $scope.staticQuestionsPresent = false;
      }
    }

    function addComment(index, fetchFrom) {
      $scope.processingConversation = true;
      var comment = {
        content: $scope.messages[fetchFrom][index].text,
        recordTags: ['FortiAI'],
        type: COMMENT_TYPES.COMMENT,
        people: []
      };
      var parentIri = $filter('prependIri')(currentModule + '/' + currentModuleId);
      comment[$scope.pageState.current.params.module] = [parentIri];
      comment.uuid = $window.UUID.generate();
      Modules.save({
        module: 'comments'
      }, angular.copy(comment)).$promise.then(function (response) {
        toaster.success({ body: 'Added as a comment to this record successfully!' });
      }).catch(function (error) {
        toaster.error({ body: "Unable to save comment" });
      }).finally(function () {
        $scope.processingConversation = false;
      })
    }

    function processSelectedQuestion(selectedMessage) {
      $scope.processingConversation = true;
      hideQuestionsPopUp(true);
      selectedQuestion = selectedMessage;
      var _selectedQuestion = keyStoreJSONValue['modules'][$scope.pageState.current.params.module]['questions'][Object.entries($scope.listOfQuestions).findIndex(([key, value]) => key === selectedQuestion)];
      $scope.messages.conversationThroughOutApplication.push({ text: _selectedQuestion.question, type: 'user' });
      prepareMaskedData().then(function() {
        //promise executed
      });
    }

    function prepareMaskedData() {
      var defer = $q.defer();
      if(currentModule){
        var fieldsOfInterest = keyStoreJSONValue['modules'][currentModule]['fieldsOfInterest'];
        if (fieldsOfInterest !== undefined) {
          prepareRecordData(fieldsOfInterest).then(function() {
            defer.resolve();
          }, function(error) {
            defer.reject(error);
          });
        }
        else {
          toaster.error({ body: "Fields of Interest not present for the selected module in key store record" });
          hideLoaders();
          defer.resolve();
        }
      } else {
        defer.resolve();
      }
      return defer.promise;
    }

    function prepareRecordData(fieldsOfInterest) {
      var defer = $q.defer();
      $scope.entity = FormEntityService.get();
      var moduleName = currentModule;
      var entity = new Entity(moduleName);
      if (!angular.isUndefined($scope.entity) && !angular.isUndefined($scope.entity.originalData['@id'])) {
        recordIRI = $scope.entity.originalData['@id'];
        previousRecordIRI === recordIRI ? record_context_updated = false : record_context_updated = true;
        previousRecordIRI = recordIRI;
      }
      entity.get(currentModuleId, {
        $relationships: true
      }).then(function (metaData) {
        recordMetadata = {
          fields: {},
          similarRecords: {}
        };
        var corelatedModules = [];
        var promises = [];
        var relatedData = {};
        var relatedEntities = {};
        var entityRelationshipFields = entity.getRelationshipFieldsArray();
        entityRelationshipFields.forEach(element => {
          if (Object.keys(keyStoreJSONValue['modules']).includes(element.name) && (moduleName !== element.name)) {
            corelatedModules.push({ name: element.name, data: keyStoreJSONValue['modules'][element.name], value: element.value });
            const fieldsOfInterest = keyStoreJSONValue['modules'][element.name].fieldsOfInterest;
            if (fieldsOfInterest) {
              var relatedEntity = new Entity(element.name);
              promises.push(
                relatedEntity.loadFields().then(function () {
                  relatedEntities[element.name] = relatedEntity;
                }));
              promises.push(
                aiAssistantService.getDetailData(moduleName, currentModuleId, element.name, fieldsOfInterest.toString()).then(function (data) {
                  relatedData[element.name] = data;
                }));
            }
          }
        });
        // Example usage
        // Main Entity
        var recordObj = {};
        fieldsOfInterest.forEach(element => {
          if (entity.fields[element]) {
            if (entity.fields[element].type != "picklist" && entity.fields[element].type != "manyToMany" && entity.fields[element].type != "manyToOne" && entity.fields[element].type != "datetime" && entity.fields[element].type != "lookup" && entity.fields[element].value) {
              recordObj[element] = typeof entity.fields[element].value === 'string'
                ? entity.fields[element].value : String(entity.fields[element].value);
            }
            else if (entity.fields[element].type === "picklist") {
              if (entity.fields[element].value) {
                recordObj[element] = entity.fields[element].value.itemValue;
              }
            }
            else if (entity.fields[element].type === "datetime") {
              if(entity.fields[element].value && entity.fields[element].value !== ''){
                recordObj[element] = aiAssistantService.epochToReadable(entity.fields[element].value);
              }
            }
          }
        });
        recordMetadata.fields[$scope.pageState.current.params.module] = recordObj;

        $q.all(promises).then(function () {
          // Related entity
          corelatedModules.forEach((module) => {
            var entity = relatedEntities[module.name];
            var fieldsOfInterest = module.data.fieldsOfInterest;
            var relatedModuleData = relatedData[module.name];
            if (fieldsOfInterest) {
              var recordObj = [];
              relatedModuleData.forEach((data) => {
                var fieldObj = {};
                fieldsOfInterest.forEach(fieldName => {
                  if (entity.fields[fieldName]) {
                    if (entity.fields[fieldName].type != "picklist" && entity.fields[fieldName].type != "manyToMany" && entity.fields[fieldName].type != "manyToOne" && entity.fields[fieldName].type != "datetime" && entity.fields[fieldName].type != "lookup" && data[fieldName]) {
                      fieldObj[fieldName] = typeof data[fieldName] === 'string'
                        ? data[fieldName] : String(data[fieldName]);
                    }
                    else if (entity.fields[fieldName].type === "picklist") {
                      if (data[fieldName] && data[fieldName]) {
                        fieldObj[fieldName] = data[fieldName].itemValue;
                      }
                    }
                    else if (entity.fields[fieldName].type === "datetime") {
                      fieldObj[fieldName] = aiAssistantService.epochToReadable(data[fieldName]);
                    }
                  }
                });
                recordObj.push(fieldObj);
              });
              recordMetadata.fields[module.name] = recordObj;
            }
          });

          if ($scope.recommendationSettings) {
            aiAssistantService.getSimilarRecords($scope.recommendationSettings.workspace, $scope.entity, angular.copy(fieldsOfInterest)).then(function (similarRecords) {
              recordMetadata.similarRecords = similarRecords;
              maskRecordData().then(function() {
                defer.resolve();
              }, function(error) {
                defer.reject(error);
              });
            }, function (error) {
              defer.reject(error);
              toaster.error({ body: "Could not load similar records" })
            })
          } else {
            maskRecordData().then(function() {
              defer.resolve();
            }, function(error) {
              defer.reject(error);
            });
          }
        });
      },
        function (err) {
          console.log('Error in fetching module record data from AI bot. Please reload the page');
          $scope.processingConversation = false;
          defer.reject(err);
        });
        return defer.promise;
    }

    //mask all record data - stringify and pass it to getArtifacts function which mask the data and adds it in maskedObjectFactory
    function maskRecordData() {
      var defer = $q.defer();
      var stringMetaData = JSON.stringify(angular.copy(recordMetadata));
      aiAssistantService.getArtifacts(stringMetaData)
        .then(function (artifacts) {
          maskedObjects = artifacts.data;
          record_data['correlated_record'] = {};
          let maskedObjectFactoryLastValue = angular.copy(maskedObjectFactory);
          for (const key in recordMetadata.fields) {
            if (angular.isArray(recordMetadata.fields[key])) {
              recordMetadata.fields[key].forEach(data => {
                aiAssistantService.replaceArtifactsWithMaskedData(data, maskedObjects, maskedObjectFactory);
              });
              record_data['correlated_record'][key] = recordMetadata.fields[key];
            } else {
              aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.fields[key], maskedObjects, maskedObjectFactory);
              record_data['primary_record'] = recordMetadata.fields[key];
            }
          }
          record_data['similar_records'] = [];
          for (const key in recordMetadata.similarRecords) {
            aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.similarRecords[key], maskedObjects, maskedObjectFactory);
            record_data['similar_records'].push(recordMetadata.similarRecords[key]);           
          }
          if (!angular.equals(maskedObjectFactoryLastValue.masked_data, maskedObjectFactory.masked_data)) {
            updateUserPreferenceData();
          }
          if (selectedQuestion) {
            generateApplicationConversation(selectedQuestion); //to pass question directly 
            selectedQuestion = '';
          }
          defer.resolve();
        })
        .catch(function (error) {
          defer.reject(error);
          toaster.error({ body: "Error in fetching artifacts" });
          console.error('Error:', error);
        });
      return defer.promise;
    }

    $scope.executePlaybook = function (playbook) {
      aiAssistantService.getPlaybook(playbook.actionUuid, $scope.entity.module).then(function (result) {
        playbookService.triggerPlaybookAction(result.data, $scope.getOriginalRecord, $scope, false, $scope.entity);
      }, function (error) {
        statusCodeService(error, true);
      });
    };

    $scope.getOriginalRecord = function () {
      var records = [];
      records.push({
        '@id': $scope.entity.originalData['@id']
      });
      return records;
    };

    function checkConnectorHealth() {
      aiAssistantService.connectorHealthCheck(aiConfiguration, userLoginId).then(function (result) {
        if(result && result.availability_status && result.connector_config){
          getassistantId();
          $scope.isConnectorConfigured = true;
          $scope.errorExists = false;     
        }
        else{
          $scope.errorExists = true;
          $scope.messages.conversationThroughOutApplication = [];
          if(result && !angular.isUndefined(result.error_message) && result.error_message !== ''){
            $scope.messages.conversationThroughOutApplication.push({
              text: result.error_message  ,
              type: 'botGeneral'
            });
          }
          else{
            if(result && !result.availability_status){
              $scope.messages.conversationThroughOutApplication.push({
                text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotAvailable,
                type: 'botGeneral'
              });
            }
            else{
              $scope.messages.conversationThroughOutApplication.push({
                text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotConfigured,
                type: 'botGeneral'
              });
            }
          }
          $scope.disableTextArea = true;
          $scope.isConnectorConfigured = false;
          hideLoaders();
        }
      },function(err){
        $scope.errorExists = true;
        $scope.messages.conversationThroughOutApplication = [];
        $scope.messages.conversationThroughOutApplication.push({
          text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotConfigured,
          type: 'botGeneral'
        });
        $scope.disableTextArea = true;
        $scope.isConnectorConfigured = false;
        hideLoaders();
      });
    }

    function stateChangeSuccessFunction() {
      stateChangeSuccess = $scope.$on('$stateChangeSuccess', function (event, toState, toParams, from, fromParams) {
        updateModuleDataOnEventChange(toState,toParams); //update parameters on state change
      });
    }

    //update all module related data as per current state and params
    function updateModuleDataOnEventChange(state,params){
      record_context_updated = false;
      recordIRI = '';
      previousRecordIRI = '';
      if (state.name.includes('main.playbookDetail')) {
        $scope.inPlaybookDesignerPage = true;
      }
      else {
        $scope.inPlaybookDesignerPage = false;
        if (state.name.includes('viewPanel.modulesDetail') && staticQuestionsModule.includes(params.module)) {
          $scope.entity = FormEntityService.get();
          currentModule = params.module;
          currentModuleId = params.id;
          record_context_updated = true;
          $scope.inRecordDetailedView = true;
          aiAssistantService.getRecommendationSettings($scope.pageState.current.params.module).then(function (response) {
            $scope.recommendationSettings = response;
          });
          fetchStaticQuestions(params.module);
          if(!staticQuestionPopUpShown){
            hideQuestionsPopUp(false);
          }
        }
        else{
          $scope.inRecordDetailedView = false;
        }
      }
    }
    
    function hideQuestionsPopUp(hide) {
      const customModal = document.getElementById('record-static-questions');
      if (hide) {
        customModal.setAttribute('style', 'display:none;');
        $timeout(function () {
          scrollToBottom();
        });
      }
      else {
        customModal.setAttribute('style', 'display:inline-block;');
        adjustTextareaHeight(true);
        staticQuestionPopUpShown = true;
      }
    }

    $scope.$on('popupOpened', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        stateChangeSuccessFunction(); //to activte the stateChange listener on pop-up open
        $scope.isLightTheme = $rootScope.theme.id === 'light';
        $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
        updateModuleDataOnEventChange($scope.pageState.current, $scope.pageState.current.params); //as state change doesn't fire on 
      }
    })

    $scope.$on('popupClosed', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        //to destroy the stateChange listener on pop-up close
        stateChangeSuccess(); 
      }
    })

    $scope.$on('$destroy', function () {
      stateChangeSuccess();
    });

    function loadDataFromLocalStorage() {
      return JSON.parse(localStorageService.get('aiAssistantBot.messages'));
    }

    function clearConversation() {
      $scope.messages = angular.copy(initialBotMessage);
      updateLocalStorageData();
      maskedObjectFactory.ioc_type = [];
      maskedObjectFactory.masked_data =  {} ;
      deleteThreadId();
    }

    function updateLocalStorageData() {
      localStorageService.set('aiAssistantBot.messages', JSON.stringify(aiAssistantService.copyWithoutBotGeneral($scope.messages)));
    }

    //scroll to bottom when new conversation message is added
    function scrollToBottom() {
      var container = document.getElementById('bot-conversation-body');
      container.scrollTop = container.scrollHeight;
    }

    function adjustTextareaHeight(fromKeypress) {
      var textarea = document.getElementById('conversation-text-input');
      //fetching height of custom modal from drawerWidgetGroup.html 
      var aiAssistantBot = document.getElementById('custom-modal');
      var userInputContainer = document.getElementById('user-input-container');
      var recordQuestionsBox = document.getElementById('record-static-questions');
      var botConversationBody = document.getElementById('bot-conversation-body');
      if (fromKeypress) {
        textarea.style.height = "auto"; // Reset textarea height
        textarea.style.height = (textarea.scrollHeight) + "px"; // Set new height
        var bottomForStaticQuestions = (textarea.scrollHeight) + 12 > 362 ? 362 : (textarea.scrollHeight) + 12;
        recordQuestionsBox.style.bottom = bottomForStaticQuestions + "px"; // Set new height
        $timeout(function () {
          var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 150; //(150 = including .modal-drag & header image, +10px for bottom space)
          botConversationBody.style.height = botConversationBodyHeight + 'px';
          botConversationBody.style.maxHeight = '100%';
          scrollToBottom();
        }, 200);
      }
      else {
        textarea.style.height = "46px";
        recordQuestionsBox.style.bottom = "58px";
        var userInputContainer = document.getElementById('user-input-container');
        $timeout(function () {
          var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 150; //(150 = including .modal-drag & header image, +10px for bottom space)
          botConversationBody.style.height = botConversationBodyHeight + 'px';
          botConversationBody.style.maxHeight = '100%';
          scrollToBottom();
        }, 200);
      }
    };

    //generate response if enter is pressed in textbox
    $scope.sendMessage = function (event, flagEnterClick) {
      //if conversation option is selected
      if (((event.keyCode === 13 && !event.shiftKey) || flagEnterClick) && ($scope.userInput.textVal && $scope.userInput.textVal !== '')) {
        var _index = 0;
        var jsonString = '';
        $scope.processingConversation = true;
        $scope.messages.conversationThroughOutApplication.push({ text: $scope.userInput.textVal, type: 'user' });
        _index = $scope.messages.conversationThroughOutApplication.length;
        jsonString = JSON.stringify(angular.copy($scope.messages.conversationThroughOutApplication[_index - 1].text));
        record_data = {};
        updateLocalStorageData();
        // Process user input and generate a bot response
        if($scope.inRecordDetailedView){
          prepareMaskedData().then(function() {
            proceedToGenerateResponse(jsonString);
          });
        }
        else{
          proceedToGenerateResponse(jsonString);
        }
        $timeout(function () {
          adjustTextareaHeight(false);
        });
      }
    };

    //proceedToGenerateResponse after message is typed in text area
    function proceedToGenerateResponse(jsonString) {
      $scope.userInput.textVal = '';
      aiAssistantService.getArtifacts(JSON.stringify(angular.copy(jsonString)))
        .then(function (artifacts) {
          maskedObjects = artifacts.data;
          let maskedObjectFactoryLastValue = angular.copy(maskedObjectFactory);
          var maskedString = aiAssistantService.replaceArtifactsInString(jsonString, maskedObjects, maskedObjectFactory);
          if (!angular.equals(maskedObjectFactoryLastValue.masked_data, maskedObjectFactory.masked_data)) {
            updateUserPreferenceData();
          }
          var maskedJSON = JSON.parse(maskedString);
          generateApplicationConversation(maskedJSON);
        })
        .catch(function (error) {
          console.error('Error:', error);
        });
    }

    // Function to generate a bot response through connector action
    function generateApplicationConversation(userMessage) {
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['conversation'] = userMessage;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;
      var messageIndex = undefined;
      var payload = {
        'genai_type': aiConfiguration['llmIntegrationTitle'], 
        'genai_arguments': {
        'content': userMessage, 'thread_id': threadId, 'role': 'user', 'ioc_data': maskedObjectFactory,
        'auth_token': Cryptography.getAuthToken(), 'assistant_id': soc_assistantId, 'record_iri': recordIRI, 'record_data': record_data,
            'page_name': currentModule || '', 'config_id': userLoginId, 'record_context_updated': record_context_updated
        }
      };
      aiAssistantService.executeAction('aiassistant-utils', 'get_llm_response', userLoginId, payload)
        .then(function (response) {
          if (response && response.data && response.data.llm_response) {
            if (!threadId && response.data.thread_id) {
              threadId = response.data.thread_id;
              updateUserPreferenceData();
            }
            if(response.data.llm_response.length > 0){ //llm_response returns array 
                response.data.llm_response.forEach(llm_response_data => {
                //check is_playbook_outline for playbook generation
                if (llm_response_data.indexOf(responseProtocol['playbookOutline']) > -1) {
                  var llm_response_json = convertToJson(llm_response_data);
                  $scope.messages.conversationThroughOutApplication.push({ text: JSON.stringify(llm_response_json.response), type: 'bot', addComment: true, isPlaybookOutline: true, generatePlaybook: true });
                  $scope.processingConversation = false;
                }
                else {
                  let navigationPresent = checkIfNavigationPresent(llm_response_data);
                  if (navigationPresent) {
                    $scope.messages.conversationThroughOutApplication.push({ text: navigationPresent.latestMessage, type: 'bot' });
                  }
                  else {
                    $scope.messages.conversationThroughOutApplication.push({ text: llm_response_data, type: 'bot', addComment: true });
                  }
                  messageIndex = $scope.messages.conversationThroughOutApplication.length;
                  unmaskingResponse(messageIndex);
                  updateLocalStorageData();
                  $scope.processingConversation = false;
                }
              });
            }
          }
          $timeout(function () {
            scrollToBottom();
          })
        }, function (error) {
          toaster.error({ body: error.data.message || 'Assistant id or Thread id not found' });
          hideLoaders();
        })
        .catch(function (error) {
          console.error('Error:', error);
          $scope.processingConversation = false;
          hideLoaders();
        });

    }

    function convertToJson(inputString) {
      // Replace single quotes with double quotes and True with true
      let jsonString = inputString.replaceAll("\'", "\"").replace("\"{", "{").replace("}\"", "}").replace("True", "true");

      // Parse the string to a JSON object
      let jsonObject = JSON.parse(jsonString);
      return jsonObject;
    }

    //to unmask the response
    function unmaskingResponse(messageIndex) {
      var currentMaskedData = $scope.messages.conversationThroughOutApplication[messageIndex - 1].text;
      var currentUnMaskedData = '';
      currentUnMaskedData = aiAssistantService.unmaskString(maskedObjectFactory.masked_data, currentMaskedData);
      $scope.messages.conversationThroughOutApplication[messageIndex - 1].text = currentUnMaskedData;
    }
    

    //when review button is clicked paste the playbook block on pb-designer
    function generatePlaybook(descriptionMessage) {
      var playbookDescription = (typeof descriptionMessage === 'object' && descriptionMessage !== null) ? descriptionMessage : JSON.parse(descriptionMessage);
      $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.botGeneralMessages.proceedingToGenerate, type: 'botGeneral' });
      var connectorsNotInstalled = [];
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['task_to_automate'] = playbookDescription;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;
      $scope.numberOfDivisions = countStepKeys(playbookDescription);
      $scope.generatePlaybookFlag = true;
      //trigger playbook and get response when execution is completed
      aiAssistantService.getDataFromPlaybook($scope.playbookTags.pBDesignerSteps, parametersForPlaybook, $scope).then(function (data) {
        $scope.generatePlaybookFlag = false;
        $scope.processCompleted = 6;
        if (data.result && data.result.data && (data.status !== 'failed')) {
          if($scope.inPlaybookDesignerPage){
            $rootScope.$broadcast('designer:addPlaybookElements', data.result.data);
            const customModal = document.getElementById('custom-modal');
            $timeout(function () {
              customModal.setAttribute('style', 'display:none;');
            }, 1000);
          }
          else{
            CommonUtils.copy(data.result.data);
            //clipboard.copyText('copy this text');
          }
          toaster.info('Copied all selected steps');
          if (data.status != 'failed') {
            $scope.messages.conversationThroughOutApplication.push({
              text:
                constantMessages.botGeneralMessages.generatedSuccessfully, type: 'botGeneral'
            });
            if (data.result.data.connectors_not_installed && data.result.data.connectors_not_installed.length > 0) {
              connectorsNotInstalled = data.result.data.connectors_not_installed.map(item => item.label);
              $scope.messages.conversationThroughOutApplication.push({ connectorsNotInstalled: connectorsNotInstalled, type: 'botGeneral' });
            }
            $timeout(function () {
              scrollToBottom();
            });
          }
        }
        else {
          $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.botGeneralMessages.playbookFailed, type: 'botGeneral' });
        }
      },
        function (error) {
          $scope.messages.conversationThroughOutApplication.push({ text: constantMessages.botGeneralMessages.playbookFailed, type: 'botGeneral' });
        }
      ).finally(function () {
        $scope.generatePlaybookFlag = false;
        $timeout(function () {
          scrollToBottom();
        });
        setTimeout(function () {
          if ($scope.inPlaybookDesignerPage) {
            $rootScope.isBotWidgetOpen = false;
            $scope.close();
          }
        }, connectorsNotInstalled.length < 1 ? 3000 : 5000);
      });
    }

    //check if returned message has navigation present and then navigate to that URL
    function checkIfNavigationPresent(latestMessage, fromLoadConversation) {
      if (latestMessage.includes(responseProtocol['recordNavigation'])) {
        return {latestMessage : prepareURLToNavigate(latestMessage,responseProtocol['recordNavigation'], fromLoadConversation, 'recordNavigation')};
      }
      else if(latestMessage.includes(responseProtocol['recordCreation'])){
        return { latestMessage: prepareURLToNavigate(latestMessage,responseProtocol['recordCreation'], fromLoadConversation, 'recordCreation')};
      }
      else if(latestMessage.includes(responseProtocol['playbookExecutionLog'])){
        return { latestMessage: prepareURLToNavigate(latestMessage,responseProtocol['playbookExecutionLog'], fromLoadConversation, 'playbookExecutionLog')};
      }
      else {
        return false;
      }
    }

    //to check which action has to be performed for navigation and is it called from load thread conversation 
    function prepareURLToNavigate(latestMessage, navigateAction, fromLoadConversation, protocol) { 
      let urlString = aiAssistantService.fetchURL(latestMessage);
      let navigateURL = urlString.split(navigateAction)[1];
      switch (protocol) {
        case 'recordNavigation':
          latestMessage  = aiAssistantService.getUpdatedURL(navigateURL, 'recordNavigation', latestMessage);
          let ifRecordOpen = aiAssistantService.checkIfRecordOpen(recordIRI,navigateURL);
          if (!fromLoadConversation && !ifRecordOpen) { //do not navigate while loading past conversations          
            $location.url(navigateURL);
          }
          break;
        case 'recordCreation':
          latestMessage  = aiAssistantService.getUpdatedURL(navigateURL, 'recordCreation', latestMessage);
          break;
        case 'playbookExecutionLog':
          latestMessage = aiAssistantService.getUpdatedURL(navigateURL, 'playbookExecutionLog', latestMessage);
          break;
        default:
          break;
      }
      return latestMessage;
    }

    function returnParameters() {
      return {
        'input': {},
        'request': {
          'data': {
            'records': [],
          }
        },
        'useMockOutput': false,
        'globalMock': false,
        'force_debug': true
      };
    }

    function countStepKeys(data) {
      let count = 0;

      function countKeysRecursively(subObj) {
        for (const key in subObj) {
          if (key.includes('Step')) {
            count++;
          }
          if (typeof subObj[key] === 'object') {
            countKeysRecursively(subObj[key]);
          }
        }
      }
      countKeysRecursively(data);
      return count;
    }

    function openDocumentation() {
      $window.open('https://github.com/fortinet-fortisoar/solution-pack-fortinet-advisor/blob/release/2.0.0/docs/usage.md#prompting-tips', '_blank');
    }

    function updateRichTextHtmlValue(value) {
      //Placeholder
      updateLocalStorageData();
      return;
    }

    //get thread id from user pref and load thread conversation
    function getThreadFromUserPreference() {
      aiAssistantService.getUserPreferences().then(function (threadIdDetails) {
        if (threadIdDetails && threadIdDetails.preferences) {
          setThreadDetails(threadIdDetails);
        }
        else{
          hideLoaders();
        }
      });
    }

    function setThreadDetails(threadIdDetails) {
      let threadData = threadIdDetails.preferences['genai_metadata']['openai']['assisstant_threads'][0];
      if (threadData['masked_data_mapping']) {
        maskedObjectFactory = threadData['masked_data_mapping'];
      }
      if(angular.isArray(maskedObjectFactory['masked_data']) && maskedObjectFactory['masked_data'].length === 0){
        maskedObjectFactory['masked_data'] = {};
      }
      threadId = threadData['thread_id'];
      if(threadId){
        $scope.messages.conversationThroughOutApplication.length === 1 ? fetchThreadConversationList() : hideLoaders();
      } 
      else{
        hideLoaders();
      }
      $timeout(function () {
        adjustTextareaHeight();
      });
    }

    function hideLoaders() {
      $scope.loadingThreadConversation = false;
      $scope.processingConversation = false;
      $scope.disableTextArea = false;
    }

    //delete thread id and generate new thread id
    function deleteThreadId() {
      $scope.disableTextArea = true;
      if (threadId !== '') {
        var _payload = {
          'genai_type': aiConfiguration['llmIntegrationTitle'],
          'genai_arguments': { thread_id: threadId, 'auth_token': Cryptography.getAuthToken(), 'config_id': userLoginId }
        };
        aiAssistantService.executeAction('aiassistant-utils', 'clear_conversation', userLoginId, _payload).then(function (threadData) {
          if (threadData && threadData.data && threadData.data['deleted']) {
            $scope.disableTextArea = false;
            hideLoaders();
           //thread deleted 
          }
        },function(error){
          if(error && error.data && error.data.message){
            toaster.error({ body: error.data.message });
            console.error('Error:', error);
            $scope.disableTextArea = false;
            hideLoaders();
          }
        });
        threadId = '';

        //clear thread and masked_object and set in user pref
        var _bodyParams = {
          "genai_metadata": {
            "openai": {
              "assisstant_threads": [
                {
                  "thread_id": threadId,
                  'masked_data_mapping': maskedObjectFactory
                }
              ]
            }
          }
        }
        aiAssistantService.setUserPreferences(_bodyParams).then(function (response) {
          if (response) {
            console.log("Successfully deleted and cleared conversation.");
          }
        });
      } else {
        $scope.disableTextArea = false;
        hideLoaders();
      }
    }

    function getAIConfiguration(){
      aiAssistantService.getKeyStoreRecord(keyStoreProperties.fortiAIConfiguration.queryParameters, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0]) && (response['hydra:member'][0].jSONValue.llmIntegrationToUse)) {
          aiConfiguration['llmIntegrationName'] = response['hydra:member'][0].jSONValue.llmIntegrationToUse;
          aiConfiguration['isMultiConfigAvailable'] = response['hydra:member'][0].jSONValue.llmIntegrationData[aiConfiguration['llmIntegrationName']].isMultiConfigAvailable;
          const matchingLLM = response['hydra:member'][0].jSONValue.llmIntegrations.filter(llm => llm.name === aiConfiguration['llmIntegrationName'])[0];
          if (matchingLLM) {
            aiConfiguration['llmIntegrationTitle'] = matchingLLM.title;
          }
          aiConfiguration['messagesLimit'] = response['hydra:member'][0].jSONValue.llmIntegrationData[aiConfiguration['llmIntegrationName']].messagesLimit;
          checkConnectorHealth();
        }else {
          toaster.error({ body: keyStoreProperties.fortiAIConfiguration.errorMessage });
          hideLoaders();
        }
      });
    }
    
    //get assisstant id 
    function getassistantId() {
      $scope.disableTextArea = false;
      var payload = { genai_type: aiConfiguration['llmIntegrationTitle'] };
      aiAssistantService.executeAction('aiassistant-utils', 'get_assistant_ids', userLoginId, payload)
        .then(function (response) {
          if (response && response.data) {
            soc_assistantId = response.data.soc_assistant_id;
            getThreadFromUserPreference();
            $scope.errorExists = false;
          }else{
            $scope.errorExists = true;
            $scope.messages.conversationThroughOutApplication = [];
            $scope.messages.conversationThroughOutApplication.push({
              text: aiAssistantService.constantMessages().botGeneralMessages.assistantNotFound,
              type: 'botGeneral'
            });
            hideLoaders();
            $scope.disableTextArea = false;
          }
        }, function (error) {
          $scope.errorExists = true;
          $scope.messages.conversationThroughOutApplication = [];
            $scope.messages.conversationThroughOutApplication.push({
              text: aiAssistantService.constantMessages().botGeneralMessages.assistantFailed,
              type: 'botGeneral'
          });
          hideLoaders();
          $scope.disableTextArea = false;
          console.log(error)
        });
    }

    //fetch messages against the current thread id from aiassistant-utils connector
    function fetchThreadConversationList() {
      $scope.loadingThreadConversation = true;
      var payload = {'genai_type': aiConfiguration['llmIntegrationTitle'], 
      'genai_arguments': { thread_id: threadId, 'auth_token': Cryptography.getAuthToken(), 'config_id': userLoginId, 'limit': aiConfiguration['messagesLimit'] || ''}}
      aiAssistantService.executeAction('aiassistant-utils', 'get_past_conversation', userLoginId, payload).then(function (threadList) {
        hideLoaders();
        if (threadList && threadList.data && threadList.data['data'].length > 0) {
          $scope.messages = angular.copy(initialBotMessage);
          let threadListMessages = threadList.data['data'];
          threadListMessages.reverse();
          threadListMessages.forEach(message => {
            let text = message.content[0]['text']['value'];
            message.role === 'assistant' ?  addConversationAsPerConditions(text) : $scope.messages.conversationThroughOutApplication.push({ 
              text: text, 
              type: 'user' 
            });
            let messageIndex = $scope.messages.conversationThroughOutApplication.length;
            unmaskingResponse(messageIndex);
            updateLocalStorageData();
          });
          $timeout(function () {
            adjustTextareaHeight();
          });
        }
      }, function (error) {
        if (error) {
          toaster.error({ body: "Failed to fetch messages from thread" });
          hideLoaders();
        }
      })
    }

    //add conversation in conversationThroughOutApplication object on thread reload 
    function addConversationAsPerConditions(conversationMessage) {
      if (conversationMessage.indexOf('is_playbook_outline') > -1) {
        var llm_response_json = convertToJson(conversationMessage);
        $scope.messages.conversationThroughOutApplication.push({ text: JSON.stringify(llm_response_json.response), type: 'bot', addComment: true, isPlaybookOutline: true, generatePlaybook: true });
      }
      else {
        let navigationPresent = checkIfNavigationPresent(conversationMessage, true);
        $scope.messages.conversationThroughOutApplication.push({ 
            text: navigationPresent ? navigationPresent.latestMessage : conversationMessage,
            type: 'bot'
        });
      }
    }

    function updateUserPreferenceData() {
      var _bodyParams = {
        'genai_metadata': {
          'openai': {
            'assisstant_threads': [
              {
                'thread_id': threadId,
                'masked_data_mapping': maskedObjectFactory
              }
            ]
          }
        }
      }
      aiAssistantService.setUserPreferences(_bodyParams).then(function () {
        console.log('Masked object/Thread Id updated')
      }, function (error) {
        toaster.error({ body: "Failed to update user preference" });
      });
    }

    function textAreaFocused(){
      hideQuestionsPopUp(true);
    }
  }
})();
