/* Copyright (C) 2008 - 2025 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('aiAssistant400Ctrl', aiAssistant400Ctrl);

  aiAssistant400Ctrl.$inject = ['$scope', 'toaster', '$rootScope', '$q', '$timeout', 'localStorageService', 'aiAssistantService', '$window', '$state', 'widgetBasePath', 'Entity', 'COMMENT_TYPES', 'Modules', '$filter', 'currentPermissionsService', 'FormEntityService', 'playbookService', 'usersService', '$location', 'Cryptography', 'Upload', 'API', 'IMAGE_TYPES', '$resource'];

  function aiAssistant400Ctrl($scope, toaster, $rootScope, $q, $timeout, localStorageService, aiAssistantService, $window, $state, widgetBasePath, Entity, COMMENT_TYPES, Modules, $filter, currentPermissionsService, FormEntityService, playbookService, usersService, $location, Cryptography, Upload, API, IMAGE_TYPES, $resource) {

    var widgetBasePath = widgetBasePath;
    var constantMessages = aiAssistantService.constantMessages();
    const initialBotMessage = {
      socAssitantConversation: [{
        text: constantMessages.botGeneralMessages.initialMessage,
        type: 'botGeneral'
      }],
      pbAssistantConversation: [{
        text: constantMessages.botGeneralMessages.playbookDesignerInitialMessage,
        type: 'botGeneral'
      }],
      connectorAssistantConversation: [{
        text: constantMessages.botGeneralMessages.connectorInitialMessage,
        type: 'botGeneral'
      }]
    };
    $scope.currentTheme = $rootScope.theme.id;
    $scope.messages = loadDataFromLocalStorage() || angular.copy(initialBotMessage);
    $scope.messages.conversationThroughOutApplication = [];
    $scope.pageState = $state;
    $scope.updateJsonOutline = updateJsonOutline;
    $scope.clearConversation = clearConversation;
    $scope.generatePlaybook = generatePlaybook;
    $scope.openDocumentation = openDocumentation;
    $scope.prepareMaskedData = prepareMaskedData;
    $scope.adjustTextareaHeight = adjustTextareaHeight;
    $scope.hideQuestionsPopUp = hideQuestionsPopUp;
    $scope.addComment = addComment;
    $scope.processSelectedQuestion = processSelectedQuestion;
    $scope.uploadAttachment = uploadAttachment;
    $scope.removeAttachment = removeAttachment;
    $scope.playbookDescription = '';
    $scope.showDescription = false;//To append review results button to the bot text, button only visible on playbook description
    $scope.pbGenerationInProgress = false; //true when Generate PB button is clicked on pbDesignerPage
    $scope.processingConversation = false;
    $scope.pbDesignerPage = false;
    $scope.disableTextArea = true;
    $scope.isConnectorConfigured = true;
    $scope.showStaticQuestions = false;
    $scope.playbookPermission = currentPermissionsService.getPermission('workflows');
    $scope.listOfQuestions = {};
    $scope.recommendationSettings = {};
    $scope.suggestedPlaybooksList = [];
    $scope.isLightTheme = $rootScope.theme.id === 'light';
    $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
    $scope.bulbIcon = $scope.isLightTheme ? widgetBasePath + 'images/bulb-light.svg' : widgetBasePath + 'images/bulb-dark.svg';
    $scope.botIcon = widgetBasePath + 'images/bot.svg';
    $scope.playbookTags = {
      pBDesignerSteps: [constantMessages.playbookTags.pBDesignerSteps]
    };
    $scope.jsonOptions = {
      mode: 'view',
      modes: ['view','preview'],
      'enableTransform': true,
      'enableSort': false
    };
    $scope.pbOptions = {
      'name': 'Workflow Steps',
      mode: 'form',
      modes: ['code', 'form'],
      'enableTransform': true,
      'enableSort': false
    };
    $scope.configForMarkdown = {
      initialEditType: 'markdown',
      previewStyle: 'tab',
      height: '420px',
      usageStatistics: false,
      hideModeSwitch: true,
      toolbarItems: ['']
    };
    $scope.userInput = {
      textVal: ''
    };
    $scope.inputText = {
      inputText: '',
    };
    $scope.processCompleted = 6; //variables for playbook percentage loader
    $scope.loadingThreadConversation = true; //on load if thread conversation are present to be loaded
    $scope.staticQuestionsPresent = false;
    $scope.textAreaActionsTriggered = textAreaActionsTriggered;
    $scope.errorExists = false;
    $scope.inRecordDetailedView = false;
    $scope.micOn = false;
    $scope.finalTranscript = '';
    $scope.conversationTextUpdated = conversationTextUpdated;
    $scope.enableVoiceService = true; //kill switch to toggle mic functionality
    $scope.iswebkitSpeechRecognitionSupported = false;
    $scope.attachment_data = new Object();
    $scope.imageTypes = IMAGE_TYPES;
    $scope.fileLoading = false;
    $scope.activeAssistant = '';
    $scope.clearConversationTooltip = 'Click to clear conversation and remove any attachments.'

    var selectedQuestion = '';
    var stateChangeSuccess = '';
    var keyStoreJSONValue = {};
    var staticQuestionsModule = [];
    var maskedObjects = { emails: {}, urls: {}, domains: {}, ips: {}, hashes: {}, sha256: {}, sha1: {}, md5: {} };
    var maskedObjectFactory = { ioc_type: [], masked_data: {} }; //to store the masked object in userPref
    var recordMetadata = {}; //to create records and field data
    var record_data = {}; // to create records and fieldOfInterest data to pass in payload
    var currentModule = undefined;
    var currentModuleId = undefined;
    var keyStoreProperties = constantMessages.keyStoreProperties;
    var user = usersService.getCurrentUser();
    const currentUserId = user.userId;
    var userLoginId = '', recordIRI = '', previousRecordIRI = '';
    var socThreadId = loadThreadsFromLocalStrorage()?.socThreadId || '';
    var connectorThreadId = loadThreadsFromLocalStrorage()?.connectorThreadId || '';
    var aiConfiguration = {};
    var responseProtocol = aiAssistantService.constantMessages().responseProtocol;
    var staticQuestionPopUpShown = false;
    var record_context_updated = false;
    var keystorePermission = currentPermissionsService.getPermission('keys');
    var dt = new Date();
    var pbParameters = new Object();
    var recommendationMessageShown = false; //to show the recommendation msg only once for error 
    const TIMEZONE_OFFSET = dt.getTimezoneOffset();
    const PROGRESS_BAR_INTERVAL = 3000;

    init();
    
    function init() {
      maskedObjectFactory = { ioc_type: [], masked_data: {} };
      if(keystorePermission.read){
        $scope.errorExists = false;
        $q.all([loadUserLoginDetails(), loadKeyStoreData()]).then((response) => {
            getAIConfiguration();
            stateChangeSuccessFunction(); //to activate the stateChange listener on init
            updateModuleDataOnEventChange($scope.pageState.current, $scope.pageState.current.params);
            setPlaybookParameters();
        },function(error){
            hideLoaders();
        });
      }
      else{
        $scope.errorExists = true;
        clearConversationText(getActiveParameters().assistant);
        updateConversationMessages(getActiveParameters().assistant,{
          text: aiAssistantService.constantMessages().botGeneralMessages.keystorePermissionError,
          type: 'botGeneral'
        }); 
        hideLoaders();
      }
    }

    function setPlaybookParameters() {
      pbParameters = {
        pbGenerationThreadId: loadThreadsFromLocalStrorage()?.pbGenerationThreadId || '', //for playbook outline generation
        pbConversationThreadId: loadThreadsFromLocalStrorage()?.pbConversationThreadId || '', //for playbook Conversation
        conversation_type : '', //generate PB outline in conversation
        outline_data: '',
        response_json: {},
        result_list: {},
        current_step: {},
        input_params: {},
        is_pb_steps_conversation: false, //true only when conversation starts after pb generation is active
        playbook_content: ''
      }
    }

    function loadUserLoginDetails(){
      var defer = $q.defer();
      aiAssistantService.getUserLoginId(currentUserId).then(function (userLoginDetails) {
        if (userLoginDetails && userLoginDetails.usersresp && userLoginDetails.usersresp[0].loginid) {
          userLoginId = userLoginDetails.usersresp[0].loginid;
          defer.resolve();
        }
      }, function (error) {
        console.log(error);
        hideLoaders();
      });
      return defer.promise;
    }

    function loadKeyStoreData(){
      var defer = $q.defer();
      aiAssistantService.getKeyStoreRecord(keyStoreProperties.fortiAIStaticQuestions.queryParameters, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          keyStoreJSONValue = response['hydra:member'][0].jSONValue;
          staticQuestionsModule = Object.keys(keyStoreJSONValue['modules']);
          defer.resolve();
        }  else {
          toaster.error({ body: keyStoreProperties.fortiAIStaticQuestions.errorMessage });
          hideLoaders();
        }
      });
      return defer.promise;     
    }

    function fetchStaticQuestions(currentModule) {
      $scope.listOfQuestions = {};
      if(keyStoreJSONValue.modules[currentModule].questions && keyStoreJSONValue.modules[currentModule].questions.length > 0){
        $scope.staticQuestionsPresent = true;
        for (const module of keyStoreJSONValue.modules[currentModule].questions) {
          if (module.enabled) {
            $scope.listOfQuestions[module.question] = module.description ? module.description : '';
          }
        }
      }
      else{
        $scope.staticQuestionsPresent = false;
      }
    }

    function addComment(index, fetchFrom) {
      $scope.processingConversation = true;
      var comment = {
        content: $scope.messages[fetchFrom][index].text,
        recordTags: ['FortiAI'],
        type: COMMENT_TYPES.COMMENT,
        people: []
      };
      var parentIri = $filter('prependIri')(currentModule + '/' + currentModuleId);
      comment[$scope.pageState.current.params.module] = [parentIri];
      comment.uuid = $window.UUID.generate();
      Modules.save({
        module: 'comments'
      }, angular.copy(comment)).$promise.then(function (response) {
        toaster.success({ body: 'Added as a comment to this record successfully!' });
      }).catch(function (error) {
        toaster.error({ body: "Unable to save comment" });
      }).finally(function () {
        $scope.processingConversation = false;
      })
    }

    function processSelectedQuestion(selectedMessage) {
      $scope.processingConversation = true;
      hideQuestionsPopUp(true);
      selectedQuestion = selectedMessage;
      var _selectedQuestion = keyStoreJSONValue['modules'][$scope.pageState.current.params.module]['questions'][Object.entries($scope.listOfQuestions).findIndex(([key, value]) => key === selectedQuestion)];
      updateConversationMessages(getActiveParameters().assistant,{ text: _selectedQuestion.question, type: 'user' }); 
      prepareMaskedData().then(function() {
        //promise executed
      });
    }

    function prepareMaskedData() {
      var defer = $q.defer();
      if(currentModule){
        var fieldsOfInterest = keyStoreJSONValue['modules'][currentModule]['fieldsOfInterest'];
        if (fieldsOfInterest !== undefined) {
          prepareRecordData(fieldsOfInterest).then(function() {
            defer.resolve();
          }, function(error) {
            defer.reject(error);
          });
        }
        else {
          toaster.error({ body: "Fields of Interest not present for the selected module in key store record" });
          hideLoaders();
          defer.resolve();
        }
      } else {
        defer.resolve();
      }
      return defer.promise;
    }

    function prepareRecordData(fieldsOfInterest) {
      var defer = $q.defer();
      $scope.entity = FormEntityService.get();
      var moduleName = currentModule;
      var entity = new Entity(moduleName);
      if (!angular.isUndefined($scope.entity) && !angular.isUndefined($scope.entity.originalData['@id'])) {
        recordIRI = $scope.entity.originalData['@id'];
        previousRecordIRI === recordIRI ? record_context_updated = false : record_context_updated = true;
        previousRecordIRI = recordIRI;
      }
      entity.get(currentModuleId, {
        $relationships: true
      }).then(function (metaData) {
        recordMetadata = {
          fields: {},
          similarRecords: {}
        };
        var corelatedModules = [];
        var promises = [];
        var relatedData = {};
        var relatedEntities = {};
        var entityRelationshipFields = entity.getRelationshipFieldsArray();
        entityRelationshipFields.forEach(element => {
          if (Object.keys(keyStoreJSONValue['modules']).includes(element.name) && (moduleName !== element.name)) {
            corelatedModules.push({ name: element.name, data: keyStoreJSONValue['modules'][element.name], value: element.value });
            const fieldsOfInterest = keyStoreJSONValue['modules'][element.name].fieldsOfInterest;
            if (fieldsOfInterest) {
              var relatedEntity = new Entity(element.name);
              promises.push(
                relatedEntity.loadFields().then(function () {
                  relatedEntities[element.name] = relatedEntity;
                }));
              promises.push(
                aiAssistantService.getDetailData(moduleName, currentModuleId, element.name, fieldsOfInterest.toString()).then(function (data) {
                  relatedData[element.name] = data;
                }));
            }
          }
        });
        // Example usage
        // Main Entity
        var recordObj = {};
        fieldsOfInterest.forEach(element => {
          if (entity.fields[element]) {
            if (entity.fields[element].type != "picklist" && entity.fields[element].type != "manyToMany" && entity.fields[element].type != "manyToOne" && entity.fields[element].type != "datetime" && entity.fields[element].type != "lookup" && entity.fields[element].value) {
              recordObj[element] = typeof entity.fields[element].value === 'string'
                ? entity.fields[element].value : String(entity.fields[element].value);
            }
            else if (entity.fields[element].type === "picklist") {
              if (entity.fields[element].value) {
                recordObj[element] = entity.fields[element].value.itemValue;
              }
            }
            else if (entity.fields[element].type === "datetime") {
              if(entity.fields[element].value && entity.fields[element].value !== ''){
                recordObj[element] = aiAssistantService.epochToReadable(entity.fields[element].value);
              }
            }
          }
        });
        recordMetadata.fields[$scope.pageState.current.params.module] = recordObj;

        $q.all(promises).then(function () {
          // Related entity
          corelatedModules.forEach((module) => {
            var entity = relatedEntities[module.name];
            var fieldsOfInterest = module.data.fieldsOfInterest;
            var relatedModuleData = relatedData[module.name];
            if (fieldsOfInterest) {
              var recordObj = [];
              relatedModuleData.forEach((data) => {
                var fieldObj = {};
                fieldsOfInterest.forEach(fieldName => {
                  if (entity.fields[fieldName]) {
                    if (entity.fields[fieldName].type != "picklist" && entity.fields[fieldName].type != "manyToMany" && entity.fields[fieldName].type != "manyToOne" && entity.fields[fieldName].type != "datetime" && entity.fields[fieldName].type != "lookup" && data[fieldName]) {
                      fieldObj[fieldName] = typeof data[fieldName] === 'string'
                        ? data[fieldName] : String(data[fieldName]);
                    }
                    else if (entity.fields[fieldName].type === "picklist") {
                      if (data[fieldName] && data[fieldName]) {
                        fieldObj[fieldName] = data[fieldName].itemValue;
                      }
                    }
                    else if (entity.fields[fieldName].type === "datetime") {
                      fieldObj[fieldName] = aiAssistantService.epochToReadable(data[fieldName]);
                    }
                  }
                });
                recordObj.push(fieldObj);
              });
              recordMetadata.fields[module.name] = recordObj;
            }
          });
          let systemRecommendationSetting = $scope.recommendationSettings.globalSettings.publicValues.recommendation.strategy ? true : false; //to check if system recommendation setting is enabled or disabled
          if (systemRecommendationSetting && $scope.recommendationSettings.workspace.similarRecords.enable) {
            aiAssistantService.getSimilarRecords($scope.recommendationSettings.workspace, $scope.entity, angular.copy(fieldsOfInterest)).then(function (similarRecords) {
              recordMetadata.similarRecords = similarRecords;
            }, function (error) {
              if(!recommendationMessageShown){
                updateConversationMessages(getActiveParameters().assistant,{
                  text: aiAssistantService.constantMessages().botGeneralMessages.similarRecordError,
                  type: 'botGeneral',
                  warning: true
                });
                recommendationMessageShown = true;
              }
            }).finally(function () {
              maskRecordData().then(function() {
                defer.resolve();
              }, function(error) {
                defer.reject(error);
              });
            })
          } else {
            recommendationMessageShown = false;
            maskRecordData().then(function() {
              defer.resolve();
            }, function(error) {
              defer.reject(error);
            });
          }
        });
      },
        function (err) {
          console.log('Error in fetching module record data from AI bot. Please reload the page');
          $scope.processingConversation = false;
          defer.reject(err);
        });
        return defer.promise;
    }

    //mask all record data - stringify and pass it to getArtifacts function which mask the data and adds it in maskedObjectFactory
    function maskRecordData() {
      var defer = $q.defer();
      var stringMetaData = JSON.stringify(angular.copy(recordMetadata));
      aiAssistantService.getArtifacts(stringMetaData)
        .then(function (artifacts) {
          maskedObjects = artifacts.data;
          record_data['correlated_record'] = {};
          let maskedObjectFactoryLastValue = angular.copy(maskedObjectFactory);
          for (const key in recordMetadata.fields) {
            if (angular.isArray(recordMetadata.fields[key])) {
              recordMetadata.fields[key].forEach(data => {
                aiAssistantService.replaceArtifactsWithMaskedData(data, maskedObjects, maskedObjectFactory);
              });
              record_data['correlated_record'][key] = recordMetadata.fields[key];
            } else {
              aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.fields[key], maskedObjects, maskedObjectFactory);
              record_data['primary_record'] = recordMetadata.fields[key];
            }
          }
          record_data['similar_records'] = [];
          for (const key in recordMetadata.similarRecords) {
            aiAssistantService.replaceArtifactsWithMaskedData(recordMetadata.similarRecords[key], maskedObjects, maskedObjectFactory);
            record_data['similar_records'].push(recordMetadata.similarRecords[key]);           
          }
          if (!angular.equals(maskedObjectFactoryLastValue.masked_data, maskedObjectFactory.masked_data)) {
            updateUserPreferenceData();
          }
          if (selectedQuestion) {
            generateApplicationConversation(selectedQuestion); //to pass question directly 
            selectedQuestion = '';
          }
          defer.resolve();
        })
        .catch(function (error) {
          defer.reject(error);
          toaster.error({ body: "Error in fetching artifacts" });
          console.error('Error:', error);
        });
      return defer.promise;
    }

    $scope.executePlaybook = function (playbook) {
      aiAssistantService.getPlaybook(playbook.actionUuid, $scope.entity.module).then(function (result) {
        playbookService.triggerPlaybookAction(result.data, $scope.getOriginalRecord, $scope, false, $scope.entity);
      }, function (error) {
        statusCodeService(error, true);
      });
    };

    //to export playbook json
    function _exportPlaybook(state) {
      const _uuid = aiAssistantService.getUUIDFromURL(state.ncyBreadcrumbLink);
      var query = {
        module: 'workflows',
        'uuid$in': $filter('getEndPathName')(_uuid),
        $relationships: true,
        $export: true
      };

      Modules.get(query).$promise.then(function (response) {
        playbookService.preparePlaybookforExport(response['hydra:member'], true).then(function (response) {
          if (response && response.data) {
            pbParameters.playbook_content = response.data;
          }
        });
      });
    }
    $scope.getOriginalRecord = function () {
      var records = [];
      records.push({
        '@id': $scope.entity.originalData['@id']
      });
      return records;
    };

    function checkConnectorHealth() {
      aiAssistantService.connectorHealthCheck(aiConfiguration, userLoginId).then(function (result) {
        if(result && result.availability_status && result.connector_config){
          getassistantId();
          $scope.isConnectorConfigured = true;
          $scope.errorExists = false;     
        }
        else{
          $scope.errorExists = true;
          clearConversationText(getActiveParameters().assistant);
          if(result && !angular.isUndefined(result.error_message) && result.error_message !== ''){
            updateConversationMessages(getActiveParameters().assistant,{
              text: result.error_message  ,
              type: 'botGeneral'
            }); 
          }
          else{
            if(result && !result.availability_status){
              updateConversationMessages(getActiveParameters().assistant,{
                text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotAvailable,
                type: 'botGeneral'
              });
            }
            else{
              updateConversationMessages(getActiveParameters().assistant,{
                text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotConfigured,
                type: 'botGeneral'
              });
            }
          }
          $scope.disableTextArea = true;
          $scope.isConnectorConfigured = false;
          hideLoaders();
        }
      },function(err){
        $scope.errorExists = true;
        clearConversationText(getActiveParameters().assistant);
        updateConversationMessages(getActiveParameters().assistant,{
          text: aiConfiguration['llmIntegrationTitle'] + ' ' + aiAssistantService.constantMessages().botGeneralMessages.connectorNotConfigured,
          type: 'botGeneral'
        });
        $scope.disableTextArea = true;
        $scope.isConnectorConfigured = false;
        hideLoaders();
      });
    }

    function stateChangeSuccessFunction() {
      stateChangeSuccess = $scope.$on('$stateChangeSuccess', function (event, toState, toParams, from, fromParams) {
        updateModuleDataOnEventChange(toState,toParams); //update parameters on state change
      });
    }

    //update all module related data as per current state and params
    function updateModuleDataOnEventChange(state,params){
      $scope.attachment_data = {};
      record_context_updated = false;
      recordIRI = '';
      previousRecordIRI = '';
      $scope.activeAssistant = getActiveParameters().assistant;
      
      if (state.name.includes('main.playbookDetail')) {
        $scope.pbDesignerPage = true;
        currentModule = 'main.playbookDetail';
        pbParameters.conversation_type = 'pb_outline';
        _exportPlaybook(state);
      }
      else {
        $scope.pbDesignerPage = false;
        pbParameters.conversation_type = '';
        pbParameters.is_pb_steps_conversation = false;
        if (state.name.includes('viewPanel.modulesDetail') && staticQuestionsModule.includes(params.module)) {
          $scope.entity = FormEntityService.get();
          currentModule = params.module;
          currentModuleId = params.id;
          record_context_updated = true;
          $scope.inRecordDetailedView = true;
          aiAssistantService.getRecommendationSettings($scope.pageState.current.params.module).then(function (response) {
            $scope.recommendationSettings = response;
          });
          fetchStaticQuestions(params.module);
          if(!staticQuestionPopUpShown){
            hideQuestionsPopUp(false);
          }
        }
        else{
          $scope.inRecordDetailedView = false;
        }
      }
      updateConversationMessages(getActiveParameters().assistant);
    }
    
    function hideQuestionsPopUp(hide) {
      const customModal = document.getElementById('record-static-questions');
      if (hide) {
        customModal.setAttribute('style', 'display:none;');
        // $timeout(function () {
        //   scrollToBottom(); 
        // });
      }
      else {
        customModal.setAttribute('style', 'display:inline-block;');
        adjustTextareaHeight(true);
        staticQuestionPopUpShown = true;
      }
    }

    $scope.$on('popupOpened', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        stateChangeSuccessFunction(); //to activte the stateChange listener on pop-up open
        $scope.isLightTheme = $rootScope.theme.id === 'light';
        $scope.backgroundImageUrl = $scope.isLightTheme ? widgetBasePath + 'images/assistant-ui-white-background.svg' : widgetBasePath + 'images/assistant-ui-dark-background.svg';
        updateModuleDataOnEventChange($scope.pageState.current, $scope.pageState.current.params); //as state change doesn't fire on 
      }
    })

    $scope.$on('popupClosed', function (event, data) {
      if (data === $scope.config.name + '_' + $scope.config.version) {
        //to destroy the stateChange listener on pop-up close
        stateChangeSuccess(); 
      }
    })

    $scope.$on('$destroy', function () {
      stateChangeSuccess();
    });

    //***************** local storage function block ******************//
    function loadDataFromLocalStorage() {
      return JSON.parse(localStorageService.get('aiAssistantBot.messages'));
    }

    function loadThreadsFromLocalStrorage(){
      return JSON.parse(localStorageService.get('aiAssistantBot.threadIds'));
    }

    function updateLocalStorageData() {
      localStorageService.set('aiAssistantBot.messages', JSON.stringify($scope.messages));
    }

    //update all application thread ids in local storage
    function updateThreadIdInLocalStorage() {
      localStorageService.set('aiAssistantBot.threadIds', JSON.stringify({
        socThreadId: socThreadId,
        pbGenerationThreadId: pbParameters.pbGenerationThreadId,
        pbConversationThreadId: pbParameters.pbConversationThreadId,
        connectorThreadId: connectorThreadId
      }));
    }

    //scroll to bottom when new conversation message is added
    function scrollToBottom() {
      var container = document.getElementById('bot-conversation-body');
      container.scrollTop = container.scrollHeight;
    }

    function conversationTextUpdated(){
      if($scope.userInput.textVal === ''){
        $scope.finalTranscript = '';
      }
    }

    function adjustTextareaHeight(fromKeypress) {
      var textarea = document.getElementById('conversation-text-input');
      //fetching height of custom modal from drawerWidgetGroup.html 
      var aiAssistantBot = document.getElementById('custom-modal');
      var userInputContainer = document.getElementById('user-input-container');
      var recordQuestionsBox = document.getElementById('record-static-questions');
      var botConversationBody = document.getElementById('bot-conversation-body');
      if (fromKeypress) {
        textarea.style.height = "auto"; // Reset textarea height
        textarea.style.height = (textarea.scrollHeight) + "px"; // Set new height
        var bottomForStaticQuestions = (textarea.scrollHeight) + 12 > 362 ? 362 : (textarea.scrollHeight) + 12;
        recordQuestionsBox.style.bottom = bottomForStaticQuestions + "px"; // Set new height
        $timeout(function () {
          var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 150; //(150 = including .modal-drag & header image, +10px for bottom space)
          botConversationBody.style.height = botConversationBodyHeight + 'px';
          botConversationBody.style.maxHeight = '100%';
          //scrollToBottom();
        }, 200);
      }
      else {
        textarea.style.height = "46px";
        recordQuestionsBox.style.bottom = "58px";
        var userInputContainer = document.getElementById('user-input-container');
        $timeout(function () {
          var botConversationBodyHeight = aiAssistantBot.scrollHeight - userInputContainer.scrollHeight - 150; //(150 = including .modal-drag & header image, +10px for bottom space)
          botConversationBody.style.height = botConversationBodyHeight + 'px';
          botConversationBody.style.maxHeight = '100%';
          scrollToBottom();
        }, 200);
      }
    };

    //generate response if enter is pressed in textbox
    $scope.sendMessage = function (event, flagEnterClick) {
      //if conversation option is selected
      if (((event.keyCode === 13 && !event.shiftKey) || flagEnterClick) && ($scope.userInput.textVal && $scope.userInput.textVal !== '')) {
        event.preventDefault();
        const _textArea = document.getElementById('conversation-text-input');
        _textArea.blur();
        var _index = 0;
        var jsonString = '';
        $scope.processingConversation = true;
        if (Object.entries($scope.attachment_data).length !== 0) {
          updateConversationMessages(getActiveParameters().assistant ,{ text: $scope.userInput.textVal, type: 'user', isFile: true, fileData: $scope.attachment_data });
        }else{
          updateConversationMessages(getActiveParameters().assistant ,{ text: $scope.userInput.textVal, type: 'user' });
        }
        _index = $scope.messages.conversationThroughOutApplication.length;
        jsonString = JSON.stringify(angular.copy($scope.messages.conversationThroughOutApplication[_index - 1].text));
        record_data = {};
        // Process user input and generate a bot response
        if($scope.inRecordDetailedView){
          prepareMaskedData().then(function() {
            proceedToGenerateResponse(jsonString);
          });
        }
        else if(getActiveParameters().assistant === 'connector'){
          generateApplicationConversation(JSON.parse(jsonString));
        }
        else{
          proceedToGenerateResponse(jsonString);
        }
        $scope.finalTranscript = '';
        $scope.userInput.textVal = '';
        $scope.micOn = false;
        stopSpeechRecognition();
        $timeout(function () {
          adjustTextareaHeight(false);
        });
      }
    };

    //proceedToGenerateResponse after message is typed in text area
    function proceedToGenerateResponse(jsonString) {
      aiAssistantService.getArtifacts(JSON.stringify(angular.copy(jsonString)))
        .then(function (artifacts) {
          maskedObjects = artifacts.data;
          let maskedObjectFactoryLastValue = angular.copy(maskedObjectFactory);
          var maskedString = aiAssistantService.replaceArtifactsInString(jsonString, maskedObjects, maskedObjectFactory);
          if (!angular.equals(maskedObjectFactoryLastValue.masked_data, maskedObjectFactory.masked_data)) {
            updateUserPreferenceData();
          }
          var maskedJSON = JSON.parse(maskedString);
          if (pbParameters.is_pb_steps_conversation) {
            generatePlaybookSteps(maskedJSON); //generate playbook step in continuation with playbook conversation
          }
          else {
            $scope.processingConversation = true;
            generateApplicationConversation(maskedJSON);
          }
        })
        .catch(function (error) {
          console.error('Error:', error);
        });
    }

    // Function to generate a bot response through connector action
    function generateApplicationConversation(userMessage) {
      var parametersForPlaybook = returnParameters();
      parametersForPlaybook.request.data['conversation'] = userMessage;
      parametersForPlaybook.request.data['botContext'] = $scope.pageState.current.name;
      let page_name = $scope.pageState.params?.module || $scope.pageState.current.name;
      let currentThreadId = getActiveParameters().threadId;
      let conversation_type = getActiveParameters().conversationType ?  getActiveParameters().conversationType : '';
      pbParameters.conversation_type = conversation_type;

      var payload = {
        'genai_type': aiConfiguration['llmIntegrationTitle'],
        'genai_arguments': {
          'content': userMessage, 
          'thread_id': currentThreadId, 
          'role': 'user', 
          'ioc_data': maskedObjectFactory,
          'auth_token': Cryptography.getAuthToken(), 
          'record_iri': recordIRI, 
          'record_data': record_data,
          'page_name': page_name || '', 
          'config_id': userLoginId, 
          'record_context_updated': record_context_updated, 
          'timezone_offset': TIMEZONE_OFFSET,
          'conversation_type': conversation_type, // pbParameters?.conversation_type,
          'current_user': {
            '@id': user['@id'],
            'firstname': user['firstname'],
            'lastname': user['lastname'],
            'uuid': user['uuid']
          },
          'attached_file_records': angular.copy($scope.attachment_data)
        }
      };  
      $scope.attachment_data = {};
      aiAssistantService.executeAction('aiassistant-utils', 'get_llm_response', userLoginId, payload)
        .then(function (response) {
          if (response && response.data && response.data.llm_response){
            setThreadIdAndUpdateMessages(response.data);
          }
        }, function (error) {
          if(error.status === 504){
            updateConversationMessages(getActiveParameters().assistant,{
              text: aiAssistantService.constantMessages().botGeneralMessages.badGatewayErrorMessage,
              type: 'botGeneral'
            });
          }
          else{
            toaster.error({ body: error.data.message || 'Assistant id or Thread id not found' });
          }
        })
        .finally(function () {
          $scope.processingConversation = false;
          updateThreadIdInLocalStorage();
          hideLoaders();
          $timeout(function () {
            scrollToBottom();
          })
        })
    }

    //upload file through attachment 
    //json, yml, txt, pdf
    function uploadAttachment(file) {
      if (file) {
        $scope.fileLoading = true;
        Upload.upload({
          url: API.BASE + 'files',
          data: {
            file: file
          }
        }).then(function(response) {
          if(response.data){
            $scope.attachment_data = response.data; //to be sent in connector payload
          }
        },function(error){
          toaster.error('Failed to upload file');
        }).finally(function(){
          $scope.fileLoading = false;
        });
      }
    }

    //remove attached file
    function removeAttachment(file) {
      $resource(API.BASE + 'files/' + file.id).delete().$promise.then(function(){
        $scope.attachment_data = {};
      },function(error){
        toaster.error('Failed to remove attachment');
      });
    }

    //retrun active parameters based on current page/state
    function getActiveParameters(){
      const page_name = $scope.pageState.params?.module || $scope.pageState.current.name;
      switch (page_name) {
        case 'main.marketplace.workspace':
            return {'assistant': 'connector','threadId': connectorThreadId};
        case 'main.playbookDetail':
            return {'assistant': 'pb', 'threadId': pbParameters.pbGenerationThreadId || pbParameters.pbConversationThreadId, 'conversationType': 'pb_outline'};
        default:
            return {'assistant': 'soc', 'threadId': socThreadId};
      }
    }

    function convertToJson(inputString) {
      // Replace single quotes with double quotes and True with true
      let jsonString = inputString.replaceAll("\'", "\"").replace("\"{", "{").replace("}\"", "}").replace("True", "true");

      // Parse the string to a JSON object
      let jsonObject = JSON.parse(jsonString);
      return jsonObject;
    }

    //to unmask the response
    function unmaskingResponse(text) {
      return aiAssistantService.unmaskString(maskedObjectFactory.masked_data, text);
    }

    //step-by-step playbook generation on generate button clicked
    function generatePlaybook(playbookSteps) {
      aiAssistantService.getArtifacts(playbookSteps)
        .then(function (artifacts) {
          maskedObjects = artifacts.data;
          let maskedObjectFactoryLastValue = angular.copy(maskedObjectFactory);
          var maskedSteps = aiAssistantService.replaceArtifactsInString(playbookSteps, maskedObjects, maskedObjectFactory);
          if (!angular.equals(maskedObjectFactoryLastValue.masked_data, maskedObjectFactory.masked_data)) {
            updateUserPreferenceData();
          }
          pbParameters.outline_data = JSON.parse(maskedSteps);
          pbParameters.response_json = {};
          pbParameters.result_list = {};
          pbParameters.input_params = {};
          pbParameters.current_step = {};
          pbParameters.is_pb_steps_conversation = false;
          pbParameters.pbConversationThreadId = '';
          generatePlaybookSteps(JSON.parse(maskedSteps));
        }).catch(function (error) {
          console.error('Error:', error);
        });
    }

    //generate Playbook steps (after button clicked and generation commandd given)
    function generatePlaybookSteps(descriptionMessage) {
      updateConversationMessages(getActiveParameters().assistant,{ text: constantMessages.botGeneralMessages.proceedingToGenerate, type: 'botGeneral' });
      $timeout(function () {
        scrollToBottom();
      });
      var payload = {
        'genai_type': aiConfiguration['llmIntegrationTitle'],
        'genai_arguments': {
          'content': descriptionMessage, 
          'auth_token': Cryptography.getAuthToken(),
          'config_id': userLoginId,
          'playbook_content': pbParameters.playbook_content,
          'page_name': 'main.playbookDetail',
          'thread_id': pbParameters.pbConversationThreadId,
          'is_playbook_conversation': pbParameters.is_pb_steps_conversation,
          'playbook_outline': pbParameters.outline_data,
          'playbook_response_json': pbParameters.response_json,
          'result_list': pbParameters.result_list,
          'input_params': pbParameters.input_params,
          'current_step': pbParameters.current_step
        }
      };
      $scope.pbGenerationInProgress = true;
      $scope.processCompleted = 6;
      var progressInterval = setInterval(() => {
        aiAssistantService.checkPlaybookExecutionCompletion($scope).then(function(response){
          if(response){
            clearInterval(progressInterval);
          }
        });
      }, PROGRESS_BAR_INTERVAL);
      aiAssistantService.executeAction('aiassistant-utils', 'generate_playbook_steps', userLoginId, payload)
        .then(function (response) {
          clearInterval(progressInterval);
          pbParameters.is_pb_steps_conversation = true;
          $scope.pbGenerationInProgress = false;
          pbParameters.pbGenerationThreadId = '';
          $scope.processCompleted = 100;
          if (response?.data?.status === 'validation_error') { 
            updateConversationMessages(getActiveParameters().assistant, { 'text': response.data.details, 'type': 'bot' , warning: true});
          }
          else {
            if (response && response.data) {
              if (response.data.playbook_steps) {
                hideLoaders();
                if ($scope.pbDesignerPage) {
                  updateConversationMessages(getActiveParameters().assistant, {
                    text: aiAssistantService.constantMessages().botGeneralMessages.pbStepGenerationCompleted,
                    type: 'botGeneral'
                  });
                  $rootScope.$broadcast('designer:addPlaybookElements', response.data.playbook_steps);
                  const customModal = document.getElementById('custom-modal');
                  $timeout(function () {
                    customModal.setAttribute('style', 'display:none;');
                  }, 1000);
                }
                toaster.info('Copied all selected steps');
                pbParameters.response_json = {};
                pbParameters.result_list = {};
                pbParameters.current_step = {};
                pbParameters.input_params = {};
                pbParameters.outline_data = {};
                pbParameters.is_pb_steps_conversation = false;
              } else {
                //to update parameters with data added from connector response
                pbParameters.pbConversationThreadId = response.data.thread_id
                pbParameters.response_json = response.data.playbook_response_json
                pbParameters.result_list = response.data.result_list
                pbParameters.current_step = response.data.current_step;
                pbParameters.input_params = response.data.input_params;
                pbParameters.outline_data = response.data.playbook_outline;
                updateConversationMessages(getActiveParameters().assistant, { text: response.data.llm_response, type: 'bot' });
              }
            }
          }
        }, function (error) {
          toaster.error({ body: error.data.message || 'Assistant id or Thread id not found' });
          $scope.pbGenerationInProgress = false;
        })
        .finally(function () {
          $scope.processingConversation = false;
          updateThreadIdInLocalStorage();
          clearInterval(progressInterval);
          hideLoaders();
          $timeout(function () {
            scrollToBottom();
          })
        })
    }

    //check if returned message has navigation present and then navigate to that URL
    function checkIfNavigationPresent(latestMessage, fromLoadConversation) {
      if (latestMessage.includes(responseProtocol['recordNavigation'])) {
        return {latestMessage : prepareURLToNavigate(latestMessage,responseProtocol['recordNavigation'], fromLoadConversation, 'recordNavigation')};
      }
      else if(latestMessage.includes(responseProtocol['recordCreation'])){
        return { latestMessage: prepareURLToNavigate(latestMessage,responseProtocol['recordCreation'], fromLoadConversation, 'recordCreation')};
      }
      else if(latestMessage.includes(responseProtocol['playbookExecutionLog'])){
        return { latestMessage: prepareURLToNavigate(latestMessage,responseProtocol['playbookExecutionLog'], fromLoadConversation, 'playbookExecutionLog')};
      }
      else {
        return false;
      }
    }

    //to check which action has to be performed for navigation and is it called from load thread conversation 
    function prepareURLToNavigate(latestMessage, navigateAction, fromLoadConversation, protocol) { 
      let urlString = aiAssistantService.fetchURL(latestMessage);
      let navigateURL = urlString.split(navigateAction)[1];
      switch (protocol) {
        case 'recordNavigation':
          latestMessage  = aiAssistantService.getUpdatedURL(navigateURL, 'recordNavigation', latestMessage);
          let ifRecordOpen = aiAssistantService.checkIfRecordOpen(recordIRI,navigateURL);
          if (!fromLoadConversation && !ifRecordOpen) { //do not navigate while loading past conversations          
            $location.url(navigateURL);
          }
          break;
        case 'recordCreation':
          latestMessage  = aiAssistantService.getUpdatedURL(navigateURL, 'recordCreation', latestMessage);
          break;
        case 'playbookExecutionLog':
          latestMessage = aiAssistantService.getUpdatedURL(navigateURL, 'playbookExecutionLog', latestMessage);
          break;
        default:
          break;
      }
      return latestMessage;
    }

    function returnParameters() {
      return {
        'input': {},
        'request': {
          'data': {
            'records': [],
          }
        },
        'useMockOutput': false,
        'globalMock': false,
        'force_debug': true
      };
    }

    function openDocumentation() {
      $window.open('https://github.com/fortinet-fortisoar/solution-pack-fortinet-advisor/blob/release/4.0.0/docs/usage.md#prompting-tips', '_blank');
    }

    function updateJsonOutline(value,index) {
      if (angular.isString(value)) {
        try {
          $scope.messages.pbAssistantConversation[index].text = value;
          $scope.messages.conversationThroughOutApplication[index].text = value;
        } catch (e) {
          // invalid JSON. skip the rest
          return;
        }
      }
      updateLocalStorageData();
      return;
    }

    //get thread id from user pref and load thread conversation
    function getThreadFromUserPreference() {
      aiAssistantService.getUserPreferences().then(function (threadIdDetails) {
        if (threadIdDetails && threadIdDetails.preferences) {
          setThreadDetails(threadIdDetails);
        }
        else{
          hideLoaders();
        }
      });
    }

    function setThreadDetails(threadIdDetails) {
      let threadData = threadIdDetails.preferences['genai_metadata'][aiConfiguration['llmIntegrationName']]['assisstant_threads'][0];
      if (angular.isUndefined(threadData['masked_data_mapping'].length) && threadData['masked_data_mapping']) {
        maskedObjectFactory = threadData['masked_data_mapping'];
      }else{ 
        //initial object from User preference returns [], to convert to {} reassign the object explicitly
        maskedObjectFactory = { ioc_type: [], masked_data: {} };
      }
      if(angular.isArray(maskedObjectFactory['masked_data']) && maskedObjectFactory['masked_data'].length === 0){
        maskedObjectFactory['masked_data'] = {};
      }
      socThreadId = threadData['thread_id'];
      connectorThreadId = threadData['connector_threadId'];
      pbParameters.pbGenerationThreadId = threadData['pb_threadId'];

      if(socThreadId || connectorThreadId || pbParameters.pbGenerationThreadId){
        $scope.messages.conversationThroughOutApplication.length === 1 ? fecthPastConversationThreadList() : hideLoaders();
      } 
      else{
        hideLoaders();
      }
      $timeout(function () {
        adjustTextareaHeight();
      });
    }

    function hideLoaders() {
      $scope.loadingThreadConversation = false;
      $scope.processingConversation = false;
      $scope.disableTextArea = false;
    }

    function getAIConfiguration(){
      aiAssistantService.getKeyStoreRecord(keyStoreProperties.fortiAIConfiguration.queryParameters, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0]) && (response['hydra:member'][0].jSONValue.llmIntegrations)) {
          aiConfiguration['llmIntegrationName'] = response['hydra:member'][0].jSONValue.llmIntegrations[0]['name'];
          aiConfiguration['isMultiConfigAvailable'] = response['hydra:member'][0].jSONValue.isMultiConfigAvailable;
          const matchingLLM = response['hydra:member'][0].jSONValue.llmIntegrations.filter(llm => llm.name === aiConfiguration['llmIntegrationName'])[0];
          if (matchingLLM) {
            aiConfiguration['llmIntegrationTitle'] = matchingLLM.title;
          }
          aiConfiguration['messagesLimit'] = response['hydra:member'][0].jSONValue.pastConversationMsgLimit;
          checkConnectorHealth();
          speechToText();
        }else {
          toaster.error({ body: keyStoreProperties.fortiAIConfiguration.errorMessage });
          hideLoaders();
        }
      });
    }
    
    //get assisstant id 
    function getassistantId() {
      $scope.disableTextArea = false;
      var payload = { genai_type: aiConfiguration['llmIntegrationTitle'] };
      aiAssistantService.executeAction('aiassistant-utils', 'get_assistant_metadata', userLoginId, payload)
        .then(function (response) {
          if (response && response.data && response.data.status===1) {
            //soc_assistantId = response.data.soc_assistant_id;
            getThreadFromUserPreference();
            $scope.errorExists = false;
          }else{
            $scope.errorExists = true;
            clearConversationText(getActiveParameters().assistant);
            updateConversationMessages(getActiveParameters().assistant,{
              text: aiAssistantService.constantMessages().botGeneralMessages.assistantNotFound,
              type: 'botGeneral'
            });
            hideLoaders();
            $scope.disableTextArea = false;
          }
        }, function (error) {
          $scope.errorExists = true;
          clearConversationText(getActiveParameters().assistant);
          updateConversationMessages(getActiveParameters().assistant,{
            text: aiAssistantService.constantMessages().botGeneralMessages.assistantFailed,
            type: 'botGeneral'
          });
          hideLoaders();
          $scope.disableTextArea = false;
          console.log(error)
        });
    }

    //fetch past conversation threads for soc, pb  and connector
    function fecthPastConversationThreadList() {
      $scope.loadingThreadConversation = true;
      let _promises = [];
      let socPayload = getPastConversationPayload();
      socPayload.genai_arguments.thread_id = socThreadId; // threadId updated as for every payload request 
      if (socThreadId) {
        _promises.push(aiAssistantService.getPastConversationAction(userLoginId, socPayload))
      }
      else{
        _promises.push(null);
      }

      let pbPayload = getPastConversationPayload();
      pbPayload.genai_arguments.thread_id = pbParameters.pbGenerationThreadId;
      if (pbParameters.pbGenerationThreadId) {
        _promises.push(aiAssistantService.getPastConversationAction(userLoginId, pbPayload));
      }
      else{
        _promises.push(null);
      }

      let connectorPayload = getPastConversationPayload(); 
      connectorPayload.genai_arguments.thread_id = connectorThreadId;
      if (connectorThreadId) {
        _promises.push(aiAssistantService.getPastConversationAction(userLoginId, connectorPayload));
      }
      else{
        _promises.push(null);
      }

      $q.all(_promises).then((response) => {
        if (response[0]?.status === 'Success') {
          if (response[0]?.data?.data?.length > 0) {
            $scope.messages.socAssitantConversation = angular.copy(initialBotMessage.socAssitantConversation);
            updatePastMessages('soc', response[0]);
          }
        }else if(response[0]){
          pastConversationErrorHandling(response[0], socThreadId);
        }
        if (response[1]?.status === 'Success') {
          if (response[1]?.data?.data?.length > 0) {
            $scope.messages.pbAssistantConversation = angular.copy(initialBotMessage.pbAssistantConversation);
            updatePastMessages('pb', response[1]);
          }
        }else if(response[1]){
          pastConversationErrorHandling(response[1], pbParameters.pbGenerationThreadId);
        }
        if (response[2]?.status === 'Success') {
          if (response[2]?.data?.data?.length > 0) {
            $scope.messages.connectorAssistantConversation = angular.copy(initialBotMessage.connectorAssistantConversation);
            updatePastMessages('connector', response[2]);
          }
        }else if(response[2]){
          pastConversationErrorHandling(response[2], connectorThreadId);
        }
      }, function (error) {
        console.log(error);
        toaster.error({ body: "Failed to fetch messages from thread." });
        hideLoaders();
      }).finally(function () {
        hideLoaders();
        $timeout(function () {
          adjustTextareaHeight();
        });
      });
    }

    //common payload object for past conversation action
    function getPastConversationPayload(){
      let payLoad = {
        'genai_type': aiConfiguration['llmIntegrationTitle'],
        'genai_arguments': {
          'thread_id': '',
          'auth_token': Cryptography.getAuthToken(),
          'config_id': userLoginId,
          'limit': aiConfiguration['messagesLimit'] || ''
        }
      }
      return payLoad;
    }

    function updatePastMessages(assisstantType, threadList){
          let threadListMessages = threadList.data['data'];
          threadListMessages.reverse();
          threadListMessages.forEach(message => {
            for (let item of message.content) {
              let text = item['text']['value'];
              if(message.role === 'assistant'){
                addConversationAsPerConditions(assisstantType, item)
              }else{
                let conversationMessage = text;
                if(assisstantType !== 'connector'){
                  conversationMessage = unmaskingResponse(conversationMessage);
                }
                updateConversationMessages(assisstantType, {text: conversationMessage, type: 'user'});
              }
            }
          });
          updateConversationMessages(getActiveParameters().assistant); // to fetch the active page messages
    }

    //add conversation in conversationThroughOutApplication object on thread reload 
    function addConversationAsPerConditions(assisstantType, item) {
      let conversationMessage = item['text']['value'];
      if (conversationMessage.indexOf('isPlaybookOutline') > -1) {
        var llm_response_json = convertToJson(conversationMessage);
        updateConversationMessages(assisstantType,{ text: JSON.stringify(llm_response_json.response), type: 'bot', addComment: true, isPlaybookOutline: true, generatePlaybook: true });
      }
      else if(item.type === 'json'){
        let jsonText = conversationMessage.replace(/^```json\s*/, '').replace(/\s*```$/, '');
              if(assisstantType !== 'connector'){ //remove this check if connector masking is to be done later 
                conversationMessage = unmaskingResponse(JSON.stringify(jsonText));
              }
              else{
                conversationMessage = JSON.stringify(jsonText);
              }
            conversationMessage = JSON.parse(conversationMessage);
            updateConversationMessages(assisstantType, { 'text': conversationMessage, 'type': 'bot', 'isJSONFormat': true, 'generatePlaybook': assisstantType === 'pb' });
      }
      else {
        let navigationPresent = checkIfNavigationPresent(conversationMessage, true);
        let conversation_text = navigationPresent ? navigationPresent.latestMessage : conversationMessage;
        let unmasked_text =  unmaskingResponse(conversation_text);
        updateConversationMessages(assisstantType,{ 
          text: unmasked_text,
          type: 'bot'
        });  
      }
    }

    function updateUserPreferenceData() {
      const integrationName =  aiConfiguration['llmIntegrationName'];
      var _bodyParams = {
        'genai_metadata': {
          [integrationName]: {
            'assisstant_threads': [
              {
                'thread_id': socThreadId,
                'connector_threadId': connectorThreadId,
                'pb_threadId':pbParameters.pbGenerationThreadId,
                'masked_data_mapping': maskedObjectFactory
              }
            ]
          }
        }
      }
      if(pbParameters.is_pb_steps_conversation){
        _bodyParams.genai_metadata.playbook_gen_progress = 6;
      }
      aiAssistantService.setUserPreferences(_bodyParams).then(function () {
        console.log('Masked object/Thread Id updated')
      }, function (error) {
        toaster.error({ body: "Failed to update user preference" });
      });
    }

    function pastConversationErrorHandling(errorResponse, threadId){
        console.log('warning :: ', errorResponse.data.message);
        toaster.warning({ body: `Failed to fetch messages from thread ${threadId}. Please check console for more details.` });
    }

    function textAreaActionsTriggered(){
      hideQuestionsPopUp(true);
    }

    //************** speechRecognition (mic functions) *************//
    function speechToText() {
      // Check if the browser supports the Web Speech API
      if (!('webkitSpeechRecognition' in window)) {
        $scope.iswebkitSpeechRecognitionSupported = false;
      } else {
        $scope.iswebkitSpeechRecognitionSupported = true;
        const speechRecognition = new webkitSpeechRecognition();
        speechRecognition.continuous = true;
        speechRecognition.interimResults = true;
    
        $scope.finalTranscript = '';
    
        speechRecognition.onresult = function (event) {
          let interimTranscript = '';
          for (let i = event.resultIndex; i < event.results.length; ++i) {
            if (event.results[i].isFinal) {
              $scope.finalTranscript += event.results[i][0].transcript + ' ';
            } else {
              interimTranscript += event.results[i][0].transcript + ' ';
            }
          }
          $scope.userInput.textVal = $scope.finalTranscript + interimTranscript;
          adjustTextareaHeight(true);
          $scope.$apply();
        };
        speechRecognition.onerror = function (event) {
          console.error(event.error);
        };
        $scope.speechRecognition = speechRecognition; // Save speechRecognition instance to $scope
      }
    }
    
    $scope.toggleSpeechRecognition = function ($event) {
      $scope.micOn = $event.type === "mousedown" ? true : false;
      if($scope.micOn){
        startSpeechRecognition();
      }
      else{
        stopSpeechRecognition();
      }
    }

    function startSpeechRecognition(){
      if($scope.speechRecognition){
        $scope.speechRecognition.start();
      }
    }

    function stopSpeechRecognition(){
      if($scope.speechRecognition){
        $scope.speechRecognition.stop();
      }
    }
    //***********************//

    //update Conversation as per current page assistant
    function updateConversationMessages(_assistant, text_params) {
      switch (_assistant) {
        case 'pb':
          if (text_params) {
            $scope.messages.pbAssistantConversation.push(text_params);
          }
          $scope.messages.conversationThroughOutApplication = angular.copy($scope.messages.pbAssistantConversation);
          break;
        case 'connector':
          if (text_params) {
            $scope.messages.connectorAssistantConversation.push(text_params);
          } 
          $scope.messages.conversationThroughOutApplication = angular.copy($scope.messages.connectorAssistantConversation);
          break;
        case 'soc':
          if (text_params) {
            $scope.messages.socAssitantConversation.push(text_params);
          }
          $scope.messages.conversationThroughOutApplication =  angular.copy($scope.messages.socAssitantConversation);
          break;
      }
      updateLocalStorageData();
    }
  
    function countStepKeys(data) {
      let count = 0;

      function countKeysRecursively(subObj) {
        for (const key in subObj) {
          if (key.includes('Step')) {
            count++;
          }
          if (typeof subObj[key] === 'object') {
            countKeysRecursively(subObj[key]);
          }
        }
      }
      countKeysRecursively(data);
      return count;
    }

    function setThreadIdAndUpdateMessages(responseData){
      $scope.activeAssistant = getActiveParameters().assistant;
      let generatePlaybookParameter = false;
      switch ($scope.activeAssistant) {
        case 'connector':
          connectorThreadId = responseData.thread_id;
          break;
        case 'pb':
          pbParameters.pbGenerationThreadId = responseData.thread_id;
          generatePlaybookParameter = true;
          break;
        case 'soc':
          socThreadId = responseData.thread_id;
          break;
      }
      updateUserPreferenceData();
      let llm_response = responseData.llm_response;
      if (llm_response.length > 0) { //llm_response returns array 
        llm_response.forEach(llm_response_data => {
          let currentUnMaskedData = unmaskingResponse(llm_response_data.value);
          let navigationPresent = checkIfNavigationPresent(currentUnMaskedData);
          if (navigationPresent) {
            updateConversationMessages(getActiveParameters().assistant, { 'text': navigationPresent.latestMessage, 'type': 'bot' });
          }
          else {
            let conversation_response_text = llm_response_data.value;
            if(llm_response_data.type === 'json'){
              let jsonText = llm_response_data.value.replace(/^```json\s*/, '').replace(/\s*```$/, '');
              if(getActiveParameters().assistant !== 'connector'){ //remove this check if connector masking is to be done later 
                conversation_response_text = unmaskingResponse(JSON.stringify(jsonText));
              }
              else{
                conversation_response_text = JSON.stringify(jsonText);
              }
              conversation_response_text = JSON.parse(conversation_response_text);
            }
            if(getActiveParameters().assistant !== 'connector'){
              conversation_response_text = unmaskingResponse(conversation_response_text);
            }
            updateConversationMessages(getActiveParameters().assistant, { 'text': conversation_response_text, 'type': 'bot', 'addComment': true, 'isJSONFormat': llm_response_data.type === 'json', 'generatePlaybook': generatePlaybookParameter });
          }
        });
      }
      if(responseData?.status === 'validation_error'){
        updateConversationMessages(getActiveParameters().assistant, { 'text': responseData.details, 'type': 'botGeneral' , warning: true});
      }
    }

    //***************** clear conversations ******************//
    
    function clearConversation() {
      $scope.activeAssistant = getActiveParameters().assistant;
      clearConversationAction();
      clearConversationText($scope.activeAssistant);
      switch ($scope.activeAssistant) {
        case 'connector':
          $scope.attachment_data = {};
          $scope.messages.connectorAssistantConversation = angular.copy(initialBotMessage.connectorAssistantConversation);
          connectorThreadId = '';
          break;
        case 'pb':
          setPlaybookParameters();
          $scope.messages.pbAssistantConversation = angular.copy(initialBotMessage.pbAssistantConversation);
          pbParameters.pbConversationThreadId = '';
          pbParameters.pbGenerationThreadId = '';
          break;
        case 'soc':
          maskedObjectFactory.ioc_type = [];
          maskedObjectFactory.masked_data = {};
          $scope.attachment_data = {};
          $scope.messages.socAssitantConversation = angular.copy(initialBotMessage.socAssitantConversation);
          deleteThreadId();
          break;
      }
      updateUserPreferenceData();
      updateConversationMessages(getActiveParameters().assistant);
      updateThreadIdInLocalStorage();
    }

    //delete thread id from User Preference table only incase of soc assistant
    function deleteThreadId() {
      $scope.disableTextArea = true;
      if (socThreadId !== '') {
        socThreadId = '';
        //clear thread and masked_object and set in user pref
        var _bodyParams = {
          "genai_metadata": {
            "openai": {
              "assisstant_threads": [
                {
                  "thread_id": socThreadId,
                  'masked_data_mapping': maskedObjectFactory
                }
              ]
            }
          }
        }
        aiAssistantService.setUserPreferences(_bodyParams).then(function (response) {
          if (response) {
            $scope.disableTextArea = false;
            hideLoaders();
            console.log("Successfully deleted and cleared conversation.");
          }
        });
      } else {
        $scope.disableTextArea = false;
        hideLoaders();
      }
    }

    //clear conversation action call 
    function clearConversationAction(){
      let page_name = $scope.pageState.params?.module || $scope.pageState.current.name;
      let payload = {
        'genai_type': aiConfiguration['llmIntegrationTitle'],
        'genai_arguments': {
          'thread_id': getActiveParameters().threadId, 
          'role': 'user', 
          'ioc_data': maskedObjectFactory,
          'auth_token': Cryptography.getAuthToken(), 
          'page_name': page_name || '', 
          'config_id': userLoginId, 
          'record_context_updated': record_context_updated,
          'current_user': {
            '@id': user['@id'],
            'firstname': user['firstname'],
            'lastname': user['lastname'],
            'uuid': user['uuid']
          },
          'attached_file_records': angular.copy($scope.attachment_data)
        }
      };  
      aiAssistantService.executeAction('aiassistant-utils', 'clear_conversation', userLoginId, payload).then(function(){
        console.log('Conversation cleared successfully');
      },function(error){
        toaster.error({ body: error.data.message || 'Clear conversation failed' });
      })
    }

    //clear Conversation as per current page assistant
    function clearConversationText(_page) {
      switch (_page) {
        case 'pb':
          $scope.messages.pbAssistantConversation = [];
          break;
        case 'connector':
          $scope.messages.connectorAssistantConversation = [];
          break;
        case 'soc':
          $scope.messages.socAssitantConversation = [];
          break;
        default:
          $scope.messages.socAssitantConversation = [];
          break;
      }
    }

  }
})();