/* Copyright start
    MIT License
    Copyright (c) 2025 Fortinet Inc
Copyright end */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('cicdContentImport100Ctrl', cicdContentImport100Ctrl);

  cicdContentImport100Ctrl.$inject = ['$scope', 'widgetUtilityService', '$uibModal', '$http', 'API', 'toaster', '_', 'websocketService', 'FormEntityService', 'CommonUtils'];

  function cicdContentImport100Ctrl($scope, widgetUtilityService, $uibModal, $http, API, toaster, _, websocketService, FormEntityService, CommonUtils) {
    $scope.triggerPlaybook = triggerPlaybook;
    $scope.changeRepository = changeRepository;
    $scope.isPlaybookExecuted = false;
    $scope.isTemplateSelected = false;
    $scope.parent_wf_id = '';
    var subscription;
    const playbookIRI = '24963415-4057-4fd5-bbe5-bf7d6bfa059d';
    const updatePlaybookIRI = 'de8a2184-a9f0-4530-ace7-132247f2be31';

    $scope.$on('websocket:reconnect', function () {
      initWebsocket();
    });

    function initWebsocket() {
      websocketService.subscribe('runningworkflow', function (data) {
        if (data.parent_wf === 'null') {
          $scope.parent_wf_id = data.instance_ids;
        }
        //do nothing in case of notification recieved from same websocketSession. As it is handled gracefully.
        if (data.sourceWebsocketId !== websocketService.getWebsocketSessionId()) {
          if ($scope.taskId && data.task_id && data.task_id === $scope.taskId && data.parent_wf === 'null') {
            $scope.taskId = undefined;
          }
        }
        if ((data.status === 'failed' || data.status === 'finished with error' || data.status === 'finished') && $scope.pullLatestContentPlaybookTaskID === data.task_id) {
          _getPlaybookResult();
        }
      }).then(function (data) {
        subscription = data;
      });
    }

    $scope.$on('$destroy', function () {
      if (subscription) {
        websocketService.unsubscribe(subscription);
      }
    });

    function _getPlaybookResult() {
      var endpoint = API.WORKFLOW + 'api/workflows/' + $scope.parent_wf_id + '/';
      $http.get(endpoint).then(function (response) {
        if (response.data.status === 'finished') {
          if (!CommonUtils.isUndefined(response.data.result.data) && response.data.result.data.status == "Reviewing") {
            _openWizard(response.data.result.data.uuid);
          }
          else if (!CommonUtils.isUndefined(response.data.result.data) && response.data.result.data.status == "Connector or User Mapping Missing") {
            toaster.warning({
              body: "The logged-in user does not have a configured source control connector or is not mapped to a source control username."
            });
            $scope.selectedRepository = null;
            $scope.isTemplateSelected = false;
            $scope.isPlaybookExecuted = false;
            $scope.isToaster = true;
            websocketService.unsubscribe(subscription);
          }
          else {
            if (!$scope.isToaster && !CommonUtils.isUndefined(response.data.result.data)) {
              toaster.warning({
                body: "Reset the \"Apply Latest Content\" task and try again."
              });
              $scope.selectedRepository = null;
              $scope.isTemplateSelected = false;
              $scope.isPlaybookExecuted = false;
              $scope.isToaster = true;
              websocketService.unsubscribe(subscription);
            }
          }
        } else if (response.data.status === 'finished with error' || response.data.status === 'failed') {
          $scope.selectedRepository = null;
          $scope.isPlaybookExecuted = false;
          $scope.isTemplateSelected = false;
          if (!$scope.isToaster) {
            toaster.warning({
              body: "The \"Review and Apply Latest Content\" playbook has failed. Check the playbook logs for details."
            });
            $scope.isToaster = true;
            websocketService.unsubscribe(subscription);
          }
        }
      });
    }

    function triggerPlaybook() {
      $scope.isPlaybookExecuted = true;
      $scope.isToaster = false;
      initWebsocket();
      var queryPayload = {
        "request": {
          "selectedRepository": $scope.selectedRepository,
          "record": (FormEntityService.get()).originalData
        }
      };
      var queryUrl = API.MANUAL_TRIGGER + playbookIRI;
      $http.post(queryUrl, queryPayload).then(function (response) {
        $scope.pullLatestContentPlaybookTaskID = response.data.task_id;
      });
    }

    function _handleTranslations() {
      widgetUtilityService.checkTranslationMode($scope.$parent.model.type).then(function () {
        $scope.viewWidgetVars = {
          // Create your translating static string variables here
          VIEW_DEFAULT_SELECT_ITEM: widgetUtilityService.translate('cicdContentImport.VIEW_DEFAULT_SELECT_ITEM'),
          VIEW_APPLY_BTN_LABEL: widgetUtilityService.translate('cicdContentImport.VIEW_APPLY_BTN_LABEL')
        };
      });
    }

    function changeRepository() {
      $scope.isTemplateSelected = true;
    }

    function _openWizard(jobUuid) {
      if (subscription) {
        websocketService.unsubscribe(subscription);
      }
      var templateUrl = 'app/editor/porter/importWizard.html';
      var controller = 'importWizardCtrl';
      var modal = $uibModal.open({
        animation: false,
        templateUrl: templateUrl,
        controller: controller,
        backdrop: 'static',
        windowClass: 'modal-ingestion',
        scope: $scope,
        resolve: {
          jobUuid: function () {
            return jobUuid;
          }
        }
      });
      modal.result.finally(function () {
        $scope.$broadcast('csGrid:refresh', 500);
        var endpoint = API.BASE + 'import_jobs/' + jobUuid + '?__selectFields=errorMessage,status,progressPercent,file,currentlyImporting,options';
        $http.get(endpoint).then(function (response) {
          if (response.data.currentlyImporting !== 'completed') {
            toaster.warning({
              body: "Failed to complete the \"Review and Apply Latest Content\" operation."
            });
          }
          var queryPayload = {
            "request": {
              "selectedRepository": $scope.selectedRepository,
              "record": (FormEntityService.get()).originalData,
              "importStatus": response.data.currentlyImporting
            }
          };
          var queryUrl = API.MANUAL_TRIGGER + updatePlaybookIRI;
          $http.post(queryUrl, queryPayload).then(function (response) {
            $scope.pullLatestContentPlaybookTaskID = response.data.task_id;
          });
          $scope.selectedRepository = null;
          $scope.isTemplateSelected = false;
          $scope.isPlaybookExecuted = false;
        });
      });
    }

    function init() {
      _handleTranslations();
    }

    init();
  }
})();
