/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
  'use strict';
  (function () {
      angular
          .module('cybersponse')
          .controller('editFeedConfigurationSettings200Ctrl', editFeedConfigurationSettings200Ctrl);
  
          editFeedConfigurationSettings200Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', '$timeout', 'widgetUtilityService'];
  
      function editFeedConfigurationSettings200Ctrl($scope, $uibModalInstance, config, $timeout, widgetUtilityService) {
        $scope.cancel = cancel;
        $scope.save = save;
        $scope.config = config;

        function cancel() {
            $uibModalInstance.dismiss('cancel');
        }

        function save() {
            $uibModalInstance.close($scope.config);
        }

        //provide i18n support
        function _handleTranslations() {
            let widgetData = {
                name: $scope.config.name,
                version: $scope.config.version
            };
            let widgetNameVersion = widgetUtilityService.getWidgetNameVersion(widgetData);
            if (widgetNameVersion) {
                widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
                    $scope.editWidgetVars = {
                        // Create your translating static string variables here
                        WIDGET_EDIT_TITLE: widgetUtilityService.translate('feedConfigurationSettings.WIDGET_EDIT_TITLE'),
                        WIDGET_EDIT_OK_BTN: widgetUtilityService.translate('feedConfigurationSettings.WIDGET_EDIT_OK_BTN')
                    };
                });
            }
            else {
                $timeout(function () {
                    cancel();
                }, 100)
            }
        }

        function init() {
            _handleTranslations();
        }

        init();

    }
  })();