/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('feedConfigurationSettings200Ctrl', feedConfigurationSettings200Ctrl);

  feedConfigurationSettings200Ctrl.$inject = ['$scope', '$resource', 'API', 'statusCodeService', 'toaster', '$http', 'PagedCollection', 'Query', 'Field', 'ALL_RECORDS_SIZE', 'CommonUtils', '$q', 'widgetUtilityService', '$timeout'];

  function feedConfigurationSettings200Ctrl($scope, $resource, API, statusCodeService, toaster, $http, PagedCollection, Query, Field, ALL_RECORDS_SIZE, CommonUtils, $q, widgetUtilityService, $timeout) {

    $scope.toggleFeedToIndicatorLinking = { open: true };
    $scope.toggleBlockHighConfidenceThreatFeeds = { open: false };
    $scope.toggleUnstructuredFeedsSupport = { open: false };
    $scope.toggleFeedRules = toggleFeedRules;
    $scope.updateSendNotification = updateSendNotification;
    $scope.clearSendEmailNotifications = clearSendEmailNotifications;
    $scope.save = save;
    $scope.unstructuredFeedsSlidder = unstructuredFeedsSlidder;
    $scope.saveSchedules = {};
    $scope.getKeyStoreRecord = false;

    function triggerPlaybook() {
      var queryPayload =
      {
        "request": $scope.feedRules
      }
      var queryUrl = API.MANUAL_TRIGGER + '43184f85-bd05-4d51-9e74-437359964f5c';
      $http.post(queryUrl, queryPayload).then(function (response) {
        $scope.configPlaybookTaskID = response.data.task_id;
        console.log(response);
      });
    }

    function init() {
      _handleTranslations();
      $q.all([_getIndicatorReputationPicklists(), _getKeyStoreRecord()]).then(function () {
        // Set after all API calls are done
        $scope.getKeyStoreRecord = true;
      });
    }

    function _getIndicatorReputationPicklists() {
      let defer = $q.defer();
      var endpoint = API.BASE + 'picklist_names/e75ed3c3-9f23-4a43-832b-0daf236209ba?$relationships=true';
      $resource(endpoint).get({}).$promise.then(function (response) {
        $scope.indicatorReputationPicklists = response.picklists;
        defer.resolve();
      });
      return defer.promise;
    }

    function _getKeyStoreRecord() {
      let defer = $q.defer();

      var pagedCollection = new PagedCollection('keys');
      var query = {
        logic: 'AND',
        limit: 1,
        filters: [{
          field: 'key',
          operator: 'eq',
          value: 'threat-intel-management-configuration'
        }],
        __selectFields: ["jSONValue"]
      };
      pagedCollection.query = new Query(query);
      pagedCollection.load().then(function () {
        if (pagedCollection.data['hydra:member'].length > 0) {
          $scope.feedRules = pagedCollection.data['hydra:member'][0].jSONValue;
          $scope.keyStoreRecordUUID = pagedCollection.data['hydra:member'][0].uuid;
          $scope.availableEmailClient = $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.availableEmailClient.find(function (client) {
            return client.enabled;
          });
          getEmailClientDetails($scope.availableEmailClient.name);
          $scope.oldFeedToIndicatorLinking = angular.copy($scope.feedRules.feedToIndicatorLinking);
          $scope.oldBlockHighConfidenceThreatFeeds = angular.copy($scope.feedRules.blockHighConfidenceThreatFeeds);
          $scope.oldUnstructuredFeedsSupport = angular.copy($scope.feedRules.unstructuredFeedsSupport);
          if ($scope.feedRules.unstructuredFeedsSupport.enabled && $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.enabled) {
            var emailIngestionScheduleCrontab = {
              "minute": "0",
              "hour": "*/1",
              "day_of_week": "*",
              "day_of_month": "*",
              "month_of_year": "*"
            };
            _createSchedule('emailIngestionPBSchedule', $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.emailIngestionPBSchedule, emailIngestionScheduleCrontab);
          }
          if ($scope.feedRules.blockHighConfidenceThreatFeeds.enabled && $scope.feedRules.blockHighConfidenceThreatFeeds.automaticBlockIOC.enabled) {
            var threatFeedBlockScheduleCrontab = {
              "minute": "1",
              "hour": "0",
              "day_of_week": "*",
              "day_of_month": "*",
              "month_of_year": "*"
            };
            _createSchedule('threatFeedBlockSchedule', $scope.feedRules.blockHighConfidenceThreatFeeds.automaticBlockIOC.threatFeedBlockSchedule, threatFeedBlockScheduleCrontab);
          }
          $scope.tagsField = new Field({
            'name': 'Tags',
            'writeable': true,
            'title': 'Tags',
            'formType': 'tags',
            'dataSource': {
              'model': 'recordTags'
            }
          });
          _getFeedRulesSettings().then(function () {
            defer.resolve();
          });
        }
      });
      return defer.promise;
    }

    $scope.$on('feedScheduleDetails', function (event, data) {
      var scheduleDetails = {
        id: data.scheduleDetails.id,
        name: data.scheduleDetails.name,
        task: data.scheduleDetails.task || "workflow.tasks.periodic_task",
        crontab: data.scheduleDetails.crontab,
        enabled: data.scheduleDetails.enabled,
        interval: data.scheduleDetails.interval || null
      };
      if ('Block High Confidence Threat Feeds (Automatic)' === data.scheduleDetails.name) {
        $scope.feedRules.blockHighConfidenceThreatFeeds.automaticBlockIOC.threatFeedBlockSchedule.activateScheduleQueryParams = angular.copy(scheduleDetails);
      } else if ('Extract Unstructured Feeds From Email' === data.scheduleDetails.name) {
        $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.emailIngestionPBSchedule.activateScheduleQueryParams = angular.copy(scheduleDetails);
      }
    });

    $scope.onEmailClientChange = function (availableEmailClient) {
      getEmailClientDetails(availableEmailClient.name);
      $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.availableEmailClient.forEach(function (emailClient) {
        emailClient.enabled = (emailClient.name === availableEmailClient.name);
      });
    };

    function toggleFeedRules(feedRule, $event) {
      if ($event && $event.target.className === 'switch-slider') {
        feedRule.enabled = !feedRule.enabled;
      }
    }

    function updateSendNotification() {
      // Automatically uncheck and disable the "Enable Threat Feed Ingestion Notifications" checkbox
      if (!($scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromFile.enabled ||
        $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.enabled)) {
        $scope.feedRules.unstructuredFeedsSupport.sendEmailNotifications.enabled = false;  // Uncheck it
        $scope.feedRules.unstructuredFeedsSupport.enabled = false;
      } else {
        $scope.feedRules.unstructuredFeedsSupport.enabled = true;
      }
    }

    function clearSendEmailNotifications() {
      // Ensure the "Enable Threat Feed Ingestion Notifications" checkbox is unchecked if both are unchecked
      if (!($scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromFile.enabled ||
        $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.enabled)) {
        $scope.feedRules.unstructuredFeedsSupport.sendEmailNotifications.enabled = false;  // Uncheck it
      }
    }

    function unstructuredFeedsSlidder(isEnabled) {
      if (isEnabled) {
        $scope.toggleUnstructuredFeedsSupport = { open: true };
      }
    }

    function getEmailClientDetails(name) {
      var queryBody = {
        "sort": [
          { "field": "featured", "direction": "DESC" },
          { "field": "label", "direction": "ASC" }
        ],
        "limit": ALL_RECORDS_SIZE,
        "logic": "AND",
        "filters": [
          { "field": "type", "operator": "in", "value": ["connector"] },
          { "field": "name", "operator": "eq", "value": name },
          { "field": "version", "operator": "notlike", "value": "%_dev" }
        ],
        "page": 1,
        "__selectFields": []
      };

      $resource(API.QUERY + 'solutionpacks?$limit=' + ALL_RECORDS_SIZE + '&$page=1').save(queryBody).$promise.then(function (response) {
        if (response['hydra:member'] && response['hydra:member'].length > 0) {
          $scope.exchangeUUID = response['hydra:member'][0].uuid;
        }
      });
    }

    function _createSchedule(scheduleName, scheduleDetails, crontab) {
      var queryBody = {
        name: scheduleDetails.name,
        "crontab": crontab,
        "kwargs": {
          "exit_if_running": true,
          "wf_iri": API.API_3_BASE + API.WORKFLOWS + scheduleDetails.playbook_uuid,
          "timezone": "UTC",
          "utcOffset": "UTC",
          "createUser": "/api/3/people/3451141c-bac6-467c-8d72-85e0fab569ce"
        },
        "enabled": false
      };
      var url = API.WORKFLOW + 'api/scheduled/?depth=2&format=json&limit=' + ALL_RECORDS_SIZE + '&ordering=-modified&search=' + scheduleDetails.name.replace(/\s+/g, '+') + '&task=workflow.tasks.periodic_task';
      // Make the GET request to check if the schedule already exists
      $resource(url).get({}).$promise.then(function (response) {
        if (response['hydra:member'].length === 0) {
          // If no schedule exists, create a new one
          $resource(API.WORKFLOW + 'api/scheduled/?format').save(queryBody).$promise.then(function (postResponse) {
            // Save the new schedule details
            $scope.saveSchedules[scheduleName] = {
              id: postResponse.id,
              crontab: postResponse.crontab,
              interval: postResponse.interval,
              name: postResponse.name,
              task: postResponse.task,
              enabled: postResponse.enabled
            };
            // Update the schedule in feed configuration
            _updateScheduleInFeedConfiguration(scheduleName);
            // If the schedule is not enabled, activate it
            if (!$scope.saveSchedules[scheduleName].enabled) {
              $scope.saveSchedules[scheduleName].enabled = true;
              _updateSchedule($scope.saveSchedules[scheduleName]);
            }
          });
        } else {
          // If schedule exists, use the existing one
          $scope.saveSchedules[scheduleName] = {
            id: response['hydra:member'][0].id,
            crontab: response['hydra:member'][0].crontab,
            interval: response['hydra:member'][0].interval,
            name: response['hydra:member'][0].name,
            task: response['hydra:member'][0].task,
            enabled: response['hydra:member'][0].enabled
          };
          // Update the schedule in feed configuration
          _updateScheduleInFeedConfiguration(scheduleName);
          // If the schedule is not enabled, activate it
          if (!$scope.saveSchedules[scheduleName].enabled) {
            $scope.saveSchedules[scheduleName].enabled = true;
            _updateSchedule($scope.saveSchedules[scheduleName]);
          }
        }
      });
    }

    function _updateScheduleInFeedConfiguration(scheduleName) {
      if (scheduleName === 'emailIngestionPBSchedule') {
        // Update feed configuration for email ingestion schedule
        $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.emailIngestionPBSchedule.activateScheduleQueryParams = $scope.saveSchedules[scheduleName];
        _updateFeedConfigurationSettings(); // Assuming this function handles the API call and returns a promise
      } else if (scheduleName === 'threatFeedBlockSchedule') {
        // Update feed configuration for threat feed block schedule
        $scope.feedRules.blockHighConfidenceThreatFeeds.automaticBlockIOC.threatFeedBlockSchedule.activateScheduleQueryParams = $scope.saveSchedules[scheduleName];
        _updateFeedConfigurationSettings(); // Assuming this function handles the API call and returns a promise
      }
    }


    function _getFeedRulesSettings() {
      return $resource(API.WORKFLOW + "api/dynamic-variable/?name=Indicator_Feed_Reputation_Preference&format=json").get({}).$promise.then(function (response) {
        $scope.feedConfidenceThresholdVariable = response["hydra:member"][0];
        var parsedFeedConfigValues = JSON.parse($scope.feedConfidenceThresholdVariable.value);
        $scope.feedRules.feedToIndicatorLinking.feedConfidenceThreshold = parsedFeedConfigValues.confidenceThreshold;
        $scope.feedRules.feedToIndicatorLinking.enabled =
          parsedFeedConfigValues.setReputation;
      }, statusCodeService);
    }

    function _updateSchedule(scheduleDetails) {
      var url = API.WORKFLOW + 'api/scheduled/' + scheduleDetails.id + '/?format=json';
      return $resource(url, null, { update: { method: "PUT" } })
        .update(scheduleDetails)
        .$promise
        .then(function () {
          console.log("Schedule updated successfully.");
        }, function () {
          toaster.error({
            body: "Unable to update schedule.",
          });
        });
    }

    function _saveFeedToIndicatorLinking(feedToIndicatorLinkingForm) {
      $scope.feedConfidenceThresholdVariable.value = JSON.stringify({
        setReputation: $scope.feedRules.feedToIndicatorLinking.enabled,
        confidenceThreshold: $scope.feedRules.feedToIndicatorLinking.feedConfidenceThreshold,
      });

      return $resource(API.WORKFLOW + "api/dynamic-variable/" + $scope.feedConfidenceThresholdVariable.id + "/?format=json", null, {
        update: { method: "PUT" }
      })
        .update($scope.feedConfidenceThresholdVariable)
        .$promise
        .then(() => {
          feedToIndicatorLinkingForm.$setPristine();
          feedToIndicatorLinkingForm.$setUntouched();
        })
        .catch((error) => {
          console.error("Update dynamic-variable api call failed with error message:", error);
        })
        .finally(() => {
          feedToIndicatorLinkingForm.$dirty = false;
          $scope.oldFeedToIndicatorLinking = angular.copy($scope.feedRules.feedToIndicatorLinking);
        });
    }

    function _removeFields(obj, fields) {
      if (Array.isArray(obj)) {
        obj.forEach(item => _removeFields(item, fields)); // Handle arrays
      } else if (obj !== null && typeof obj === 'object') {
        Object.keys(obj).forEach(key => {
          if (fields.includes(key)) {
            delete obj[key]; // Delete the field if it's in the list
          } else {
            _removeFields(obj[key], fields); // Recurse through nested objects
          }
        });
      }
    }

    function _resetForm(form) {
      form.$setPristine();
      form.$dirty = false;
    }

    function _hasFeedConfigurationChanged(oldFeedConfig, newFeedConfig, schedulePath) {
      let oldCopy = angular.copy(oldFeedConfig);
      let newCopy = angular.copy(newFeedConfig);

      // Remove sensitive fields from both copies
      _removeFields(oldCopy, ['$$hashKey', 'id']);
      _removeFields(newCopy, ['$$hashKey', 'id']);

      return !_.isEqual(oldCopy, newCopy);
    }

    function _updateScheduleIfNeeded(feedRule, schedulePath) {
      // Check if the nested object structure exists to avoid accessing undefined properties
      const scheduleFullPath = schedulePath.concat('.activateScheduleQueryParams');
      const keys = scheduleFullPath.split('.');
      // Traverse the object using reduce and optional chaining
      const schedule = keys.reduce((obj, key) => obj?.[key], feedRule);
      if (!schedule) {
        console.warn("Missing schedule configuration:", schedulePath);
        return Promise.resolve(); // No update needed if the schedule doesn't exist
      }
      var scheduleStatus = false;
      if (feedRule.name === 'Unstructured Threat Feeds Support') {
        scheduleStatus = feedRule.enabled && feedRule.ingestFeedsFromEmail.enabled;
      } else {
        scheduleStatus = feedRule.enabled && feedRule.automaticBlockIOC.enabled;
      }
      if (scheduleStatus && schedule.enabled !== true) {
        schedule.enabled = true;
        return _updateSchedule(schedule);
      }
      if (!scheduleStatus && schedule.enabled !== false) {
        schedule.enabled = false;
        return _updateSchedule(schedule);
      }
      return Promise.resolve(); // No update needed
    }

    function _updateFeedConfigurationSettings() {
      const requestPayload = { jSONValue: $scope.feedRules };
      return $resource(API.BASE + "keys/" + $scope.keyStoreRecordUUID, null, { update: { method: "PUT" } })
        .update(requestPayload)
        .$promise;
    }

    function save(feedConfigurationSettingsForm) {
      if ($scope.feedConfigurationSettingsForm.$invalid) {
        if ($scope.feedConfigurationSettingsForm.feedToIndicatorLinkingForm.$invalid) {
          $scope.toggleFeedToIndicatorLinking = { open: true };
        }
        if ($scope.feedConfigurationSettingsForm.blockHighConfidenceThreatFeedsForm.$invalid) {
          $scope.toggleBlockHighConfidenceThreatFeeds = { open: true };
          $scope.feedConfigurationSettingsForm.blockHighConfidenceThreatFeedsForm.emailRecipients.$touched = true;
          $scope.feedConfigurationSettingsForm.blockHighConfidenceThreatFeedsForm.emailRecipients.$invalid = true;
        }
        if ($scope.feedConfigurationSettingsForm.unstructuredFeedsSupportForm.$invalid) {
          $scope.toggleUnstructuredFeedsSupport = { open: true };
          $scope.feedConfigurationSettingsForm.unstructuredFeedsSupportForm.emailRecipients.$touched = true;
          $scope.feedConfigurationSettingsForm.unstructuredFeedsSupportForm.emailRecipients.$invalid = true;
        }
        $scope.feedConfigurationSettingsForm.$setTouched();
        $scope.feedConfigurationSettingsForm.$focusOnFirstError();
        return;
      }
      var promises = [];
      // Handle Feed to Indicator Linking
      if (!_.isEqual($scope.oldFeedToIndicatorLinking, $scope.feedRules.feedToIndicatorLinking)) {
        _resetForm(feedConfigurationSettingsForm.feedToIndicatorLinkingForm);
        promises.push(_saveFeedToIndicatorLinking(feedConfigurationSettingsForm.feedToIndicatorLinkingForm));
      }

      // Handle Block High Confidence Threat Feeds
      if (_hasFeedConfigurationChanged($scope.oldBlockHighConfidenceThreatFeeds, $scope.feedRules.blockHighConfidenceThreatFeeds, 'automaticBlockIOC.threatFeedBlockSchedule')) {
        _resetForm(feedConfigurationSettingsForm.blockHighConfidenceThreatFeedsForm);
        promises.push(_updateScheduleIfNeeded($scope.feedRules.blockHighConfidenceThreatFeeds, 'automaticBlockIOC.threatFeedBlockSchedule'));
      }
      // Handle Unstructured Feeds Support
      if (_hasFeedConfigurationChanged($scope.oldUnstructuredFeedsSupport, $scope.feedRules.unstructuredFeedsSupport, 'ingestFeedsFromEmail.emailIngestionPBSchedule')) {
        if (!($scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromFile.enabled || $scope.feedRules.unstructuredFeedsSupport.ingestFeedsFromEmail.enabled)) {
          $scope.feedRules.unstructuredFeedsSupport.enabled = false;
          toaster.warning({
            body: "No options selected. Disabling \"Ingest unstructured Threat Feeds\" rule."
          });
        }
        _resetForm(feedConfigurationSettingsForm.unstructuredFeedsSupportForm);
        promises.push(_updateScheduleIfNeeded($scope.feedRules.unstructuredFeedsSupport, 'ingestFeedsFromEmail.emailIngestionPBSchedule'));
      }
      // Execute all promises and update feed configuration settings
      Promise.all(promises)
        .then(_updateFeedConfigurationSettings)
        .then(() => {
          triggerPlaybook();
          toaster.success({
            body: "Feed configuration settings updated successfully."
          });
        })
        .catch((error) => {
          console.error("Error updating feed configuration settings:", error);
          toaster.error({
            body: "Unable to update feed configuration settings."
          });
        })
        .finally(() => {
          _resetForm($scope.feedConfigurationSettingsForm);
        });
    }

    //provide i18n support
    function _handleTranslations() {
      let widgetData = {
        name: $scope.config.name,
        version: $scope.config.version
      };
      let widgetNameVersion = widgetUtilityService.getWidgetNameVersion(widgetData);
      if (widgetNameVersion) {
        widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
          $scope.viewWidgetVars = {
            // Create your translating static string variables here
            WIDGET_TITLE: widgetUtilityService.translate('feedConfigurationSettings.WIDGET_TITLE'),
            WIDGET_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.WIDGET_DESCRIPTION'),
            LINK_FEEDS_TO_INDICATOR_RULE_TITLE: widgetUtilityService.translate('feedConfigurationSettings.LINK_FEEDS_TO_INDICATOR_RULE_TITLE'),
            LINK_FEEDS_TO_INDICATOR_RULE_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.LINK_FEEDS_TO_INDICATOR_RULE_DESCRIPTION'),
            LINK_FEEDS_TO_INDICATOR_RULE_TEXT_FIELD_TITLE: widgetUtilityService.translate('feedConfigurationSettings.LINK_FEEDS_TO_INDICATOR_RULE_TEXT_FIELD_TITLE'),
            LINK_FEEDS_TO_INDICATOR_RULE_TEXT_FIELD_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.LINK_FEEDS_TO_INDICATOR_RULE_TEXT_FIELD_TOOLTIP'),

            UNSTRUCTURED_THREAT_FEEDS_RULE_TITLE: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_TITLE'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_DESCRIPTION'),
            INGEST_FROM_FILE: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_FILE'),
            INGEST_FROM_FILE_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_FILE_TOOLTIP'),
            INGEST_FROM_EMAIL: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL'),
            INGEST_FROM_EMAIL_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_TOOLTIP'),
            INGEST_FROM_EMAIL_EMAIL_SERVER: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_SERVER'),
            INGEST_FROM_EMAIL_EMAIL_SERVER_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_SERVER_TOOLTIP'),
            INGEST_FROM_EMAIL_EMAIL_SERVER_ERROR: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_SERVER_ERROR'),
            INGEST_FROM_EMAIL_EMAIL_SERVER_NOTE_1: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_SERVER_NOTE_1'),
            INGEST_FROM_EMAIL_EMAIL_SERVER_NOTE_1_2: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_SERVER_NOTE_1_2'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER_TOOLTIP'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_1: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_1'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_2: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_2'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_3: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_3'),
            INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_4: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_EMAIL_FOLDER_ERROR_4'),
            INGEST_FROM_EMAIL_ING_PARAMS_TITLE: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_PARAMS_TITLE'),
            INGEST_FROM_EMAIL_ING_PARAMS_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_PARAMS_TOOLTIP'),
            INGEST_FROM_EMAIL_ING_PARAMS_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_PARAMS_DESCRIPTION'),
            INGEST_FROM_EMAIL_ING_SCHEDULE: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_SCHEDULE'),
            INGEST_FROM_EMAIL_ING_SCHEDULE_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_SCHEDULE_TOOLTIP'),
            INGEST_FROM_EMAIL_ING_SCHEDULE_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.INGEST_FROM_EMAIL_ING_SCHEDULE_DESCRIPTION'),
            INGESTED_FEED_BLOCK: widgetUtilityService.translate('feedConfigurationSettings.INGESTED_FEED_BLOCK'),
            INGESTED_FEED_BLOCK_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.INGESTED_FEED_BLOCK_TOOLTIP'),
            INGESTED_FEED_BLOCK_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.INGESTED_FEED_BLOCK_DESCRIPTION'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_TOOLTIP'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_DESCRIPTION_1: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_DESCRIPTION_1'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_DESCRIPTION_12: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_DESCRIPTION_12'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_EMAIL_ADD: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_EMAIL_ADD'),
            UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_EMAIL_ADD_ERROR: widgetUtilityService.translate('feedConfigurationSettings.UNSTRUCTURED_THREAT_FEEDS_RULE_NOTIFICATION_EMAIL_ADD_ERROR'),

            BLOCK_HIGH_CONF_FEED_RULE_TITLE: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_TITLE'),
            BLOCK_HIGH_CONF_FEED_RULE_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_DESCRIPTION'),
            BLOCK_HIGH_CONF_FEED_RULE_CRITERIA: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_CRITERIA'),
            BLOCK_HIGH_CONF_FEED_RULE_CONF: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_CONF'),
            BLOCK_HIGH_CONF_FEED_RULE_CONF_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_CONF_TOOLTIP'),
            BLOCK_HIGH_CONF_FEED_RULE_REPUTATION: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_REPUTATION'),
            BLOCK_HIGH_CONF_FEED_RULE_REPUTATION_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_REPUTATION_TOOLTIP'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_TOOLTIP: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_TOOLTIP'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_DESCRIPTION'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_SCH_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_BLOCK_SCH_DESCRIPTION'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_DESCRIPTION: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_DESCRIPTION'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_EMAIL_ADD: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_EMAIL_ADD'),
            BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_EMAIL_ADD_ERROR: widgetUtilityService.translate('feedConfigurationSettings.BLOCK_HIGH_CONF_FEED_RULE_IS_NOTIFY_EMAIL_ADD_ERROR'),
            WZ_SAVE_BTN: widgetUtilityService.translate('feedConfigurationSettings.WZ_SAVE_BTN'),
            SAVE_BTN: widgetUtilityService.translate('feedConfigurationSettings.SAVE_BTN'),

            MSG_CONFIRM_DI_SCH: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.MSG_CONFIRM_DI_SCH'),
            NO_OPTION: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.NO_OPTION'),
            YES_OPTION: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.YES_OPTION'),
            TIME_BY: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.TIME_BY'),
            CRON_VALUE: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE'),
            CRON_VALUE_HR: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE_HR'),
            CRON_VALUE_DAILY: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE_DAILY'),
            CRON_VALUE_WEEKLY: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE_WEEKLY'),
            CRON_VALUE_MONTHLY: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE_MONTHLY'),
            CRON_VALUE_YEARLY: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.CRON_VALUE_YEARLY'),
            MINUTE_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.MINUTE_LABEL'),
            HOUR_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.HOUR_LABEL'),
            MONTH_DAY_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.MONTH_DAY_LABEL'),
            MONTH_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.MONTH_LABEL'),
            WEEK_DAY_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.WEEK_DAY_LABEL'),
            TIMEZONE_LABEL: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.TIMEZONE_LABEL'),
            TIMEZONE_TOOLTIP: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.TIMEZONE_TOOLTIP'),
            SAVE_BUTTON: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.SAVE_BUTTON'),
            BTN_SAVING_SPINNER: widgetUtilityService.translate('FEED_CONFIG_WIDGET_SCHEDULE_DIRECTIVE.BTN_SAVING_SPINNER')

          };
        });
      }
      else {
        $timeout(function () {
          cancel();
        }, 100)
      }
    }

    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }

    init();
  }
})();
