/* Copyright (C) 2008 - 2024 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */

'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('fortiAIConfiguration200Ctrl', fortiAIConfiguration200Ctrl);

  fortiAIConfiguration200Ctrl.$inject = ['$scope', '$rootScope', 'fortiAiConfigService', 'toaster', 'WizardHandler', '$window', '_', 'currentPermissionsService', 'connectorService', 'CommonUtils', '$controller', 'widgetBasePath', 'fileService', '$q', 'Cryptography', 'usersService'];

  function fortiAIConfiguration200Ctrl($scope, $rootScope, fortiAiConfigService, toaster, WizardHandler, $window, _, currentPermissionsService, connectorService, CommonUtils, $controller, widgetBasePath, fileService, $q, Cryptography, usersService) {
    $controller('BaseConnectorCtrl', {
      $scope: $scope
    });
    $scope.entity = {};
    $scope.keyStoreValue = {};
    $scope.llmIntegrationData = {};
    $scope.moveNext = moveNext;
    $scope.moveBack = moveBack;
    $scope.loadConnectorPage = loadConnectorPage;
    $scope.updateLLMIntegrationData = updateLLMIntegrationData;
    $scope.saveConnector = saveConnector;
    $scope.proceedToCreateAssistant = proceedToCreateAssistant;
    $scope.formUpdate = formUpdate;
    $scope.defaultLLMIntegration = {};
    $scope.isLightTheme = $rootScope.theme.id === 'light';
    $scope.startInfoGraphics = $scope.isLightTheme ? widgetBasePath + 'images/fortiAI-start-light.png' : widgetBasePath + 'images/fortiAI-start-dark.png';
    $scope.connectLLMInfoGraphics = $scope.isLightTheme ? widgetBasePath + 'images/fortiAI-connect-llm-light.png' : widgetBasePath + 'images/fortiAI-connect-llm-dark.png';
    $scope.createAssistantGraphics = $scope.isLightTheme ? + widgetBasePath + 'images/fortiai-create-assistant-light.png' : widgetBasePath + 'images/fortiai-create-assistant-dark.png';
    $scope.widgetCSS = widgetBasePath + 'assets/fortiAiConfig.css';
    $scope.assistantStatus = 'Create'; 
    var attachmentData = '',soc_function_data = '', pb_instruction = '';
    var soc_assistant_id = '' , playbook_assistant_id = '';
    $scope.createUpdateActionClicked = false;
    $scope.genAIAssistant = {};
    var authToken = Cryptography.getAuthToken();
    let user = usersService.getCurrentUser();
    const currentUserId = user.userId;
    var userLoginId = '';
    var keystorePermissions = currentPermissionsService.getPermission('keys');
    $scope.isValidKeystorePermission = true;
    $scope.configurationClicked = false; 
    $scope.configureProcessing = false;

    init();

    function init() {
      $scope.llmIntegrationData = fortiAiConfigService.constants();
      $scope.defaultLLMIntegration = $scope.llmIntegrationData.defaultLLMIntegration;
    }

    function moveNext() {
      var currentStepTitle = WizardHandler.wizard('fortiAIConfiguration').currentStep().wzTitle
      if (currentStepTitle === 'Start') {
        if (keystorePermissions.create && keystorePermissions.read && keystorePermissions.update) {
          $scope.isValidKeystorePermission = true;
          fetchKeyStoreData().then(function () {
            updateLLMIntegrationData('load');
            WizardHandler.wizard('fortiAIConfiguration').next();
          }, function (err) {
            toaster.error({ body: "Key Store record not found, refer documentation" });
          });
        } else {
          toaster.error({ body: "Required Key Store permissions not assigned to the user, refer documentation" });
          $scope.isValidKeystorePermission = false;
        }
      }
      if (currentStepTitle === 'Finish') {
        fortiAiConfigService.updateConfigurationRecord($scope.keyStoreValue, $scope.entity['hydra:member'][0].uuid);
        WizardHandler.wizard('fortiAIConfiguration').next();
      }
    }

    function loadConnectorPage() {
      updateKeyStoreValue();
      fortiAiConfigService.loadConnectorData($scope.keyStoreValue.llmIntegrationToUse).then(function (selectedConnector) {
        $scope.selectedConnector = selectedConnector;
        $scope.loadConnector($scope.selectedConnector, false, false);
        WizardHandler.wizard('fortiAIConfiguration').next();
      });
    }

    function fetchKeyStoreData(){
      var defer = $q.defer();
      fortiAiConfigService.getKeyStoreRecord($scope.llmIntegrationData.queryForKeyStore, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          $scope.entity = response;
          $scope.keyStoreValue = $scope.entity['hydra:member'][0].jSONValue;
          defer.resolve();
        }
        else {
          defer.reject();
        }
      });
      return defer.promise;
    }

    function saveConnector(saveFrom) {
      $scope.isConnectorConfigured = true;
      $scope.configuredConnector = false;
      $scope.configurationClicked = false;
      var data = angular.copy($scope.connector);
      if (CommonUtils.isUndefined(data)) {
        $scope.statusChanged = false;
        return;
      }
      if (!currentPermissionsService.availablePermission('connectors', 'update')) {
        $scope.statusChanged = false;
        return;
      }

      var newConfiguration, newConfig, deleteConfig;
      newConfiguration = false;
      if (saveFrom !== 'deleteConfigAndSave') {
        if (!_.isEmpty($scope.connector.config_schema)) {
          if (!$scope.validateConfigurationForm()) {
            return;
          }
        }
        if (!$scope.input.selectedConfiguration.id) {
          newConfiguration = true;
          $scope.input.selectedConfiguration.config_id = $window.UUID.generate();
          if ($scope.input.selectedConfiguration.default) {
            angular.forEach(data.configuration, function (configuration) {
              if (configuration.config_id !== $scope.input.selectedConfiguration.config_id) {
                configuration.default = false;
              }
            });
          }
          data.configuration.push($scope.input.selectedConfiguration);
          newConfig = $scope.input.selectedConfiguration;
        }
        delete data.newConfig;
      }

      if (saveFrom === 'deleteConfigAndSave') {
        $scope.isConnectorConfigured = false;
        deleteConfig = true;
        $scope.isConnectorHealthy = false;
      }

      var updateData = {
        connector: data.id,
        name: $scope.input.selectedConfiguration.name,
        config_id: $scope.input.selectedConfiguration.config_id,
        id: $scope.input.selectedConfiguration.id,
        default: $scope.input.selectedConfiguration.default,
        config: {},
        teams: $scope.input.selectedConfiguration.teams
      };
      $scope.saveValues($scope.input.selectedConfiguration.fields, updateData.config);
      $scope.saveProcessing = true;
      connectorService.updateConnectorConfig(updateData, newConfiguration, deleteConfig).then(function (response) {
        if (newConfig) {
          $scope.connector.configuration.push(newConfig);
          if (response.default) {
            $scope.removeDefaultFromOthers();
          }

        }
        $scope.formHolder.connectorForm.$setPristine();
        if (!deleteConfig) {
          $scope.input.selectedConfiguration.id = response.id;
          $scope.configuredConnector = true;
          $scope.isConnectorHealthy = true;
        }
        $scope.checkHealth();
        $scope.statusChanged = false;
      }, function (error) {
        toaster.error({
          body: error.data.message ? error.data.message : error.data['hydra:description']
        });
      }).finally(function () {
        $scope.saveProcessing = false;
      });
    }

    function updateLLMIntegrationData(action) {
      var llmIntegrationToUse;
      var llMIntegrationDict;

      if (action === 'load') {
        llmIntegrationToUse = $scope.keyStoreValue.llmIntegrationToUse;
        llMIntegrationDict = $scope.keyStoreValue.llmIntegrations.find(integration => integration.name === llmIntegrationToUse);
        if ($scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse] === undefined) {
          $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse] = { "conversationModel": "", "pBGenerationModel": "", "isMultiConfigAvailable": false }
        }
        $scope.defaultLLMIntegration.conversationModel = $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse].conversationModel
        $scope.defaultLLMIntegration.pBGenerationModel = $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse].pBGenerationModel
        $scope.defaultLLMIntegration.isMultiConfigAvailable = $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse].isMultiConfigAvailable
      } else if (action === 'set') {
        llmIntegrationToUse = $scope.defaultLLMIntegration.title;
        llMIntegrationDict = $scope.keyStoreValue.llmIntegrations.find(integration => integration.title === llmIntegrationToUse);
        if ($scope.keyStoreValue.llmIntegrationData[llMIntegrationDict.name] === undefined) {
          $scope.keyStoreValue.llmIntegrationData[llMIntegrationDict.name] = { "conversationModel": "", "pBGenerationModel": "", "isMultiConfigAvailable": false }
        }
        $scope.defaultLLMIntegration.conversationModel = $scope.keyStoreValue.llmIntegrationData[llMIntegrationDict.name].conversationModel
        $scope.defaultLLMIntegration.pBGenerationModel = $scope.keyStoreValue.llmIntegrationData[llMIntegrationDict.name].pBGenerationModel
        $scope.defaultLLMIntegration.isMultiConfigAvailable = $scope.keyStoreValue.llmIntegrationData[llMIntegrationDict.name].isMultiConfigAvailable
      }
      $scope.defaultLLMIntegration.title = llMIntegrationDict.title;
      $scope.defaultLLMIntegration.name = llMIntegrationDict.name;
      $scope.defaultLLMIntegration.modelList = llMIntegrationDict.modelList;
      $scope.defaultLLMIntegration.llmIntegrationsList = $scope.keyStoreValue.llmIntegrations.map(item => item.title);
    }

    function updateKeyStoreValue() {
      var llmIntegrationToUse = $scope.defaultLLMIntegration.name;
      var llmIntegrationDict = $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse];
      $scope.keyStoreValue.llmIntegrationToUse = llmIntegrationToUse;
      llmIntegrationDict.conversationModel = $scope.defaultLLMIntegration.conversationModel;
      llmIntegrationDict.pBGenerationModel = $scope.defaultLLMIntegration.pBGenerationModel;
      llmIntegrationDict.isMultiConfigAvailable = $scope.defaultLLMIntegration.isMultiConfigAvailable;
      $scope.keyStoreValue.llmIntegrationData[llmIntegrationToUse] = llmIntegrationDict;
    }

    //load step4 - create assistant page
    function proceedToCreateAssistant() {
      $scope.configurationClicked = true;
      if(!$scope.connector.configuration && $scope.connector.configuration.length === 0){
        toaster.warning({
          body: 'Connector configuration not found'
        });
        return;
      } 
      $scope.assistantCreated = false;
      $scope.config_name = $scope.input.selectedConfiguration.config_id;
      if($scope.defaultLLMIntegration.isMultiConfigAvailable){  //if multiple config available check for userloginId config
        fetchUserLogin().then(function(){
          if(!checkForUserLoggedInId()) {
            toaster.warning({
              body: 'Please create atleast one connector configuration with matching user login Id'
            });
            return;
          }
          loadAndUpdateAssistantDetails();
        });
      }else{
        if(!checkForDefaultConfig()) { //if single config available check for default config
          toaster.warning({
            body: 'Please mark any one connector configuration as default'
          });
          return;
        }
        loadAndUpdateAssistantDetails();
      }
    }

    function loadAndUpdateAssistantDetails(){
      $scope.configureProcessing = true;
      $q.all([loadAttachmentData(), getAssistantIds()]).then((response) => {
        $scope.configurationClicked = false;
        let assistantPromise = configureAssistant();
        assistantPromise.then(function(response) {
          $scope.genAIAssistant['playbookAssistantName'] = response[0].data.playbook_assistant.name;
          $scope.genAIAssistant['socAssistantName'] = response[0].data.soc_assistant.name;
          $scope.configureProcessing = false;
          toaster.success({
            body: 'Successfully created/updated Assistant'
          });
          WizardHandler.wizard('fortiAIConfiguration').next();
        }, function(error) {
          toaster.error({ body: error.data.message || 'Failed to create/update Assistant' });
          console.log(error.data.message);
          $scope.configureProcessing = false;
        });
      }, function(error) {
        toaster.error({ body: error.data.message || 'Failed to load Assistant data' });
        console.log(error.data.message);
        $scope.configureProcessing = false;
      });
    }

    function fetchUserLogin(){
      var defer = $q.defer();
      fortiAiConfigService.getUserLoginId(currentUserId).then(function (userLoginDetails) {
        if (userLoginDetails && userLoginDetails.usersresp && userLoginDetails.usersresp[0].loginid) {
          userLoginId = userLoginDetails.usersresp[0].loginid;
          defer.resolve();
        }
      }, function (error) {
        toaster.error({ body: 'Failed to fetch logged in user Id' });
      });  
      return defer.promise;
    }

    //to enable/disable button when change in text
    function formUpdate(){
      $scope.assistantCreated = false;
    }

    //load file instruction for soc assistant from attachment module
    function loadAttachmentData(){
      var defer = $q.defer();
      const soc_instruction = fortiAiConfigService.getAttachmentRecord($scope.llmIntegrationData.queryForAttachment,'attachments').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          var fileId = response['hydra:member'][0]['file']['id'];
          fileService.getFile(fileId).then(function(response){
            attachmentData = response.data;
          })
        }
        else {
          toaster.error({ body: 'SOC Assitant instruction attachment record not found' });
        }
      });
      $q.all([soc_instruction]).then((response) => {
          defer.resolve();
      }).catch((error) => {
        toaster.error({ body: 'Assistant ids not found' });
      })
      return defer.promise;
    }

 
    // check if assistant ids are already present
    function getAssistantIds(){
      var defer = $q.defer();
      var config_name = $scope.input.selectedConfiguration.config_id;
      var payload = { genai_type: 'OpenAI' };
      fortiAiConfigService.executeAction('aiassistant-utils', 'get_assistant_ids',null, payload)
      .then(function (response) {
        if (response) {
          if(response.data !== null && (response.data.soc_assistant_id !== '' && response.data.playbook_assistant_id !== '')){
            $scope.assistantStatus = 'Update';
            toaster.success({
              body: 'Updating Assistant, please wait'
            });
            var socId_payload = { assistant_id: response.data.soc_assistant_id}; 
            soc_assistant_id = response.data.soc_assistant_id;
            const soc_name_promise = fortiAiConfigService.executeAction('openai', 'get_assistant', config_name, socId_payload).then(function (soc_response) {
              return soc_response;
            });
            var pbId_payload = {assistant_id: response.data.playbook_assistant_id};
            playbook_assistant_id = response.data.playbook_assistant_id;
            const pb_name_promise = fortiAiConfigService.executeAction('openai', 'get_assistant', config_name, pbId_payload).then(function (pb_response) {
              return pb_response;
            });
            $q.all([soc_name_promise, pb_name_promise]).then((responses) => {
              if (responses) {
                $scope.genAIAssistant.socAssistantName = responses[0].data.name;
                $scope.genAIAssistant.playbookAssistantName = responses[1].data.name;
                //updateAssistant();
              }
              defer.resolve();
            }).catch((error) => {
              console.log(error);
              defer.reject(error);
            })
          }
          else{
            $scope.assistantStatus = 'Create';
            toaster.success({
              body: 'Creating Assistants, please wait'
            });
            defer.resolve();
          }
        }
      }, function (error) {
        toaster.error({ body: 'Assistant Ids not found' });
        defer.reject(error);
      });
      return defer.promise;
    }

    //call create_assistant from openaic and then save the assistant ids in assistant utils 
    function configureAssistant() {
      var defer = $q.defer();

      var config_name = $scope.input.selectedConfiguration.config_id;
      var payload = {
        genai_type: "OpenAI", 
        genai_arguments: {
          auth_token: authToken,
          config_id: config_name
        },
        assistant_metadata: [
          {
            assistant_id: playbook_assistant_id,
            type: 'playbook_assistant', 
            model: $scope.defaultLLMIntegration.pBGenerationModel
          }, 
          { 
            assistant_id: soc_assistant_id,
            type: 'soc_assistant', 
            model: $scope.defaultLLMIntegration.pBGenerationModel, 
            instructions: JSON.stringify(attachmentData)
          }
        ]
      }
      const assistant_promise = fortiAiConfigService.executeAction('aiassistant-utils', 'configure_assistant', config_name, payload).then(function (assistant_response) {
        return assistant_response;
      });

      $q.all([assistant_promise]).then((responses) => {
        defer.resolve(responses);
      }).catch((error) => {
        defer.reject(error);
      })
      return defer.promise;
    }

    function checkForDefaultConfig() {
      return $scope.connector.configuration.find(function(config) {
        return config.default;
      });
    }

    function checkForUserLoggedInId() {
      return $scope.connector.configuration.find(function(config) {
        return config.name === userLoginId;
      });
    }

    function moveBack() {
      $scope.configurationClicked = false;
      WizardHandler.wizard('fortiAIConfiguration').previous();
    }
  }
})();
