/* Copyright (C) 2008 - 2025 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE */

'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('fortiAIConfiguration300Ctrl', fortiAIConfiguration300Ctrl);

  fortiAIConfiguration300Ctrl.$inject = ['$scope', '$rootScope', 'fortiAiConfigService', 'toaster', 'WizardHandler', '$window', '_', 'currentPermissionsService', 'connectorService', 'CommonUtils', '$controller', 'widgetBasePath', 'fileService', '$q', 'Cryptography', 'usersService'];

  function fortiAIConfiguration300Ctrl($scope, $rootScope, fortiAiConfigService, toaster, WizardHandler, $window, _, currentPermissionsService, connectorService, CommonUtils, $controller, widgetBasePath, fileService, $q, Cryptography, usersService) {
    $controller('BaseConnectorCtrl', {
      $scope: $scope
    });
    $scope.entity = {};
    $scope.keyStoreValue = {};
    $scope.llmIntegrationData = {};
    $scope.moveNext = moveNext;
    $scope.moveBack = moveBack;
    $scope.loadConnectorPage = loadConnectorPage;
    $scope.updateLLMIntegrationData = updateLLMIntegrationData;
    $scope.saveConnector = saveConnector;
    $scope.proceedToCreateAssistant = proceedToCreateAssistant;
    $scope.formUpdate = formUpdate;
    $scope.defaultLLMIntegration = {};
    $scope.isLightTheme = $rootScope.theme.id === 'light';
    $scope.startInfoGraphics = $scope.isLightTheme ? widgetBasePath + 'images/fortiAI-start-light.png' : widgetBasePath + 'images/fortiAI-start-dark.png';
    $scope.fortiAIGraphics = widgetBasePath + 'images/fortiAIConfiguration.png';
    $scope.connectLLMInfoGraphics = $scope.isLightTheme ? widgetBasePath + 'images/fortiAI-connect-llm-light.png' : widgetBasePath + 'images/fortiAI-connect-llm-dark.png';
    $scope.createAssistantGraphics = $scope.isLightTheme ? + widgetBasePath + 'images/fortiai-create-assistant-light.png' : widgetBasePath + 'images/fortiai-create-assistant-dark.png';
    $scope.finishInfoGraphics = widgetBasePath + 'images/finish.png';
    $scope.widgetCSS = widgetBasePath + 'assets/fortiAiConfig.css';
    $scope.assistantStatus = 'Create'; 
    var attachmentData = '';
    $scope.createUpdateActionClicked = false;
    $scope.genAIAssistant = {};
    var authToken = Cryptography.getAuthToken();
    let user = usersService.getCurrentUser();
    const currentUserId = user.userId;
    var userLoginId = '';
    var keystorePermissions = currentPermissionsService.getPermission('keys');
    $scope.isValidKeystorePermission = true;
    $scope.configurationClicked = false; 
    $scope.configureProcessing = false;

    init();

    function init() {
      $scope.llmIntegrationData = fortiAiConfigService.constants();
      $scope.defaultLLMIntegration = $scope.llmIntegrationData.defaultLLMIntegration;
    }

    function moveNext() {
      var currentStepTitle = WizardHandler.wizard('fortiAIConfiguration').currentStep().wzTitle
      if (currentStepTitle === 'Start') {
        if (keystorePermissions.create && keystorePermissions.read && keystorePermissions.update) {
          $scope.isValidKeystorePermission = true;
          fetchKeyStoreData().then(function () {
            updateLLMIntegrationData('load');
            WizardHandler.wizard('fortiAIConfiguration').next();
          }, function (err) {
            toaster.error({ body: "Key Store record not found, refer documentation" });
          });
        } else {
          toaster.error({ body: "Required Key Store permissions not assigned to the user, refer documentation" });
          $scope.isValidKeystorePermission = false;
        }
      }
      if (currentStepTitle === 'Finish') {
        fortiAiConfigService.updateConfigurationRecord($scope.keyStoreValue, $scope.entity['hydra:member'][0].uuid);
        WizardHandler.wizard('fortiAIConfiguration').next();
      }
    }

    function loadConnectorPage() {
      updateKeyStoreValue();
      fortiAiConfigService.loadConnectorData($scope.defaultLLMIntegration.name).then(function (selectedConnector) {
        $scope.selectedConnector = selectedConnector;
        $scope.loadConnector($scope.selectedConnector, false, false);
        WizardHandler.wizard('fortiAIConfiguration').next();
      });
    }

    function fetchKeyStoreData(){
      var defer = $q.defer();
      fortiAiConfigService.getKeyStoreRecord($scope.llmIntegrationData.queryForKeyStore, 'keys').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'][0])) {
          $scope.entity = response;
          $scope.keyStoreValue = $scope.entity['hydra:member'][0].jSONValue;
          defer.resolve();
        }
        else {
          defer.reject();
        }
      });
      return defer.promise;
    }

    function saveConnector(saveFrom) {
      $scope.isConnectorConfigured = true;
      $scope.configuredConnector = false;
      $scope.configurationClicked = false;
      var data = angular.copy($scope.connector);
      if (CommonUtils.isUndefined(data)) {
        $scope.statusChanged = false;
        return;
      }
      if (!currentPermissionsService.availablePermission('connectors', 'update')) {
        $scope.statusChanged = false;
        return;
      }

      var newConfiguration, newConfig, deleteConfig;
      newConfiguration = false;
      if (saveFrom !== 'deleteConfigAndSave') {
        if (!_.isEmpty($scope.connector.config_schema)) {
          if (!$scope.validateConfigurationForm()) {
            return;
          }
        }
        if (!$scope.input.selectedConfiguration.id) {
          newConfiguration = true;
          $scope.input.selectedConfiguration.config_id = $window.UUID.generate();
          if ($scope.input.selectedConfiguration.default) {
            angular.forEach(data.configuration, function (configuration) {
              if (configuration.config_id !== $scope.input.selectedConfiguration.config_id) {
                configuration.default = false;
              }
            });
          }
          data.configuration.push($scope.input.selectedConfiguration);
          newConfig = $scope.input.selectedConfiguration;
        }
        delete data.newConfig;
      }

      if (saveFrom === 'deleteConfigAndSave') {
        $scope.isConnectorConfigured = false;
        deleteConfig = true;
        $scope.isConnectorHealthy = false;
      }

      var updateData = {
        connector: data.id,
        name: $scope.input.selectedConfiguration.name,
        config_id: $scope.input.selectedConfiguration.config_id,
        id: $scope.input.selectedConfiguration.id,
        default: $scope.input.selectedConfiguration.default,
        config: {},
        teams: $scope.input.selectedConfiguration.teams
      };
      $scope.saveValues($scope.input.selectedConfiguration.fields, updateData.config);
      $scope.saveProcessing = true;
      connectorService.updateConnectorConfig(updateData, newConfiguration, deleteConfig).then(function (response) {
        if (newConfig) {
          $scope.connector.configuration.push(newConfig);
          if (response.default) {
            $scope.removeDefaultFromOthers();
          }

        }
        $scope.formHolder.connectorForm.$setPristine();
        if (!deleteConfig) {
          $scope.input.selectedConfiguration.id = response.id;
          $scope.configuredConnector = true;
          $scope.isConnectorHealthy = true;
        }
        $scope.checkHealth();
        $scope.statusChanged = false;
      }, function (error) {
        toaster.error({
          body: error.data.message ? error.data.message : error.data['hydra:description']
        });
      }).finally(function () {
        $scope.saveProcessing = false;
      });
    }

    function updateLLMIntegrationData(action) {
      let llmIntegrationToUse;
      let llmIntegrationDict;

      fortiAiConfigService.executeAction('aiassistant-utils', 'get_assistant_metadata',null).then(function (response) {
        if(response && response.data && response.data.status===1){
          llmIntegrationToUse =  response.data.metadata?.llm_integration_to_use;
          $scope.defaultLLMIntegration.conversationModel = response.data.metadata[llmIntegrationToUse].assistant_category_metadata.soc_assistant.model;
          $scope.defaultLLMIntegration.pBGenerationModel = response.data.metadata[llmIntegrationToUse].assistant_category_metadata.code_generation_assistant.model;
        }
        else{
          llmIntegrationToUse = $scope.keyStoreValue.llmIntegrations[0].name; //if status===0 use [0] value
          $scope.defaultLLMIntegration.conversationModel = $scope.keyStoreValue.llmIntegrations[0].modelList[0];
          $scope.defaultLLMIntegration.pBGenerationModel = $scope.keyStoreValue.llmIntegrations[0].modelList[0];
        }
        llmIntegrationDict =  $scope.keyStoreValue.llmIntegrations.find(integration => integration.name === llmIntegrationToUse);
        $scope.defaultLLMIntegration.isMultiConfigAvailable = $scope.keyStoreValue.isMultiConfigAvailable;
        $scope.defaultLLMIntegration.title = llmIntegrationDict.title;
        $scope.defaultLLMIntegration.name = llmIntegrationDict.name;
        $scope.defaultLLMIntegration.modelList = llmIntegrationDict.modelList;
        $scope.defaultLLMIntegration.llmIntegrationsList = $scope.keyStoreValue.llmIntegrations.map(item => item.title);
      }, function(error) {
        toaster.error({ body: error.data.message || 'Failed to create/update Assistant' });
        console.log(error.data.message);
      });
    }

    //update key store with current values of llmIntegration
    function updateKeyStoreValue() {
      $scope.keyStoreValue.isMultiConfigAvailable = $scope.defaultLLMIntegration.isMultiConfigAvailable;
    }

    //load step4 - create assistant page
    function proceedToCreateAssistant() {
      $scope.configurationClicked = true;
      if(!$scope.connector.configuration && $scope.connector.configuration.length === 0){
        toaster.warning({
          body: 'Connector configuration not found'
        });
        return;
      } 
      $scope.assistantCreated = false;
      $scope.config_name = $scope.input.selectedConfiguration.config_id;
      if($scope.defaultLLMIntegration.isMultiConfigAvailable){  //if multiple config available check for userloginId config
        fetchUserLogin().then(function(){
          if(!checkForUserLoggedInId()) {
            toaster.warning({
              body: 'Please create atleast one connector configuration with matching user login Id'
            });
            return;
          }
          fetchExternalSource();
        });
      }else{
        if(!checkForDefaultConfig()) { //if single config available check for default config
          toaster.warning({
            body: 'Please mark any one connector configuration as default'
          });
          return;
        }
        fetchExternalSource();
      }
    }

    //fetch instructions/attachement for assistants
    //currently implemented for soc_assistant will make it generic once the schema is fixed for all assitants in use
    function fetchExternalSource(){
      var payload = { genai_type: $scope.defaultLLMIntegration.title };
      fortiAiConfigService.executeAction('aiassistant-utils', 'get_external_source_supported_assistant_details',null, payload).then(function(response){
        if(response && response.data.length > 0){
          const externalSourceAssistants =response.data;
          loadAndUpdateAssistantDetails(externalSourceAssistants);
        }
      }, function(error){
        console.log(error);
      })
    }
    
    function loadAndUpdateAssistantDetails(externalSourceAssistants){
      $scope.configureProcessing = true;
      $q.all([loadAttachmentData(externalSourceAssistants)]).then((response) => {
        $scope.configurationClicked = false;
        let assistantPromise = configureAssistant();
        assistantPromise.then(function(response) {
          $scope.genAIAssistant = response[0].data;
          $scope.assistantTooltip = createAssistantTooltipHtml($scope.genAIAssistant);
          $scope.configureProcessing = false;
          toaster.success({
            body: 'Successfully created/updated Assistant'
          });
          WizardHandler.wizard('fortiAIConfiguration').next();
        }, function(error) {
          toaster.error({ body: error.data.message || 'Failed to create/update Assistant' });
          console.log(error.data.message);
          $scope.configureProcessing = false;
        });
      }, function(error) {
        toaster.error({ body: error.data.message || 'Failed to load Assistant data' });
        console.log(error.data.message);
        $scope.configureProcessing = false;
      });
    }

    function createAssistantTooltipHtml(_content){
      var _html = '';
      Object.entries(_content).forEach(([key, value]) => {
         _html += `<li><span class="grey-text padding-bottom-3">${key}: </span>
                    <span>${value}</span></li>`
      });
      return _html;
    }

    function fetchUserLogin(){
      var defer = $q.defer();
      fortiAiConfigService.getUserLoginId(currentUserId).then(function (userLoginDetails) {
        if (userLoginDetails && userLoginDetails.usersresp && userLoginDetails.usersresp[0].loginid) {
          userLoginId = userLoginDetails.usersresp[0].loginid;
          defer.resolve();
        }
      }, function (error) {
        toaster.error({ body: 'Failed to fetch logged in user Id' });
      });  
      return defer.promise;
    }

    //to enable/disable button when change in text
    function formUpdate(){
      $scope.assistantCreated = false;
    }

    //load file instruction for soc assistant from attachment module
    function loadAttachmentData(externalSourceAssistants){
      var defer = $q.defer();
      var defer2 = $q.defer();

      const queryForAttachment = fortiAiConfigService.constants(externalSourceAssistants[0]).queryForAttachment;
      fortiAiConfigService.getAttachmentRecord(queryForAttachment,'attachments').then(function (response) {
        if (response['hydra:member'] && (response['hydra:member'].length>0) && (response['hydra:member'][0]['file'])) {
          var fileId = response['hydra:member'][0]['file']['id'];
          fileService.getFile(fileId).then(function(response){
            attachmentData = response.data;
            defer2.resolve();
          })
        }
        else {
          defer2.reject({'body': 'SOC Assistant instruction attachment record not found' });
          $scope.configurationClicked = false;
          $scope.configureProcessing = false;
        }
      });
      
      $q.all([defer2.promise]).then((response) => {
          defer.resolve();
      }).catch((error) => {
        if(error?.body){
          toaster.error({ body: error.body });
         }
        else{
          toaster.error({ body: 'Assistant ids not found' }); 
        }
      })
      return defer.promise;
    }

    //call create_assistant from openaic and then save the assistant ids in assistant utils 
    function configureAssistant() {
      var defer = $q.defer();

      var config_name = $scope.input.selectedConfiguration.config_id;
      var payload = {
        genai_type: $scope.defaultLLMIntegration.title, 
        genai_arguments: {
          llm_integration_to_use: $scope.defaultLLMIntegration.name,
          auth_token: authToken,
          config_id: config_name,
          reset_to_default: false,
          is_multi_config_available: $scope.defaultLLMIntegration.isMultiConfigAvailable, //need to use this in assistant bot later
          assistant_category_metadata: {
            soc_assistant: {
              model: $scope.defaultLLMIntegration.conversationModel
            },
            code_generation_assistant: {
              model: $scope.defaultLLMIntegration.pBGenerationModel
            }
          },
          assistant_sub_category_metadata: {
            soc_assistant: {
              instructions: attachmentData
            }
            //need to add for playbook assistant
          }
        }
      }
      const assistant_promise = fortiAiConfigService.executeAction('aiassistant-utils', 'configure_assistant', config_name, payload).then(function (assistant_response) {
        return assistant_response;
      });

      $q.all([assistant_promise]).then((responses) => {
        defer.resolve(responses);
      }).catch((error) => {
        defer.reject(error);
      })
      return defer.promise;
    }

    function checkForDefaultConfig() {
      return $scope.connector.configuration.find(function(config) {
        return config.default;
      });
    }

    function checkForUserLoggedInId() {
      return $scope.connector.configuration.find(function(config) {
        return config.name === userLoginId;
      });
    }

    function moveBack() {
      $scope.configurationClicked = false;
      WizardHandler.wizard('fortiAIConfiguration').previous();
    }
  }
})();
