/* Copyright start 
Copyright (C) 2008 - 2025 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
Copyright end */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('fortiguardIocSearch100Ctrl', fortiguardIocSearch100Ctrl);

  fortiguardIocSearch100Ctrl.$inject = ['$scope', 'widgetUtilityService', 'fortiguardIocSearchService', '$rootScope', 'widgetService', 'widgetTemplateService', 'toaster', 'widgetBasePath', '_', 'Entity', '$state'];

  function fortiguardIocSearch100Ctrl($scope, widgetUtilityService, fortiguardIocSearchService, $rootScope, widgetService, widgetTemplateService, toaster, widgetBasePath, _, Entity, $state) {
    $scope.widgetBasePath = widgetBasePath;
    $scope.themeApplied = $rootScope.theme.id;
    $scope.summaryTabOpen = true;
    $scope.iocSearchClicked = iocSearchClicked;
    $scope.onKeyDown = onKeyDown;
    $scope.isSearchClicked = false;
    $scope.params = { searchIOCText: '' };
    $scope.processing = false;
    $scope.model = {};
    $scope.widgetDefinition = {};
    $scope.gridOptions = {};
    $scope.searcInfoGraphicsSVG = $scope.themeApplied === 'light' ? $scope.widgetBasePath + 'widgetAssets/images/searchInfographics_light.svg' : $scope.widgetBasePath + 'widgetAssets/images/searchInfographics.svg';
    $scope.noResultFoundSVG = $scope.themeApplied === 'light' ? $scope.widgetBasePath + 'widgetAssets/images/noResultFound_light.svg' : $scope.widgetBasePath + 'widgetAssets/images/noResultFound.svg';
    $scope.iocSearchIconSVG = $scope.themeApplied === 'light' ? $scope.widgetBasePath + 'widgetAssets/images/fortiguardLogo_light.svg' : $scope.widgetBasePath + 'widgetAssets/images/fortiguardLogo.svg';
    $scope.riskLevelPicklist = {};
    $scope.enteredIOCLength = null;
    $scope.showSummaryTab = false;

    const TOP_TAGS_LIMIT = 5;
    const MAX_IOC_INPUT_LIMIT = 10;
    const ZERO_INPUT = 0;

    var countriesData;

    function _handleTranslations() {
      widgetUtilityService.checkTranslationMode($scope.$parent.model.type).then(function () {
        $scope.viewWidgetVars = {
          // Create your translating static string variables here
          ERROR_MAXIMUM_IOC: widgetUtilityService.translate('fortiguardIocSearch.ERROR_MAXIMUM_IOC'),
          ERROR_NO_IOC: widgetUtilityService.translate('fortiguardIocSearch.ERROR_NO_IOC'),
          ERROR_NO_INFORMATION_AVAILABLE: widgetUtilityService.translate('fortiguardIocSearch.ERROR_NO_INFORMATION_AVAILABLE'),
          HEADING_IOC_SEARCH_SUMMARY: widgetUtilityService.translate('fortiguardIocSearch.HEADING_IOC_SEARCH_SUMMARY'),
          HEADING_TOP_TAGS: widgetUtilityService.translate('fortiguardIocSearch.HEADING_TOP_TAGS'),
          LABEL_EDIT_VIEW_TITLE: widgetUtilityService.translate('fortiguardIocSearch.LABEL_EDIT_VIEW_TITLE'),
          LABEL_IOC_SEARCH: widgetUtilityService.translate('fortiguardIocSearch.LABEL_IOC_SEARCH'),
          LABEL_SEARCH_RESULT_HERE: widgetUtilityService.translate('fortiguardIocSearch.LABEL_SEARCH_RESULT_HERE'),
          PLACEHOLDER_ENTER_IOC: widgetUtilityService.translate('fortiguardIocSearch.PLACEHOLDER_ENTER_IOC'),
          TEXT_INSTRUCTION_SEARCH_IOC: widgetUtilityService.translate('fortiguardIocSearch.TEXT_INSTRUCTION_SEARCH_IOC'),
          TEXT_INSTRUCTION_ENTER_IOC: widgetUtilityService.translate('fortiguardIocSearch.TEXT_INSTRUCTION_ENTER_IOC')
        };
      });
    }

    function init() {
      // To handle backward compatibility for widget
      _handleTranslations();
      fortiguardIocSearchService.setWidgetBasePath($scope.widgetBasePath);
      fetchRiskLevelPicklist();
      fetchCountryCSV();
      checkIOCinURL();
      $scope.currentTheme = $rootScope.theme.id;
      $scope.textColor = $scope.currentTheme === 'light' ? '#000000' : '#FFFFFF';
      $scope.hoverColor = $scope.currentTheme === 'light' ? '#000000' : '#36b9b0';
    }

    //checks if urlParams are present in the URL and then populates IOC's in text box and executes search
    function checkIOCinURL(){
      if($state.params?.urlParams && $state.params?.urlParams!==''){
        let urlParameters = JSON.parse($state.params.urlParams);
        if(urlParameters.searchText && urlParameters.searchText !== ''){
          $scope.params.searchIOCText = urlParameters.searchText.replace(/,/g, '\n');
          iocSearchClicked();
        }
      }
    }

    function onKeyDown() {
      $scope.enteredIOCLength = null;
      $scope.iocLengthError = false;
    }

    function fetchRiskLevelPicklist() {
      const MODULE_NAME = 'ioc_searches';
      const PICKLIST_NAME = 'risk_level';
      var entity = new Entity(MODULE_NAME);
      entity.loadFields().then(function () {
        let formFields = entity.getFormFields();
        $scope.riskLevelPicklist = _.find(formFields, function (field) {
          return field.type === 'picklist' && field.name === PICKLIST_NAME;
        });
      })
    }

    function fetchCountryCSV(){
      fortiguardIocSearchService.fetchCountry().then(function (response) {
        countriesData = fortiguardIocSearchService.csvToJSON(response.data);
      });
    }

    //function to fetch data from connector action of the given IOC's
    function iocSearchClicked() {
      $scope.isSearchClicked = true;
      $scope.processing = true;
      $scope.responseMessage = undefined;
      $scope.iocLengthError = false;

      //multiple IOC's comma separated array
      let enteredIOCs = $scope.params.searchIOCText !== '' && !angular.isUndefined($scope.params.searchIOCText) ? $scope.params.searchIOCText.split("\n") : [];
      enteredIOCs = enteredIOCs.filter(value => value.trim() !== "");
      $scope.enteredIOCLength = enteredIOCs.length;

      if (enteredIOCs.length > ZERO_INPUT && enteredIOCs.length <= MAX_IOC_INPUT_LIMIT) {
        let payload = { 'indicator': enteredIOCs };
        fortiguardIocSearchService.executeAction('fortinet-fortiguard-ioc', 'ioc_search', payload).then(function (response) {
          //console.log(response);
          $scope.processing = false;
          if (response && response.data) {
            $scope.responseMessage = undefined;
            let responseData = fortiguardIocSearchService.removeDuplicateValues(response.data);
            mapReponseData(responseData);
          }
        }, function (error) {
          $scope.processing = false;
          const SEARCH_LIMIT_EXHAUSTED = 'exhausted';
          if(error?.data?.message && error?.data?.message.includes(SEARCH_LIMIT_EXHAUSTED)){
            //retries excedded
            $scope.responseMessage = "DAILY SEARCH LIMIT EXHAUSTED!";
          }
          else if (error) { 
            //incorrect IOC entered
            $scope.responseMessage = "Invalid data";
          }
        });
      }
      else {
        $scope.iocLengthError = true;
        $scope.responseMessage = undefined;
        $scope.processing = false;
        $scope.isSearchClicked = false;
      }
    }

    //map response data with parameters to be used on UI 
    function mapReponseData(responseData) {
      fortiguardIocSearchService.fetchGridOptions().then(function (response) {
        $scope.gridOptions = response.data;
        generateSummaryGridData(responseData);
      });
      $scope.topTags = calculateTopTagsCount(responseData);
      $scope.topKillChainStages = fortiguardIocSearchService.getKillChainPhasesAggregate(responseData);
      $scope.host_visit_count = fetchTopVisitingCountries(responseData);
      setTimeout(() => {
        createWidgetDefinition();
      }, 10);
    }

    // ***************** Functions to create summary of IOC Grid Data ********************//
    //to calculate the top tags and its count from the response
    function calculateTopTagsCount(data) {
      // Create an object to store the count of each tag
      let _dataArray = data;
      const tagCounts = {};

      // Loop through each object in the data array and update the tagCounts object
      _dataArray.forEach(item => {
        if (item.ioc_tags) {
          item.ioc_tags.forEach(tag => {
            tagCounts[tag] = (tagCounts[tag] || 0) + 1;
          });
        }
      });

      // Convert the tagCounts object into an array of objects with tag and count properties
      const result = Object.keys(tagCounts).map(tag => ({
        key: tag,
        count: tagCounts[tag],
        icon: fortiguardIocSearchService.mapTagsIcon(tag),
        color: 'defaultColor'
      }));

      // return only top 5 tags
      return result.sort((a, b) => b.count - a.count).slice(0, TOP_TAGS_LIMIT);
    }

    function fetchTopVisitingCountries(data) {
      // Aggregate `countryvisitcounts`
      const aggregateCounts = data.reduce((acc, item) => {
        if (item.countryvisitcounts && item.countryvisitcounts.data) {
          item.countryvisitcounts.data.forEach(({ iso, count }) => {
            if (!acc[iso]) {
              acc[iso] = 0; // Initialize if not already present
            }
            acc[iso] += count; // Add counts for the same ISO code
          });
        }
        return acc;
      }, {});

      // Convert to an array for easier use or display
      //const result = Object.entries(aggregateCounts).map(([iso, count]) => ({ iso, count }));
      let result = [];
      for (const iso in aggregateCounts) {
        if (aggregateCounts.hasOwnProperty(iso)) {
          result.push({ iso : iso, count: aggregateCounts[iso], country: getCountryName(iso).country , iso3: getCountryName(iso).iso3 });
        }
      }
      // return only top 5 tags
      return result;
    }

    function getCountryName(isoCode) {
      let _country = '';
      let _iso3 = '';
      let _countryData = countriesData.find(data=> data.iso===isoCode);
      if(_countryData){
        _country =  _countryData.country;
        _iso3 =  _countryData.iso3;
      }
      return {'country' : _country, 'iso3' : _iso3};
    }

    // ***************** Functions to map IOC Grid Data ********************//

    // to create the topkillchainstage object to be displayed in Grid 
    function mapKillChainPhasesForGridColumn(iocKillChainPhasesData) {
      // Convert the killChainCounts object into an array of objects with tag and count properties
      let result = '';
      if (iocKillChainPhasesData && !angular.isUndefined(iocKillChainPhasesData) && iocKillChainPhasesData.length > 0) { //kill_chain_phases can be null or []
        result = iocKillChainPhasesData.map(stage => ({
          key: fortiguardIocSearchService.mapKillChainPhasesData(stage).tag, //displayName
          color: fortiguardIocSearchService.mapKillChainPhasesData(stage).color,
          image: fortiguardIocSearchService.mapKillChainPhasesData(stage).image,
          icon: fortiguardIocSearchService.mapKillChainPhasesData(stage).icon,
          id: fortiguardIocSearchService.mapKillChainPhasesData(stage).id
        }));
      }
      else {
        result = 'NA'
      }
      return result;
    }

    //aggregate the riskScoreData to show in grid 
    function mapRiskScoreDataForGridColumn(data) {
      let _riskScore = [];
      if (data.risk_level && data.threatinfo?.risk_score) {
        _riskScore.push({
          'key': data.risk_level.itemValue,
          'count': data.threatinfo?.risk_score,
          'color': fortiguardIocSearchService.getRiskScorePicklistColor(data.risk_level, $scope.riskLevelPicklist)
        })
      }
      else {
        return 'NA';
      }
      return _riskScore;
    }

    // create live rating data for grid 
    function createLiveRatingData(data) {
      let threatInfoData = data.threatinfo;
      let _liveRating = [];
      if (data.invalid && data.invalid.error) {
        _liveRating.push({
          'key': 'ERROR: ' + data.invalid.error, //Invalid IOC
          'color': '#efe1b3',
          'textColor': '#966b3c'
        })
      }
      else {
        if (threatInfoData.wf_cate) {
          _liveRating.push({
            'key': 'WebFilter: ' + threatInfoData.wf_cate
          })
        }
        if (threatInfoData.av_cate) {
          _liveRating.push({
            'key': 'AntiVirus: ' + threatInfoData.av_cate
          })
        }
        if (threatInfoData.ioc_cate) {
          _liveRating.push({
            'key': 'IOC: ' + threatInfoData.ioc_cate
          })
        }
        if (threatInfoData.spam_cate) {
          _liveRating.push({
            'key': 'AntiSpam: ' + threatInfoData.spam_cate
          })
        }
      }
      return _liveRating;
    }

    // aggregate the IP ASN Data to show in grid 
    function formatASNData(iocData) {
      let _asnData = {};
      if (iocData.geoip && iocData.asn) {
        _asnData = {
          'iso': iocData.geoip.iso,
          'country': iocData.geoip.country,
          'as_handle': iocData.asn.as_info ? iocData.asn.as_info.as_handle : '',
          'organization': iocData.asn.as_info ? iocData.asn.as_info.organization : ''
        }
      } else {
        return 'NA';
      }
      return _asnData;
    }

    //generate Summary Grid data for multiple IOC
    function generateSummaryGridData(responseData) {
      $scope.gridOptions.data = [];
      responseData.forEach(iocData => {
        $scope.gridOptions.data.push({
          'indicator': { 'id': iocData.id, 'valid': angular.isUndefined(iocData.invalid) }, //valid key added to handle opening of view panel
          'riskScore': angular.isUndefined(iocData.invalid) ? mapRiskScoreDataForGridColumn(iocData) : 'NA',
          'fortiguardLiveRating': createLiveRatingData(iocData),
          'relatedKillChain': angular.isUndefined(iocData.invalid) ? mapKillChainPhasesForGridColumn(iocData.threatinfo.kill_chain_phases) : 'NA',
          'asn': angular.isUndefined(iocData.invalid) ? formatASNData(iocData) : 'NA',
          'relatedObjects': '--' //data not present in v1.0.0
        });
      });
    }
    // ***************** xxxx Functions to map IOC Grid Data xxxx ********************//

    //function to create widget definition to embed the required widgets with current data 
    function createWidgetDefinition() {
      $scope.widgetProcessing = true;
      widgetService.getInstalledWidgets().then(function (widgets) {
        angular.forEach(widgets, function (widget) {
          if ($scope.showSummaryTab && widget.name === 'cyberThreatWorldMap') {
            $scope.widgetDefinition['cyberThreatWorldMap'] = widgetTemplateService.generateWidgetDefinition(widget);
            $scope.model['cyberThreatWorldMap'] = {
              config: { 'title': 'Top Visiting Countries', 'embedded': true, 'data': $scope.host_visit_count }
            };
          }
          if ($scope.showSummaryTab && widget.name === 'killchainphases') {
            $scope.widgetDefinition['killchainPhases'] = widgetTemplateService.generateWidgetDefinition(widget);
            $scope.model['killchainPhases'] = {
              config: { 'title': 'Kill Chain Phases', 'embedded': true, 'killchainDataJson': $scope.topKillChainStages, 'moduleType': 'Summary Data' }
            };
          }
          if (widget.name === 'gridSummary') {
            $scope.widgetDefinition['gridSummary'] = widgetTemplateService.generateWidgetDefinition(widget);
            $scope.model['gridSummary'] = {
              config: {
                'embedded': true,
                'title': 'IOC Details',
                'gridDefinition': {
                  'module': 'ioc_searches', 'gridOptions': $scope.gridOptions
                },
                'gridData': {
                  'data': $scope.gridOptions.data
                }
              }
            };
          }
        });
      }).finally(function () {
        $scope.widgetProcessing = false;
      });
    }

    init();
  }
})();