/* Copyright start 
Copyright (C) 2008 - 2025 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
Copyright end */
'use strict';

(function () {
  angular
    .module('cybersponse')
    .factory('fortiguardIocSearchService', fortiguardIocSearchService);

  fortiguardIocSearchService.$inject = ['$http', 'API', 'connectorService', '$resource'];

  function fortiguardIocSearchService($http, API, connectorService, $resource) {
    var service;
    var widgetBasePath = '';
    var tagIconsPath = '';

    const tagsType = ['Malware', 'CVE', 'Vulnerability', 'Threat', 'Default'];

    service = {
      setWidgetBasePath: setWidgetBasePath,
      fetchGridOptions: fetchGridOptions,
      fetchCountry: fetchCountry,
      csvToJSON: csvToJSON,
      mapKillChainPhasesData: mapKillChainPhasesData,
      getKillChainPhasesAggregate: getKillChainPhasesAggregate,
      executeAction: executeAction,
      getRiskScorePicklistColor: getRiskScorePicklistColor,
      mapTagsIcon: mapTagsIcon,
      removeDuplicateValues: removeDuplicateValues
    };

    //set widget base path to keep the version updated
    function setWidgetBasePath(_widgetBasePath){
      widgetBasePath = _widgetBasePath;
      tagIconsPath = widgetBasePath + 'widgetAssets/images/';
    }

    //fetch Grid templates designed for IOC Summary grid columns
    function fetchGridOptions() {
      return $http.get(widgetBasePath + 'widgetAssets/gridOptions.json');
    }

    //fetch country csv from asset
    function fetchCountry() {
      return $http.get(widgetBasePath + 'widgetAssets/country.csv');
    }

    //map killchain data to be displayed in GRID
    //kill chain tag color are mapped with CTS portal. Need to verify for exploit as didn't find details for it
    function mapKillChainPhasesData(phase) {
      if (typeof phase != 'string') {
        return '';
      }
      switch (phase.toLowerCase().trim()) {
        case 'reconnaissance':
          return { 'tag': 'Reconnaissance', 'color': '#F4CC46', 'icon': 'fa fa-binoculars', 'id': 'recon' };
          break;
        case 'weaponization':
          return { 'tag': 'Weaponization', 'color': '#F4CC46', 'image': tagIconsPath + 'virus.svg', 'id': 'weaponize' }; //image tag will be used in DOM to show svg
          break;
        case 'delivery':
          return { 'tag': 'Delivery', 'color': '#F48A00', 'image': tagIconsPath + 'delivery.svg', 'id': 'deliver' };
          break;
        case 'exploitation':
          return { 'tag': 'Exploitation', 'color': '#c6401e', 'image': tagIconsPath + 'exploit.svg', 'id': 'exploit' };
          break;
        case 'installation':
          return { 'tag': 'Installation', 'color': '#c6401e', 'icon': 'fa fa-download', 'id': 'install' };
          break;
        case 'command-and-control':
          return { 'tag': 'Command & Control', 'color': '#a90329', 'icon': 'fa fa-laptop', 'id': 'control' };
          break;
        case 'actions-on-objectives':
          return { 'tag': 'Actions', 'color': '#a90329', 'icon': 'fa fa-keyboard-o', 'id': 'actions' };
          break;
        case 'unknown':
        default:
          return { 'tag': '', 'color': '', 'icon': '', 'id': '' };
      }
    }

    //connector action call
    function executeAction(connector_name, connector_action, payload) {
      return $resource(API.INTEGRATIONS + 'connectors/?name=' + connector_name)
        .get()
        .$promise
        .then(function (connectorMetaDataForVersion) {
          let defaultConfig = connectorMetaDataForVersion.data[0].configuration.filter(item => item.default);
          if (defaultConfig) {
            var config_id = defaultConfig[0]['config_id'];
          }
          else {
            toaster.error({ body: 'Default configuration not present.' });
          }
          return connectorService.executeConnectorAction(connector_name, connectorMetaDataForVersion.data[0].version, connector_action, config_id, payload);
        })
        .catch(function (error) {
          console.error('Error:', error);
          throw error; // Rethrow the error to be handled by the caller
        });
    }

    //map risk color for speedometer through Confidence picklist value using entity form fields
    function getRiskScorePicklistColor(riskKey , _picklistValues) {
      let color = '';
      _.find(_picklistValues.options, function (element) {
        if (element.itemValue === riskKey.itemValue) {
          color = element.color;
        }
      });
      return color;
    }

    //to map tags with icons svg
    function mapTagsIcon(tag) {
      var _icon = tagIconsPath + 'ic-default.svg';
      tagsType.forEach(type => {
        if (tag.includes(type)) {
          _icon = tagIconsPath + 'ic-' + type.toLocaleLowerCase() + '.svg';
        }
      });
      return _icon;
    }

    //create kill chain aggregate count to be displayed in killchain widget(SVG)
    function getKillChainPhasesAggregate(data) {
      // Create an object to store the count of each tag
      const killChainPhasesCount = {
        'reconnaissance': 0,
        'weaponization': 0,
        'delivery': 0,
        'exploitation': 0,
        'installation': 0,
        'command-and-control': 0,
        'actions-on-objectives': 0
      };
      // Loop through each object in the data array and update the killChainPhasesCount object
      data.forEach(item => {
        if(item.kill_chain_phases){
          item.kill_chain_phases.forEach(stage => {
            killChainPhasesCount[stage] = (killChainPhasesCount[stage] || 0) + 1;
          });
        }
      });
      return killChainPhasesCount;
    }

    //remove duplicate IOC's based on id
    function removeDuplicateValues(array){
      const uniqueArray = array.filter((item, index, self) => 
        index === self.findIndex(obj => obj.id === item.id)
      );
      return uniqueArray;
    }

    function csvToJSON(csv) {
      const lines = csv.split("\n");
      const headers = lines[0].replaceAll("\"","").split(",");
    
      const result = lines.slice(1).map((line) => {
        const values = line.replaceAll("\"","").split(",");
        const obj = {};
        headers.forEach((header, index) => {
          obj[header.trim()] = values[index]?.trim();
        });
        return obj;
      });
    
      return result;
    }

    return service;
  }
})();
