/* Copyright start
    MIT License
    Copyright (c) 2025 Fortinet Inc
Copyright end */
'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('editGridSummary100Ctrl', editGridSummary100Ctrl);

    editGridSummary100Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', 'widgetUtilityService', '$timeout'];

    function editGridSummary100Ctrl($scope, $uibModalInstance, config, widgetUtilityService, $timeout) {
        $scope.cancel = cancel;
        $scope.save = save;
        $scope.config = config;
        $scope.isConfigurable = false;
        $scope.header = $scope.config.title ? 'Edit Summary Grid' : 'Add Summary Grid';
        $scope.setGridDefinition = setGridDefinition; //set grid options
        $scope.setGridDataJson = setGridDataJson; //set grid data
        $scope.config.gridDefinitionJson = !angular.isArray($scope.config.gridDefinitionJson) ? $scope.config.gridDefinitionJson : {};
        $scope.jsoneditorOptions = {
          name: 'Fields',
          mode: 'code',
          onEditable: function () {
            return {
              field: true,
              value: true
            };
          }
        };
        $scope.config.gridDataJson = !angular.isArray($scope.config.gridDataJson) ? $scope.config.gridDataJson : {};

        function _handleTranslations() {
          let widgetNameVersion = widgetUtilityService.getWidgetNameVersion($scope.$resolve.widget, $scope.$resolve.widgetBasePath);
          
          if (widgetNameVersion) {
            widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
              $scope.viewWidgetVars = {
                // Create your translating static string variables here
                HEADER_EDIT_HEATMAP: widgetUtilityService.translate('gridSummary.HEADER_EDIT_SUMMARY_GRID'),
                HEADER_ADD_HEATMAP: widgetUtilityService.translate('gridSummary.HEADER_ADD_SUMMARY_GRID'),
                LABEL_GRID_TEMPLATE: widgetUtilityService.translate('gridSummary.LABEL_GRID_TEMPLATE'),
                LABEL_GRID_DATA: widgetUtilityService.translate('gridSummary.LABEL_GRID_DATA'),
                LABEL_NOT_CONFIGURABLE: widgetUtilityService.translate('gridSummary.LABEL_NOT_CONFIGURABLE')
              };
            $scope.header = $scope.config.title ? $scope.viewWidgetVars.HEADER_EDIT_HEATMAP : $scope.viewWidgetVars.HEADER_ADD_HEATMAP;
            });
          } else {
            $timeout(function() {
              cancel();
            },100);
          }
        }

        function setGridDefinition(json) {
          if (angular.isString(json)) {
            try {
              $scope.config.gridDefinitionJson = JSON.parse(json);
            } catch (e) {
              // invalid JSON. skip the rest
              return;
            }
          }
        }

        function setGridDataJson(json) {
          if (angular.isString(json)) {
            try {
              $scope.config.gridDataJson = JSON.parse(json);
            } catch (e) {
              // invalid JSON. skip the rest
              return;
            }
          }
        }

        function init() {
            // To handle backward compatibility for widget
            _handleTranslations();
        }

        init();

        function cancel() {
            $uibModalInstance.dismiss('cancel');
        }

        function save() {
            $uibModalInstance.close($scope.config);
        }

    }
})();
