'user strict';
(function() {
  angular
  .module('cybersponse')
  .controller('incidentTimeline100Ctrl', incidentTimeline100Ctrl);
  
  incidentTimeline100Ctrl.$inject = ['$scope','config',  'Entity', '$filter', 'API', '$interpolate', '$state', '$resource', '$rootScope'];
  
  function incidentTimeline100Ctrl($scope, config, Entity, $filter, API,  $interpolate, $state, $resource, $rootScope) {
    $scope.processing = true;
    $scope.showError = false;
    $scope.config = config;
    $scope.page = $state.params.page;
    $scope.refresh = _init;
    $scope.toggleEventNode = it_toggleEventNode;
    $scope.widgetThemeColor = getThemeColors($rootScope.theme);

    // TODO: Maybe dont need to set events to empty here. Could cause re-initialization problems maybe?
    $scope.events = [];
 
    function it_load_from_report() {
      var id;
      if($scope.config.toggleEnable) {
        var interpolateObject = JSON.parse($state.params.qparam);
        var entityId = $interpolate($scope.config.jinjaValue)(interpolateObject);
         id = entityId;
      }else {
        id = $scope.config.id;
      }
      var query = {
        'sort': [
        {
          'field':'modifyDate',
          'direction':'DESC'
        }
      ],
        'logic':'AND',
        'filters': [
          {
            'field':'id',
            'operator':'eq',
            '_operator':'eq',
            'value':id,
            'type':'primitive'
          }]
      };
      $resource(API.QUERY + "incidents").save(query).$promise.then(function(data) {
        if(data['hydra:member'].length > 0) {
          var id = $filter('getEndPathName')(data['hydra:member'][0]['@id']);
          it_loadTimeline(id, "incidents");
        }else {
          $scope.showError = true;
        }
      }).catch((error) => {
        console.error(error);
        $scope.showError = true;
      });
    }
    
    function it_loadTimeline(incident_uuid, module) {
      $scope.processing = true;
      var entity  = new Entity(module);
      let alertContentFields = $scope.config.alertContentFields ? $scope.config.alertContentFields : [];
      let indicatorContentFields = $scope.config.indicatorContentFields ? $scope.config.indicatorContentFields : [];

      $scope.events = [];

      let request_parent_primary_event = entity.get(incident_uuid, {}, true).then(function() {
        let promises = [];
        promises.push(entity.getRelationship('alerts', true).then(function() {
          entity.fields['alerts'].value.forEach(alert => add_record_to_results(alert, $scope.events, $scope.config.alertDateField, alertContentFields, $scope.config.alertEventColorField, 'left'));
        }));

        promises.push(entity.getRelationship('indicators', true).then(function() {
          // Set up Timeline events for Indicators here
          entity.fields['indicators'].value.forEach(indicator => add_record_to_results(indicator, $scope.events, $scope.config.indicatorDateField, indicatorContentFields, $scope.config.indicatorEventColorField, 'right'));
        }))

        return Promise.all(promises);
      }).then(function () {
        if($scope.events.length != 0) {
          $scope.events = $filter('orderBy')($scope.events, 'date');
          if ($scope.events[0].side == 'left') {
            $scope.timeline_top_margin = '60px'
          }
          else {
            $scope.timeline_top_margin = '40px'
          }
        }
        $scope.processing = false;
      }).catch((error) => {
        console.error(error);
        $scope.showError = true;
      });
      
      return request_parent_primary_event;
    }

    function add_record_to_results(record, records_list, module_date_field, module_content_fields, module_color_field, side) {
      let record_card = {
        'meta': '',
        'header': record['@type'] + " " + record.display,
        'data': {},
        'date': record[module_date_field.name]*1000,
        'dateLabel': module_date_field.title,
        'side': side,
        'isOpen': $scope.config.auto_expand
      };
      if(!record[module_date_field.name]) {
        record_card['date'] = record['createDate']*1000;
        record_card['dateLabel'] = "Created";
      }
      angular.forEach(module_content_fields, function(field) {
        record_card['data'][field.title] = {"value": it_fieldValToString(record[field.name])}
        record_card['data'][field.title]['type'] = field.type;
      })
      if(module_color_field && record[module_color_field.name] && record[module_color_field.name]['color']) {
        record_card['color'] = record[module_color_field.name]['color'];
      }
      else {
        record_card['color'] = "#FFFFFF";
      }
      records_list.push(record_card);
    }

    function it_fieldValToString(fieldValue) {
      if (typeof fieldValue === 'string') {
        return fieldValue
      }
      else if (typeof fieldValue === 'number') {
        return String(fieldValue);
      }
      else if (fieldValue == null) {
        return "Null"
      }
      else if (typeof fieldValue === 'object' && fieldValue['@type']) {
        return fieldValue.itemValue;
      }
    }

    function it_toggleEventNode(event) {
      event.isOpen = !event.isOpen;
    }

    function getThemeColors(theme){ 
      var widgetThemeColor = {};
      widgetThemeColor.cardColor = '#c42323';
      if(theme.id === 'light') {
        widgetThemeColor.borderColor = '#dcdcdc';
        widgetThemeColor.backgroundColor = '#e0dede';
      } else if(theme.id === 'steel') {
        widgetThemeColor.borderColor = '#29333e';
        widgetThemeColor.backgroundColor = '#0d1218';
      } else {
        widgetThemeColor.borderColor = '#262626';
        widgetThemeColor.backgroundColor = '#000000';
      }
      return widgetThemeColor;
    }
  
    function _init(){
      if(!angular.isUndefined($scope.page) && $scope.page === 'reporting') {
        it_load_from_report();
      }else {
        // TODO: Hardcode $scope.events
        it_loadTimeline($state.params.id, $state.params.module).then(function() {
          return;
        });
      }
    }
  
    _init();  
}
 })();
