(function() {
    angular
      .module("cybersponse")
      .controller("editIncidentTimeline101Ctrl", editIncidentTimeline101Ctrl);
  
      editIncidentTimeline101Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', '$state', 'ViewTemplateService', 'Entity'];
  
    function editIncidentTimeline101Ctrl($scope, $uibModalInstance, config, $state, ViewTemplateService, Entity) {
      $scope.cancel = cancel;
      $scope.save = save;
      $scope.config = config;
      $scope.page = $state.params.page;
      $scope.loadFields = loadFields;

      if(!angular.isUndefined($scope.page) && $scope.page === 'reporting') {
        $scope.expressions =  angular.copy(ViewTemplateService.getConfigInputs());
      }

      loadFields().catch(error => console.error(error));

      function loadFields() {
        $scope.datefields_alert = [];
        $scope.datefields_indicator = [];
        $scope.picklists_alert = [];
        $scope.picklists_indicator = [];
        $scope.fields_alert = [];
        $scope.fields_indicator = [];

        let promises = [];

        var entity_alert = new Entity('alerts');
        promises.push(entity_alert.loadFields().then(function() {
          populate_fields(entity_alert, $scope.fields_alert, $scope.datefields_alert, $scope.picklists_alert);
          $scope.config.alertDateField = $scope.config.alertDateField ? $scope.config.alertDateField : entity_alert.fields['createDate'];
          $scope.config.alertEventColorField = $scope.config.alertEventColorField ? $scope.config.alertEventColorField : entity_alert.fields['severity'];
          $scope.config.alertContentFields = $scope.config.alertContentFields ? $scope.config.alertContentFields : [entity_alert.fields['status'], entity_alert.fields['description']];

        }));

        var entity_indicator = new Entity('indicators');
        promises.push(entity_indicator.loadFields().then(function() {
          populate_fields(entity_indicator, $scope.fields_indicator, $scope.datefields_indicator, $scope.picklists_indicator);
          $scope.config.indicatorDateField = $scope.config.indicatorDateField ? $scope.config.indicatorDateField : entity_indicator.fields['firstSeen'];
          $scope.config.indicatorEventColorField = $scope.config.indicatorEventColorField ? $scope.config.indicatorEventColorField : entity_indicator.fields['reputation'];
          $scope.config.indicatorContentFields = $scope.config.indicatorContentFields ? $scope.config.indicatorContentFields : [entity_indicator.fields['indicatorStatus']];
        }));

        return Promise.all(promises);
      }

      function populate_fields(entity_object, all_fields_array, date_fields_array, picklist_fields_array) {
        angular.forEach(entity_object.fields, function(value, key) {
          all_fields_array.push(entity_object.fields[key]);
          if(entity_object.fields[key].type === 'datetime') {
            date_fields_array.push(entity_object.fields[key]);
          }
          else if(entity_object.fields[key].type === 'picklist') {
            picklist_fields_array.push(entity_object.fields[key]);
          }
        });
      }
  
      function cancel() {
        $uibModalInstance.dismiss("cancel");
      }
  
      function save() {
        $uibModalInstance.close($scope.config);
      }
      
    }
  })();  