(function () {
  angular
    .module('cybersponse')
    .controller('editManageDatasets100Ctrl', editManageDatasets100Ctrl);

  editManageDatasets100Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', 'appModulesService', '_'];

  function editManageDatasets100Ctrl($scope, $uibModalInstance, config, appModulesService, _) {
    $scope.cancel = cancel;
    $scope.save = save;
    $scope.addTOModuleLinkingList = addTOModuleLinkingList;
    $scope.removeModuleFromLinkList = removeModuleFromLinkList;
    $scope.filterLinkedModules = filterLinkedModules;
    $scope.config = config || {};    
    $scope.showConfigParams = true;
    $scope.dataSetWidgets = [{
      name: 'createAndListDataset',
      title: 'Create and List Datasets'
    }, {
      name: 'datasetSelection',
      title: 'Dataset Selection'
    }];
    $scope.widgetDescription = {
      createAndListDataset: 'Allows to save, list and preview datasets. Datasets allow to filter module data based on saved data fileter',
      datasetSelection: 'Allows users to select from saved datasets'
    };

    appModulesService.load(true).then(function (modules) {
      $scope.modules = modules;
      $scope.config.datasetLinkingModules = $scope.config.datasetLinkingModules || [];
      _prepareLinkedModuleList();
    });

    
    
    function addTOModuleLinkingList(module){
      $scope.config.datasetLinkingModules.push(module);
      _prepareLinkedModuleList();
    } 
    
    function _prepareLinkedModuleList(){
      $scope.datasetLinkingModulesObj = [];
      if($scope.config.datasetLinkingModules.length > 0){
        angular.forEach($scope.config.datasetLinkingModules, function(key) {
        	 var getMatchedModule = _.find($scope.modules, function(obj){ return key === obj.type;});
             if(getMatchedModule && $scope.datasetLinkingModulesObj.indexOf(getMatchedModule.name) === -1){
               $scope.datasetLinkingModulesObj.push(getMatchedModule.name);
             }
        }); 
      }
      
    }
     
    function removeModuleFromLinkList(index){
      $scope.config.datasetLinkingModules.splice(index,1);
      _prepareLinkedModuleList();
    }
    
      function filterLinkedModules(module) {
        var foundResult = _.find($scope.config.datasetLinkingModules, function(item){ return item === module.type;});
        return foundResult ? false :  true;
    }
      
    
    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }

    function save() {
      $uibModalInstance.close($scope.config);
    }

  }
})();