(function () {
  angular
    .module('cybersponse')
    .controller('manageDatasets100Ctrl', manageDatasets100Ctrl);

  manageDatasets100Ctrl.$inject = ['$scope', 'config', 'Entity', 'queryCollectionService', 'Query', 'modelMetadatasService', 'toaster', '$uibModal',
    'VIEW_TEMPLATES', 'PagedCollection', '$q', 'ViewTemplateService', '$state', 'appModulesService', '_', 'FormEntityService', 'statusCodeService',
    'Modules', 'ModalService', '$rootScope', 'currentPermissionsService', '$resource', 'API', 'uiGridConstants'];

  function manageDatasets100Ctrl($scope, config, Entity, queryCollectionService, Query, modelMetadatasService, toaster, $uibModal,
    VIEW_TEMPLATES, PagedCollection, $q, ViewTemplateService, $state, appModulesService, _, FormEntityService, statusCodeService,
    Modules, ModalService, $rootScope, currentPermissionsService, $resource, API, uiGridConstants) {
    $scope.processing = true;
    $scope.config = config;
    $scope.datasets = [];
    $scope.addNewDataset = addNewDataset;
    $scope.saveDataset = saveDataset;
    $scope.cancel = cancel;
    $scope.openRecords = openRecords;
    $scope.deleteDataset = deleteDataset;
    $scope.close = close;
    $scope.selectDataset = selectDataset;
    $scope.filterLinkedModules = filterLinkedModules;
    $scope.linkDataset = linkDataset;
    $scope.loadDatasets = loadDatasets;
    $scope.unlinkDataSet = unlinkDataSet;
    $scope.openDataset = openDataset;
    $scope.formHolder = {};
    $scope.currentTheme = $rootScope.theme.id;
    $scope.applicationCanUpdate = currentPermissionsService.availablePermission('application', 'update');
    $scope.gridOptions = {
      csOptions: {
        allowAdd: false,
        allowDelete: false,
        allowClone: false,
        allowAddRelations: false,
        isLink: true
      },
      enableHorizontalScrollbar : uiGridConstants.scrollbars.NEVER,
      enableRowSelection: false,
      selectWithCheckboxOnly: false,
      showSelectionCheckbox: false,
      enableRowHeaderSelection: false
    };
    $scope.linkDatasetConfig = {};
    $scope.linkedDatasets = [];
    var columns = [];
    var modalInstance;
    var module;

    function _init() {
      if ($scope.config.typeofWidget === 'createAndListDataset') {
        _initializeDatasetsList();
      } else {
        _initializeDatasetsLink();
      }

    }
    // function to load entity selecte in edit
    function _initializeDatasetsList() {
      module = $scope.config.selectedModule;
      $scope.moduleCanRead = currentPermissionsService.availablePermission(module, 'read');
      $scope.entity = new Entity(module);
      $scope.entity.loadFields().then(function () {
        $scope.fields = $scope.entity.fields;
        if($scope.moduleCanRead) {
          _getDatasets(module).then(function () {
            $scope.processing = false;
          });
        } else  {
          $scope.processing = false;
        }
      });
    }

    function _initializeDatasetsLink() {
      $scope.entity = FormEntityService.get();
      module = $state.params.module;
      _getLinkedDatasets();
    }

    function _getLinkedDatasets() {
      $scope.loadingLinkedDatasets = true;
      var _query = {
        $limit: 30,
        $relationships: true,
        module: module,
        id: $state.params.id
      };
      Modules.get(_query).$promise.then(function (response) {
        $scope.linkedDatasets = response.datasets || response['hydra:member'];
        $scope.loadingLinkedDatasets = false;
      }, statusCodeService);
    }

    // function to get all datasets present in the system
    function _getDatasets(module) {
      var defer = $q.defer();
      $resource(API.BASE +"system_queries?models__type=" + module).get({}).$promise.then(function (response) {
        $scope.datasets = response['hydra:member'];
        defer.resolve(response);
      }, function () {
        defer.resolve();
      });
      return defer.promise;
    }

    // function to create empty dataset structure to add new dataset
    function addNewDataset() {
      $scope.datasets.push({
        open: true,
        query: {},
        form: {},
        name: ''
      });
    }

    // function to save and update dataset
    function saveDataset(dataset, index) {
      if ($scope.formHolder['datasetForm-' + index].$invalid || !$scope.applicationCanUpdate) {
        return;
      }
      $scope.datasetProcessing = true;
      var _query;
      if (dataset['@id']) {
        _query = dataset;
      } else {
        var query = new Query();
        query = angular.extend(query, dataset.query);
        _query = {
          models: [modelMetadatasService.getIriByType($scope.entity.name)],
          name: dataset.name,
          query: query
        };
      }
      queryCollectionService.saveSystem(_query).then(function () {
        toaster.success({
          body: 'Dataset saved successfully'
        });
        $scope.datasetProcessing = false;
        _getDatasets(module);
      }, function() {
        $scope.datasetProcessing = false;
      });
    }

    // Function to cancle dataset edit
    function cancel(dataset) {
      dataset.open = false;
    }

    // function to open records with datset filters
    function openRecords(event, dataset, _module) {
      event.stopPropagation();
      event.preventDefault();
      $scope.currentDataset = dataset;
      $scope.datasetProcessing = true;
      _getModuleNameByIRI(_module).then(function (_moduleName) {
        _module = _moduleName;
        getColumns(_module).then(function () {
          loadGrid(_module, { query: dataset.query }).then(function () {
            modalInstance = $uibModal.open({
              animation: false,
              templateUrl: 'widgets/installed/manageDatasets-1.0.0/widgetAssets/html/openRecord.html',
              backdrop: 'static',
              windowClass: 'no-animation dataset-records',
              scope: $scope
            });
            $scope.datasetProcessing = false;
          });
        });
      });

    }

    function _getModuleNameByIRI(moduleIRI) {
      var defer = $q.defer();
      if (moduleIRI.indexOf('api/3/model_metadatas') !== -1) {
        if ($scope.moduleMetadata) {
          defer.resolve(_getModuleName($scope.moduleMetadata, moduleIRI));
        } else {
          modelMetadatasService.getModuleList(false, false).then(function (moduleMetadata) {
            $scope.moduleMetadata = moduleMetadata;
            defer.resolve(_getModuleName($scope.moduleMetadata, moduleIRI));
          });
        }
      } else {
        defer.resolve(moduleIRI);
      }
      return defer.promise;
    }

    function _getModuleName(modules, iri) {
      var currentModule = _.find(modules, function (module) {
        return module['@id'] === iri;
      });
      return currentModule.module;
    }

    // funciton to get columns for a module to display records
    function getColumns(_module) {
      columns = [];
      var defer = $q.defer();
      ViewTemplateService.get(VIEW_TEMPLATES.GRID_COLUMNS).then(function (template) {
        if (template.config[_module] && template.config[_module].length > 0) {
          createColumns(template.config[_module]);
        }
      }, angular.noop).finally(function () {
        defer.resolve();
      });
      return defer.promise;
    }

    function createColumns(config) {
      var _columns = config;
      angular.forEach(_columns, function (column) {
        if (column.visible === true) {
          columns.push(column.field);
        }
      });
    }

    // function to load grid records 
    function loadGrid(_module, config) {
      var defer = $q.defer();
      var pagedCollection = new PagedCollection(_module, null, null, false, undefined, columns);
      pagedCollection.loadByPost(config).then(function () {
        $scope.pagedCollection = pagedCollection;
        defer.resolve();
      }, function (error) {
        defer.reject(error);
      });
      return defer.promise;
    }

    // function to delete dataset
    function deleteDataset(event, dataset) {
      event.stopPropagation();
      event.preventDefault();
      ModalService.confirm('Are you sure want to delete ' + dataset.name +' dataset.').then(function(result) {
        if (result) {
          queryCollectionService.delete(dataset).then(function () {
            toaster.success({
              body: 'Dataset deleted successfully'
            });
            _getDatasets(module);
          });
        }
      });
    }

    //function to open popup to select dataset
    function selectDataset() {
      $scope.linkDatasetConfig = {};
      if ($scope.modules) {
        _openSelectionPopup();
      } else {
        appModulesService.load().then(function (modules) {
          $scope.modules = modules;
          _openSelectionPopup();
        });
      }
    }

    function filterLinkedModules(module) {
      var foundResult = _.find($scope.config.datasetLinkingModules, function(item){ return item === module.type;});
      return foundResult ? true :  false;
   }

    function _openSelectionPopup() {
      modalInstance = $uibModal.open({
        animation: false,
        templateUrl: 'widgets/installed/manageDatasets-1.0.0/widgetAssets/html/selectDataset.html',
        backdrop: 'static',
        //windowClass: 'no-animation',
        scope: $scope
      });
    }

    //function to link selected dataset
    function linkDataset() {
      var fieldData = {
        __link: {
          datasets: [$scope.linkDatasetConfig.selectedDataset['@id']]
        }
      };
      $scope.entity.save(fieldData).then(function () {
        close();
        _getLinkedDatasets();
      }, statusCodeService);
    }

    function unlinkDataSet(event, dataset) {
      event.preventDefault();
      event.stopPropagation();
      ModalService.confirm('Are you sure want to unlink ' + dataset.name +' dataset from the record .').then(function(result) {
        if (result) {
          var fieldData = {
            __unlink: {
              datasets: [dataset['@id']]
            }
          };
          $scope.entity.save(fieldData).then(function () {
            toaster.success({
              body: dataset.name + ' is unlinked successfully.'
            });
            close();
            _getLinkedDatasets();
          }, statusCodeService);
        }
      });
    }

    function loadDatasets(selectedModule) {
      _getDatasets(selectedModule.type);
    }

    function openDataset(dataset) {
      if (dataset.open) {
        dataset.processing = true;
        if (dataset.fields) {
          dataset.processing = false;
        } else {
          _getModuleNameByIRI(dataset.models).then(function (_moduleName) {
            var entity = new Entity(_moduleName);
            entity.loadFields().then(function () {
              dataset.fields = entity.fields;
              dataset.processing = false;
            });
          });
        }
      }
    }

    // function to close popup
    function close() {
      if (modalInstance) {
        modalInstance.close('cancel');
      }
    }

    _init();

  }
})();
