/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('editSecurityPosture100Ctrl', editSecurityPosture100Ctrl);

    editSecurityPosture100Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', 'widgetUtilityService', '$timeout', 'appModulesService', 'modelMetadatasService', 'Entity'];

    function editSecurityPosture100Ctrl($scope, $uibModalInstance, config, widgetUtilityService, $timeout, appModulesService, modelMetadatasService, Entity) {
        $scope.cancel = cancel;
        $scope.save = save;
        $scope.config = config;
        $scope.config.days = 30;

        function _handleTranslations() {
          let widgetNameVersion = widgetUtilityService.getWidgetNameVersion($scope.$resolve.widget, $scope.$resolve.widgetBasePath);
          
          if (widgetNameVersion) {
            widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
              $scope.viewWidgetVars = {
                // Create your translating static string variables here
              };
              $scope.header = $scope.config.title ? 'Edit Widget' : 'Add Widget';
              loadModules();
            });
          } else {
            $timeout(function() {
              $scope.cancel();
            });
          }
        }

        function loadModules() {
          appModulesService.load(true).then(function (modules) {
            $scope.modules = modules;
            //Create a list of modules with atleast one JSON field
            $scope.modules.forEach((module) => {
              var moduleMetaData = modelMetadatasService.getMetadataByModuleType(module.type);
              for (let fieldIndex = 0; fieldIndex < moduleMetaData.attributes.length; fieldIndex++) {
                //Check If JSON field is present in the module
                if (moduleMetaData.attributes[fieldIndex].type === "object") {
                  $scope.jsonObjModuleList.push(module);
                  break;
                }
              }
            });
          });
          if ($scope.config.resource) {
            $scope.loadAttributes();
          }
        }
    
        $scope.loadAttributes = function () {
          $scope.dateField = [];
          var entity = new Entity($scope.config.resource);
          entity.loadFields().then(function () {
            for (var key in entity.fields) {
              if (entity.fields[key].type === 'datetime') {
                $scope.dateField.push(entity.fields[key]);
                entity.fields[key].type = 'datetime.quick';
              } 
            }
          });
        };
    

        function init() {
            // To handle backward compatibility for widget
            _handleTranslations();
        }

        init();

        function cancel() {
            $uibModalInstance.dismiss('cancel');
        }

        function save() {
          if (!$scope.postureEditForm.$valid) {
            $scope.postureEditForm.$setTouched();
            $scope.postureEditForm.$focusOnFirstError();
            return;
          }else{
            $uibModalInstance.close($scope.config);
          }
        }

    }
})();
