/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
    angular
      .module('cybersponse')
      .controller('securityPosture100Ctrl', securityPosture100Ctrl);

    securityPosture100Ctrl.$inject = ['$scope', 'widgetUtilityService', 'widgetBasePath', 'securityPostureService', '$state', 'commonService', '$q', 'currentDateMinusService', 'toaster'];

    function securityPosture100Ctrl($scope, widgetUtilityService , widgetBasePath, securityPostureService, $state, commonService, $q, currentDateMinusService, toaster) {
      $scope.widgetBasePath = widgetBasePath;
      $scope.postureData = [];
      $scope.pageState = $state;
      $scope.noData = false;
      var fazConnectorConfigId = undefined;
      var fazConnectorAdomName = undefined;

      function _handleTranslations() {
        widgetUtilityService.checkTranslationMode($scope.$parent.model.type).then(function () {
          $scope.viewWidgetVars = {
            // Create your translating static string variables here
            ERROR_NO_INFORMATION_AVAILABLE: widgetUtilityService.translate('postureDummy.ERROR_NO_INFORMATION_AVAILABLE'),
          };
        });
      }

      function init() {
        // To handle backward compatibility for widget
        _handleTranslations();
        securityPostureService.setWidgetBasePath($scope.widgetBasePath);
        checkCurrentPage($scope.pageState);
      }

      $scope.$on('$destroy', function() {
        if($scope.agentWebSocket){
          $scope.agentWebSocket.unsubscribe();
        }
      })

       function checkCurrentPage(state) {
        if (state.current.name.includes('viewPanel.modulesDetail')) {
          let params = $scope.pageState.current.params;
          getRecordDetail(params.id, params.module).then(function (response) {
            let outbreakName = response[0].sourceData[0].tag;
            securityPostureService.getKeyStoreRecord().then(function (response) {
              if (response['hydra:member'] && (response['hydra:member'][0] && response['hydra:member'][0].jSONValue && Object.keys(response['hydra:member'][0].jSONValue).length !== 0)){
                let configParsedValue = JSON.parse(response['hydra:member'][0].jSONValue);
                if(configParsedValue.fazConfig.configId && configParsedValue.fazConfig.adomName){
                  fazConnectorConfigId = configParsedValue.fazConfig.configId;
                  fazConnectorAdomName = configParsedValue.fazConfig.adomName;
                  postureConnectorAction(outbreakName);
                }else{
                  $scope.noData = true;
                }
              }
              else {
                $scope.noData = true;
              }
            },function(error){
                $scope.noData = true;
            });
          });
        }
      }

      function getRecordDetail(records, module) {
        var defer = $q.defer();
        commonService.getRecordsDetail({
            module: module,
            uuids: [records]
        }).then(function (response) {
            defer.resolve(response);
        }, function (error) {
            $scope.params.similarError = error.data.message;
            $scope.params.similarErrorStatus = true;
            defer.reject(error);
        });
        return defer.promise;
    }

      function postureConnectorAction(outbreakName) {
        const _connectorName = 'fortinet-fortianalyzer';
        const _connectorAction = 'get_outbreak_alerts_summary';
        let _dayRange = $scope.config.days ? $scope.config.days : 30;
        let _endDate = new Date().toISOString(); //currentDate
        let _fromDate = currentDateMinusService(_dayRange).toISOString();

        let payload = {
          "end": _endDate,
          "start": _fromDate,
          "filter": `outbreak-name='${outbreakName}'`,
          "adom_name": fazConnectorAdomName
        }
        securityPostureService.executeAction(_connectorName, _connectorAction, payload, fazConnectorConfigId, $scope).then(function (response) {
          if (response?.data?.result?.data && response.data.result.data.length > 0) {
            $scope.noData = false;
            $scope.postureData = response.data.result.data;
            fetchDefinedSchema();
          }
          else {
            $scope.noData = true;
          }
        }, function (error) {
          if (error) {
            //display error
            $scope.noData = true;
            if (error?.data?.message) {
              if (error?.status === 400) {
                console.log(error.data.message)
              } else {
                toaster.error({ body: error.data.message });
              }
            }
          }
        });
      }

      //fetch pre defined posture schema to match the response returned from FAZ connector 
      function fetchDefinedSchema() {
        securityPostureService.fetchPostureSchema().then(function (response) {
          $scope.postureSchema = response.data.result.data;
          mapProductDeviceData();
        });
      }

      //map product response with predefined schema to dsiplay data on UI 
      function mapProductDeviceData() {
        // Updating schema with response data
        $scope.postureSchema.forEach(section => {
          section.products.forEach(product => {
            const matched = $scope.postureData.find(
              item => item["device-type"] === product.deviceType
            );

            if (matched) {
              product.alertCount = matched["alert-count"];
              product.lastDetected = matched["last-detected"];
              product.available = true;
            }
          });
          section.products.forEach(element => {
            element['icon'] =  `${$scope.widgetBasePath}widgetAssets/icons/${element.deviceType}.svg`;     
          });
          //sort device as per availability
          section.products.sort((a, b) => {
            if (a.available === true && b.available === false) {
              return -1; // a should come before b
            } else if (a.available === false && b.available === true) {
              return 1; // b should come before a
            }
            return 0; // No change if both are the same
          });
        });
      }

      init();
    }
})();
