/* Copyright start 
Copyright (C) 2008 - 2025 Fortinet Inc.
All rights reserved.
FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
Copyright end */
'use strict';

(function () {
  angular
    .module('cybersponse')
    .factory('securityPostureService', securityPostureService);

  securityPostureService.$inject = ['$http', 'API', 'connectorService', '$resource', '$q', 'toaster', 'websocketService'];

  function securityPostureService($http, API, connectorService, $resource, $q, toaster, websocketService) {
    var service;
    var widgetBasePath = '';

    service = {
      setWidgetBasePath: setWidgetBasePath,
      fetchPostureSchema: fetchPostureSchema,
      executeAction: executeAction,
      getKeyStoreRecord: getKeyStoreRecord
    };

    //set widget base path to keep the version updated
    function setWidgetBasePath(_widgetBasePath){
      widgetBasePath = _widgetBasePath;
    }

    //fetch predefined scheman to match the response data
    function fetchPostureSchema() {
      return $http.get(widgetBasePath + 'widgetAssets/postureSchema.json');
    }

    //execute connection action
    function executeAction(connector_name, connector_action, payload, fazConnectorConfigId, _scope) {
      let defer = $q.defer();
      $resource(API.INTEGRATIONS + 'connectors/?name=' + connector_name) //fetch connector version
        .get()
        .$promise
        .then(function (connectorMetaDataForVersion) {
          connectorService.executeConnectorAction(connector_name, connectorMetaDataForVersion.data[0].version, connector_action, fazConnectorConfigId, payload).then(function (response) {
            if(response.agent){
              _scope.agentWebSocket = websocketService.subscribe(response.id, function (result) {
                defer.resolve(result);
              });
            }else{
              defer.resolve(response);
            }
          }, function (error) {
            defer.reject(error);
          });
        }, function (error) {
          defer.reject(error);
        })
      return defer.promise;
    }

    //fetch outbreak-alert-config keystore query
    function getKeyStoreRecord() {
      var queryObject = {
        "sort": [
          {
            "field": "id",
            "direction": "ASC",
            "_fieldName": "id"
          }
        ],
        "limit": 30,
        "logic": "AND",
        "filters": [
          {
            "field": "key",
            "operator": "like",
            "_operator": "like",
            "value": "%outbreak-alert-config%",
            "type": "primitive"
          },
          {
            "sort": [],
            "limit": 30,
            "logic": "AND",
            "filters": []
          }
        ],
        "__selectFields": [
          "id",
          "key",
          "value",
          "notes",
          "@id",
          "@type",
          "jSONValue"
        ]
      };
      var defer = $q.defer();
      var url = API.QUERY + 'keys';
      $resource(url).save(queryObject, function (response) {
        defer.resolve(response);
      }, function (err) {
        defer.reject(err);
      })
      return defer.promise;
    }

    return service;
  }
})();
