/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
    angular
      .module('cybersponse')
      .controller('setupGuide130Ctrl', setupGuide130Ctrl);

      setupGuide130Ctrl.$inject = ['$scope', 'settingsService', 'setupGuideService', '_', 'toaster', '$rootScope', 'translationService', 'widgetBasePath', 'widgetUtilityService', 'widgetService'];

    function setupGuide130Ctrl($scope, settingsService, setupGuideService, _, toaster, $rootScope, translationService, widgetBasePath, widgetUtilityService, widgetService) {
      $rootScope.onboardingGuide.guideClose = true;
      $scope.openCloseAllTasks = openCloseAllTasks;
      $scope.completeLater = completeLater;
      $scope.resetTask = resetTask;
      $scope.notApplicable = notApplicable;
      $scope.markAsDone = markAsDone;
      $scope.close = close;
      $scope.changeGuideType = changeGuideType;
      $scope.openCloseTask = openCloseTask;
      $scope.isFortiTIP = false;
      $scope.themeId = $rootScope.theme.id;
      $scope.widgetCSS = widgetBasePath + 'widgetAssets/css/setupGuide.css';
      $scope.launchWidget = launchWidget;
      $scope.ONBOARDING_GUIDE = {
        'MARK_AS_DONE': 0,
        'NOT_APPLICABLE': 1
      };
      const PRODUCT_TYPE = {
        FortiTIP: 'FortiTIP'
      };
      let _url = widgetBasePath + 'widgetAssets/json/Enterprise/onboarding-setup-guide-' + ($rootScope.language ? $rootScope.language : 'en') + '.json';

      function init() {
        // To handle backward compatibility for widget
        _handleTranslations();
        $scope.processing = true;

        setupGuideService.getContentInfo('solutionpack', ['sOARFramework'], ['version']).then(function(response) {
          if(response.length > 0) {
            $scope.installedSFSPVer = parseInt(response[0].version.split('.').join(''));
          }
          settingsService.getAppFlavorConfiguration().then(function(appConfig) {
            if(appConfig && (appConfig.productType.includes(PRODUCT_TYPE.FortiTIP))) {
              $scope.isFortiTIP = true;
              _url = widgetBasePath + 'widgetAssets/json/TIP/onboarding-setup-guide-' + ($rootScope.language ? $rootScope.language : 'en') + '.json';
            }
            setupGuideService.getOnboardingTasksByAppVersion(_url).then(function(response) {
              $scope.originalOnboardingGuide = response.onboardingGuide;
              $scope.settings = response.settings;
              $rootScope.onboardingGuide.setupIncomplete = setupGuideService.isOnboardingSetupIncomplete(response.settings, response.onboardingGuide);
              $scope.guideType = $scope.settings.publicValues.onboarding_guide.deployment_type;
              _setGuideByType();
            }, function () {
              $scope.errorMessage = translationService.instantTranslate('setupGuide.ERROR_LOADING_SETUP_GUIDE');
            });
          }, function () {
            $scope.errorMessage = translationService.instantTranslate('setupGuide.ERROR_LOADING_SETUP_GUIDE');
          }).finally(function() {
            $scope.processing = false;
          });
        });
      }
  
      function _setGuideByType() {
        let _onboardingGuide = [];
        angular.forEach( $scope.originalOnboardingGuide.categories, function (category) {
          let _tasks = _.filter(category.tasks, function (task) {
            return task.applicable_types.indexOf($scope.guideType) !== -1;
          });
          if (_tasks.length > 0) {
            _onboardingGuide.push({
              title: category.title,
              description: category.description,
              tasks: _tasks,
              icon: category.icon,
              hideButtons: category.hideButtons
            });
          }
        });
        $scope.onboardingSetupGuide = { categories: _onboardingGuide };
      }
  
      function changeGuideType() {
        let _currentGuideType = angular.copy($scope.guideType);
        $scope.guideType = $scope.guideType === 'quick_start' ? 'production' : 'quick_start';
        let _settings = angular.copy($scope.settings);
        _settings.publicValues.onboarding_guide.deployment_type = _currentGuideType;
        settingsService.setSystem(_settings).then(function (data) {
          $scope.settings = data;
          $scope.guideType = $scope.settings.publicValues.onboarding_guide.deployment_type;
          _notifyUpdate();
          _setGuideByType();
        }, function(error) {
          toaster.error({
            body: error.data.message
          });
        });
      }
  
      function close() {
        $rootScope.onboardingGuide.guideClose = !$rootScope.onboardingGuide.guideClose;
        _checkForAlltaskComplete();  
        $scope.$parent.close();
      }
  
      function _checkForAlltaskComplete() {
        settingsService.getSystem(true).then(function(settings) {
          $rootScope.onboardingGuide.setupIncomplete = setupGuideService.isOnboardingSetupIncomplete(settings, $scope.originalOnboardingGuide);
        });
      }
  
      function markAsDone(task) {
        _saveTask(task, $scope.ONBOARDING_GUIDE.MARK_AS_DONE); 
      }
  
      function notApplicable(task) {
        _saveTask(task, $scope.ONBOARDING_GUIDE.NOT_APPLICABLE); 
      }
  
      function resetTask(task) {
        _saveTask(task, 'reset');
      }
  
      function _saveTask(task, operation) {
        task.processing = true;
        if(angular.isArray($scope.settings.publicValues.onboarding_guide.tasks)) {
          $scope.settings.publicValues.onboarding_guide.tasks = {};
        }
        let _settings = angular.copy($scope.settings);
        if(operation === 'reset') {
          delete _settings.publicValues.onboarding_guide.tasks[task.name];
        } else {
          _settings.publicValues.onboarding_guide.tasks[task.name] = operation;
        }
        settingsService.setSystem(_settings).then(function (data) {
          $scope.settings = data;
          task.processing = false;
          _notifyUpdate();
        }, function(error) {
          task.processing = false;
          toaster.error({
            body: error.data.message
          });
        });
      }
  
      function completeLater(task, category) {
        task.open = false;
        openCloseTask(category);
      }
  
      function openCloseAllTasks(category) {
        category.open = !category.open;
        angular.forEach(category.tasks, function(task) {
          task.open = category.open;
        });
      }
  
      function openCloseTask(category) {
        let _openedTasks = _.filter(category.tasks, function(task) {
          return task.open;
        });
        category.open = _openedTasks.length > 0;
      }
  
      function _notifyUpdate() {
        $rootScope.$broadcast('setupGuide:updated');
      }

      function launchWidget(name, version, closeMe) {
        widgetService.launchStandaloneWidget(name, version).then(function(){
          if(closeMe) {
            $scope.close();
          }
        });
      }


      function _handleTranslations() {
        widgetUtilityService.checkTranslationMode($scope.$parent.model.type).then(function () {
          $scope.viewWidgetVars = {
            // Create your translating static string variables here
          };
        });
      }

      init();
    }
})();
