/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';

(function() {
  angular
    .module('cybersponse')
    .factory('setupGuideService', setupGuideService);

    setupGuideService.$inject = ['$q', '$http', 'settingsService', '$rootScope', '_', 'versionService', 'ALL_RECORDS_SIZE', 'API'];

    function setupGuideService($q, $http, settingsService, $rootScope, _, versionService, ALL_RECORDS_SIZE, API) {
      var service = {
        getOnboardingTasksByAppVersion: getOnboardingTasksByAppVersion,
        isOnboardingSetupIncomplete: isOnboardingSetupIncomplete,
        getContentInfo: getContentInfo
      };
      const ONBOARDING_GUIDE = {
        'MARK_AS_DONE': 0,
        'NOT_APPLICABLE': 1
      };
      return service;

      function getOnboardingTasksByAppVersion(_url) {
        var defer = $q.defer();
        var _promises = [];
        _promises.push(settingsService.getSystem(true));
        _promises.push(versionService.get('app'));
        _promises.push($http.get(_url));
        $q.all(_promises).then(function (result) {
          var settings = result[0];
          settings.publicValues.onboarding_guide = settings.publicValues.onboarding_guide || {};
          settings.publicValues.onboarding_guide.tasks = settings.publicValues.onboarding_guide.tasks || {};
          settings.publicValues.onboarding_guide.deployment_type = settings.publicValues.onboarding_guide.deployment_type || 'quick_start';
          var _appVersion = parseInt(result[1].version.split('.').join(''));
          var _appVersionString = `/${result[1].version.split('-')[0]}/`;
          var _onboardingGuide = [];
          if (_appVersion > 0) {
            angular.forEach(result[2].data['onboarding-setup-guide'].categories, function (category) {
              var _tasks = _.filter(category.tasks, function (task) {
                task.description = task.description.replaceAll('/7.2.0/', _appVersionString);
                if (task.applicable_versions.end_version !== -1) {
                  return _appVersion >= task.applicable_versions.start_version && _appVersion < task.applicable_versions.end_version;
                } else {
                  return _appVersion >= task.applicable_versions.start_version;
                }
              });
              if (_tasks.length > 0) {
                _onboardingGuide.push({
                  title: category.title,
                  description: category.description,
                  tasks: _tasks,
                  icon: category.icon,
                  hideButtons: category.hideButtons
                });
              }
            });
            _onboardingGuide = { categories: _onboardingGuide };
          } else {
            _onboardingGuide = result[2].data['onboarding-setup-guide'];
          }
          defer.resolve({
            onboardingGuide: _onboardingGuide,
            settings: settings
          });
        }, function (error) {
          if (_url === error.config.url && $rootScope.language !== 'en') {
            defer.resolve(getOnboardingTasksByAppVersion(true));
          } else {
            defer.reject(error);
          }
        });
        return defer.promise;
      }

      function isOnboardingSetupIncomplete(settings, setupGuide) {
        let setupIncomplete = false;
        let _deploymentType = settings.publicValues.onboarding_guide.deployment_type;
        if (settings.publicValues.onboarding_guide.tasks) {
          for (var i = 0; i < setupGuide.categories.length; i++) {
            var section = setupGuide.categories[i];
            for (var j = 0; j < section.tasks.length; j++) {
              var task = section.tasks[j];
              if (task.applicable_types.indexOf(_deploymentType) !== -1 && !(settings.publicValues.onboarding_guide.tasks[task.name] === ONBOARDING_GUIDE.MARK_AS_DONE || settings.publicValues.onboarding_guide.tasks[task.name] === ONBOARDING_GUIDE.NOT_APPLICABLE)) {
                setupIncomplete = true;
                break;
              }
            }
            if (setupIncomplete) {
              break;
            }
          }
        } else {
          setupIncomplete = true;
        }
        return setupIncomplete;
      }

      function getContentInfo(type, contentList, selectedFields) {
        var queryParams = [
            {
                'field': 'type',
                'value': type,
                'operator': 'eq'
            },
            {
                'field': 'name',
                'value': contentList,
                'operator': 'in'
            }
        ];
        var defer = $q.defer();
        var queryObject = {
            limit: ALL_RECORDS_SIZE,
            logic: 'AND',
            filters: queryParams,
            __selectFields: selectedFields
        };

        $http.post(API.QUERY + 'solutionpacks?$limit=' + queryObject.limit, queryObject).then(function (response) {
            var list = angular.isDefined(response.data) ? response.data['hydra:member'] : response['hydra:member'];
            defer.resolve(list);
        }, function (error) {
            defer.reject(error);
        });
        return defer.promise;
    }

    }
})();