'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('taskManagement200Ctrl', taskManagement200Ctrl);
  taskManagement200Ctrl.$inject = ['$scope', '$uibModal', 'config', 'Entity', '$resource', 'API', 'statusCodeService', 'toaster', 'ModalService', '$filter', 'Modules', '$state', '$http', '_', 'taskManagementService', 'appModulesService', 'ALL_RECORDS_SIZE', '$rootScope', '$interpolate', '$window', 'currentPermissionsService', 'websocketService'];
  function taskManagement200Ctrl($scope, $uibModal, config, Entity, $resource, API, statusCodeService, toaster, ModalService, $filter, Modules, $state, $http, _, taskManagementService, appModulesService, ALL_RECORDS_SIZE, $rootScope, $interpolate, $window, currentPermissionsService, websocketService) {
    
    var modalInstance;
    var subscriptions = [];
    $scope.config = config;
    $scope.processing = false;
    $scope.loading = false;
    $scope.isConfigUndefined = false;
    $scope.saveTaskCard = saveTaskCard;
    $scope.showFilters = false;
    $scope.filterParams = undefined;
    $scope.editProcessing = false;
    if(config.selectedModule){
      $scope.selectedModuleCanCreate = currentPermissionsService.availablePermission(config.selectedModule, 'create');
      $scope.selectedModuleCanRead = currentPermissionsService.availablePermission(config.selectedModule, 'read');
      $scope.selectedModuleCanUpdate = currentPermissionsService.availablePermission(config.selectedModule, 'update');
      $scope.selectedModuleCandelete = currentPermissionsService.availablePermission(config.selectedModule, 'delete');
    }
    
    $scope.$on('websocket:reconnect',function(){
      initWebsocket();
    });

    function initWebsocket(webSocket){
      if(webSocket){
        var moduleName = config.selectedModule;
        websocketService.subscribe($state.params.module + '/' + $state.params.id + '/' + moduleName, function(data) {
          if(data.sourceWebsocketId !== websocketService.getWebsocketSessionId()){
            loadTasks();
          }
        }).then(function(data){
          subscriptions.push(data);
        });
        websocketService.subscribe(moduleName, function(data) {
          if(data.sourceWebsocketId !== websocketService.getWebsocketSessionId()){
            if(data.operation === "update"){
              var fieldsChanged = _.find($scope.taskField, function(field){
                return data.changeData.indexOf(field.name) > -1;
              });
              var records = _.find(webSocket.records, function(record){
                return data.entityUuid.indexOf(record['@id']) > -1;
              });
              if(records && fieldsChanged){
                loadTasks();
              }
            }
          }
        }).then(function(data){
          subscriptions.push(data);
        });
       } else {
         loadTasks();
       }
    }
    
    $scope.$on('$destroy', function() {
      if(subscriptions){
        // Unsubscribe
        unsubscribeWebSockets();
      }
    });
    
    function unsubscribeWebSockets(){
      angular.forEach(subscriptions, function(subscription){
        websocketService.unsubscribe(subscription);
      });
    }
    
    if($scope.selectedModuleCanRead){
    	init(true);
    }
    
    function init(subscribeWebsocket){
      $scope.processing = true;
      if(!config.selectedModule && !config.groupByField && !config.titleField && !config.assignedToField && !config.priorityField){
        $scope.processing = false;
        $scope.isConfigUndefined = true;
      }
      if(config.filterByField1 || config.filterByField2 || config.filterByField3) {
        $scope.showFilters = true;
      }
      var entity = new Entity(config.selectedModule);
      $scope.taskField = [];
      $scope.taskFilterField = [];
      entity.loadFields().then(function() {
        for (var key in entity.fields) {
          if (entity.fields[key].name === config.titleField || entity.fields[key].name === config.assignedToField || entity.fields[key].name === config.dueDateField || entity.fields[key].name === config.priorityField || entity.fields[key].name === config.groupByField) {
            $scope.taskField.push(entity.fields[key]);
            if(entity.fields[key].name === config.groupByField){
              $scope.statusTypes = entity.fields[key].options;
            }
          }
          if(entity.fields[key].name === config.filterByField1 || entity.fields[key].name === config.filterByField2 || entity.fields[key].name === config.filterByField3) {
            $scope.taskFilterField.push(angular.copy(entity.fields[key]));
          }
        }
      });
      
      $scope.taskManagementSortOptions = {
        'ui-floating' : true,
        revert: true,
        itemMoved: function (event) {
          if($scope.selectedModuleCanUpdate){
            saveTaskStatus(event);
          }
        },
        orderChanged: function (event) {
        },
        containment: '#task-management-board',
        containerPositioning: 'relative'
      };
      
      $scope.taskThemeColor = taskManagementService.getThemeColors($rootScope.theme);
      
      loadTasks(subscribeWebsocket);
    }
    
    function loadTasks(subscribeWebsocket, filterParams) {
      var params = {
        module: $state.params.module,
        id: $state.params.id,
        fieldName: config.selectedModule,
        $relationships: true,
        $limit: ALL_RECORDS_SIZE,
        $count_only: true
      };
      if(filterParams){
        params = angular.extend(params, filterParams);
      }
      Modules.get(params).$promise.then(function(data) {
        $scope.processing = false;
        $scope.loading = false;
        var allStatusTypes = [{'itemValue' : 'Task List'}];
        allStatusTypes = allStatusTypes.concat($scope.statusTypes);
        $scope.taskData = [];
        angular.forEach(allStatusTypes, function(status){
          var column = {'name': status, 'cards': getGroupedTasks(data['hydra:member'], status)};
          $scope.taskData.push(column);
        });
        if(subscribeWebsocket){
          if(subscriptions.length > 0){
            unsubscribeWebSockets();
          }
          initWebsocket({'records': data['hydra:member']});
        }
      }, function(error){
        console.log(error);
      });
    }
    
    function getGroupedTasks(tasks, status){
      return _.filter(tasks, function(task){
        if(angular.isObject(task[config.groupByField])){
          return status.itemValue === task[config.groupByField].itemValue;
        }
        else if(task[config.groupByField] === null) {
          return status.itemValue === 'Task List';
        }
      });
    }
    
    $scope.removeTaskCard = function (card) {
      var message = 'Are you sure you want to delete this ' + config.selectedModule + '?';
      ModalService.confirm(message).then(function(result) {
        if (!result) {
          return;
        }
        var uuid = card['@id'] ? $filter('getEndPathName')(card['@id']) : card.uuid;
        Modules.delete({
          module: config.selectedModule,
          id: uuid
        }).$promise.then(function(){
          toaster.success({
            body: config.selectedModule + ' successfully deleted.'
          });
          loadTasks();
        }).catch(function() {
          toaster.error({
            body: 'Unable to delete ' + config.selectedModule + '.'
          });
        });
      });
    };
    
    $scope.addNewTaskCard = function (taskStatus) {
      $scope.taskModalType = 'Add';
      angular.forEach($scope.taskField, function(field){
        if(taskStatus.itemValue !== 'Task List' && field.name === config.groupByField) {
          field.value = taskStatus;
        }
        else {
          field.value = null;
        }
      });
      
      modalInstance = $uibModal.open({
        animation: false,
        templateUrl: 'widgets/installed/taskManagement-2.0.0/widgetAssets/html/newTaskCard.html',
        windowClass: 'task-management-modal',
        backdrop: 'static',
        scope: $scope
      });
    };
    
    $scope.editTaskCard = function (card) {
      $scope.editProcessing = true;
      if($scope.selectedModuleCanUpdate){
        $scope.taskModalType = 'Edit';
        $scope.taskId = card['@id'];
        taskManagementService.getModuleRecordData(config.selectedModule, $filter('getEndPathName')($scope.taskId)).then(function(data) {
      	  $scope.editProcessing = false;
          if(data.status === 200){
            angular.forEach(card, function(value, key){
              angular.forEach($scope.taskField, function(field){
                if(key === field.name){
                  if(field.type === 'datetime' && value) {
                    field.value = $filter('unixToDate')(value);
                  } else if(field.type === 'lookup' && value) {
                    value.display = $interpolate(field.displayTemplate)(value);
                    field.value = value;
                  } else {
                    field.value = value;
                  }
                }
              });
            });

            modalInstance = $uibModal.open({
              animation: false,
              templateUrl: 'widgets/installed/taskManagement-2.0.0/widgetAssets/html/newTaskCard.html',
              windowClass: 'task-management-modal',
              backdrop: 'static',
              scope: $scope
            });
          } else {
            toaster.error({
              body: 'Something went wrong. Please retry updating.'
            });
          }
        }, function (error) {
      	  $scope.editProcessing = false;
          toaster.error({
            body: 'We are sorry, but you don\'t have the necessary permissions to update the resource. Please contact your administrator for assistance.'
          });
        });
      }
    };
    
    $scope.exit = function () {
      modalInstance.close('cancel');
    };
    
    function saveTaskCard (taskData, saveType, taskId) {
      $scope.loading = true;
      var tasks = {};
      angular.forEach(taskData, function(field){
        if(field.type === 'datetime') {
           field.value = $filter('dateToUnix')(field.value);
        }
        tasks[field.name] = field.value;
      });
      if(saveType === 'Add') {
        taskManagementService.createModuleRecord(tasks, config.selectedModule).then(function(response) {
          var fieldData = {
            __link: {
              'tasks': [response['@id']]}
          };
          taskManagementService.updateModuleRecordData(fieldData, $state.params.module, $state.params.id).then(function(data) {
          }).finally(function() {
            toaster.success({
              body: config.selectedModule + ' saved sucessfully!'
            });
            loadTasks(true);
            modalInstance.close();
          });
        }, statusCodeService);
      }
      else {
        taskManagementService.updateModuleRecordData(tasks, config.selectedModule, $filter('getEndPathName')(taskId)).then(function(data) {
          toaster.success({
            body: config.selectedModule + ' updated sucessfully!'
          });
          loadTasks();
          modalInstance.close();
        });
      }
    }
    
    function saveTaskStatus(eventObj) {
      var taskData = eventObj.source.itemScope.modelValue;
      var newStatus = eventObj.dest.sortableScope.$parent.column.name;
      $scope.editProcessing = true;
      var updateTaskData = {};
      updateTaskData[config.groupByField] = (newStatus.itemValue !== 'Task List' ? newStatus : null);
      taskManagementService.updateModuleRecordData(updateTaskData, config.selectedModule, $filter('getEndPathName')(taskData['@id'])).then(function(data) {
        eventObj.source.itemScope.modelValue.status = eventObj.dest.sortableScope.$parent.column.name;
        $scope.editProcessing = false;
        toaster.success({
          body: config.selectedModule + ' updated sucessfully!'
        });
      }, function (error) {
        $scope.editProcessing = false;   
        eventObj.dest.sortableScope.removeItem(eventObj.dest.index);
        eventObj.source.itemScope.sortableScope.insertItem(eventObj.source.index, eventObj.source.itemScope.$parent.card);
        toaster.error({
          body: 'We are sorry, but you don\'t have the necessary permissions to update the resource. Please contact your administrator for assistance.'
        });
      });
    }
    
    $scope.openRecord = function (record) {
      var state = appModulesService.getState();
      var params = {
        module: config.selectedModule,
        id: $filter('getEndPathName')(record['@id'])
      };
      $state.go(state, params);
    };
    
    function setFilters () {
      var filterParams = {};
      angular.forEach($scope.taskFilterField, function(filterField){
        if(filterField.value) {
          filterParams[filterField.name + '$eq'] = $filter('getEndPathName')(filterField.value['@id']);
        }
      });
      $scope.filterParams = (_.isObject(filterParams) && !angular.equals({}, filterParams)) ? filterParams : undefined;
    }
    
    $scope.applyFilters = function () {
      setFilters();
      $scope.loading = true;
      loadTasks(false, $scope.filterParams);
    }
    
    $scope.removeAllFilters = function () {
      angular.forEach($scope.taskFilterField, function(filterField){
        if(filterField.value){
          filterField.value = null;
        }
      });
      $scope.filterParams = undefined;
      $scope.loading = true;
      loadTasks();
    }
  }
}
)();
