'use strict';

(function() {
  angular
    .module('cybersponse')
    .factory('taskManagementService', taskManagementService);

  taskManagementService.$inject = ['$q', '$http', 'API'];

  function taskManagementService($q, $http, API) {
    var service = {
      getThemeColors: getThemeColors,
      createModuleRecord: createModuleRecord,
      getModuleRecordData: getModuleRecordData,
      updateModuleRecordData: updateModuleRecordData
    };
    return service;
    
    function getThemeColors(theme){ 
      var taskThemeColor = {};
      if(theme.id === 'light') {
        taskThemeColor.columnColor = '#eeeeee';
        taskThemeColor.columnHeaderColor = '#e0dede';
        taskThemeColor.cardColor = '#FFFFFF';
        taskThemeColor.cardBorderColor = '#cacaca';
      } else if(theme.id === 'steel') {
        taskThemeColor.columnColor = '#323b47';
        taskThemeColor.columnHeaderColor = '#151c24';
        taskThemeColor.cardColor = '#1b2430';
        taskThemeColor.cardBorderColor = '#000000';
      } else {
        taskThemeColor.columnColor = '#2b2b2b';
        taskThemeColor.columnHeaderColor = '#000000';
        taskThemeColor.cardColor = '#161616';
        taskThemeColor.cardBorderColor = '#000000';
      }
      return taskThemeColor;
    }
    
    function createModuleRecord(config, entity) {
      var defer = $q.defer();
      $http.post(API.BASE + entity, config).then(function(data) {
        defer.resolve(data.data);
      }, function(error){
         defer.reject(error);
      });
      return defer.promise;
    }
    
    function getModuleRecordData(entity, entityId) {
      var defer = $q.defer();
      $http.get(API.BASE + entity + '/' + entityId).then(function(data) {
        defer.resolve(data);
      }, function(error){
         defer.reject(error);
      });
      return defer.promise;
    }

    function updateModuleRecordData(config, entity, entityId) {
      var defer = $q.defer();
      $http.put(API.BASE + entity + '/' + entityId, config).then(function(data) {
        defer.resolve(data.data);
      }, function(error){
         defer.reject(error);
      });
      return defer.promise;
    }

  }
})();