/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('taxiiServerConfiguration110Ctrl', taxiiServerConfiguration110Ctrl);

  taxiiServerConfiguration110Ctrl.$inject = ['$scope', 'CommonUtils', '$resource', 'API', 'config', 'statusCodeService', 'toaster', '$rootScope', 'ModalService', 'clipboard', 'versionService', 'widgetUtilityService', '$timeout', 'settingsService'];

  function taxiiServerConfiguration110Ctrl($scope, CommonUtils, $resource, API, config, statusCodeService, toaster, $rootScope, ModalService, clipboard, versionService, widgetUtilityService, $timeout, settingsService) {
    $scope.getFeedSettings = getFeedSettings;
    $scope.updateTaxiiServerStatus = updateTaxiiServerStatus;
    $scope.revertTaxiiServerStatus = revertTaxiiServerStatus;
    $scope.getDataSets = getDataSets;
    $scope.params = {};
    $scope.taxiiServerAddress = CommonUtils.getOrigin();
    $scope.copyDatasetLink = copyDatasetLink;

    function _getAppFlavorConfiguration() {
      $scope.hideContent = false;
      settingsService.getAppFlavorConfiguration().then(function(appConfig) {
        if(appConfig?.restricted_feature?.widgets?.taxiiServerConfiguration) {
          $scope.hideContent = appConfig.restricted_feature.widgets.taxiiServerConfiguration.hideContent ? appConfig.restricted_feature.widgets.taxiiServerConfiguration.hideContent : false;
        }
      });
    }

    function init() {
      _getAppFlavorConfiguration();
      _handleTranslations();
      getFeedSettings();
      versionService.get('cyops_version').then(function (version) {
        var fsrVersion = angular.copy(version.version).split('-')[0];
        $scope.apiGuideURL = "https://docs.fortinet.com/document/fortisoar/" + fsrVersion + "/api-guide/797122/access-keys"
      });
      $scope.getTheme = $rootScope.theme.id;
      $scope.tableHeader = "backgrund-color:#191919";
    }

    function getFeedSettings() {
      $scope.processing = true;
      $resource(
        API.BASE +
        "system_settings/18f3043e-c1e4-4041-bba3-d481ea86d1b5/?$relationships=true"
      )
        .get({})
        .$promise.then(function (response) {
          $scope.params.enableTaxiiServer =
            response.publicValues.status.enabled;
          $scope.oldTaxiiServerStatusObject =
            angular.copy(response);
        }, statusCodeService)
        .finally(function () {
          $scope.processing = false;
        });

      getDataSets();
    }

    function updateTaxiiServerStatus() {
      $scope.updateProcessing = true;
      $scope.oldTaxiiServerStatusObject.publicValues.status.enabled =
        $scope.params.enableTaxiiServer;
      $resource(
        API.BASE +
        "system_settings/18f3043e-c1e4-4041-bba3-d481ea86d1b5",
        null,
        {
          update: {
            method: "PUT",
          },
        }
      )
        .update($scope.oldTaxiiServerStatusObject)
        .$promise.then(
          function () {
            $scope.params.feedOutgoingStatusForm.$setPristine();
            toaster.success({
              body: "TAXII sever settings updated successfully.",
            });
          },
          function () {
            toaster.error({
              body: "Unable to update TAXII sever settings.",
            });
          }
        )
        .finally(function () {
          $scope.updateProcessing = false;
        });
    }

    function revertTaxiiServerStatus() {
      ModalService.confirm(
        "Are you sure that you want to revert the changes?"
      ).then(function (result) {
        if (result) {
          $scope.params.enableTaxiiServer =
            $scope.oldTaxiiServerStatusObject.publicValues.status.enabled;
          $scope.params.feedOutgoingStatusForm.$setPristine();
          toaster.success({
            body: "Changes reverted successfully.",
          });
        }
      });
    }

    function getDataSets() {
      $scope.datasetProcessing = true;
      $resource(
        API.BASE +
        "system_queries?models__type=" +
        config.module + '&$limit=100'
      )
        .get({})
        .$promise.then(function (response) {
          $scope.datasets = response["hydra:member"];
        }, statusCodeService)
        .finally(function () {
          $scope.datasetProcessing = false;
        });
    }

    function copyDatasetLink(datasetId, format) {
      if (format === 'taxii') {
        clipboard.copyText(CommonUtils.getOrigin() + 'api/taxii/1/collections/' + datasetId + '/objects');
      }
      else {
        clipboard.copyText(CommonUtils.getOrigin() + 'api/taxii/1/collections/' + datasetId + '/objects?$format=csv&$limit=1000');
      }
      toaster.success({
        body: 'Dataset URL copied to clipboard.'
      });
    }

    //provide i18n support
    function _handleTranslations() {
      let widgetData = {
        name: $scope.config.name,
        version: $scope.config.version
      };
      let widgetNameVersion = widgetUtilityService.getWidgetNameVersion(widgetData);
      if (widgetNameVersion) {
        widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
          $scope.viewWidgetVars = {
            // Create your translating static string variables here
            WIDGET_TITLE: widgetUtilityService.translate('taxiiServerConfiguration.WIDGET_TITLE'),
            WIDGET_DISCRIPTION1: widgetUtilityService.translate('taxiiServerConfiguration.WIDGET_DISCRIPTION1'),
            WIDGET_DISCRIPTION12: widgetUtilityService.translate('taxiiServerConfiguration.WIDGET_DISCRIPTION12'),
            TAXII_BTN_LABLE: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_BTN_LABLE'),
            TAXII_SERVER_DETAILS: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_SERVER_DETAILS'),
            SERVER_ADD: widgetUtilityService.translate('taxiiServerConfiguration.SERVER_ADD'),
            SERVER_DISCOVERY_ADD: widgetUtilityService.translate('taxiiServerConfiguration.SERVER_DISCOVERY_ADD'),
            AUTH_TITLE: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_TITLE'),
            AUTH_API_KEY_DETAILS1: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_API_KEY_DETAILS1'),
            AUTH_API_KEY_DETAILS12: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_API_KEY_DETAILS12'),
            AUTH_CUSTOM_HEADERS_API: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_CUSTOM_HEADERS_API'),
            AUTH_CUSTOM_HEADERS_API1: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_CUSTOM_HEADERS_API1'),
            AUTH_CUSTOM_HEADERS_API2: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_CUSTOM_HEADERS_API2'),
            AUTH_USER_NAME_PWD: widgetUtilityService.translate('taxiiServerConfiguration.AUTH_USER_NAME_PWD'),
            ENDPOINTS_TITLE: widgetUtilityService.translate('taxiiServerConfiguration.ENDPOINTS_TITLE'),
            TAXII_COLLECTIONS: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_COLLECTIONS'),
            TAXII_COLLECTION_DETAILS: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_COLLECTION_DETAILS'),
            TAXII_THREAT_FEEDS: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_THREAT_FEEDS'),
            TAXII_THREAT_FEEDS_DETAILS: widgetUtilityService.translate('taxiiServerConfiguration.TAXII_THREAT_FEEDS_DETAILS'),
            THREAT_FEED_DATASETS: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS'),
            THREAT_FEED_DATASETS_DISCRIPTION1: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_DISCRIPTION1'),
            THREAT_FEED_DATASETS_DISCRIPTION2: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_DISCRIPTION2'),
            THREAT_FEED_DATASETS_DISCRIPTION3: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_DISCRIPTION3'),
            THREAT_FEED_DATASETS_DISCRIPTION4: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_DISCRIPTION4'),
            THREAT_FEED_DATASETS_DISCRIPTION5: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_DISCRIPTION5'),
            THREAT_FEED_DATASETS_COUNT_LABEL1: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_COUNT_LABEL1'),
            THREAT_FEED_DATASETS_COUNT_LABEL2: widgetUtilityService.translate('taxiiServerConfiguration.THREAT_FEED_DATASETS_COUNT_LABEL2'),
            DATASETS_TABLE_COLUMN1: widgetUtilityService.translate('taxiiServerConfiguration.DATASETS_TABLE_COLUMN1'),
            DATASETS_TABLE_COLUMN2: widgetUtilityService.translate('taxiiServerConfiguration.DATASETS_TABLE_COLUMN2'),
            DATASETS_TABLE_COLUMN3: widgetUtilityService.translate('taxiiServerConfiguration.DATASETS_TABLE_COLUMN3'),
            DATASETS_NOT_AVAILABLE: widgetUtilityService.translate('taxiiServerConfiguration.DATASETS_NOT_AVAILABLE'),
            SAVE_BTN: widgetUtilityService.translate('taxiiServerConfiguration.SAVE_BTN'),
            REVERT_BTN: widgetUtilityService.translate('taxiiServerConfiguration.REVERT_BTN'),
            LICENSE_EDITION_ERROR_MSG: widgetUtilityService.translate('taxiiServerConfiguration.LICENSE_EDITION_ERROR_MSG')
          };
        });
      }
      else {
        $timeout(function () {
          cancel();
        }, 100)
      }
    }

    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }

    init();
  }
})();
