/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('threatIntelManagementConfiguration100Ctrl', threatIntelManagementConfiguration100Ctrl);

  threatIntelManagementConfiguration100Ctrl.$inject = ['$scope', 'PagedCollection', 'Query', 'SchedulesService', 'threatIntelManagementConfigurationService', 'widgetDataIngestionService', 'WizardHandler', '$controller', '$state', 'connectorService', 'currentPermissionsService', 'CommonUtils', 'API', '_', '$filter', '$http', '$resource', 'toaster', 'appModulesService', 'widgetBasePath', '$rootScope', '$timeout', 'ALL_RECORDS_SIZE', '$q', 'Modules', 'widgetService', 'widgetTemplateService', 'widgetUtilityService', '$window'];

  function threatIntelManagementConfiguration100Ctrl($scope, PagedCollection, Query, SchedulesService, threatIntelManagementConfigurationService, widgetDataIngestionService, WizardHandler, $controller, $state, connectorService, currentPermissionsService, CommonUtils, API, _, $filter, $http, $resource, toaster, appModulesService, widgetBasePath, $rootScope, $timeout, ALL_RECORDS_SIZE, $q, Modules, widgetService, widgetTemplateService, widgetUtilityService, $window) {
    $controller('BaseConnectorCtrl', {
      $scope: $scope
    });
    $scope.widgetProcessing = true;
    $scope.backToStartPage = backToStartPage;
    $scope.backToConfigConnector = backToConfigConnector;
    $scope.moveToConfigureConnector = moveToConfigureConnector;
    $scope.backToinstallConnector = backToinstallConnector;
    $scope.moveToSelectConnector = moveToSelectConnector;
    $scope.backToSelectConnector = backToSelectConnector;
    $scope.moveToFeedRules = moveToFeedRules;
    $scope.backToFeedRules = backToFeedRules;
    $scope.configFieldChanged = configFieldChanged;
    $scope.moveToFinish = moveToFinish;
    $scope.installConnector = installConnector;
    $scope.close = close;
    $scope.toggleSelectFeedsSettings = toggleSelectFeedsSettings;
    $scope.loadActiveTab = loadActiveTab;
    $scope.saveParams = saveParams;
    $scope.cancel = cancel;
    $scope.dataIngestionParamsUpdating = false;
    $scope.areFeedConnectorsConfigured = false;
    $scope.allConnectorsInstalled = false;
    $scope.model = {};
    $scope.widgetDefinition = {};
    $scope.connectorInstalledOnAgents = [];
    $scope.dataIngestCollectionUUIDs = [];
    $scope.saveSchedules = [];
    $scope.feedConnectors = [];
    $scope.healthyConnectors = [];
    $scope.isScheduleCreated = [];
    $scope.installedConnectors = [];
    $scope.healthyConnectorsParams = [];
    $scope.connectorHealthStatus = [];
    $scope.connectorParamsStatus = [];
    $scope.samplePlaybookEntity = {};
    $scope.ingestMethodActions = {};
    $scope.connectorFetchIndex = {};
    $scope.connectorConfigIndex = {};
    $scope.toggleConnectorConfigSettings = { open: true };
    $scope.toggleParametersSettings = { open: false };
    $scope.toggleScheduleConfigSettings = { open: false };
    $scope.searchQuery = '';
    $scope.scheduleJsonData = [];
    $scope.params = {
      activeTab: 0
    };
    $scope.isLightTheme = $rootScope.theme.id === 'light';
    $scope.widgetBasePath = widgetBasePath;
    $scope.startInfoGraphics = $scope.isLightTheme ? widgetBasePath + 'images/start-light.svg' : widgetBasePath + 'images/start-dark.svg';
    $scope.feedSources = $scope.isLightTheme ? widgetBasePath + 'images/feed-sources-light.svg' : widgetBasePath + 'images/feed-sources-dark.svg';
    $scope.installFeeds = $scope.isLightTheme ? widgetBasePath + 'images/install-feeds-light.svg' : widgetBasePath + 'images/install-feeds-dark.svg';
    $scope.configFeeds = $scope.isLightTheme ? widgetBasePath + 'images/config-feeds-light.svg' : widgetBasePath + 'images/config-feeds-dark.svg';
    $scope.feedRulesImg = $scope.isLightTheme ? widgetBasePath + 'images/feed-rules-light.svg' : widgetBasePath + 'images/feed-rules-dark.svg';
    $scope.finishInfoGraphics = widgetBasePath + 'images/finish.png';
    $scope.widgetCSS = widgetBasePath + 'widgetAssets/css/wizard-style.css';
    const fortiGuardConnectorName = 'Fortinet FortiGuard Threat Intelligence';
    init();

    function init() {
      _handleTranslations().then(function () {
        createWidgetDefinition().then(function () {
          $scope.widgetProcessing = false;
        });
        $scope.isFortiGuardConnectorInstalled = true;
        appModulesService.load(true).then(function (modules) {
          modules = $filter('playbookModules')(modules);
          $scope.modules = currentPermissionsService.availablePermissions(modules, 'create');
        });
        $scope.allowPlaybookEdit = currentPermissionsService.availablePermission('workflows', 'create') || currentPermissionsService.availablePermission('workflows', 'update');
        Modules.get({
          module: 'teams',
          $limit: self.ALL_RECORDS_SIZE,
        }).$promise.then(function (result) {
          $scope.owners = result['hydra:member'];
        });
      }).catch(function (error) {
        console.error("Error in translation handling:", error);
        // Handle any error from _handleTranslations() if necessary
      });
    }

    function _getKeyStoreRecord() {
      return new Promise((resolve, reject) => {
        var pagedCollection = new PagedCollection('keys');
        var query = {
          logic: 'AND',
          limit: 1,
          filters: [{
            field: 'key',
            operator: 'eq',
            value: 'threat-intel-management-configuration'
          }],
          __selectFields: ["jSONValue"]
        };
        pagedCollection.query = new Query(query);

        // Load the data asynchronously
        pagedCollection.load().then(function () {
          if (pagedCollection.data['hydra:member'].length > 0) {
            // Set the feedRules value
            $scope.feedRules = pagedCollection.data['hydra:member'][0].jSONValue;
            resolve();  // Resolve the promise after successfully loading the data
          } else {
            reject(new Error("No records found"));  // Reject the promise if no records are found
          }
        }).catch(function (error) {
          reject(error);  // Reject the promise if there’s an error in the load
        });
      });
    }

    function close() {
      $timeout(function () { $window.location.reload(); }, 3000);
      $state.go('main.modules.list', { module: 'threat_intel_feeds' }, { reload: true });
      $scope.$parent.$parent.$parent.$ctrl.handleClose();
    }

    function toggleSelectFeedsSettings(event) {
      event.stopPropagation();
    }

    $scope.removeTab = function (index) {
      $scope.loadingStates[index] = true;
      $timeout(function () {
        // Logic to remove the tab
        $scope.installedConnectors.splice(index, 1);
        $scope.connectorInstalledOnAgents.splice(index, 1);
        $scope.dataIngestCollectionUUIDs.splice(index, 1);
        $scope.healthyConnectors.splice(index, 1);
        $scope.isScheduleCreated.splice(index, 1);
        $scope.saveSchedules.splice(index, 1);
        $scope.connectorHealthStatus.splice(index, 1);
        $scope.scheduleJsonData.splice(index, 1);
        $scope.healthyConnectorsParams.splice(index, 1);
        if ($scope.params.activeTab === index) {
          $scope.params.activeTab = 0;
        } else if ($scope.params.activeTab > index) {
          // If the active tab was after the removed tab, decrement the active tab index
          $scope.params.activeTab--;
        }
        // Remove loading state for the specific tab
        $scope.loadingStates.splice(index, 1);

        // Adjust the active tab index accordingly
        for (let i = 0; i < $scope.loadingStates.length; i++) {
          if (i >= index) {
            $scope.loadingStates[i] = $scope.loadingStates[i + 1]; // Shift the loading states
          }
        }
        $scope.loadingStates.push(false); // Maintain the length of loadingStates array
        $scope.$apply(); // Apply changes
        loadActiveTab(0);
        $scope.params = {
          activeTab: 0
        };
        const tabHeadings = document.querySelectorAll('.uib-tab-heading');
        if (tabHeadings.length > 0) {
          tabHeadings[0].focus();
        }
      }, 2000);
    };

    function installConnector() {
      WizardHandler.wizard('timSolutionpackConfigWizard').next();
      const selectedConnectors = $scope.feedConnectors.filter(pack => pack.selectConnector === true && pack.installed === false);
      $scope.getSelectedConnectorsCount = selectedConnectors.length + ($scope.feedConnectors.filter(pack => pack.selectConnector === true && pack.installed === true)).length
      function installSequentially(index) {
        if (index >= selectedConnectors.length) {
          $scope.allConnectorsInstalled = true;
          return;
        }
        const connector = selectedConnectors[index];
        threatIntelManagementConfigurationService.installConnector(connector)
          .then(resp => {
            const importJobId = resp.data.importJob;
            threatIntelManagementConfigurationService.getConnectorInstallationProgress(importJobId, connector)
              .then(() => {
                connector.installed = true;
                installSequentially(index + 1);
              })
              .catch(error => {
                console.log(error);
                installSequentially(index + 1);
              });
          })
          .catch(error => {
            console.log(error);
            installSequentially(index + 1);
          });
      }
      installSequentially(0);
    }

    function loadActiveTab(tabIndex) {
      $scope.toggleConnectorConfigSettings = { open: true };
      $scope.toggleParametersSettings = { open: false };
      $scope.toggleScheduleConfigSettings = { open: false };
      $scope.healthyConnectors[tabIndex] = false;
      $scope.isScheduleCreated[tabIndex] = false;
      if (CommonUtils.isUndefined(tabIndex)) {
        if (CommonUtils.isUndefined($scope.params.activeTab)) {
          $scope.params = {
            activeTab: 0
          };
        }
        _loadConnectorDetails(0, $scope.installedConnectors[0]);
      }
      else {
        $scope.params = {
          activeTab: tabIndex
        };
        $scope.selectedFeedConnectorName = $scope.installedConnectors[tabIndex].label;
        _loadConnectorDetails(tabIndex, $scope.installedConnectors[tabIndex]);
      }
    }

    function _loadConnectorDetails(tabIndex, installedConnector) {
      $scope.connectorProcessing = true;
      connectorService.getConnector(installedConnector.name, installedConnector.version).then(function (connector) {
        installedConnector.connectorInfo = angular.copy(connector);
        installedConnector.connectorInfo.baseId = angular.copy(connector.id);
        $scope.connectorProcessing = false;
        if (!connector) {
          toaster.error({
            body: 'The Connector "' + installedConnector.name + '" is not installed. Install the connector and re-run this wizard to complete the configuration'
          });
          return;
        }
      }, function () {
        $scope.connectorProcessing = false;
      });
    }

    $scope.$on('scheduleDetails', function (event, data) {
      $scope.scheduleStatus = data.status;
      $scope.scheduleID = data.scheduleId;
    });

    $scope.$on('configurationChanged', function (event, data) {
      $scope.healthyConnectors[data.tabIndex] = false;
      $scope.isScheduleCreated[data.tabIndex] = false;
      $scope.scheduleJsonData[data.tabIndex] = {};
      $scope.healthyConnectorsParams[data.tabIndex] = {};
      $scope.saveSchedules[data.tabIndex] = {};
    });

    $scope.$on('toggleAgentMode', function (event, data) {
      $scope.healthyConnectors[data.tabIndex] = false;
      $scope.isScheduleCreated[data.tabIndex] = false;
      $scope.scheduleJsonData[data.tabIndex] = {};
      $scope.healthyConnectorsParams[data.tabIndex] = {};
      $scope.saveSchedules[data.tabIndex] = {};
    });

    $scope.$on('healthCheckDetails', function (event, connectorDetails) {
      var connector = angular.copy(connectorDetails);
      const connectorConfig = _.find(connector.connectorInfo.configuration, { config_id: connector.config_id });
      $scope.installedConnectors[connector.tabIndex].defaultConfig = connector.connectorInfo.configuration.some(item => item.default === true);
      if (!CommonUtils.isUndefined(connectorConfig) && connectorConfig.status === "Available") {
        if (!$scope.healthyConnectors[connector.tabIndex] || !_.isEmpty(connectorConfig.remote_status)) {
          $scope.installedConnectors[connector.tabIndex].health = true;
          _.assign(connector.connectorInfo, { "configuration": connectorConfig });
          _.assign(connector.connectorInfo, { "playbook_collections": connector.connectorInfo.playbook_collections[0] });
          _.assign(connector.connectorInfo, { "uuid": $scope.installedConnectors[connector.tabIndex].uuid });
          _processDataIngestion(connector.tabIndex, connector.connectorInfo)
            .then(() => {
              console.log('Data Ingestion successfully configured for the integration ' + connector.connectorInfo.label);
            })
            .catch(error => {
              console.error('Error during data ingestion:', error);
            });
        }
      } else {
        $scope.toggleConnectorConfigSettings = { open: true };
        $scope.toggleParametersSettings = { open: false };
        $scope.toggleScheduleConfigSettings = { open: false };
        $scope.installedConnectors[connector.tabIndex].health = false;
        $scope.healthyConnectors[connector.tabIndex] = false;
      }
    });

    function backToStartPage() {
      WizardHandler.wizard('timSolutionpackConfigWizard').previous();
    }

    function backToinstallConnector() {
      $scope.areFeedConnectorsConfigured = false;
      WizardHandler.wizard('timSolutionpackConfigWizard').previous();
    }

    function backToFeedRules() {
      WizardHandler.wizard('timSolutionpackConfigWizard').previous();
    }

    async function moveToFinish() {
      try {
        // Wait for _getKeyStoreRecord to finish before proceeding
        await _getKeyStoreRecord();

        // Once _getKeyStoreRecord is successful, proceed with the rest of the code
        let feedIntegrationNames = _.map($scope.installedConnectors, 'label');
        $scope.displayFeedIntegrations = feedIntegrationNames.join(', ');

        var queryPayload = {
          "request": $scope.feedRules
        };
        var queryUrl = API.MANUAL_TRIGGER + '6a4c2425-d0f8-454c-aae4-9a9bf5e6c171';

        const response = await $http.post(queryUrl, queryPayload);
        WizardHandler.wizard('timSolutionpackConfigWizard').next();
        console.log(response);
      } catch (error) {
        console.error('Error during execution:', error);
      }
    }

    function backToConfigConnector() {
      $scope.toggleConnectorConfigSettings = { open: true };
      $scope.toggleParametersSettings = { open: false };
      $scope.toggleScheduleConfigSettings = { open: false };
      loadActiveTab(0);
      $scope.areFeedConnectorsConfigured = false;
      WizardHandler.wizard('timSolutionpackConfigWizard').previous();
    }

    function backToSelectConnector() {
      $scope.feedConnectors.sort((firstItem, secondItem) => secondItem.installed - firstItem.installed);
      $scope.allConnectorsInstalled = false;
      WizardHandler.wizard('timSolutionpackConfigWizard').previous();
    }

    function moveToSelectConnector() {
      threatIntelManagementConfigurationService.getFeedConnectors(fortiGuardConnectorName).then(function (response) {
        $scope.fortiGuardConnector = response.data['hydra:member'][0];
        if ($scope.fortiGuardConnector.installed === false) {
          $scope.isFortiGuardConnectorInstalled = false;
          threatIntelManagementConfigurationService.installConnector($scope.fortiGuardConnector)
            .then(resp => {
              const importJobId = resp.data.importJob;
              threatIntelManagementConfigurationService.getConnectorInstallationProgress(importJobId, $scope.fortiGuardConnector)
                .then(() => {
                  threatIntelManagementConfigurationService.configFortiGuardConnector($scope.fortiGuardConnector).then(() => {
                    threatIntelManagementConfigurationService.getFeedConnectors().then(function (response) {
                      $scope.feedConnectors = response.data['hydra:member'];
                      $scope.feedConnectors.sort((firstItem, secondItem) => secondItem.installed - firstItem.installed);
                      $scope.feedConnectors.forEach(feedConnector => {
                        $scope.isFortiGuardConnectorInstalled = true;
                        feedConnector.selectConnector = feedConnector.installed ? true : false;
                      });
                      WizardHandler.wizard('timSolutionpackConfigWizard').next();
                    });
                  });
                })
                .catch(error => {
                  console.log(error);
                  // Continue to the next connector even if there is an error
                });
            })
            .catch(error => {
              console.log(error);
              // Continue to the next connector even if there is an error
            });
        }
        else {
          threatIntelManagementConfigurationService.configFortiGuardConnector($scope.fortiGuardConnector).then(() => {
            threatIntelManagementConfigurationService.getFeedConnectors().then(function (response) {
              $scope.feedConnectors = response.data['hydra:member'];
              $scope.feedConnectors.sort((firstItem, secondItem) => secondItem.installed - firstItem.installed);
              $scope.feedConnectors.forEach(feedConnector => {
                $scope.isFortiGuardConnectorInstalled = true;
                feedConnector.selectConnector = feedConnector.installed ? true : false;
              });
              WizardHandler.wizard('timSolutionpackConfigWizard').next();
            });
          });
        }
      });
    }

    function _processDataIngestion(tabIndex, healthyConnector) {
      return new Promise((resolve, reject) => {
        widgetDataIngestionService.cloneIngestionPlaybookCollection($scope, healthyConnector)
          .then(function () {
            return widgetDataIngestionService.prepareFetchSampleConfig($scope, tabIndex, healthyConnector);
          })
          .then(function () {
            // Wrapping _createDefaultSchedule in a promise to ensure it completes before moving on
            return new Promise((resolve, reject) => {
              _createDefaultSchedule(tabIndex, $scope.healthyConnectorsParams[tabIndex])
                .then(() => resolve()) // Resolving after _createDefaultSchedule finishes
                .catch(reject);
            });
          })
          .then(function () {
            $scope.dataIngestCollectionUUIDs[tabIndex] = $scope.ingestCollectionUUID;
            $scope.healthyConnectors[tabIndex] = true;
            widgetDataIngestionService.updateConfigParams($scope, $scope.healthyConnectorsParams[tabIndex]);
            console.log('Data Ingestion successfully configured for the integration ' + healthyConnector.label);
            resolve();
          })
          .catch(function (error) {
            console.error('Error processing healthyConnectors:', error);
            reject(error);
          });
      });
    }

    function _createDefaultSchedule(tabIndex, ingestionConnectorDetails) {
      return new Promise((resolve, reject) => {
        var queryBody = {
          name: "Ingestion_" + ingestionConnectorDetails.ingestionPlaybook.ingestionConnector.name + "_" + ingestionConnectorDetails.ingestionPlaybook.ingestionConnector.configuration.name + "_" + ingestionConnectorDetails.ingestionPlaybook.ingestionConnector.configuration.config_id,
          "crontab": {
            "minute": "0",
            "hour": "*/1",
            "day_of_week": "*",
            "day_of_month": "*",
            "month_of_year": "*"
          },
          "kwargs": {
            "exit_if_running": true,
            "wf_iri": API.API_3_BASE + API.WORKFLOWS + ingestionConnectorDetails.ingestionPlaybook.ingestPlaybook['@id'],
            "timezone": "UTC",
            "utcOffset": "UTC",
            "createUser": "/api/3/people/3451141c-bac6-467c-8d72-85e0fab569ce"
          },
          "enabled": false
        };
        var url = API.WORKFLOW + 'api/scheduled/?depth=2&format=json&limit=' + ALL_RECORDS_SIZE + '&ordering=-modified&search=' + ingestionConnectorDetails.ingestionPlaybook.ingestionConnector.configuration.config_id + '&task=workflow.tasks.periodic_task';

        $resource(url).get({}).$promise.then(function (response) {
          if (response['hydra:member'].length === 0) {
            $resource(API.WORKFLOW + 'api/scheduled/?format').save(queryBody).$promise.then(function (postResponse) {
              $scope.saveSchedules[tabIndex] = postResponse;
              $scope.scheduleJsonData[tabIndex] = angular.copy(ingestionConnectorDetails);
              $scope.isScheduleCreated[tabIndex] = true;
              threatIntelManagementConfigurationService.saveScheduleMetadata($scope.healthyConnectorsParams[tabIndex].ingestionPlaybook, $scope.saveSchedules[tabIndex]);
              if (!$scope.saveSchedules[tabIndex].enabled) {
                $scope.saveSchedules[tabIndex].enabled = true;
                SchedulesService.saveSchedule($scope.saveSchedules[tabIndex], false);
              }
              resolve();
            }).catch(reject);
          } else {
            $scope.saveSchedules[tabIndex] = response['hydra:member'][0];
            $scope.scheduleJsonData[tabIndex] = angular.copy(ingestionConnectorDetails);
            $scope.isScheduleCreated[tabIndex] = true;
            threatIntelManagementConfigurationService.saveScheduleMetadata($scope.healthyConnectorsParams[tabIndex].ingestionPlaybook, $scope.saveSchedules[tabIndex]);
            if (!$scope.saveSchedules[tabIndex].enabled) {
              $scope.saveSchedules[tabIndex].enabled = true;
              SchedulesService.saveSchedule($scope.saveSchedules[tabIndex], false);
            }
            resolve();
          }
        }).catch(reject);
      });
    }

    function moveToFeedRules() {
      _checkConnectorHealth();
    }


    function saveParams(timParamsForm, index) {
      widgetDataIngestionService.saveDataIngestionParams($scope, timParamsForm, index);
      timParamsForm.$setPristine();
    }


    function _checkConnectorHealth() {
      if ($scope.installedConnectors.length === 0) {
        toaster.error({
          body: 'At least one integration configuration should be necessary.'
        });
        return;
      }
      $scope.areFeedConnectorsConfigured = true;
      if ($scope.installedConnectors.length === $scope.saveSchedules.length) {
        const promises = $scope.installedConnectors.reduce((promise, installedConnector, index) => {
          return promise.then(() => {
            if (installedConnector.health === false || installedConnector.defaultConfig === false) {
              return connectorService.getConnector(installedConnector.name, installedConnector.version)
                .then(connector => {
                  if (connector.configuration.length > 0) {
                    return _getConnectorHealth(installedConnector, connector, index);
                  } else {
                    return connectorService.getAgents(connector).then(agents => {
                      if (agents.length > 0) {
                        return connectorService.getConnector(agents[0].conn_name, agents[0].conn_version, agents[0].agent)
                          .then(response => _getConnectorHealth(installedConnector, response, index));
                      } else {
                        toaster.error({
                          body: 'The ' + installedConnector.label + ' is not configured. To proceed with the wizard, configure or close the ' + installedConnector.label + ' tab.'
                        });
                        loadActiveTab(index);
                        return Promise.reject(); // Resolve to continue the chain
                      }
                    });
                  }
                });
            } else {
              return widgetDataIngestionService.activateIngestionPlaybooks($scope.dataIngestCollectionUUIDs[index]);
            }
          });
        }, Promise.resolve()); // Start with a resolved promise
        promises
          .then(() => {
            // Finally, execute the remaining code after the schedules and metadata are saved
            $scope.feedIntegrationTools = _.map($scope.installedConnectors, 'label');
            WizardHandler.wizard('timSolutionpackConfigWizard').next();
          })
          .catch(error => {
            console.error('Error fetching connector health:', error);
          })
          .finally(() => {
            console.log('Finished processing all connectors.');
            $scope.areFeedConnectorsConfigured = false;
          });
      } else {
        $scope.areFeedConnectorsConfigured = false;
        let notCreatedScheduleIndex = _.findIndex($scope.isScheduleCreated, (value) => value === false);
        loadActiveTab(notCreatedScheduleIndex);
        if (!CommonUtils.isUndefined($scope.installedConnectors[notCreatedScheduleIndex].connectorInfo) && $scope.installedConnectors[notCreatedScheduleIndex].connectorInfo.config_count > 0) {
          toaster.info({
            body: 'Please wait until the ' + $scope.installedConnectors[notCreatedScheduleIndex].label + ' data ingestion schedule is created.'
          });
        } else {
          toaster.info({
            body: 'The ' + $scope.installedConnectors[notCreatedScheduleIndex].label + ' either not configured or please wait until the configuration health is being checked.'
          });
        }
      }
    }

    function _getConnectorHealth(installedConnector, connector, index) {
      const defaultConfiguredConnector = _.find(connector.configuration, { default: true });
      let toasterMessage;
      if (!CommonUtils.isUndefined(defaultConfiguredConnector)) {
        return connectorService.getConnectorHealth(
          installedConnector,
          defaultConfiguredConnector.config_id,
          defaultConfiguredConnector.agent
        ).then(data => {
          if (!CommonUtils.isUndefined(data.status) && data.status === "Available") {
            loadActiveTab(index);
            $scope.connectorHealthStatus[index] = true;
            return widgetDataIngestionService.activateIngestionPlaybooks($scope.dataIngestCollectionUUIDs[index])
              .then(() => {
                return Promise.resolve();
              });
          } else if (!CommonUtils.isUndefined(data.id)) {
            return $resource(API.INTEGRATIONS + 'connectors/' + installedConnector.name + '/' + installedConnector.version + '/?format=json&agent=' + data.agent).save({}).$promise.then(function (response) {
              const defaultAgentConfiguredConnector = _.find(response.configuration, { default: true });
              if (!CommonUtils.isUndefined(defaultAgentConfiguredConnector)) {
                if (defaultAgentConfiguredConnector.health_status.status === "Available") {
                  loadActiveTab(index);
                  if (!CommonUtils.isUndefined($scope.dataIngestCollectionUUIDs[index])) {
                    $scope.connectorHealthStatus[index] = true;
                    return widgetDataIngestionService.activateIngestionPlaybooks($scope.dataIngestCollectionUUIDs[index])
                      .then(() => {
                        return Promise.resolve();
                      });
                  }
                  else {
                    toaster.error({
                      body: 'The agent configuration found for ' + installedConnector.label + '. Check the health check to configure the data ingestion'
                    });
                    return Promise.reject();
                  }
                }
              }
            });
          }
          else {
            toaster.error({
              body: installedConnector.label + ' connector health check is disconnected. Health check must be available to proceed.'
            });
            loadActiveTab(index);
            return Promise.reject();
          }
        });
      } else {
        toasterMessage = installedConnector.label + ' connector doesn\'t have a default configuration';
        toaster.error({ body: toasterMessage });
        loadActiveTab(index);
        return Promise.reject(); // Reject to break the chain
      }
    }

    function configFieldChanged(deletedParams) {
      _deleteConfigKeys(deletedParams, $scope.ingestMethodActions.ingestionPlaybook.fetchPlaybook);
    }

    function _deleteConfigKeys(deletedConfigParams, samplePlaybookData) {
      angular.forEach(deletedConfigParams, function (param) {
        delete samplePlaybookData.steps[$scope.configIndex].arguments[param];
      });
    }

    function moveToConfigureConnector() {
      $scope.selectedFeedConnectorName = fortiGuardConnectorName;
      $scope.fetchingAvailableConnectors = false;
      $scope.installedConnectors = $scope.feedConnectors.filter(connector => connector.installed === true && connector.selectConnector === true);
      const fortiGuardConnector = _.find($scope.installedConnectors, { label: fortiGuardConnectorName });
      const filteredConnectors = _.filter($scope.installedConnectors, connector => connector.label !== fortiGuardConnectorName);
      const sortedConnectors = _.sortBy(filteredConnectors, 'label');
      $scope.installedConnectors = [fortiGuardConnector].concat(sortedConnectors);
      $scope.loadingStates = [];
      $scope.healthyConnectors = [];
      $scope.isScheduleCreated = [];
      $scope.connectorHealthStatus = [];
      $scope.connectorParamsStatus = [];
      $scope.installedConnectors.reduce((promise, installedConnector, index) => {
        return promise.then(() => {
          $scope.loadingStates[index] = false;
          installedConnector.health = false;
          $scope.healthyConnectors[index] = false;
          $scope.isScheduleCreated[index] = false;
          $scope.connectorHealthStatus[index] = false;
          $scope.connectorParamsStatus[index] = false;
          return _loadConnectorAgents(installedConnector, index);
        });
      }, Promise.resolve()) // Start with a resolved promise
        .then(() => {
          console.log('All connectors have been processed.');
        })
        .catch(error => {
          console.error('Error processing connectors:', error);
        });
      loadActiveTab($scope.params.activeTab);
      WizardHandler.wizard('timSolutionpackConfigWizard').next();
    }

    function _loadConnectorAgents(installedConnector, index) {
      let defer = $q.defer();
      connectorService.getAgents(installedConnector).then(function (installedAgents) {
        $scope.connectorInstalledOnAgents[index] = installedAgents;
        //handle toggleAgentMode function promise
        defer.resolve(installedAgents);
      });
      return defer.promise;
    }

    //function to create widget definition to embed the required widgets with current data 
    function createWidgetDefinition() {
      let defer = $q.defer();
      $scope.widgetProcessing = true;
      widgetService.getInstalledWidgets().then(function (widgets) {
        angular.forEach(widgets, function (widget) {
          if (widget.name === 'feedConfigurationSettings') {
            $scope.widgetDefinition['feedConfigurationSettings'] = widgetTemplateService.generateWidgetDefinition(widget);
            $scope.model['feedConfigurationSettings'] = {
              config: { 'title': 'Feed Configuration Settings', 'embedded': true }
            };
          }
        });
        defer.resolve();
      });
      return defer.promise;
    }

    //provide i18n support
    function _handleTranslations() {
      return new Promise(function (resolve, reject) {
        let widgetData = {
          name: $scope.config.name,
          version: $scope.config.version
        };
        let widgetNameVersion = widgetUtilityService.getWidgetNameVersion(widgetData);
        if (widgetNameVersion) {
          widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
            $scope.viewWidgetVars = {
              // Create your translating static string variables here
              WZ_LABEL_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_LABEL_TITLE'),
              START_PAGE_WZ_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_WZ_TITLE'),
              START_PAGE_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_TITLE'),
              START_PAGE_DISCRIPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_DISCRIPTION'),
              START_PAGE_PREREQUISITIES_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_PREREQUISITIES_TITLE'),
              START_PAGE_PREREQUISITIES: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_PREREQUISITIES'),
              START_PAGE_INSTALL_CONNECTOR: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_INSTALL_CONNECTOR'),
              START_PAGE_BUTTON: widgetUtilityService.translate('threatIntelManagementConfiguration.START_PAGE_BUTTON'),

              WZ_SELECT_FEED_INTG_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_TITLE'),
              WZ_SELECT_FEED_INTG_DISCRIPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_DISCRIPTION'),
              WZ_SELECT_FEED_INTG_DEFAUL_FEED_SOURCE_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_DEFAUL_FEED_SOURCE_TITLE'),
              WZ_SELECT_FEED_INTG_DEFAUL_FEED_SOURCE_DISCRIPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_DEFAUL_FEED_SOURCE_DISCRIPTION'),
              WZ_SELECT_FEED_INTG_FEED_SOURCE_NAME: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_FEED_SOURCE_NAME'),
              WZ_SELECT_FEED_INTG_FEED_SOURCE_INSTALLED: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_FEED_SOURCE_INSTALLED'),
              WZ_SELECT_FEED_INTG_FEED_SOURCE_VERSION: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_FEED_SOURCE_VERSION'),
              WZ_SELECT_FEED_INTG_FEED_SOURCE_PUBLISHED: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_FEED_SOURCE_PUBLISHED'),
              WZ_SELECT_FEED_INTG_FEED_SOURCE_CERT: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_FEED_SOURCE_CERT'),
              WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_TITLE'),
              WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_DISCRIPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_DISCRIPTION'),
              WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_SEARCH: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_ADDITIONAL_FEED_SOURCE_SEARCH'),
              WZ_SELECT_FEED_INTG_BACK_BTN: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_BACK_BTN'),
              WZ_SELECT_FEED_INTG_NEXT_BTN: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_SELECT_FEED_INTG_NEXT_BTN'),


              WZ_INSTALL_FEED_INTG_WZ_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_WZ_TITLE'),
              WZ_INSTALL_FEED_INTG_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_TITLE'),
              WZ_INSTALL_FEED_INTG_DISCRIPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_DISCRIPTION'),
              WZ_INSTALL_FEED_INTG_CONNECTOR_COUNT: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_CONNECTOR_COUNT'),
              WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_1'),
              WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_2'),
              WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_3: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_CONNECTOR_INSTALLATION_STATUS_3'),
              WZ_INSTALL_FEED_INTG_NEXT_SPINNER: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_NEXT_SPINNER'),
              WZ_INSTALL_FEED_INTG_NEXT: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_NEXT'),
              WZ_INSTALL_FEED_INTG_BACK: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_INSTALL_FEED_INTG_BACK'),

              WZ_CONFIG_FEED_WZ_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_WZ_TITLE'),
              WZ_CONFIG_FEED_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_TITLE'),
              WZ_CONFIG_FEED_SECTION_TOGGLE_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_SECTION_TOGGLE_1'),
              WZ_CONFIG_FEED_SECTION_TOGGLE_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_SECTION_TOGGLE_2'),
              WZ_CONFIG_FEED_CONFIG_NAME: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_CONFIG_NAME'),
              WZ_CONFIG_FEED_SECTION_TOGGLE_3: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_SECTION_TOGGLE_3'),
              WZ_CONFIG_FEED_SAVE_BUTTON: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_SAVE_BUTTON'),
              WZ_CONFIG_FEED_SAVEING_BUTTON: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_SAVEING_BUTTON'),
              WZ_CONFIG_FEED_BACK: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_BACK'),
              WZ_CONFIG_FEED_NEXT_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_NEXT_1'),
              WZ_CONFIG_FEED_NEXT_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_FEED_NEXT_2'),

              WZ_CONFIG_RULES_WZ_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_RULES_WZ_TITLE'),
              WZ_CONFIG_RULES_BACK: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_RULES_BACK'),
              WZ_CONFIG_RULES_NEXT: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_CONFIG_RULES_NEXT'),

              WZ_FINISH_WZ_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_WZ_TITLE'),
              WZ_FINISH_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_TITLE'),
              WZ_FINISH_SUMMARY: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY'),
              WZ_FINISH_SUMMARY_HEADING_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_1'),
              WZ_FINISH_SUMMARY_HEADING_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_2'),
              WZ_FINISH_SUMMARY_HEADING_ENABLED: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_ENABLED'),
              WZ_FINISH_SUMMARY_HEADING_DISABLED: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_DISABLED'),
              WZ_FINISH_SUMMARY_HEADING_RULE_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_1'),
              WZ_FINISH_SUMMARY_HEADING_RULE_1_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_1_1'),
              WZ_FINISH_SUMMARY_HEADING_RULE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE'),
              WZ_FINISH_SUMMARY_HEADING_RULE_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_2'),
              WZ_FINISH_SUMMARY_HEADING_RULE_2_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_2_1'),
              WZ_FINISH_SUMMARY_HEADING_RULE_2_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_2_2'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_1'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_2'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_3: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_3'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_4: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_4'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_a: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_a'),
              WZ_FINISH_SUMMARY_HEADING_RULE_3_b: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_SUMMARY_HEADING_RULE_3_b'),
              WZ_FINISH_DISCRIPTION_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_DISCRIPTION_1'),
              WZ_FINISH_DISCRIPTION_2_1: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_DISCRIPTION_2_1'),
              WZ_FINISH_DISCRIPTION_2_2: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_DISCRIPTION_2_2'),
              WZ_FINISH_DISCRIPTION_2_3: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_DISCRIPTION_2_3'),
              WZ_FINISH_BACK: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_BACK'),
              WZ_FINISH_NEXT: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_FINISH_NEXT'),

              DIRECTIVE_MSG_CONFIRM_DI_SCH: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_MSG_CONFIRM_DI_SCH'),
              DIRECTIVE_NO_OPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_NO_OPTION'),
              DIRECTIVE_YES_OPTION: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_YES_OPTION'),
              DIRECTIVE_CONFIG_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CONFIG_TITLE'),
              DIRECTIVE_TIME_BY: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_TIME_BY'),
              DIRECTIVE_CRON_VALUE: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE'),
              DIRECTIVE_CRON_VALUE_HR: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE_HR'),
              DIRECTIVE_CRON_VALUE_DAILY: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE_DAILY'),
              DIRECTIVE_CRON_VALUE_WEEKLY: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE_WEEKLY'),
              DIRECTIVE_CRON_VALUE_MONTHLY: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE_MONTHLY'),
              DIRECTIVE_CRON_VALUE_YEARLY: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_CRON_VALUE_YEARLY'),
              DIRECTIVE_MINUTE_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_MINUTE_LABEL'),
              DIRECTIVE_HOUR_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_HOUR_LABEL'),
              DIRECTIVE_MONTH_DAY_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_MONTH_DAY_LABEL'),
              DIRECTIVE_MONTH_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_MONTH_LABEL'),
              DIRECTIVE_WEEK_DAY_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_WEEK_DAY_LABEL'),
              DIRECTIVE_TIMEZONE_LABEL: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_TIMEZONE_LABEL'),
              DIRECTIVE_TIMEZONE_TOOLTIP: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_TIMEZONE_TOOLTIP'),
              DIRECTIVE_SAVE_BUTTON: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_SAVE_BUTTON'),
              DIRECTIVE_BTN_SAVING_SPINNER: widgetUtilityService.translate('threatIntelManagementConfiguration.DIRECTIVE_BTN_SAVING_SPINNER'),
            };
            resolve();  // Resolve the promise once translations are set
          }).catch(function (error) {
            reject(error);  // Reject the promise if there's an error with checking translation mode
          });
        }
        else {
          $timeout(function () {
            cancel();
            reject("Widget name version not found");
          }, 100)
        }
      });
    }

    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }
  }
})();