/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('editThreatIntelManagementConfiguration110Ctrl', editThreatIntelManagementConfiguration110Ctrl);

    editThreatIntelManagementConfiguration110Ctrl.$inject = ['$scope', '$uibModalInstance', 'config', '$timeout', 'widgetUtilityService'];

    function editThreatIntelManagementConfiguration110Ctrl($scope, $uibModalInstance, config, $timeout, widgetUtilityService) {
        $scope.cancel = cancel;
        $scope.save = save;
        $scope.config = config;

        function cancel() {
            $uibModalInstance.dismiss('cancel');
        }

        function save() {
            $uibModalInstance.close($scope.config);
        }
        //provide i18n support
        function _handleTranslations() {
            let widgetData = {
                name: $scope.config.name,
                version: $scope.config.version
            };
            let widgetNameVersion = widgetUtilityService.getWidgetNameVersion(widgetData);
            if (widgetNameVersion) {
                widgetUtilityService.checkTranslationMode(widgetNameVersion).then(function () {
                    $scope.editWidgetVars = {
                        // Create your translating static string variables here
                        WZ_EDIT_TITLE: widgetUtilityService.translate('threatIntelManagementConfiguration.WZ_EDIT_TITLE'),
                    };
                });
            }
            else {
                $timeout(function () {
                    cancel();
                }, 100)
            }
        }

        function init() {
            _handleTranslations();
        }
        init();
    }
})();
