(function () {
  angular
    .module('cybersponse')
    .controller('editUserAssignments200Ctrl', editUserAssignments200Ctrl);
  editUserAssignments200Ctrl.$inject = ['$scope', 'appModulesService', '$uibModalInstance', 'config', 'Entity', '$state', 'ViewTemplateService', 'localStorageService', 'Field', 'MMD', 'Query'];
  function editUserAssignments200Ctrl($scope, appModulesService, $uibModalInstance, config, Entity, $state, ViewTemplateService, localStorageService, Field, MMD, Query) {
    $scope.cancel = cancel;
    $scope.save = save;
    $scope.removeModule = removeModule;
    $scope.config = config;
    $scope.config.toggleEnable = $scope.config.toggleEnable ? $scope.config.toggleEnable : false;
    $scope.processing = true;
    $scope.page = $state.params.page;
    $scope.expressions = angular.copy(ViewTemplateService.getConfigInputs());
    appModulesService.load(true).then(function (modules) {
      $scope.modules = modules;
    }
    ).finally(function () {
      $scope.processing = false;
    });
    $scope.$watch('config.resources', function (oldValue, newValue) {
      if ($scope.config.resources && oldValue !== newValue) {
        loadAttributes();
      }
    });

    function loadAttributes() {
      $scope.config.filters = [];
      angular.forEach($scope.config.resources, function (item) {
        var tmp = {
        };
        var entity = new Entity(item);
        entity.loadFields().then(function () {
          for (var key in entity.fields) {
            if (entity.fields[key].type === 'datetime') {
              entity.fields[key].type = 'datetime.quick';
            }
          }
          tmp.resource = item;
          tmp.fields = entity.getFormFields();
          tmp.fieldsArray = entity.getFormFieldsArray();
        });
        $scope.config.filters.push(tmp);
      });
    }

    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }
    function save() {
      if ($scope.userForm.$invalid) {
        $scope.userForm.$setTouched();
        $scope.userForm.$focusOnFirstError();
        return;
      }
      angular.forEach($scope.config.query, function (item) {
        item.aggregates = [
          {
            "operator": "count",
            "field": "uuid",
            "alias": "rCount"
          }
        ];
      });
      $uibModalInstance.close($scope.config);
    }

    function _createField() {
      $scope.selectedLookupField = new Field({
        'title': 'Select User',
        'name' : 'userTileAssignedTo',
        'writable': true,
        'required': true,
        'dataSource': {
          'model': 'people',
            'query': {
              'filters': []
            }
          }
        }
      );
      var modelMetadatas = localStorageService.get(MMD.MODEL_METADATAS_KEY);
      angular.forEach(modelMetadatas, function (metadata) {
        if ('people' === metadata.type) {
          $scope.selectedLookupField.displayTemplate = metadata.displayName;
        }
      });
    }

    function removeModule(resource) {
      delete $scope.config.query[resource.type];
    }

    function _init() {
      loadAttributes();
      _createField();
    }
    _init();
  }
}
)();
