class HmacValidationException(Exception):
    """
    Base error class for HMAC validation failures
    """
    def __init__(self):
        Exception.__init__(self, 'An error occurred in HMAC validation')


class MalformedAuthorizationHeader(HmacValidationException):
    """
    The Authorization header does not start with CS or is not properly
    base64 encoded
    """
    def __init__(self):
        Exception.__init__(self, 'Malformed Authorization header')


class HmacSignatureExpired(HmacValidationException):
    """
    The timestamp in the HMAC request is beyond the time threshold
    """
    def __init__(self):
        Exception.__init__(self, 'HMAC signature has expired')


class KeyModulusNotMatching(HmacValidationException):
    """
    The modulus for the public/private keys does not match
    """
    def __init__(self):
        Exception.__init__(self, 'Modulus for HMAC keys does not match')


class InvalidFingerprint(HmacValidationException):
    """
    The fingerprint built did not match the fingerprint provided
    """
    def __init__(self):
        Exception.__init__(self, 'Could not validate HMAC fingerprint')
