import unittest

from freezegun import freeze_time

from cshmac.utils import (
    HmacFingerprintBuilder,
)

CURRENT_TIME = '2015-12-10 11:59:01'
PUBKEY = 'pubkey'
PRIVATEKEY = 'privatekey'


@freeze_time(CURRENT_TIME)
class TestHmacAuth(unittest.TestCase):

    def setUp(self):
        self.public_key = PUBKEY
        self.private_key = PRIVATEKEY
        self.request_time = CURRENT_TIME
        self.full_uri = 'example.com/api'
        self.request_method = 'GET'

    def test_build_hmac_fingerprint(self):
        expected_fingerprint = \
            '721bf443a2a039aa086c9381b48d939f5a7350698c917fa27db7d067a6ea5800'

        builder = HmacFingerprintBuilder(self.private_key,
                                         self.request_time,
                                         self.full_uri,
                                         self.request_method,
                                         self.public_key)

        self.assertEqual(expected_fingerprint, builder.build())
