/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers$Caller;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;

public final class XmlReportWriter {
    public final void output(ConfigurationResolveReport configurationResolveReport, String[] stringArray, OutputStream outputStream) {
        Object object;
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not known on your jvm", unsupportedEncodingException);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        ModuleRevisionId moduleRevisionId = configurationResolveReport.getModuleDescriptor().getModuleRevisionId();
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<?xml-stylesheet type=\"text/xsl\" href=\"ivy-report.xsl\"?>");
        printWriter.println("<ivy-report version=\"1.0\">");
        printWriter.println("\t<info");
        printWriter.println("\t\torganisation=\"" + XMLHelper.escape(moduleRevisionId.getOrganisation()) + "\"");
        printWriter.println("\t\tmodule=\"" + XMLHelper.escape(moduleRevisionId.getName()) + "\"");
        printWriter.println("\t\trevision=\"" + XMLHelper.escape(moduleRevisionId.getRevision()) + "\"");
        if (moduleRevisionId.getBranch() != null) {
            printWriter.println("\t\tbranch=\"" + XMLHelper.escape(moduleRevisionId.getBranch()) + "\"");
        }
        Object object2 = moduleRevisionId.getExtraAttributes().entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            printWriter.println("\t\textra-" + object.getKey() + "=\"" + XMLHelper.escape(object.getValue().toString()) + "\"");
        }
        printWriter.println("\t\tconf=\"" + XMLHelper.escape(configurationResolveReport.getConfiguration()) + "\"");
        printWriter.println("\t\tconfs=\"" + XMLHelper.escape(StringUtils.join(stringArray, ", ")) + "\"");
        printWriter.println("\t\tdate=\"" + Ivy.DATE_FORMAT.format(configurationResolveReport.getDate()) + "\"/>");
        printWriter.println("\t<dependencies>");
        object2 = new ArrayList(configurationResolveReport.getModuleRevisionIds());
        object = configurationResolveReport.getModuleIds().iterator();
        while (object.hasNext()) {
            ModuleId moduleId = (ModuleId)object.next();
            printWriter.println("\t\t<module organisation=\"" + XMLHelper.escape(moduleId.getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(moduleId.getName()) + "\">");
            Iterator iterator = configurationResolveReport.getNodes(moduleId).iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode = (IvyNode)iterator.next();
                this.ouputRevision(configurationResolveReport, printWriter, (List)object2, ivyNode);
            }
            printWriter.println("\t\t</module>");
        }
        printWriter.println("\t</dependencies>");
        printWriter.println("</ivy-report>");
        printWriter.flush();
    }

    private void ouputRevision(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, List list, IvyNode ivyNode) {
        Object object;
        ModuleDescriptor moduleDescriptor = null;
        if (ivyNode.getModuleRevision() != null) {
            moduleDescriptor = ivyNode.getModuleRevision().getDescriptor();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (ivyNode.isLoaded()) {
            stringBuffer.append(" status=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getDescriptor().getStatus()));
            stringBuffer.append("\" pubdate=\"");
            stringBuffer.append(Ivy.DATE_FORMAT.format(new Date(ivyNode.getPublication())));
            stringBuffer.append("\" resolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getResolver().getName()));
            stringBuffer.append("\" artresolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getArtifactResolver().getName()));
            stringBuffer.append("\"");
        }
        if (ivyNode.isEvicted(configurationResolveReport.getConfiguration())) {
            object = ivyNode.getEvictedData(configurationResolveReport.getConfiguration());
            if (((IvyNodeEviction$EvictionData)object).getConflictManager() != null) {
                stringBuffer.append(" evicted=\"").append(XMLHelper.escape(((IvyNodeEviction$EvictionData)object).getConflictManager().toString())).append("\"");
            } else {
                stringBuffer.append(" evicted=\"transitive\"");
            }
            stringBuffer.append(" evicted-reason=\"").append(XMLHelper.escape(((IvyNodeEviction$EvictionData)object).getDetail() == null ? "" : ((IvyNodeEviction$EvictionData)object).getDetail())).append("\"");
        }
        if (ivyNode.hasProblem()) {
            stringBuffer.append(" error=\"").append(XMLHelper.escape(ivyNode.getProblem().getMessage())).append("\"");
        }
        if (moduleDescriptor != null && moduleDescriptor.getHomePage() != null) {
            stringBuffer.append(" homepage=\"").append(XMLHelper.escape(moduleDescriptor.getHomePage())).append("\"");
        }
        Map map2 = moduleDescriptor != null ? moduleDescriptor.getExtraAttributes() : ivyNode.getResolvedId().getExtraAttributes();
        object = map2.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map2.get(string).toString())).append("\"");
        }
        object = ivyNode.getDescriptor() != null ? " default=\"" + ivyNode.getDescriptor().isDefault() + "\"" : "";
        int n = list.indexOf(ivyNode.getResolvedId());
        printWriter.println("\t\t\t<revision name=\"" + XMLHelper.escape(ivyNode.getResolvedId().getRevision()) + "\"" + (ivyNode.getResolvedId().getBranch() == null ? "" : " branch=\"" + XMLHelper.escape(ivyNode.getResolvedId().getBranch()) + "\"") + stringBuffer + " downloaded=\"" + ivyNode.isDownloaded() + "\"" + " searched=\"" + ivyNode.isSearched() + "\"" + (String)object + " conf=\"" + XmlReportWriter.toString(ivyNode.getConfigurations(configurationResolveReport.getConfiguration())) + "\"" + " position=\"" + n + "\">");
        if (moduleDescriptor != null) {
            License[] licenseArray = moduleDescriptor.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                String string = licenseArray[i].getUrl() != null ? " url=\"" + XMLHelper.escape(licenseArray[i].getUrl()) + "\"" : "";
                printWriter.println("\t\t\t\t<license name=\"" + XMLHelper.escape(licenseArray[i].getName()) + "\"" + string + "/>");
            }
        }
        IvyNode ivyNode2 = ivyNode;
        PrintWriter printWriter2 = printWriter;
        if (ivyNode2.getModuleRevision() != null) {
            ArtifactOrigin artifactOrigin;
            MetadataArtifactDownloadReport metadataArtifactDownloadReport = ivyNode2.getModuleRevision().getReport();
            printWriter2.print("\t\t\t\t<metadata-artifact");
            printWriter2.print(" status=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getDownloadStatus().toString()) + "\"");
            printWriter2.print(" details=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getDownloadDetails()) + "\"");
            printWriter2.print(" size=\"" + metadataArtifactDownloadReport.getSize() + "\"");
            printWriter2.print(" time=\"" + metadataArtifactDownloadReport.getDownloadTimeMillis() + "\"");
            if (metadataArtifactDownloadReport.getLocalFile() != null) {
                printWriter2.print(" location=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getLocalFile().getAbsolutePath()) + "\"");
            }
            printWriter2.print(" searched=\"" + metadataArtifactDownloadReport.isSearched() + "\"");
            if (metadataArtifactDownloadReport.getOriginalLocalFile() != null) {
                printWriter2.print(" original-local-location=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getOriginalLocalFile().getAbsolutePath()) + "\"");
            }
            if ((artifactOrigin = metadataArtifactDownloadReport.getArtifactOrigin()) != null) {
                printWriter2.print(" origin-is-local=\"" + String.valueOf(artifactOrigin.isLocal()) + "\"");
                printWriter2.print(" origin-location=\"" + XMLHelper.escape(artifactOrigin.getLocation()) + "\"");
            }
            printWriter2.println("/>");
        }
        XmlReportWriter.outputEvictionInformation(configurationResolveReport, printWriter, ivyNode);
        XmlReportWriter.outputCallers(configurationResolveReport, printWriter, ivyNode);
        XmlReportWriter.outputArtifacts(configurationResolveReport, printWriter, ivyNode);
        printWriter.println("\t\t\t</revision>");
    }

    private static void outputEvictionInformation(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        Collection collection;
        if (ivyNode.isEvicted(configurationResolveReport.getConfiguration()) && (collection = ivyNode.getEvictedData(configurationResolveReport.getConfiguration()).getSelected()) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IvyNode ivyNode2 = (IvyNode)iterator.next();
                printWriter.println("\t\t\t\t<evicted-by rev=\"" + XMLHelper.escape(ivyNode2.getResolvedId().getRevision()) + "\"/>");
            }
        }
    }

    private static void outputCallers(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        IvyNodeCallers$Caller[] ivyNodeCallers$CallerArray = ivyNode.getCallers(configurationResolveReport.getConfiguration());
        for (int i = 0; i < ivyNodeCallers$CallerArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            Map map2 = ivyNodeCallers$CallerArray[i].getDependencyDescriptor().getExtraAttributes();
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map2.get(string).toString())).append("\"");
            }
            printWriter.println("\t\t\t\t<caller organisation=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getModuleRevisionId().getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getModuleRevisionId().getName()) + "\"" + " conf=\"" + XMLHelper.escape(XmlReportWriter.toString(ivyNodeCallers$CallerArray[i].getCallerConfigurations())) + "\"" + " rev=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getAskedDependencyId$53b7e4ab().getRevision()) + "\"" + " rev-constraint-default=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getDependencyDescriptor().getDependencyRevisionId().getRevision()) + "\"" + " rev-constraint-dynamic=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getDependencyDescriptor().getDynamicConstraintDependencyRevisionId().getRevision()) + "\"" + " callerrev=\"" + XMLHelper.escape(ivyNodeCallers$CallerArray[i].getModuleRevisionId().getRevision()) + "\"" + stringBuffer + "/>");
        }
    }

    private static void outputArtifacts(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getDownloadReports(ivyNode.getResolvedId());
        printWriter.println("\t\t\t\t<artifacts>");
        for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
            printWriter.print("\t\t\t\t\t<artifact name=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getName()) + "\" type=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getType()) + "\" ext=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getExt()) + "\"");
            Map map2 = artifactDownloadReportArray[i].getArtifact().getExtraAttributes();
            Object object = map2.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                printWriter.print(" extra-" + string + "=\"" + XMLHelper.escape(map2.get(string).toString()) + "\"");
            }
            printWriter.print(" status=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadStatus().toString()) + "\"");
            printWriter.print(" details=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadDetails()) + "\"");
            printWriter.print(" size=\"" + artifactDownloadReportArray[i].getSize() + "\"");
            printWriter.print(" time=\"" + artifactDownloadReportArray[i].getDownloadTimeMillis() + "\"");
            if (artifactDownloadReportArray[i].getLocalFile() != null) {
                printWriter.print(" location=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getLocalFile().getAbsolutePath()) + "\"");
            }
            if ((object = artifactDownloadReportArray[i].getArtifactOrigin()) != null) {
                printWriter.println(">");
                printWriter.println("\t\t\t\t\t\t<origin-location is-local=\"" + String.valueOf(((ArtifactOrigin)object).isLocal()) + "\"" + " location=\"" + XMLHelper.escape(((ArtifactOrigin)object).getLocation()) + "\"/>");
                printWriter.println("\t\t\t\t\t</artifact>");
                continue;
            }
            printWriter.println("/>");
        }
        printWriter.println("\t\t\t\t</artifacts>");
    }

    private static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(", ");
        }
        return XMLHelper.escape(stringBuffer.toString());
    }
}

