'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('accessControlCtrl', accessControlCtrl);

    accessControlCtrl.$inject = ['$scope', 'FormEntityService', '$resource', 'API', 'ALL_RECORDS_SIZE', '_', 'Field', 'toaster', 'currentPermissionsService', '$state', '$uibModal', 'ModalService', 'websocketService', '$filter', '$rootScope', 'usersService'];

    function accessControlCtrl($scope, FormEntityService, $resource, API, ALL_RECORDS_SIZE, _, Field, toaster, currentPermissionsService, $state, $uibModal, ModalService, websocketService, $filter, $rootScope, usersService) {
      $scope.entity = FormEntityService.get();
      if (!$scope.entity) {
        toaster.warning({
          body: 'No record was found to assign owners to. This widget must be added in a detail view.'
        });
        return;
      }
      $scope.cancelAddUserInput = cancelAddUserInput;
    	$scope.submitField = FormEntityService.submitField;
      $scope.securityCanUpdate = currentPermissionsService.availablePermission('security', 'update');
      $scope.securityCanRead = currentPermissionsService.availablePermission('security', 'read');
      if (!$scope.securityCanRead) {
        return;
      }
      $scope.viewType = 'all';
      $scope.records = {
        owners: [],
        userOwners: []
      };
      $scope.fieldOptions = {
        renderWidget: 'toManyList',
        highlightMode: $scope.config.inlineEditor
      };
      
      $scope.showAllFilters = $scope.entity.userOwnable && $scope.entity.ownable;
      if(!$scope.showAllFilters){
        $scope.filterType = $scope.entity.userOwnable ? 'user' : 'team';
      }
      
      $scope.widgetThemeColor = getThemeColors($rootScope.theme);
      var modalInstance;
      var recordIri = API.BASE + $scope.entity.name + '/' + $scope.entity.id;
      if ($scope.entity.ownable) {
        loadOwners();
      }
      if ($scope.entity.userOwnable) {
        loadUserOwners();
      }
      createFields();
      
      var subscriptions = [{'module': 'userOwners'}, {'module': 'owners'}];
      var webSockets = [];

      $scope.$on('websocket:reconnect',function(){
        initWebsocket();
      });

      function initWebsocket(webSocket){
        if(webSocket){
          websocketService.subscribe($state.params.module + '/' + $state.params.id + '/' + webSocket.module, function(data) {
            if($filter('getEndPathName')(data.entityUuid[0]) === $state.params.id && data.operation === 'update'){
              if(webSocket.module === 'teams'){
                loadOwners();
              } else {
                loadUserOwners();
              }
            }
          }).then(function(data){
            subscriptions[webSocket.module + '_module'] = data;
          });
         } else {
           if ($scope.entity.ownable) {
             loadOwners();
           }
           if ($scope.entity.userOwnable) {
             loadUserOwners();
           }
         }
      }

      $scope.$on('$destroy', function() {
        if(subscriptions){
          // Unsubscribe
          angular.forEach(subscriptions, function(k, v){
            websocketService.unsubscribe(subscriptions[k]);
          });
        }
      });
      
      $scope.toggleViewType = function(type) {
        $scope.viewType = type;
      }
      
      function loadUserOwners() {
        return $resource(recordIri + '/userOwners').get({
          $limit: ALL_RECORDS_SIZE
        }).$promise.then(function(response) {
          angular.forEach(response['hydra:member'], function(record){
            record.display = record.firstname + ' ' + record.lastname;
            usersService.getAvatar(record.avatar, false).then(function (avatarImgSrc) {
              record.profileImgSrc = avatarImgSrc;
            });
          });
          $scope.records.userOwners = response['hydra:member'];
          $scope.userLookupField.value = response['hydra:member'];
          initWebsocket({'module': 'people'});
        });
      }
      
      function loadOwners() {
        return $resource(recordIri + '/owners').get({
          $limit: ALL_RECORDS_SIZE
        }).$promise.then(function(response) {
          angular.forEach(response['hydra:member'], function(record){
            record.display = record.name;
          });
          $scope.records.owners = response['hydra:member'];
          $scope.teamLookupField.value = response['hydra:member'];
          initWebsocket({'module': 'teams'});
        });
      }
      
      function createFields() {
        var userLookupField = new Field({
          formType: 'manyToMany',
          title: 'Individual Owners',
          dataSource: {
            model: 'people'
          },
          name: 'userOwners',
          visibility: true,
          writeable: true
        });
        userLookupField.displayTemplate = '{{ firstname }} {{ lastname }}';
        $scope.userLookupField = userLookupField;
        
        var teamLookupField = new Field({
          formType: 'manyToMany',
          title: 'Team Owners',
          dataSource: {
            model: 'teams'
          },
          name: 'owners',
          visibility: true,
          writeable: true
        });
        teamLookupField.displayTemplate = '{{ name }}';
        $scope.teamLookupField = teamLookupField;
      }
      
      function cancelAddUserInput() {
        $scope.showAddInput = false;
      }
      
      $scope.assignTeamUser = function (assignType) {
        $scope.assignType = assignType;
        $scope.placeholder = 'Add ' + assignType;
        $scope.fieldData = assignType === 'user' ? angular.copy($scope.userLookupField) : angular.copy($scope.teamLookupField);

        modalInstance = $uibModal.open({
          animation: false,
          templateUrl: 'widgets/accessControl/widgetAssets/html/assignTeamUser.html',
          windowClass: 'assign-team-user-modal',
          backdrop: 'static',
          scope: $scope
        });
      };
      
      $scope.unassignTeamUser = function (fieldData, type) {
        var message = 'Are you sure you want to remove this ' + type + '?';
        ModalService.confirm(message).then(function(result) {
          if (!result) {
            return;
          }
          
        	var updateType = type === 'User' ? 'userOwners' : 'owners';
          
          var ids = _.pluck($scope.records[updateType], '@id');
          var index = ids.indexOf(fieldData['@id']);
          if (index > -1) {
            $scope.records[updateType].splice(index, 1);
          }
          
        	var updateValue = {};
          updateValue[updateType] = $scope.records[updateType];
        	$scope.submitField(updateValue);
          
        });
      }
      
      $scope.saveAssignedTeamUser = function (assignType, fieldData) {
        var updateType = assignType === 'user' ? 'userOwners' : 'owners';
        var updateValue = {};
        updateValue[updateType] = fieldData.value;
        $scope.records[updateType] = fieldData.value;
        $scope.submitField(updateValue);
        $scope.exit();
      };
      
      $scope.exit = function () {
        modalInstance.close('cancel');
      };
      
      
      function getThemeColors(theme){ 
        var widgetThemeColor = {};
        if(theme.id === 'light') {
          widgetThemeColor.borderColor = '#e0dede';
        } else if(theme.id === 'steel') {
          widgetThemeColor.borderColor = '#0d1218';
        } else {
          widgetThemeColor.borderColor = '#000000';
        }
        return widgetThemeColor;
      }
      
    }
})(); 
