'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('editRecordSummaryCtrl', editRecordSummaryCtrl);

    editRecordSummaryCtrl.$inject = ['$scope', '$uibModalInstance', 'config', 'Entity', 'appModulesService', '$rootScope', '$state', 'toaster', '_'];
  function editRecordSummaryCtrl($scope, $uibModalInstance, config, Entity, appModulesService, $rootScope, $state, toaster, _) {
    
    $scope.cancel = cancel;
    $scope.save = save;
    $scope.config = config;
    $scope.loadModuleFields = loadModuleFields;
    $scope.addBlockType = addBlockType;
    $scope.removeBlock = removeBlock;
    $scope.widgetThemeColor = getThemeColors($rootScope.theme);
    
    appModulesService.load(true).then(function(modules) {
      $scope.modulesList = modules;
    });
    
    if($scope.config){
      if($scope.config.blocks && $scope.config.blocks.length > 0) {
        angular.forEach($scope.config.blocks, function(block){
          if((block.type === 'related_record_count' || block.type === 'field_value_display') && block.module){
            loadModuleFields(block, block.module);
          } else if (block.type === 'time_elapsed'){
            loadModuleFields(block, $state.params.module);
          }
        });
      } else {
        $scope.config.blocks = [];
      }
    }
    
    function addBlockType(){
      if($scope.config.blocks.length < 4){
        var newBlock = {'type': angular.copy($scope.blockType)};
        $scope.config.blocks.push(newBlock);
        if ($scope.blockType === 'time_elapsed'){
          loadModuleFields(newBlock, $state.params.module);
        }
        $scope.blockType = '';
      } else {
        toaster.info({
          body: 'Maximum number of widget blocks, 04 reached. Please remove a block to add another one.'
        });
      }
    }
    
    function removeBlock(block){
      $scope.config.blocks.splice($scope.config.blocks.indexOf(block), 1);
    }
    
    function loadModuleFields(block, blockModule) {
      var entity = new Entity(blockModule);
      block.picklistFields = [];
      block.dateFields = [];
      entity.loadFields().then(function() {
        for (var key in entity.fields) {
          if (entity.fields[key].type === 'picklist'){
            block.picklistFields.push(entity.fields[key]);
          } else if (entity.fields[key].type === 'datetime') {
            block.dateFields.push(entity.fields[key]);
          }
        }
      });
    }
    
    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }
    
    function save() {
      var config = angular.copy($scope.config)
      config.blocks.forEach(function(block){
        if(block.picklistFields){
          delete block.picklistFields;
        }
        if(block.dateFields){
          delete block.dateFields;
        }
      });
      $uibModalInstance.close(config);
    }
    
    function getThemeColors(theme){ 
      var widgetThemeColor = {};
      widgetThemeColor.cardColor = '#c42323';
      if(theme.id === 'light') {
        widgetThemeColor.summaryBorderColor = '#57616f';
        widgetThemeColor.borderColor = '#e0dede';
      } else if(theme.id === 'steel') {
        widgetThemeColor.summaryBorderColor = '#57616f';
        widgetThemeColor.borderColor = '#0d1218';
      } else {
        widgetThemeColor.summaryBorderColor = '#57616f';
        widgetThemeColor.borderColor = '#000000';
      }
      return widgetThemeColor;
    }
  }
}
)();