'use strict';
(function () {
    angular
        .module('cybersponse')
        .controller('recordSummaryCtrl', recordSummaryCtrl);

    recordSummaryCtrl.$inject = ['$scope', 'config', 'Modules', '$state', '_', 'ALL_RECORDS_SIZE', '$q', 'websocketService', '$rootScope'];
  function recordSummaryCtrl($scope, config, Modules, $state, _, ALL_RECORDS_SIZE, $q, websocketService, $rootScope) {
    
    var subscriptions = [];
    var webSockets = [];
    $scope.config = config;
    $scope.processing = false;
    $scope.loading = false;
    $scope.isConfigUndefined = false;
    $scope.widgetThemeColor = getThemeColors($rootScope.theme);
    
    $scope.$on('websocket:reconnect',function(){
      initWebsocket();
    });

    function initWebsocket(webSocket){
      if(webSocket){
        var moduleName = webSocket.module;
        websocketService.subscribe($state.params.module + '/' + $state.params.id + '/' + moduleName, function(data) {
          if(data.sourceWebsocketId !== websocketService.getWebsocketSessionId()){
            init();
          }
        }).then(function(data){
          subscriptions.push(data);
        });
        websocketService.subscribe(moduleName, function(data) {
          if(data.sourceWebsocketId !== websocketService.getWebsocketSessionId()){
            if(data.operation === "update" && data.changeData.indexOf(webSocket.field) > -1){
              var records = _.find(webSocket.records, function(record){
                return data.entityUuid.indexOf(record['@id']) > -1;
              });
              if(records){
                init();
              }
            }
          }
        }).then(function(data){
          subscriptions.push(data);
        });
       } else {
         init();
       }
    }
    
    $scope.$on('$destroy', function() {
      if(subscriptions){
        // Unsubscribe
        angular.forEach(subscriptions, function(subscription){
          websocketService.unsubscribe(subscription);
        });
      }
    });
    
    init();
    
    function init(){
      $scope.processing = true;
    	webSockets = [];
      subscriptions = [];
      angular.forEach(config.blocks, function(block){
        if(block.type === 'time_elapsed'){
          loadModuleData([block.dateField, block.closedDateField]).then(function(moduleData) {
            block.timeElapsed = secondsToString(moduleData[block.dateField], moduleData[block.closedDateField]);
          });
        }
        else if((block.type === 'related_record_count') && block.module){
          loadModuleData(block.picklistField.name, block.module, true).then(function(moduleData) {
          	block.moduleCount = moduleData['hydra:totalItems'];
            if(block.fieldValue && moduleData['hydra:member'].length > 0){
              block.selectedFieldData = _.find(block.picklistField.options, function(option){
                return option['@id'] === block.fieldValue;
              });
              block.selectedField = _.filter(moduleData['hydra:member'], function(collection) {
                if(collection[block.picklistField.name] && collection[block.picklistField.name]['@id']){
                  return collection[block.picklistField.name]['@id'] === block.fieldValue;
                }
              });
            } else {
              block.selectedFieldData = undefined;
              block.selectedField = undefined;
            }
          }, function(error) {
          	block.moduleCount = 0;
            block.selectedFieldData = undefined;
            block.selectedField = undefined;
      		});
        } else if(block.type === 'field_value_display' && block.module){
          loadModuleData(block.picklistField.name, block.module, true).then(function(moduleData) {
            if(block.fieldValues && block.fieldValues.length > 0){
              block.selectedFieldData = [];
              angular.forEach(moduleData['hydra:member'], function(record){
                if(record.type && block.fieldValues.indexOf(record.type['@id']) !== -1){
                	block.selectedFieldData.push(record.type);
                }
              });
              if(block.selectedFieldData.length > 0){
                block.selectedFieldData = _.uniq(block.selectedFieldData, false, function(field) {
                  return field['@id'];
                });
              }
            } else {
              block.selectedFieldData = [];
              angular.forEach(moduleData['hydra:member'], function(record){
                if(record.type){
                	block.selectedFieldData.push(record.type);
                }
              });
              if(block.selectedFieldData.length > 0){
                block.selectedFieldData = _.uniq(block.selectedFieldData, false, function(field) {
                  return field['@id'];
                });
              }
            }
          });
        }
      });
    }
    
    function loadModuleData(field, module, subscribeWebsocket) {
      var deferred = $q.defer();
      var params;
      if(module) {
        params = {
          module: $state.params.module,
          id: $state.params.id,
          fieldName: module,
          $relationships: true,
          $limit: ALL_RECORDS_SIZE,
          $count_only: true,
          __selectFields: [field]
        };
      } else {
        params = {
          module: $state.params.module,
          id: $state.params.id,
          __selectFields: field
        };
      }
      Modules.get(params).$promise.then(function(data) {
        $scope.processing = false;
        $scope.loading = false;
        if(subscribeWebsocket){
        	initWebsocket({'module': module, 'field': field, 'records': data['hydra:member']});
        }
        deferred.resolve(data);
      }, function(error){
        deferred.reject(error);
      });
      
      return deferred.promise;
    }
    
    function secondsToString(createDate, closedDate){
      
     var currentDatetime = (new Date().getTime())/1000;
     var value = closedDate ? closedDate - createDate : currentDatetime - createDate;
      
     var units = {
        'd': 24*60*60,
        'h': 60*60,
		'm': 60,
      };

      var result = [];

      for(var name in units) {
        var p =  Math.floor(value/units[name]);
        if(p === 1){result.push(p + name);}
        if(p >= 2){result.push(p + name);}
        value %= units[name];
      }

      return result.toString().replace(/\,/g, ' ');
    }
    
    function getThemeColors(theme){ 
      var widgetThemeColor = {};
      widgetThemeColor.cardColor = '#c42323';
      if(theme.id === 'light') {
        widgetThemeColor.summaryBorderColor = '#dcdcdc';
        widgetThemeColor.borderColor = '#e0dede';
      } else if(theme.id === 'steel') {
        widgetThemeColor.summaryBorderColor = '#29333e';
        widgetThemeColor.borderColor = '#0d1218';
      } else {
        widgetThemeColor.summaryBorderColor = '#262626';
        widgetThemeColor.borderColor = '#000000';
      }
      return widgetThemeColor;
    }
    
  }
}
)();