'use strict';
(function () {
  angular
    .module('cybersponse')
    .controller('editTaskManagementCtrl', editTaskManagementCtrl);
  editTaskManagementCtrl.$inject = ['$scope', '$uibModalInstance', 'config', 'Entity', 'appModulesService', 'taskManagementService', '$rootScope'];
  function editTaskManagementCtrl($scope, $uibModalInstance, config, Entity, appModulesService, taskManagementService, $rootScope) {
    
    $scope.cancel = cancel;
    $scope.save = save;
    $scope.config = config;
    $scope.taskModuleChanged = taskModuleChanged;
    $scope.taskThemeColor = taskManagementService.getThemeColors($rootScope.theme);
    
    appModulesService.load(true).then(function(modules) {
      $scope.modulesList = modules;
      $scope.config.selectedModule = 'tasks';
      taskModuleChanged();
    });
    
    function taskModuleChanged() {
      var entity = new Entity($scope.config.selectedModule);
      $scope.userField = [];
      $scope.picklistField = [];
      $scope.dateField = [];
      entity.loadFields().then(function() {
        for (var key in entity.fields) {
          if (entity.fields[key].type === 'datetime') {
            entity.fields[key].type = 'datetime.quick';
            $scope.dateField.push(entity.fields[key]);
          }
          else if (entity.fields[key].model === 'people' && entity.fields[key].type !== 'manyToMany') {
            $scope.userField.push(entity.fields[key]);
          }
          else if (entity.fields[key].type === 'picklist'){
            $scope.picklistField.push(entity.fields[key]);
          }
        }
        $scope.filterFields = angular.copy($scope.picklistField);
        $scope.filterFields = $scope.filterFields.concat($scope.userField);
        $scope.fieldsArray = entity.getFormFieldsArray();
      });
    }
    
    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }
    
    function save() {
      $uibModalInstance.close($scope.config);
    }
  }
}
)();
