(function () {
  angular
    .module('cybersponse')
    .controller('editUserAssignmentsCtrl', editUserAssignmentsCtrl);

  editUserAssignmentsCtrl.$inject = ['$scope', 'appModulesService', '$uibModalInstance', 'config', 'Entity'];

  function editUserAssignmentsCtrl($scope, appModulesService, $uibModalInstance, config, Entity) {
    $scope.cancel = cancel;
    $scope.save = save;
    $scope.config = config;
    $scope.processing = true;

    appModulesService.load(true).then(function (modules) {
      $scope.modules = modules;
    }).finally(function () {
      $scope.processing = false;
    });

    $scope.$watch('config.resources', function (oldValue, newValue) {
      if ($scope.config.resources && oldValue !== newValue) {
        loadAttributes();
      }
    });

    function loadAttributes() {
      $scope.config.filters = [];
      angular.forEach($scope.config.resources, function (item) {
        var tmp = {};
        var entity = new Entity(item);
        entity.loadFields().then(function () {
          for (var key in entity.fields) {
            if (entity.fields[key].type === 'datetime') {
              entity.fields[key].type = 'datetime.quick';
            } 
          }
          tmp.resource = item;
          tmp.fields = entity.getFormFields();
          tmp.fieldsArray = entity.getFormFieldsArray();
        });
        
        $scope.config.filters.push(tmp); 
      });
    }

    function cancel() {
      $uibModalInstance.dismiss('cancel');
    }

    function save() {
      angular.forEach($scope.config.query, function(item){
        item.aggregates =  [
        {
          "operator": "count",
          "field": "uuid",
          "alias": "rCount"
        }];
      
      });
      $uibModalInstance.close($scope.config);
    }

    function _init() {
      loadAttributes();
    }

    _init();


  }
})();