(function() {
  angular
    .module('cybersponse')
    .controller('userAssignmentsCtrl', userAssignmentsCtrl);
    
  userAssignmentsCtrl.$inject = ['$scope', 'usersService', '$resource', 'API', 'Query', '$q'];
  
  function userAssignmentsCtrl($scope, usersService, $resource, API, Query, $q) {
    $scope.result = [];
    $scope.collapsed = $scope.page !== undefined && $scope.page.toLowerCase() !== 'dashboard'  && $scope.page.toLowerCase() !== 'reporting';
    
    function loadData() {
      var defer = $q.defer();
      var consolidatedResult = [];
      angular.forEach($scope.config.query, function(key, value){
        var tmp = {};
        var query = new Query(key);
        $scope.processing = true;
        $resource(API.QUERY + value).save(query.getQuery(true)).$promise.then(function(result) {
          if (result['hydra:member']) {
            tmp.name = value;
            tmp.count = result['hydra:member'][0].rCount;
            consolidatedResult.push(tmp);
          }
          $scope.processing = false;
        }, defer.reject);
      });
      defer.resolve(consolidatedResult);
      
      return defer.promise;
      
    }
    
    function loadAvatar() {
      var user = usersService.getCurrentUser();
      $resource(API.BASE + 'avatars').get().$promise.then(function(result){
      if (result) {
        angular.forEach(result['hydra:member'], function(item){
          if (item['@id'] === user.avatar) {
            $scope.imageData = item.file.data;
          }
        });
      }});
      
    }
    
    
    function _init() {
      loadAvatar();
      var loadDataPromise = loadData();
      
      loadDataPromise.then(function(result){
        $scope.result = result;
      });
      
    }
    
    _init();
    
  }
})();