(function () {
  angular
    .module('cybersponse')
    .controller('userAssignmentsCtrl', userAssignmentsCtrl);
  userAssignmentsCtrl.$inject = ['$scope', 'usersService', '$resource', 'API', 'Query', '$q', 'config', '$state', '$interpolate', 'localStorageService', 'User', '$filter'];
  function userAssignmentsCtrl($scope, usersService, $resource, API, Query, $q, config, $state, $interpolate, localStorageService, User, $filter) {
    $scope.result = [];
    $scope.collapsed = $scope.page !== undefined && $scope.page.toLowerCase() !== 'dashboard' && $scope.page.toLowerCase() !== 'reporting';
    var userId;
    if (config.toggleEnable) {
      var interpolateObject = JSON.parse($state.params.qparam);
      userId = $interpolate(config.jinjaValue)(interpolateObject);
      if (userId.includes('api/3')) {
        userId = $filter('getEndPathName')(userId);
      }
    }
    else {
      if (config.defaultLookupValue['@id'].indexOf('currentUserIri') > -1) {
        var storedCurrentUser = localStorageService.get(API.API_3_BASE + API.CURRENT_ACTOR);
        userId = $filter('getEndPathName')(storedCurrentUser['@id']);
      }
      else {
        userId = $filter('getEndPathName')(config.defaultLookupValue['@id']);
      }
    }
    function loadData() {
      var defer = $q.defer();
      var consolidatedResult = [];
      angular.forEach($scope.config.query, function (key, value) {
        var tmp = {};
        var query = new Query(key);

        $scope.processing = true;
        $resource(API.QUERY + value).save(query.getQuery(true)).$promise.then(function (result) {
          if (result['hydra:member']) {
            tmp.name = value;
            tmp.count = result['hydra:member'][0].rCount;
            consolidatedResult.push(tmp);
          }
          $scope.processing = false;
        }, defer.reject);
      });
      defer.resolve(consolidatedResult);
      return defer.promise;
    }
    function loadAvatar() {
      $resource(API.BASE + 'people/' + userId).get().$promise.then(function (user) {
        $resource(API.BASE + 'avatars').get().$promise.then(function (result) {
          if (result) {
            angular.forEach(result['hydra:member'], function (item) {
              if (item['@id'] === user.avatar) {
                $scope.imageData = item.file.data;
              }
            });
          }
        });
      });
    }
    function _init() {
      loadAvatar();
      loadData().then(function (result) {
        $scope.result = result;
      });
    }
    _init();
  }
}
)();
