# What's New

## Dashboard Enhancements
- Added a new dashboard **Vulnerability Management** that presents data like *Critical Vulnerabilities*, *Assets Affected by Critical Vulnerabilities*, and *Open Vulnerabilities* for a quick status check and prioritization

## Playbook Enhancements

- Renamed the playbook collection **02 - Use Case - Vulnerability Management** to **10 - SP - Vulnerability Management** for better categorization and identification regarding the functionalities
- Following table lists the playbooks that have been renamed to better communicate the function they perform:

  | Previous Name                    | New Name                                                      |
  |:---------------------------------|:--------------------------------------------------------------|
  | Generate Scan Record             | Scenario -  Fetch Scan Records                                |
  | Generate Assets Record           | Scenario - Create or Update Asset Records for Scan            |
  | Generate Vulnerabilities Records | Scenario - Create or Update Vulnerabilities Records for Asset |
  | Get Vulnerability Details        | Scenario - Get Vulnerability Details                          |

- Following new playbooks have been added to generate alerts for high-risk assets:
  - Fetch High Risk Assets for Scan
  - Create or Update Alert for High Risk Asset
- Following new playbook has been added to automate response:
  - High Risk Vulnerability Response
- Following new playbook creates a ServiceNow incident
  - Asset - Create ServiceNow Ticket

## Picklist Enhancements

- Added a new item *Vulnerable Asset* to the **AlertType** picklist so when creating or modifying alerts users can now select *Vulnerable Asset* as an alert *Type*

## Scan Module Enhancements
- Added new fields *Scan UUID* and *Ingestion Completed* (hidden) in the scan module
- *Scan UUID* field now contains unique values for the scan module

## Vulnerability Module Enhancements
- Vulnerability module's detailed view is now inline with standard FortiSOAR user interface
- *Vulnerability ID* field now contains unique values in the Vulnerability module