# What's New

## Enhancements

- An ICS Advisory is now correlated with asset at *product* level as well, for creating a KEV alert. Earlier, the correlation was only at *Vendor* level.

- A new KVE alert is created for each identified Known Exploited Vulnerability (KEV) CVE under **OT - Vulnerability Management** > **ICS Advisory**.

- Introduced remediation time (SLA) for Alert as per BOD 22-01.

## Playbook Enhancements

- Following playbooks ingest ICS Advisories published by CISA and create records in **OT - Vulnerability Management** > **ICS Advisory**:

    - Ingest CISA ICS Advisory
    - Ingest CISA ICS Medical Advisory

        These playbooks create KEV Alerts if the listed CVEs are found in CISA KEV catalog; and the associated asset, complete with **Vendor** and **Product**, is present in the FortiSOAR&trade; environment.

- **BOD 22-01 - Notify KEV Alert Report** sends notification emails as per the schedule frequency to specified users and days remaining until the SLA breach.

    - The **> Check KEV Alert SLA** playbook checks for *KEV Alert SLA* to notify users.

- Renamed the following playbooks to better convey their functionality:
    - *Create or Link CVEs* is now **Correlate CVEs and Assets**
    - *Create KEV Alert On Advisory* is now **Create KEV Alert (On Advisory Update)**
    - *Create KEV Alert* is now **Create KEV Alert (Manual trigger)**
    - *Create Task On KEV Alert* is now **>> Create KEV Alert and Related Tasks**

## Schedule Enhancements

- Following schedules can be triggered daily to ingest ICS advisories published by CISA:

    - Ingest CISA ICS Advisory

    - Ingest CISA ICS Medical Advisory

- **BOD 22-01: Notify KEV Alert Summary Report**: Sends notification emails as per the schedule frequency to specified users and days remaining until the SLA breach.

    <table>
            <th>NOTE</th>
            <td>These schedules have to be reviewed and activated manually.</td>
    </table>

## Module Enhancements

- Following new fields have been added to the the **KEV Alert** module to enhance reporting and SLA management:
    - `SSVC`
    - `Closed On`
    - `Response Due Date`

- Following new enhancements have been added to the the **ICS Advisory** module to specify if the advisory type is *ICS Medical Advisory* or an *ICS Advisory*:
    - The field `Advisory Type`
    - The picklist `Advisory Type`

- Following SVTs were enhanced to accommodate the module changes:
    - `ICS Advisory` List and Detail View.
    - `KEV Alert` Detail and Detail View.

- Added a visibility condition for the field `Vulnerability Assignment`, under the module **KEV Alert**, to become visible if it doesn't contain `null` values.

<!-- ## Connector Enhancements

- Following new connectors have been :
    - **CISA Advisory**
    - **Fuzzy Search** -->

## Dashboard Enhancements

- Introduced a new dashboard ***Binding Operational Directive (BOD) 22-01*** contains visualizations aimed to better track the **BOD 22-01** directive.

- Following new views have been introduced under **Critical Advisories and Asset Risk**:
    - Top 10 Vulnerabilities Within Devices
    - Devices By Exploited CVEs
    - Exploited CVEs Within Devices

- Following new views have been introduced under **ICS CERT Advisories - Overview**:
    - ICS Advisory Overview
    - Affected Advisories in Environment
    - Critical Assets In Environment
    - Advisories by CVSS Severity By Year

## Deprecated

- The **Ingest KEV CVEs** schedule and related playbooks are no longer a part of **OT-Vulnerability Management**.
    
    The schedule and related playbooks are now a part of [Vulnerability Management v2.1.0](https://fortisoar.contenthub.fortinet.com//detail.html?entity=vulnerabilityManagement&version=2.1.0&type=solutionpack).

- Removed the following playbooks:
    - Ingest ICS Advisory CSV File From URL
    - Ingest Advisory Through CSV File
    - Create ICS Advisory Record
    - On ICS Attachment Creation

- Removed the schedule **Ingest ICS Advisory**

- Following dashboards have been removed:

    - Renamed *Critical Advisory Alerts In Environment* to *8Exploited Vulnerabilities In Environment- To Be Remediated** and moved under **Binding Operational Directive (BOD) 22-01**

- Removed the view *Known Exploited Advisories* from the **Critical Advisories and Asset Risk** dashboard.

- Removed the views *Known Exploited CVEs* and *Critical Advisories In Environment* from the **ICS CERT Advisories - Overview** dashboard.

## Bugfixes

- Changed the following filter for the widget **Assets At Risk Of Exploitation** under the dashboard *Critical Advisories and Asset Risk*

    - Removed the condition `ICS Advisories` -> `Is In Kev` -> `Yes`
    - Added the condition `ICS Advisories` -> `Id` -> `Is Null` -> `False`

        This change was done to appropriately capture the targeted information.

## Known Issue

The schedule **BOD 22-01: Notify KEV Alert Summary Report** creates the alert summary report containing the UUID of the admin user *csadmin* instead of the user who triggered the schedule.

In cases where the user *csadmin* does not exist, the triggered schedule fails even if there exists a user with exact same permissions as *csadmin*.

### Workaround

To avoid this issue, users have to create a new schedule. In the new schedule, select the **Notify BOD 22-01 SLA and Report** playbook, from the **Playbook** drop-down list.

For information on how to create a new schedule refer to [Working with Schedules](https://docs.fortinet.com/document/fortisoar/7.4.3/user-guide/915083/schedules#Working_with_Schedules) in platform documentation.
