# What's New

## Enhancement

- New Playbooks:
    - **Ingest CISA ICS Advisory**
    - **Ingest CISA ICS Medical Advisory**
    >**Note:** Above playbooks ingests `ICS Advisory` and `ICS Medical Advisory` published by CISA and creates records in **ICS Advisory**. The assets (in an environment) get correlated once Advisory records are created based on its vendor and product details. **KEV Alert** record get created if any `CVEs` found in Known Exploited Vulnerability (KEV) Catalog.
    - **Notify for SLA and Report**, playbook notify for BOD 22-01 KEV Alert SLA remaining time and report.
    - **> Check KEV Alert SLA**, playbook check for KEV Alert SLA to notify.

- New Schedules:
    - **Ingest CISA ICS Advisory**, triggered daily to ingest ICS Advisory
    - **Ingest CISA ICS Medical Advisory**, triggered daily to ingest ICS Medical Advisory

- New Fields:
    - `SSVC`, `Closed On`, and `Response Due Date` in **KEV Alert** module.
    - `Advisory Type` in **ICS Advisory** module and picklist `Advisory Type` for same.

- New connector:
    - **CISA Advisory**
    - **Fuzzy Search**

- SVT changes:
    - `ICS Advisory` List and Detail View.
    - `KEV Alert` Detail and Detail View.

- Dashboard:
  - Introduced new dashboard for Directive `BOD 22-01` ***Binding Operational Directive (BOD) 22-01***
  - Introduced new view `Top 10 Vulnerabilities Within Devices`, `Exploited CVE In Year 2021 By Severity`, `Exploited CVE In Year 2022 By Severity`, `Exploited CVE In Year 2023 By Severity`, `Exploited CVE In Year 2024 By Severity`, and `Exploited CVE In Year 2025 By Severity` under **Critical Advisories and Asset Risk**
  - Introduced new view `ICS Advisory Overview`, `Critical Assets In Environment`, `Advisories by CVSS Severity By Year` under **ICS CERT Advisories - Overview**
  - Introduced new view `Affected Advisories In Environment` under **ICS CERT Advisories - Overview**

- Added field visibility condition for the **KEV Alert** field `Vulnerability Assignment` if they are not null.

- Renamed playbooks:
    - **Create or Link CVEs** to **Correlate CVEs and Assets**
    - **Create KEV Alert On Advisory** to **Create KEV Alert (On Advisory Update)**
    - **Create KEV Alert** to **Create KEV Alert (Manual)**
    - **Create Task On KEV Alert** to **>> Create KEV Alert and Related Tasks**

- Deep down to "product" level correlation of asset with ICS Advisory, and Alert creation for same.

- Now KEV Alert gets created for each Known Exploited Vulnerability (KEV) CVE under advisory.

- Introduced remediation time (SLA) for Alert as per BOD 22-01.

## Depreciated

- Moved `Ingest KEV CVEs` schedule and related playbook to solution pack `Vulnerability Management v2.1.0`.
- Removed following playbook:
    - **Ingest ICS Advisory CSV File From URL**
    - **Ingest Advisory Through CSV File**
    - **Create ICS Advisory Record**
    - **On ICS Attachment Creation**
- Removed `Ingest ICS Advisory` schedule.
- Dashboard:
  - Renamed `Critical Advisory Alerts In Environment` to `Exploited Vulnerabilities In Environment- To Be Remediated` and moved under **Binding Operational Directive (BOD) 22-01**
  - Changed filter for widget `Assets At Risk Of Exploitation` from `ICS Advisories` -> `Is In Kev` -> `Yes` to `ICS Advisories` -> `Id` -> `Is Null` -> `False`
  - Removed `Known Exploited Advisories` from **Critical Advisories and Asset Risk**
  - Removed `Known Exploited CVEs`, and `Critical Advisories In Environment` from **ICS CERT Advisories - Overview**
