import { DatePipe } from '@angular/common';
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild, inject } from '@angular/core';
import { TranslocoService } from '@jsverse/transloco';
import { AgGridAngular } from 'ag-grid-angular';
import { difference, merge } from 'lodash-es';
import { ToastrService } from 'ngx-toastr';
import { catchError, concatMap, forkJoin, isObservable, of } from 'rxjs';
import { ApiService, DEFAULT_CACHE_BLOCK_SIZE, DEFAULT_GRID_ROWS, ModalService, Query } from "shared";
import { GridColumnService } from './services/grid-column.service';
import { GridReferenceService } from './services/grid-reference.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "ag-grid-angular";
import * as i4 from "./custom-grid-header/custom-grid-header.component";
const _c0 = a0 => ({ "custom-grid-header": a0 });
const _c1 = () => [];
function GridComponent_div_0_lib_custom_grid_header_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "lib-custom-grid-header", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("component", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent)("componentData$", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderData$);
} }
function GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "button", 10);
    i0.ɵɵlistener("click", function GridComponent_div_0_div_3_ng_container_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.refresh()); });
    i0.ɵɵelement(2, "i", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template, 1, 2, "xf-button-group", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) && (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons == null ? null : ctx_r1.gridConfig.options.buttons.length));
} }
function GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", ctx_r1.selectButtons || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template, 1, 2, "xf-button-group", 12);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngIf", ctx_r1.selectButtons == null ? null : ctx_r1.selectButtons.length);
} }
function GridComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8);
    i0.ɵɵtemplate(1, GridComponent_div_0_div_3_ng_container_1_Template, 4, 1, "ng-container", 9)(2, GridComponent_div_0_div_3_ng_template_2_Template, 1, 1, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const recordSelection_r4 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.selectedRows.length === 0)("ngIfElse", recordSelection_r4);
} }
function GridComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
    i0.ɵɵtemplate(2, GridComponent_div_0_lib_custom_grid_header_2_Template, 1, 2, "lib-custom-grid-header", 4)(3, GridComponent_div_0_div_3_Template, 4, 2, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "ag-grid-angular", 6);
    i0.ɵɵlistener("gridReady", function GridComponent_div_0_Template_ag_grid_angular_gridReady_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridReady($event)); })("firstDataRendered", function GridComponent_div_0_Template_ag_grid_angular_firstDataRendered_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onFirstDataRendered($event)); })("gridSizeChanged", function GridComponent_div_0_Template_ag_grid_angular_gridSizeChanged_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridSizeChanged($event)); })("rowDataUpdated", function GridComponent_div_0_Template_ag_grid_angular_rowDataUpdated_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onRowDataUpdated($event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0, ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.enableSelectMenu);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("w-100 ", ctx_r1.gridClass, "");
    i0.ɵɵproperty("columnDefs", ctx_r1.columnDefs)("gridOptions", ctx_r1.gridOptions)("serverSideDatasource", ctx_r1.dataSource)("selectionColumnDef", ctx_r1.selectionColumnDef)("animateRows", true)("suppressContextMenu", ctx_r1.suppressContextMenu)("overlayNoRowsTemplate", ctx_r1.noRowsTemplate);
} }
export class GridComponent {
    constructor(themeService, changeDetectorRef) {
        this.themeService = themeService;
        this.changeDetectorRef = changeDetectorRef;
        this.customColumnDefs = [];
        this.suppressContextMenu = false;
        this.rowSelectionChanged = new EventEmitter();
        this.gridQuery = new Query();
        this.gridColumnService = inject(GridColumnService);
        this.gridReferenceService = inject(GridReferenceService);
        this.modalService = inject(ModalService);
        this.apiService = inject(ApiService);
        this.toasterService = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
        this.datePipe = inject(DatePipe);
        this.contextId = '';
        this.gridClass = 'ag-theme-alpine';
        this.selectedRows = [];
        this.selectButtons = [];
        this.selectionColumnDef = {
            suppressHeaderMenuButton: false,
            pinned: 'left',
        };
        this.columnDefs = [];
        this.currentRowHeight = 0;
        this.minRowHeight = 0;
        this.noRowsTemplate = '';
    }
    onGridReady(params) {
        this.contextId = this.gridConfig.uuid || this.dataSource.entity.type;
        this.gridApi = params.api;
        if (this.gridConfig.options?.onRegisterApi) {
            this.gridConfig.options?.onRegisterApi(this.gridApi);
        }
        this.minRowHeight = params.api.getSizesForCurrentTheme().rowHeight;
        this.currentRowHeight = this.minRowHeight;
        window.onresize = () => {
            this.gridApi.sizeColumnsToFit();
        };
        this.dataSource.selectedRows.forEach((uuid) => {
            const rowNode = this.gridApi.getRowNode(uuid);
            rowNode?.setSelected(true);
        });
        this.gridReferenceService.refresh$.subscribe(() => {
            this.refresh();
        });
    }
    onFirstDataRendered(params) {
        this.updateGridRowsHeight(params);
    }
    onGridSizeChanged(params) {
        this.updateGridRowsHeight(params);
    }
    onRowDataUpdated(params) {
        this.updateGridRowsHeight(params);
    }
    updateGridRowsHeight(params) {
        //Calculate the height of the grid and available parent height to fit all the grid rows scrollable
        if (this.gridConfig.options?.adjustGridRowHeight) {
            let pagingPanel = document.querySelector('.ag-paging-panel');
            let headerPanel = document.querySelector('.ag-header');
            let gridWrapper = document.querySelector('.grid-wrapper');
            let gridActionsContainer = document.querySelector('.grid-actions-container');
            let customGridHeight = 15; //Adjust the extra height
            if (!pagingPanel || !headerPanel || !gridWrapper || !gridActionsContainer) {
                return;
            }
            let gridHeight = gridWrapper.clientHeight - (gridActionsContainer.clientHeight + customGridHeight + pagingPanel.clientHeight + headerPanel.clientHeight);
            let renderedRowCount = params.api.getDisplayedRowCount();
            if (renderedRowCount * this.minRowHeight >= gridHeight) {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + gridHeight + 'px');
            }
            else {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + (renderedRowCount * this.minRowHeight) + 'px');
            }
        }
    }
    ngOnInit() {
        this.columnDefs = this.gridColumnService.create(this.dataSource.entity?.fields, this.gridConfig.configuration.query, this.gridConfig.configuration.columns, false, this.customColumnDefs, this.dataSource.entity.defaultSort);
        this.columnDefs = this.columnDefs.map((colDef) => {
            if (colDef.field === this.gridConfig.configuration.nameColumn) {
                colDef.pinned = 'left';
                colDef.suppressMovable = true;
                colDef.lockPosition = true;
                colDef.lockVisible = true;
            }
            return colDef;
        });
        this.gridOptions = this.mapGridOptions();
        let selectButtons = [];
        if (this.gridConfig.options?.selectButtons?.length) {
            selectButtons = this.gridConfig.options.selectButtons;
        }
        if (this.gridConfig.options?.allowDelete) {
            let deleteButton = this.createDeleteButton();
            selectButtons.push(deleteButton);
        }
        this.selectButtons = selectButtons;
        this.setTheme(this.themeService.getTheme());
        this.themeService.themeChanged.subscribe((theme) => this.setTheme(theme));
        this.noRowsTemplate = `<span class="margin-top-40px">${this.translocoService.translate('errors.error_no_records')}</span>`;
    }
    createDeleteButton() {
        return {
            id: 'delete',
            text: '',
            tooltip: 'Delete',
            iconClass: 'fa fa-trash-can fa-light',
            onClick: () => { this.deleteSelected(); },
            class: 'btn btn-secondary',
            visible: true
        };
    }
    deleteSelected() {
        let entityName = this.selectedRows.length > 1 ? this.dataSource.entity.descriptions.plural : this.dataSource.entity.descriptions.singular;
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            entityName: `${this.dataSource.entity.descriptions.singular}(s)`
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.uuid);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid).pipe(catchError((error) => {
                    return of(error.error?.errors[0]?.detail);
                })));
            });
            return forkJoin(observables$);
        })).subscribe((responses) => {
            let successfulDeletions = responses.filter((error) => error === null).length;
            const deletionErrors = responses.length - successfulDeletions;
            if (deletionErrors > 0) {
                this.toasterService.warning(this.translocoService.translate('components.grid.partialDeletedToast', {
                    successful: successfulDeletions,
                    errors: deletionErrors,
                    length: this.selectedRows.length,
                    entityName: entityName
                }));
            }
            else {
                this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                    length: this.selectedRows.length, entityName: entityName
                }), 'Success');
            }
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.rowSelectionChanged.emit(this.selectedRows);
            this.refresh();
        });
    }
    setTheme(theme) {
        this.gridClass = theme === 'dark' ? 'ag-theme-alpine-dark' : 'ag-theme-alpine';
        this.changeDetectorRef.detectChanges();
    }
    mapGridOptions() {
        let columnTypes = this.gridColumnService.getDefaultColumnTypes();
        columnTypes = merge(columnTypes, this.gridConfig.options?.customColumnTypes || {});
        let dataTypeDefinitions = this.gridColumnService.getDefaultDataTypeDefinitions();
        dataTypeDefinitions = merge(dataTypeDefinitions, this.gridConfig.options?.customDataTypeDefinitions || {});
        let processCellCallback = (params) => this.processCellCallback(params);
        let gridOptions = {
            defaultColDef: this.gridColumnService.getDefaultColumnDef(),
            processCellForClipboard: processCellCallback,
            defaultCsvExportParams: {
                processCellCallback: processCellCallback,
            },
            defaultExcelExportParams: {
                processCellCallback: processCellCallback,
            },
            onCellClicked: (event) => {
                if (this.gridConfig.options?.onView && !event.colDef.cellRendererParams?.suppressCellClick) {
                    this.gridConfig.options.onView(event);
                }
            },
            onSelectionChanged: (event) => {
                const selectionState = event.api.getServerSideSelectionState();
                let uuids = [];
                if (selectionState.selectAll) {
                    const allNodes = event.api.getRenderedNodes().map((node) => node.data.uuid) || [];
                    uuids = difference(allNodes, selectionState.toggledNodes);
                }
                else {
                    uuids = selectionState.toggledNodes || [];
                }
                this.selectedRows = event.api.getRenderedNodes().filter((node) => uuids.indexOf(node.data.uuid) > -1).map((node) => node.data);
                this.rowSelectionChanged.emit(this.selectedRows);
                this.changeDetectorRef.detectChanges();
            },
            onDisplayedColumnsChanged: (event) => {
                event.api.refreshServerSide();
                event.api.sizeColumnsToFit();
            },
            rowSelection: {
                mode: 'multiRow',
                enableClickSelection: false,
                headerCheckbox: !this.gridConfig.options?.hideCheckboxes,
                checkboxes: !this.gridConfig.options?.hideCheckboxes,
                hideDisabledCheckboxes: true,
            },
            suppressCellFocus: true,
            suppressMenuHide: false,
            columnMenu: 'new',
            pagination: true,
            paginationPageSize: DEFAULT_GRID_ROWS,
            cacheBlockSize: DEFAULT_CACHE_BLOCK_SIZE,
            enableCellTextSelection: this.gridConfig.options?.enableCellTextSelection,
            columnTypes: columnTypes,
            dataTypeDefinitions: dataTypeDefinitions,
            paginationPageSizeSelector: [10, 20, 50, 100, 250],
            suppressServerSideFullWidthLoadingRow: true
        };
        if (this.gridConfig.options?.expandable) {
            gridOptions.masterDetail = true;
            gridOptions.detailCellRenderer = this.gridConfig.options?.detailCellRenderer;
        }
        if (!this.gridConfig.options?.skipRowId) {
            gridOptions.getRowId = (params) => params.data.uuid;
        }
        gridOptions.treeData = this.gridConfig.options?.treeData;
        gridOptions.isServerSideGroup = this.gridConfig.options?.isServerSideGroup;
        gridOptions.getServerSideGroupKey = this.gridConfig.options?.getServerSideGroupKey;
        gridOptions.autoGroupColumnDef = this.gridConfig.options?.autoGroupColumnDef;
        return gridOptions;
    }
    refresh() {
        this.gridApi.refreshServerSide({ route: [], purge: true });
    }
    processCellCallback(params) {
        if (isObservable(params.value)) {
            return getStoredResolvedObservableValue(params.value) || '';
        }
        return params.value;
    }
    static { this.ɵfac = function GridComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridComponent)(i0.ɵɵdirectiveInject(i1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridComponent, selectors: [["xf-grid"]], viewQuery: function GridComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(AgGridAngular, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.agGrid = _t.first);
        } }, inputs: { dataSource: "dataSource", gridConfig: "gridConfig", customColumnDefs: "customColumnDefs", suppressContextMenu: "suppressContextMenu" }, outputs: { rowSelectionChanged: "rowSelectionChanged" }, features: [i0.ɵɵProvidersFeature([])], decls: 1, vars: 1, consts: [["recordSelection", ""], ["class", "grid-wrapper bg-secondary-panel h-100", 4, "ngIf"], [1, "grid-wrapper", "bg-secondary-panel", "h-100"], [1, "d-flex", "padding-top-16px", "grid-actions-container", "margin-bottom-4px", 3, "ngClass"], [3, "component", "componentData$", 4, "ngIf"], ["class", "grid-actions margin-right-16px ms-auto", 4, "ngIf"], ["rowModelType", "serverSide", 3, "gridReady", "firstDataRendered", "gridSizeChanged", "rowDataUpdated", "columnDefs", "gridOptions", "serverSideDatasource", "selectionColumnDef", "animateRows", "suppressContextMenu", "overlayNoRowsTemplate"], [3, "component", "componentData$"], [1, "grid-actions", "margin-right-16px", "ms-auto"], [4, "ngIf", "ngIfElse"], [1, "btn", "btn-sm", "btn-secondary", "mx-2", "float-end", 3, "click"], [1, "fa", "fa-refresh"], [3, "buttons", 4, "ngIf"], [3, "buttons"]], template: function GridComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridComponent_div_0_Template, 5, 15, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.columnDefs && ctx.gridOptions && ctx.dataSource);
        } }, dependencies: [i2.NgClass, i2.NgIf, i1.ButtonGroupComponent, i3.AgGridAngular, i4.CustomGridHeaderComponent], styles: [".grid-expandable-wrapper[_ngcontent-%COMP%]{position:absolute;left:70px;right:0}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper[_ngcontent-%COMP%]   .custom-grid-header[_ngcontent-%COMP%]{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid', changeDetection: ChangeDetectionStrategy.OnPush, providers: [], template: "<div class=\"grid-wrapper bg-secondary-panel h-100\" *ngIf=\"columnDefs && gridOptions && dataSource\">\n  <div class=\"d-flex padding-top-16px grid-actions-container margin-bottom-4px\"\n    [ngClass]=\"{'custom-grid-header' : gridConfig.options?.customGridHeaderComponent}\">\n    <lib-custom-grid-header *ngIf=\"gridConfig.options?.customGridHeaderComponent\"\n      [component]=\"gridConfig.options?.customGridHeaderComponent\"\n      [componentData$]=\"gridConfig.options?.customGridHeaderData$\"></lib-custom-grid-header>\n    <div class=\"grid-actions margin-right-16px ms-auto\" *ngIf=\"gridConfig.options?.enableSelectMenu\">\n      <ng-container *ngIf=\"selectedRows.length === 0; else recordSelection\">\n        <button class=\"btn btn-sm btn-secondary mx-2 float-end\" (click)=\"refresh()\">\n          <i class=\"fa fa-refresh\"></i>\n        </button>\n        <xf-button-group *ngIf=\"gridConfig.options?.buttons && gridConfig.options?.buttons?.length\"\n          [buttons]=\"gridConfig.options?.buttons || []\"></xf-button-group>\n      </ng-container>\n      <ng-template #recordSelection>\n        <xf-button-group *ngIf=\"selectButtons?.length\" [buttons]=\"selectButtons || []\"></xf-button-group>\n      </ng-template>\n    </div>\n  </div>\n  <ag-grid-angular class=\"w-100 {{gridClass}}\" rowModelType=\"serverSide\" [columnDefs]=\"columnDefs\"\n    [gridOptions]=\"gridOptions\" [serverSideDatasource]=\"dataSource\" [selectionColumnDef]=\"selectionColumnDef\"\n    (gridReady)=\"onGridReady($event)\" [animateRows]=\"true\" [suppressContextMenu]=\"suppressContextMenu\"\n    (firstDataRendered)=\"onFirstDataRendered($event)\" (gridSizeChanged)=\"onGridSizeChanged($event)\"\n    (rowDataUpdated)=\"onRowDataUpdated($event)\" [overlayNoRowsTemplate]=\"noRowsTemplate\"></ag-grid-angular>\n</div>\n", styles: [".grid-expandable-wrapper{position:absolute;left:70px;right:0}.grid-wrapper .grid-actions ::ng-deep .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper .grid-actions ::ng-deep .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper .custom-grid-header{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}\n"] }]
    }], () => [{ type: i1.ThemeService }, { type: i0.ChangeDetectorRef }], { agGrid: [{
            type: ViewChild,
            args: [AgGridAngular]
        }], dataSource: [{
            type: Input
        }], gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }], suppressContextMenu: [{
            type: Input
        }], rowSelectionChanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridComponent, { className: "GridComponent", filePath: "src/grid.component.ts", lineNumber: 23 }); })();
const valueByObservable = new WeakMap();
export function storeResolvedObservableValue(observable, value) {
    valueByObservable.set(observable, value);
}
export function getStoredResolvedObservableValue(observable) {
    return valueByObservable.get(observable);
}
//# sourceMappingURL=data:application/json;base64,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