import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import _, { isUndefined } from 'lodash-es';
import { findIndex } from 'lodash-es';
import { combineLatest, concatMap, map, of } from 'rxjs';
import { Entity, Query, SearchableItem } from "shared";
import { AbstractWidgetEditComponent } from 'shared/view-templates';
import { GridColumn } from '../../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/router";
import * as i4 from "../../../services/grid-column.service";
import * as i5 from "@angular/common";
import * as i6 from "ngx-drag-drop";
import * as i7 from "../default-sort/default-sort.component";
import * as i8 from "../grid-columns-editor/grid-columns-editor.component";
function GridEditComponent_div_3_option_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 22);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const module_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", module_r1.type);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(module_r1.descriptions.plural);
} }
function GridEditComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Data Source");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 19)(4, "option", 20);
    i0.ɵɵtext(5, "Select a module");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, GridEditComponent_div_3_option_6_Template, 2, 2, "option", 21);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.formGroup.controls.onlyRelated.value ? ctx_r1.relatedModules : ctx_r1.modules);
} }
function GridEditComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 23);
    i0.ɵɵtext(2, " Records to Include ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 24)(4, "option", 20);
    i0.ɵɵtext(5, "Related Records");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "option", 20);
    i0.ɵɵtext(7, "All Records");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", false);
} }
function GridEditComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, GridEditComponent_div_4_div_1_Template, 8, 2, "div", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.formGroup.controls.onlyRelated);
} }
function GridEditComponent_div_16_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Select Columns");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "xf-grid-columns-editor", 25);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_18_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 31)(1, "div", 32)(2, "span", 33);
    i0.ɵɵelement(3, "i", 34);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 35)(6, "i", 36);
    i0.ɵɵlistener("click", function GridEditComponent_div_18_div_6_Template_i_click_6_listener() { const pbIndex_r5 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.removeActionPlaybook(pbIndex_r5)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const playbook_r6 = ctx.$implicit;
    i0.ɵɵproperty("dndDraggable", playbook_r6);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", playbook_r6.name, " ");
} }
function GridEditComponent_div_18_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Actions");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 26)(4, "xf-searchable-dropdown", 27);
    i0.ɵɵlistener("ngModelChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addActionPlaybook($event)); })("searchQueryChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.filterActionPlaybooks($event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 28);
    i0.ɵɵlistener("dndDrop", function GridEditComponent_div_18_Template_div_dndDrop_5_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onActionsDrop($event)); });
    i0.ɵɵtemplate(6, GridEditComponent_div_18_div_6_Template, 7, 2, "div", 29);
    i0.ɵɵelement(7, "div", 30);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngModel", ctx_r1.actionPlaybook)("clearValueOnSelect", true)("required", false)("items", ctx_r1.actionPlaybookList);
    i0.ɵɵadvance();
    i0.ɵɵproperty("dndHorizontal", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig.configuration.actionPlaybooks);
} }
function GridEditComponent_div_33_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "small", 37);
    i0.ɵɵtext(2, "Select a module above");
    i0.ɵɵelementEnd()();
} }
function GridEditComponent_div_34_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-filter-group", 38);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_35_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "xf-default-sort", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("query", ctx_r1.widgetConfig.configuration.query)("fields", ctx_r1.fields);
} }
export class GridEditComponent extends AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, modelMetadataService, formBuilder, playbookService, router, utilityService, gridColumnService) {
        super(changeDetectorRef, entityService, utilityService);
        this.modelMetadataService = modelMetadataService;
        this.playbookService = playbookService;
        this.router = router;
        this.gridColumnService = gridColumnService;
        this.modules = [];
        this.relatedModules = [];
        this.actionPlaybook = null;
        this.fields = {};
        this.actionPlaybookList = [];
        this.actionPBList = [];
        this.isDetailPage = false;
        this.formGroup = formBuilder.group({
            onlyRelated: [false, Validators.required],
            module: [null, Validators.required],
            onClickState: ['preview', Validators.required],
            rowExpandable: new FormControl(false),
            lightMode: new FormControl(false),
            query: new FormControl({}),
            gridConfig: [null]
        });
        this.isDetailPage = this.router.url.indexOf('/module/') !== -1;
    }
    ngOnInit() {
        this.formGroup.controls.gridConfig.setValue(this.widgetConfig.configuration.columns);
        this.modelMetadataService.getModuleList(false, false).pipe(concatMap((modules) => {
            this.modules = modules;
            if (this.context.module) {
                return this.entityService.build(this.context.module).pipe(concatMap((entity) => {
                    this.entity = entity;
                    return this.initWidgetConfig(this.entity);
                }));
            }
            else {
                return this.initWidgetConfig();
            }
        })).subscribe(() => this.changeDetectorRef.detectChanges());
    }
    moduleChanged(module) {
        this.widgetConfig.configuration.module = module;
        this.entityService.build(module).subscribe((entity) => {
            this.selectedEntity = entity;
            this.widgetConfig.configuration.columns = undefined;
            this.setFields();
            this.changeDetectorRef.detectChanges();
        });
    }
    queryChange(filterGroup) {
        if (!filterGroup) {
            return;
        }
        this.widgetConfig.configuration.query = filterGroup;
    }
    initWidgetConfig(entity) {
        this.widgetConfig.configuration.module = entity ? entity.type : this.widgetConfig.configuration.module;
        let observable$ = of(null);
        if (this.widgetConfig.configuration.module) {
            observable$ = this.entityService.build(this.widgetConfig.configuration.module).pipe(concatMap((entity) => {
                this.selectedEntity = entity;
                this.setFields();
                if (entity) {
                    let relatedModules$ = entity.relationships.map((field) => {
                        if (!field.model) {
                            let entity = new Entity(field.name);
                            entity.descriptions = {
                                singular: field.name,
                                plural: field.name
                            };
                            return of(entity);
                        }
                        return this.entityService.build(field.model);
                    });
                    return combineLatest(relatedModules$).pipe(map((entities) => {
                        this.relatedModules = entities;
                        this.changeDetectorRef.detectChanges();
                    }));
                }
                return of(null);
            }));
        }
        this.widgetConfig.configuration.onClickState = this.widgetConfig.configuration.onClickState || 'preview';
        this.widgetConfig.configuration.query = this.widgetConfig.configuration.query ? plainToInstance(Query, this.widgetConfig.configuration.query) : new Query();
        this.formGroup.controls.onlyRelated.setValue(this.widgetConfig.configuration.onlyRelated);
        this.formGroup.controls.module.setValue(this.widgetConfig.configuration.module || null);
        this.formGroup.controls.onClickState.setValue(this.widgetConfig.configuration.onClickState);
        this.formGroup.controls.query.setValue(this.widgetConfig.configuration.query);
        if (this.isDetailPage) {
            this.formGroup.controls.module.disable();
        }
        this.formGroup.controls.onlyRelated.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onlyRelated = value;
            if (value) {
                const foundRelatedModule = this.relatedModules.find((relatedModule) => relatedModule.type === this.widgetConfig.configuration.module);
                if (this.formGroup.controls.module.value !== foundRelatedModule?.type) {
                    this.formGroup.controls.module.setValue(foundRelatedModule?.type || null);
                }
            }
        });
        this.formGroup.controls.module.valueChanges.subscribe((value) => {
            if (value === null) {
                this.selectedEntity = undefined;
            }
            else {
                this.moduleChanged(value);
            }
        });
        this.formGroup.controls.onClickState.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onClickState = value;
        });
        this.formGroup.controls.query.valueChanges.subscribe((value) => this.queryChange(value));
        // this.changeDetectorRef.detectChanges();
        return observable$;
    }
    rowExpansionChange(event) {
        this.widgetConfig.configuration.rowExpandable = event.target.checked;
    }
    lightModeChange(event) {
        this.widgetConfig.configuration.lightMode = event.target.checked;
    }
    setFields() {
        let fields = this.selectedEntity?.getFormFields();
        this.fields = _.keyBy(fields, 'name');
        this.getActionPlaybooks();
        this.setColumns();
    }
    setColumns() {
        if (isUndefined(this.widgetConfig.configuration.columns) || this.widgetConfig.configuration.columns.length === 0) {
            const gridColumns = this.gridColumnService.create(this.fields, new Query());
            const visibleColumns = gridColumns.filter((column) => !column.hide);
            this.widgetConfig.configuration.columns = [];
            visibleColumns?.forEach((column) => {
                this.widgetConfig.configuration.columns?.push(new GridColumn({
                    name: column.field || '',
                    editable: false,
                    resizable: true,
                    sticky: 'NONE'
                }));
            });
        }
    }
    getActionPlaybooks() {
        this.playbookService.getActionPlaybooks(this.selectedEntity, false, []).subscribe((response) => {
            response.forEach((playbook) => {
                const searchablePB = new SearchableItem(playbook.actionTriggerName, playbook['@id'], playbook.uuid);
                this.actionPlaybookList.push(searchablePB);
                this.actionPBList.push(searchablePB);
            });
            this.widgetConfig.configuration.actionPlaybooks = this.widgetConfig.configuration.actionPlaybooks || [];
        });
    }
    onActionsDrop(event) {
        const foundIndex = findIndex(this.widgetConfig.configuration.actionPlaybooks, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.widgetConfig.configuration.actionPlaybooks[foundIndex];
            this.widgetConfig.configuration.actionPlaybooks.splice(foundIndex, 1);
            this.widgetConfig.configuration.actionPlaybooks.splice(event.index, 0, dragColumn);
        }
    }
    addActionPlaybook(event) {
        if (event !== null) {
            this.widgetConfig.configuration.actionPlaybooks?.push({
                name: event?.display,
                id: event?.value
            });
        }
    }
    removeActionPlaybook(index) {
        this.widgetConfig.configuration.actionPlaybooks?.splice(index, 1);
    }
    filterActionPlaybooks(search) {
        of(this.actionPBList).pipe(map((items) => {
            const pbs = this.widgetConfig.configuration.actionPlaybooks?.map(({ id }) => id);
            return items.filter((item) => {
                return pbs.indexOf(item.value) === -1;
            });
        }), map((items) => {
            return items.filter((item) => {
                return item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.actionPlaybookList = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i1.ModelMetadataService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i1.PlaybookService), i0.ɵɵdirectiveInject(i3.Router), i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i4.GridColumnService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridEditComponent, selectors: [["xf-grid-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 36, vars: 10, consts: [[3, "formGroup"], [1, "row", "mt-3"], [1, "col-md-6"], ["class", "form-group", 4, "ngIf"], ["class", "col-md-6", 4, "ngIf"], [1, "form-group"], ["for", "onClickState", 1, "fw-bold", "col-form-label"], ["formControlName", "onClickState", "id", "onClickState", 1, "form-select"], ["value", "preview"], ["value", "module"], ["for", "row-expansion", 1, "fw-bold"], ["type", "checkbox", "name", "row-expansion", "id", "row-expansion", "formcontrolname", "rowExpandable", 1, "form-check-input", 3, "change", "checked"], [1, "form-check-label", "ps-2"], ["for", "light-mode", 1, "fw-bold"], ["type", "checkbox", "name", "light-mode", "id", "light-mode", "formcontrolname", "lightMode", 1, "form-check-input", 3, "change", "checked"], [1, "col-md-12"], [1, "fw-bold"], [4, "ngIf"], ["class", "row mt-3", 4, "ngIf"], ["formControlName", "module", 1, "form-select"], [3, "ngValue"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"], ["for", "onlyRelated", 1, "fw-bold"], ["formControlName", "onlyRelated", 1, "form-select"], ["formControlName", "gridConfig", 3, "entity"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Select a Manual Trigger Playbook", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "required", "items"], ["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"], [1, "font-italic"], ["formControlName", "query", 3, "entity"], [1, "col-lg-7", "col-md-8", "col-sm-12", 3, "query", "fields"]], template: function GridEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "div", 2);
            i0.ɵɵtemplate(3, GridEditComponent_div_3_Template, 7, 2, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, GridEditComponent_div_4_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div", 1)(6, "div", 2)(7, "div", 5)(8, "label", 6);
            i0.ɵɵtext(9, "Click Action");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(10, "select", 7)(11, "option", 8);
            i0.ɵɵtext(12, "Open in Preview");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "option", 9);
            i0.ɵɵtext(14, "Open in Detail View");
            i0.ɵɵelementEnd()()()()();
            i0.ɵɵelementStart(15, "div", 1);
            i0.ɵɵtemplate(16, GridEditComponent_div_16_Template, 4, 1, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "div", 1);
            i0.ɵɵtemplate(18, GridEditComponent_div_18_Template, 8, 6, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(19, "div", 1)(20, "label", 10)(21, "input", 11);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_21_listener($event) { return ctx.rowExpansionChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(22, "span", 12);
            i0.ɵɵtext(23, "Row Expandable");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(24, "div", 1)(25, "label", 13)(26, "input", 14);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_26_listener($event) { return ctx.lightModeChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(27, "span", 12);
            i0.ɵɵtext(28, "Enable light mode");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(29, "div", 1)(30, "div", 15)(31, "label", 16);
            i0.ɵɵtext(32, "Filters");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(33, GridEditComponent_div_33_Template, 3, 0, "div", 17)(34, GridEditComponent_div_34_Template, 2, 1, "div", 17);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(35, GridEditComponent_div_35_Template, 2, 2, "div", 18);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.entity && !ctx.isDetailPage);
            i0.ɵɵadvance(12);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.gridConfig);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.rowExpandable);
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.lightMode);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", !ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fields);
        } }, dependencies: [i5.NgForOf, i5.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.RequiredValidator, i2.NgModel, i2.FormGroupDirective, i2.FormControlName, i1.FilterGroupComponent, i1.SearchableDropdownComponent, i6.DndDraggableDirective, i6.DndDropzoneDirective, i6.DndHandleDirective, i6.DndPlaceholderRefDirective, i7.DefaultSortComponent, i8.GridColumnsEditorComponent], styles: [".border-grey[_ngcontent-%COMP%]{border:1px solid var(--solid-border-secondary-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-edit', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div [formGroup]=\"formGroup\">\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n        <label class=\"fw-bold\">Data Source</label>\n        <select class=\"form-select\" formControlName=\"module\">\n          <option [ngValue]=\"null\">Select a module</option>\n          <option *ngFor=\"let module of (formGroup.controls.onlyRelated.value ? relatedModules : modules)\"\n            [value]=\"module.type\">{{ module.descriptions.plural }}</option>\n        </select>\n      </div>\n    </div>\n    <div class=\"col-md-6\" *ngIf=\"entity && !isDetailPage\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.onlyRelated\">\n        <label class=\"fw-bold\" for=\"onlyRelated\">\n          Records to Include\n        </label>\n        <select class=\"form-select\" formControlName=\"onlyRelated\">\n          <option [ngValue]=\"true\">Related Records</option>\n          <option [ngValue]=\"false\">All Records</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\">\n        <label for=\"onClickState\" class=\"fw-bold col-form-label\">Click Action</label>\n        <select class=\"form-select\" formControlName=\"onClickState\" id=\"onClickState\">\n          <option value=\"preview\">Open in Preview</option>\n          <option value=\"module\">Open in Detail View</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <!-- Select fields -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.gridConfig\">\n      <label class=\"fw-bold\">Select Columns</label>\n      <xf-grid-columns-editor [entity]=\"selectedEntity\" formControlName=\"gridConfig\"></xf-grid-columns-editor>\n    </div>\n  </div>\n\n  <!-- Select Action Playbooks -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n      <label class=\"fw-bold\">Actions</label>\n      <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n        <xf-searchable-dropdown (ngModelChange)=\"addActionPlaybook($event)\" [ngModel]=\"actionPlaybook\" [clearValueOnSelect]=\"true\"\n          [required]=\"false\" [items]=\"actionPlaybookList\" placeholder=\"+ Select a Manual Trigger Playbook\"\n          (searchQueryChange)=\"filterActionPlaybooks($event)\">\n        </xf-searchable-dropdown>\n      </div>\n      <div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\"\n        (dndDrop)=\"onActionsDrop($event)\">\n        <div *ngFor=\"let playbook of widgetConfig.configuration.actionPlaybooks; let pbIndex = index\"\n          [dndDraggable]=\"playbook\" dndEffectAllowed=\"move\" class=\"card d-inline-block p-2 m-2\">\n          <div class=\"card-title m-0 d-flex\">\n            <span class=\"flex-grow-1\">\n              <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ playbook.name }}\n            </span>\n            <span class=\"ms-3\">\n              <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n                (click)=\"removeActionPlaybook(pbIndex)\"></i>\n            </span>\n          </div>\n\n        </div>\n        <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n      </div>\n    </div>\n  </div>\n\n  <!-- Row expansion -->\n  <div class=\"row mt-3\">\n    <label for=\"row-expansion\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"row-expansion\" id=\"row-expansion\" formcontrolname=\"rowExpandable\"\n        class=\"form-check-input\" [checked]=\"widgetConfig.configuration.rowExpandable\"\n        (change)=\"rowExpansionChange($event)\">\n      <span class=\"form-check-label ps-2\">Row Expandable</span>\n    </label>\n  </div>\n\n  <!--  Light Mode -->\n  <div class=\"row mt-3\">\n    <label for=\"light-mode\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"light-mode\" id=\"light-mode\" formcontrolname=\"lightMode\" class=\"form-check-input\"\n        [checked]=\"widgetConfig.configuration.lightMode\" (change)=\"lightModeChange($event)\">\n      <span class=\"form-check-label ps-2\">Enable light mode</span>\n    </label>\n  </div>\n\n  <!-- Filters -->\n  <div class=\"row mt-3\">\n    <div class=\"col-md-12\">\n      <label class=\"fw-bold\">Filters</label>\n      <div *ngIf=\"!selectedEntity\">\n        <small class=\"font-italic\">Select a module above</small>\n      </div>\n      <div *ngIf=\"selectedEntity\">\n        <xf-filter-group formControlName=\"query\" [entity]=\"selectedEntity\"></xf-filter-group>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"row mt-3\" *ngIf=\"fields\">\n    <xf-default-sort [query]=\"widgetConfig.configuration.query\" [fields]=\"fields!\" class=\"col-lg-7 col-md-8 col-sm-12\">\n    </xf-default-sort>\n  </div>\n\n</div>\n", styles: [".border-grey{border:1px solid var(--solid-border-secondary-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i1.ModelMetadataService }, { type: i2.FormBuilder }, { type: i1.PlaybookService }, { type: i3.Router }, { type: i1.UtilityService }, { type: i4.GridColumnService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridEditComponent, { className: "GridEditComponent", filePath: "src/widgets/grid-widget/grid-edit/grid-edit.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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