import { ChangeDetectionStrategy, Component } from '@angular/core';
import { map } from 'rxjs/operators';
import { API, AddRecordComponent } from "shared";
import { AbstractWidgetComponent } from 'shared/view-templates';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@ng-bootstrap/ng-bootstrap";
import * as i3 from "shared";
import * as i4 from "@angular/router";
import * as i5 from "../../../services/grid-data-source.service";
function GridViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 1);
    i0.ɵɵelement(2, "xf-grid", 2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("dataSource", ctx_r0.dataSource)("gridConfig", ctx_r0.gridConfig);
} }
export class GridViewComponent extends AbstractWidgetComponent {
    constructor(http, offcanvasService, themeService, _changeDetectorRef, entityService, router, route, gridDataSourceService) {
        super(_changeDetectorRef);
        this.http = http;
        this.offcanvasService = offcanvasService;
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.entityService = entityService;
        this.router = router;
        this.route = route;
        this.gridDataSourceService = gridDataSourceService;
    }
    ngOnInit() {
        super.ngOnInit();
    }
    widgetConfigChanged(widgetConfig) {
        this.gridConfig = widgetConfig;
        this.title = widgetConfig.title;
        this.changeDetectorRef.detectChanges();
    }
    openRecord(event) {
        const module = event.data['@id'].split('/')[3];
        const onClickState = this.gridConfig.configuration.onClickState || 'module';
        if (onClickState === 'preview') {
            this.router.navigate(['.'], {
                relativeTo: this.route,
                queryParams: {
                    preview: true,
                    recordId: event.data.uuid
                },
                queryParamsHandling: 'merge'
            });
        }
        else {
            this.router.navigate([onClickState, module, 'detail'], {
                queryParams: {
                    recordId: event.data.uuid
                }
            });
        }
    }
    loadDatasource() {
        this.gridConfig.options = this.gridConfig.options || {};
        this.gridConfig.options.onView = (_event) => this.openRecord(_event);
        this.gridConfig.options.addText = 'Add';
        this.entityService.build(this.gridConfig.configuration.module).subscribe((entity) => {
            if (!this.context || !this.gridConfig) {
                return;
            }
            this.entity = entity;
            let relatedField;
            let relatedUuid;
            let primaryModule = this.gridConfig.configuration.module;
            if (this.gridConfig.configuration.onlyRelated && this.context.module && this.context.uuid) {
                relatedField = this.gridConfig.configuration.module;
                relatedUuid = this.context.uuid;
                primaryModule = this.context.module;
            }
            // TODO: Implement related records grid
            this.dataSource = this.gridDataSourceService.getDataSource(this.entity);
            // this.pagedCollection = new PagedCollection(primaryModule, this.entity, relatedField, relatedUuid);
            this.changeDetectorRef.detectChanges();
        });
    }
    addModule() {
        if (this.offcanvasInstance) {
            this.offcanvasInstance.close();
        }
        this.offcanvasInstance = this.offcanvasService.open(AddRecordComponent, {
            position: 'end',
            container: '.content'
        });
    }
    loadPicklistNames(picklistName) {
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map(response => response['hydra:member'][0]));
    }
    contextChanged(context) {
        this.context = context;
        this.loadDatasource();
    }
    static { this.ɵfac = function GridViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridViewComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i2.NgbOffcanvas), i0.ɵɵdirectiveInject(i3.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i4.Router), i0.ɵɵdirectiveInject(i4.ActivatedRoute), i0.ɵɵdirectiveInject(i5.GridDataSourceService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridViewComponent, selectors: [["xf-grid-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[4, "ngIf"], [1, "m-2", "ms-0"], [3, "dataSource", "gridConfig"]], template: function GridViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridViewComponent_div_0_Template, 3, 2, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.dataSource);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *ngIf=\"dataSource\">\n  <div class=\"m-2 ms-0\">\n    <!-- <button class=\"btn btn-primary btn-sm\" (click)=\"addModule()\">Add {{ entity?.descriptions?.singular }}</button> -->\n    <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\"></xf-grid>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.HttpClient }, { type: i2.NgbOffcanvas }, { type: i3.ThemeService }, { type: i0.ChangeDetectorRef }, { type: i3.EntityService }, { type: i4.Router }, { type: i4.ActivatedRoute }, { type: i5.GridDataSourceService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridViewComponent, { className: "GridViewComponent", filePath: "src/widgets/grid-widget/grid-view/grid-view.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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