import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
const _c0 = a0 => ({ "disabled": a0 });
function PaginationComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 16);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const pageSize_r2 = ctx.$implicit;
    i0.ɵɵproperty("value", pageSize_r2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(pageSize_r2);
} }
const FILTER_PAG_REGEX = /[^0-9]/g;
export class PaginationComponent {
    set totalItems(value) {
        this._totalItems = value;
        this.calculatePaginationSize();
    }
    get totalItems() {
        return this._totalItems;
    }
    constructor() {
        //@Input() totalRecords: number = 0;
        this.itemsPerPage = 30;
        this.paginationSize = [5, 10, 30, 50, 100, 250];
        this.pageChanged = new EventEmitter();
        this.page = 1;
        this.noOfPages = 1;
        this._totalItems = 0;
    }
    ngOnInit() {
    }
    calculatePaginationSize() {
        this.noOfPages = Math.ceil(this._totalItems / this.itemsPerPage);
    }
    selectPage(page) {
        let _pageChange = parseInt(page) || 1;
        this.gotoPage(_pageChange, paginationEventType.directPage);
    }
    gotoPage(page, eventType) {
        if (page > this.noOfPages) {
            page = this.noOfPages;
        }
        else if (page < 0) {
            page = 1;
        }
        this.page = page;
        this.fireEvent(eventType);
    }
    formatInput(input) {
        input.value = input.value.replace(FILTER_PAG_REGEX, '');
    }
    recordsSizeChanged() {
        this.page = 1;
        this.calculatePaginationSize();
        this.fireEvent(paginationEventType.recordsPerPageChange);
    }
    fireEvent(eventType) {
        this.pageChanged.emit({
            currentPage: this.page,
            itemsPerPage: this.itemsPerPage,
            eventType: eventType
        });
    }
    firstPage() {
        this.gotoPage(1, paginationEventType.pageFirst);
    }
    previousPage() {
        this.gotoPage(this.page - 1, paginationEventType.pagePrevious);
    }
    nextPage() {
        this.gotoPage(this.page + 1, paginationEventType.pageNext);
    }
    lastPage() {
        this.gotoPage(this.noOfPages, paginationEventType.pageLast);
    }
    static { this.ɵfac = function PaginationComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PaginationComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PaginationComponent, selectors: [["xf-pagination"]], inputs: { itemsPerPage: "itemsPerPage", paginationSize: "paginationSize", totalItems: "totalItems" }, outputs: { pageChanged: "pageChanged" }, decls: 20, vars: 16, consts: [["pageInput", ""], [1, "pagination-wrapper", "d-flex", "justify-content-end"], [1, "align-items-center", "d-flex", "me-4"], ["for", "itemsPerPageDD", 1, "me-2", "ps-2", "content-font"], ["id", "itemsPerPageDD", "name", "itemsPerPageDD", 1, "form-select", "form-select-xs", "text-center", "w-auto", 3, "ngModelChange", "change", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], [1, "align-items-center", "d-flex"], [1, "btn", "btn-xs", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-double-left", "content-font"], [1, "btn", "btn-xs", "mx-1", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-left", "content-font"], ["type", "text", "pattern", "[0-9]*", "id", "paginationInput", "aria-labelledby", "paginationInputLabel paginationDescription", 1, "form-control", "form-control-xs", "mx-2", "text-center", 2, "width", "3.5rem", 3, "keyup.enter", "blur", "input", "value"], [1, "me-2", "content-font"], [1, "fa-light", "fa", "fa-chevron-right", "content-font"], [1, "fa-light", "fa", "fa-chevron-double-right", "content-font"], [1, "clearfix"], [3, "value"]], template: function PaginationComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "label", 3);
            i0.ɵɵtext(3, "Items Per Page");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 4);
            i0.ɵɵtwoWayListener("ngModelChange", function PaginationComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); i0.ɵɵtwoWayBindingSet(ctx.itemsPerPage, $event) || (ctx.itemsPerPage = $event); return i0.ɵɵresetView($event); });
            i0.ɵɵlistener("change", function PaginationComponent_Template_select_change_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.recordsSizeChanged()); });
            i0.ɵɵtemplate(5, PaginationComponent_option_5_Template, 2, 2, "option", 5);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 6)(7, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_7_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.firstPage()); });
            i0.ɵɵelement(8, "i", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.previousPage()); });
            i0.ɵɵelement(10, "i", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(11, "input", 11, 0);
            i0.ɵɵlistener("keyup.enter", function PaginationComponent_Template_input_keyup_enter_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("blur", function PaginationComponent_Template_input_blur_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("input", function PaginationComponent_Template_input_input_11_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.formatInput($event.target)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "label", 12);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.nextPage()); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.lastPage()); });
            i0.ɵɵelement(18, "i", 14);
            i0.ɵɵelementEnd()();
            i0.ɵɵelement(19, "div", 15);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.itemsPerPage);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.paginationSize);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("value", ctx.page);
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate1(" of ", ctx.noOfPages, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(12, _c0, ctx.page === ctx.noOfPages));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(14, _c0, ctx.page === ctx.noOfPages));
        } }, dependencies: [i1.NgClass, i1.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PaginationComponent, [{
        type: Component,
        args: [{ selector: 'xf-pagination', template: "<div class=\"pagination-wrapper d-flex justify-content-end\">\n    <div class=\"align-items-center d-flex me-4\">\n        <label for=\"itemsPerPageDD\" class=\"me-2 ps-2 content-font\">Items Per Page</label>\n        <select class=\"form-select form-select-xs text-center w-auto\" id=\"itemsPerPageDD\"\n            name=\"itemsPerPageDD\" [(ngModel)]=\"itemsPerPage\" (change)=\"recordsSizeChanged()\">\n            <option *ngFor=\"let pageSize of paginationSize\" [value]=\"pageSize\">{{ pageSize }}</option>\n        </select>\n    </div>\n    <div class=\"align-items-center d-flex\">\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"firstPage()\">\n            <i class=\"fa-light fa fa-chevron-double-left content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"previousPage()\">\n            <i class=\"fa-light fa fa-chevron-left content-font\"></i>\n        </button>\n        <input #pageInput type=\"text\" pattern=\"[0-9]*\" class=\"form-control form-control-xs mx-2 text-center\"\n            id=\"paginationInput\" [value]=\"page\" (keyup.enter)=\"selectPage(pageInput.value)\"\n            (blur)=\"selectPage(pageInput.value)\" (input)=\"formatInput($any($event).target)\"\n            aria-labelledby=\"paginationInputLabel paginationDescription\" style=\"width: 3.5rem\" />\n        <label class=\"me-2 content-font\"> of {{ noOfPages }}</label>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"nextPage()\">\n            <i class=\"fa-light fa fa-chevron-right content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"lastPage()\">\n            <i class=\"fa-light fa fa-chevron-double-right content-font\"></i>\n        </button>\n    </div>\n    <div class=\"clearfix\"></div>\n</div>" }]
    }], () => [], { itemsPerPage: [{
            type: Input
        }], paginationSize: [{
            type: Input
        }], pageChanged: [{
            type: Output
        }], totalItems: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PaginationComponent, { className: "PaginationComponent", filePath: "src/widgets/grid-widget/pagination/pagination.component.ts", lineNumber: 9 }); })();
export var paginationEventType;
(function (paginationEventType) {
    paginationEventType["pageFirst"] = "pageFirst";
    paginationEventType["pageLast"] = "pageLast";
    paginationEventType["pageNext"] = "pageNext";
    paginationEventType["pagePrevious"] = "pagePrevious";
    paginationEventType["recordsPerPageChange"] = "recordsPerPageChange";
    paginationEventType["directPage"] = "directPage";
})(paginationEventType || (paginationEventType = {}));
//# sourceMappingURL=data:application/json;base64,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