import { CommonModule } from '@angular/common';
import { Component, Input, ViewChildren } from '@angular/core';
import { FormControl, FormsModule, ReactiveFormsModule, Validators } from '@angular/forms';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import { cloneDeep, forEach } from 'lodash-es';
import { isObject } from 'lodash-es';
import { FormFieldComponent } from '../../form-fields/field-renderers/built-ins/form-field/form-field.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/forms";
import * as i3 from "../../core/services/entity.service";
import * as i4 from "@angular/common";
import * as i5 from "../../form-fields/field-renderers/built-ins/form-field/form-field.component";
function AddRecordComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "xf-form-field", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r2.value)("formControlName", field_r2.value.name)("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true);
} }
function AddRecordComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, AddRecordComponent_div_9_div_1_Template, 2, 4, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", field_r2.value.isFormField);
} }
export class AddRecordComponent {
    constructor(activeOffcanvas, formBuilder, entityService) {
        this.activeOffcanvas = activeOffcanvas;
        this.formBuilder = formBuilder;
        this.entityService = entityService;
        this.saveBtnText = 'Save';
        this.processing = false;
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return a.value.orderIndex > b.value.orderIndex ? 1 : a.value.orderIndex < b.value.orderIndex ? -1 : 0;
        };
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({});
        forEach(this.entity.fields, (field) => {
            if (field.isFormField) {
                let validators = [];
                if (field.validation.required) {
                    validators.push(Validators.required);
                }
                let fieldCtrl = new FormControl(this.entity.values[field.name] || '', validators);
                this.formGroup.addControl(field.name, fieldCtrl);
                this.formGroup.controls[field.name].valueChanges.subscribe((value) => {
                    if (this.entity.type === 'playbooks' && field.formType === 'lookup') {
                        this.entity.values[field.name] = value.uuid;
                    }
                    else {
                        this.entity.values[field.name] = value;
                    }
                });
            }
        });
    }
    createRecord() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formFieldComponent of this.formFieldComponents) {
                if (!formFieldComponent.valid) {
                    formFieldComponent.focus();
                    return;
                }
            }
        }
        this.processing = true;
        forEach(this.entity.fields, (field) => {
            if (field.isFormField && this.entity.type === 'playbooks' && field.formType === 'lookup' && isObject(this.entity.values[field.name])) {
                this.entity.values[field.name] = this.entity.values[field.name].uuid;
            }
        });
        let entity = cloneDeep(this.entity);
        entity.uuid = undefined;
        this.entityService.save(entity, Object.keys(this.entity.values)).subscribe({
            next: (response) => {
                this.activeOffcanvas.close(response);
                this.processing = false;
            }, error: () => {
                this.processing = false;
            }
        });
    }
    static { this.ɵfac = function AddRecordComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddRecordComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddRecordComponent, selectors: [["xf-add-record"]], viewQuery: function AddRecordComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { entity: "entity", saveBtnText: "saveBtnText" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 18, vars: 11, consts: [["addModuleForm", "ngForm"], [3, "ngSubmit", "formGroup"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click", "disabled"], [1, "margin-top-20px", "modal-body"], [1, "row", "m-0"], [1, "col-md-12"], ["class", "form-group", 4, "ngFor", "ngForOf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "submit", 1, "btn", "btn-primary", "btn-sm", "margin-left-6px", 3, "click", "disabled"], [1, "fa-light", "margin-right-4px", 3, "ngClass"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click", "disabled"], [1, "fa", "fa-times", "margin-right-4px"], [1, "form-group"], ["class", "mb-2", 4, "ngIf"], [1, "mb-2"], [3, "field", "formControlName", "fieldClass", "autoFocus"]], template: function AddRecordComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1, 0);
            i0.ɵɵlistener("ngSubmit", function AddRecordComponent_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelementStart(2, "div", 2)(3, "h4", 3);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "button", 4);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Cross click")); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5)(7, "div", 6)(8, "div", 7);
            i0.ɵɵtemplate(9, AddRecordComponent_div_9_Template, 2, 1, "div", 8);
            i0.ɵɵpipe(10, "keyvalue");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(11, "div", 9)(12, "button", 10);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelement(13, "i", 11);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 12);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Close click")); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵtext(17, "Cancel ");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate1("Create ", ctx.entity.descriptions.singular, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(10, 8, ctx.entity.fields, ctx.originalOrder));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.processing ? "fa-spin fa-spinner" : "fa fa-check");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1("", ctx.saveBtnText, " ");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
        } }, dependencies: [CommonModule, i4.NgClass, i4.NgForOf, i4.NgIf, i4.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, XFFormFieldsModule, i5.FormFieldComponent, ReactiveFormsModule, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddRecordComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule
                ], selector: 'xf-add-record', template: "<form #addModuleForm=\"ngForm\" (ngSubmit)=\"createRecord()\" [formGroup]=\"formGroup\">\n  <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"page-title-font modal-title muted-10\">Create {{entity.descriptions.singular}}</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"activeOffcanvas.dismiss('Cross click')\"\n      [disabled]=\"processing\"></button>\n  </div>\n  <div class=\"margin-top-20px modal-body\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\" *ngFor=\"let field of entity.fields | keyvalue : originalOrder\">\n          <div class=\"mb-2\" *ngIf=\"field.value.isFormField\">\n            <xf-form-field [field]=\"field.value\" [formControlName]=\"field.value.name\"\n              [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n    <button type=\"submit\" class=\"btn btn-primary btn-sm margin-left-6px\" (click)=\"createRecord()\"\n      [disabled]=\"processing\">\n      <i class=\"fa-light margin-right-4px\"\n        [ngClass]=\"processing ? 'fa-spin fa-spinner' : 'fa fa-check'\"></i>{{saveBtnText}}\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeOffcanvas.dismiss('Close click')\"\n      [disabled]=\"processing\">\n      <i class=\"fa fa-times margin-right-4px\"></i>Cancel\n    </button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveOffcanvas }, { type: i2.FormBuilder }, { type: i3.EntityService }], { entity: [{
            type: Input
        }], saveBtnText: [{
            type: Input
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddRecordComponent, { className: "AddRecordComponent", filePath: "lib/components/add-record/add-record.component.ts", lineNumber: 27 }); })();
//# sourceMappingURL=data:application/json;base64,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