import { CommonModule } from '@angular/common';
import { Component } from '@angular/core';
import { ReactiveFormsModule } from '@angular/forms';
import { TextareaField } from '../../form-fields/field-types/textarea';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/forms";
import * as i3 from "../../form-fields/field-renderers/built-ins/form-field/form-field.component";
export class LogoutPromptComponent {
    constructor(activeModal, formBuilder) {
        this.activeModal = activeModal;
        this.formBuilder = formBuilder;
        this.logoutMessage = 'You are being force logged out by the admin for administrative purposes. Please get in touch with admin for more information.';
    }
    ngOnInit() {
        this.field = new TextareaField('logoutMessage');
        this.field.title = `Provide a custom message to show the user while being forced a logout:`;
        this.field.placeholder = `Add custom message to show user being force logged out...`;
        this.field.validation = {
            required: true,
            maxlength: 255
        };
        this.field.params = {
            rows: 4
        };
        this.formGroup = this.formBuilder.group({
            editableField: []
        });
        this.formGroup.setValue({
            editableField: this.logoutMessage
        });
    }
    logout() {
        this.activeModal.close(this.formGroup.controls.editableField.value);
    }
    static { this.ɵfac = function LogoutPromptComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LogoutPromptComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LogoutPromptComponent, selectors: [["xf-logout-prompt"]], standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 12, vars: 3, consts: [[3, "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body", "p-3"], ["formControlName", "editableField", 3, "field"], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "button", "ngbAutofocus", "", 1, "btn", "btn-outline-primary", 3, "click", "disabled"]], template: function LogoutPromptComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", 0)(1, "div", 1)(2, "h4", 2);
            i0.ɵɵtext(3, "Force Logout User");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 3);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_4_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 4);
            i0.ɵɵelement(6, "xf-form-field", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 6)(8, "button", 7);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_8_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵtext(9, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(10, "button", 8);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_10_listener() { return ctx.logout(); });
            i0.ɵɵtext(11, "Confirm");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(6);
            i0.ɵɵproperty("field", ctx.field);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("disabled", ctx.formGroup.invalid);
        } }, dependencies: [CommonModule, XFFormFieldsModule, i3.FormFieldComponent, ReactiveFormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LogoutPromptComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [CommonModule, XFFormFieldsModule, ReactiveFormsModule], selector: 'xf-logout-prompt', template: "<form [formGroup]=\"formGroup\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Force Logout User</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"activeModal.close(false)\"></button>\n  </div>\n  <div class=\"modal-body p-3\">\n    <xf-form-field [field]=\"field\" formControlName=\"editableField\"></xf-form-field>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"activeModal.close(false)\">Cancel</button>\n    <button type=\"button\" class=\"btn btn-outline-primary\" ngbAutofocus (click)=\"logout()\"\n      [disabled]=\"formGroup.invalid\">Confirm</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i2.FormBuilder }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LogoutPromptComponent, { className: "LogoutPromptComponent", filePath: "lib/components/logout-prompt/logout-prompt.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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